/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.converters.datatypes.DataType;
import ca.spottedleaf.dataconverter.minecraft.MCVersionRegistry;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCDataType;
import ca.spottedleaf.dataconverter.types.json.JsonMapType;
import ca.spottedleaf.dataconverter.types.nbt.NBTMapType;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import net.minecraft.nbt.CompoundTag;

public final class MCDataConverter {
    private static final LongArrayList BREAKPOINTS = MCVersionRegistry.getBreakpoints();

    public static <T> T copy(T type) {
        if (type instanceof CompoundTag) {
            return (T)((CompoundTag)type).copy();
        }
        if (type instanceof JsonObject) {
            return (T)((JsonObject)type).deepCopy();
        }
        return type;
    }

    public static CompoundTag convertTag(MCDataType type, CompoundTag data, int fromVersion, int toVersion) {
        NBTMapType wrapped = new NBTMapType(data);
        NBTMapType replaced = (NBTMapType)MCDataConverter.convert(type, wrapped, fromVersion, toVersion);
        return replaced == null ? wrapped.getTag() : replaced.getTag();
    }

    public static JsonObject convertJson(MCDataType type, JsonObject data, boolean compressed, int fromVersion, int toVersion) {
        JsonMapType wrapped = new JsonMapType(data, compressed);
        JsonMapType replaced = (JsonMapType)MCDataConverter.convert(type, wrapped, fromVersion, toVersion);
        return replaced == null ? wrapped.getJson() : replaced.getJson();
    }

    public static <T, R> R convert(DataType<T, R> type, T data, int fromVersion, int toVersion) {
        return MCDataConverter.convertWithSubVersion(type, data, DataConverter.encodeVersions(Math.max(fromVersion, 99), Integer.MAX_VALUE), DataConverter.encodeVersions(toVersion, Integer.MAX_VALUE));
    }

    public static <T, R> R convertWithSubVersion(DataType<T, R> type, T data, long fromVersion, long toVersion) {
        R converted;
        Object ret = data;
        long currentVersion = fromVersion;
        int len = BREAKPOINTS.size();
        for (int i = 0; i < len; ++i) {
            long breakpoint = BREAKPOINTS.getLong(i);
            if (currentVersion >= breakpoint) continue;
            R converted2 = type.convert(ret, currentVersion, Math.min(toVersion, breakpoint - 1L));
            if (converted2 != null) {
                ret = converted2;
            }
            if ((currentVersion = Math.min(toVersion, breakpoint - 1L)) == toVersion) break;
        }
        if (currentVersion != toVersion && (converted = type.convert(ret, currentVersion, toVersion)) != null) {
            ret = converted;
        }
        return (R)ret;
    }

    private MCDataConverter() {
    }
}

