/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.tileentity;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import java.util.function.Function;

public final class ConverterAbstractTileEntityRename {
    public static void register(int version, Function<String, String> renamer) {
        ConverterAbstractTileEntityRename.register(version, 0, renamer);
    }

    public static void register(int version, int subVersion, final Function<String, String> renamer) {
        MCTypeRegistry.TILE_ENTITY.addStructureConverter(new DataConverter<MapType, MapType>(version, subVersion){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                String id = data.getString("id");
                if (id == null) {
                    return null;
                }
                String converted = (String)renamer.apply(id);
                if (converted != null) {
                    data.setString("id", converted);
                }
                return null;
            }
        });
    }
}

