/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.HelperSpawnEggNameV105;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;

public final class V105 {
    private static final int VERSION = 105;

    public static void register() {
        MCTypeRegistry.ITEM_STACK.addConverterForId("minecraft:spawn_egg", new DataConverter<MapType, MapType>(105){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                String converted;
                MapType entityTag;
                short damage;
                MapType tag = data.getMap("tag");
                if (tag == null) {
                    tag = Types.NBT.createEmptyMap();
                }
                if ((damage = data.getShort("Damage")) != 0) {
                    data.setShort("Damage", (short)0);
                }
                if ((entityTag = tag.getMap("EntityTag")) == null) {
                    entityTag = Types.NBT.createEmptyMap();
                }
                if (!entityTag.hasKey("id", ObjectType.STRING) && (converted = HelperSpawnEggNameV105.getSpawnNameFromId(damage)) != null) {
                    entityTag.setString("id", converted);
                    tag.setMap("EntityTag", entityTag);
                    data.setMap("tag", tag);
                }
                return null;
            }
        });
    }

    private V105() {
    }
}

