/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V111 {
    private static final int VERSION = 111;

    public static void register() {
        EntityRotationFix rotationFix = new EntityRotationFix(111);
        MCTypeRegistry.ENTITY.addConverterForId("Painting", rotationFix);
        MCTypeRegistry.ENTITY.addConverterForId("ItemFrame", rotationFix);
    }

    private V111() {
    }

    protected static final class EntityRotationFix
    extends DataConverter<MapType, MapType> {
        private static final int[][] DIRECTIONS = new int[][]{{0, 0, 1}, {-1, 0, 0}, {0, 0, -1}, {1, 0, 0}};

        public EntityRotationFix(int version) {
            super(version);
        }

        @Override
        public MapType convert(MapType data, long sourceVersion, long toVersion) {
            int facing;
            if (data.getNumber("Facing") != null) {
                return null;
            }
            Number direction = data.getNumber("Direction");
            if (direction != null) {
                Number rotation;
                data.remove("Direction");
                facing = direction.intValue() % DIRECTIONS.length;
                int[] offsets = DIRECTIONS[facing];
                data.setInt("TileX", data.getInt("TileX") + offsets[0]);
                data.setInt("TileY", data.getInt("TileY") + offsets[1]);
                data.setInt("TileZ", data.getInt("TileZ") + offsets[2]);
                if ("ItemFrame".equals(data.getString("id")) && (rotation = data.getNumber("ItemRotation")) != null) {
                    data.setByte("ItemRotation", (byte)(rotation.byteValue() * 2));
                }
            } else {
                facing = data.getByte("Dir") % DIRECTIONS.length;
                data.remove("Dir");
            }
            data.setByte("Facing", (byte)facing);
            return null;
        }
    }
}

