/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.options.ConverterAbstractOptionsRename;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.versions.V2550;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.Types;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;

public final class V2558 {
    private static final int VERSION = 2558;

    public static void register() {
        ConverterAbstractOptionsRename.register(2558, new HashMap(ImmutableMap.of((Object)"key_key.swapHands", (Object)"key_key.swapOffhand"))::get);
        MCTypeRegistry.WORLD_GEN_SETTINGS.addStructureConverter(new DataConverter<MapType, MapType>(2558){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType dimensions = data.getMap("dimensions");
                if (dimensions == null) {
                    dimensions = Types.NBT.createEmptyMap();
                    data.setMap("dimensions", dimensions);
                }
                if (dimensions.isEmpty()) {
                    data.setMap("dimensions", V2558.recreateSettings(data));
                }
                return null;
            }
        });
    }

    private static MapType recreateSettings(MapType data) {
        long seed = data.getLong("seed");
        return V2550.vanillaLevels(seed, V2550.defaultOverworld(seed), false);
    }

    private V2558() {
    }
}

