/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.converters.datatypes.DataWalker;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItemLists;
import ca.spottedleaf.dataconverter.types.MapType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class V4300 {
    private static final int VERSION = 4300;

    public static void register() {
        MCTypeRegistry.ENTITY.addStructureConverter(new DataConverter<MapType, MapType>(4300){
            private static final Set<String> SADDLE_ITEM_ENTITIES = new HashSet<String>(Arrays.asList("minecraft:horse", "minecraft:skeleton_horse", "minecraft:zombie_horse", "minecraft:donkey", "minecraft:mule", "minecraft:camel", "minecraft:llama", "minecraft:trader_llama"));
            private static final Set<String> SADDLE_FLAG_ENTITIES = new HashSet<String>(Arrays.asList("minecraft:pig", "minecraft:strider"));

            private static void setGuaranteedSaddleDropChance(MapType data) {
                data.getOrCreateMap("drop_chances").setFloat("saddle", 2.0f);
            }

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                String id = data.getString("id");
                if (SADDLE_ITEM_ENTITIES.contains(id)) {
                    if (!RenameHelper.renameSingle(data, "SaddleItem", "saddle")) {
                        return null;
                    }
                    1.setGuaranteedSaddleDropChance(data);
                    return null;
                }
                if (SADDLE_FLAG_ENTITIES.contains(id)) {
                    boolean saddle = data.getBoolean("Saddle");
                    data.remove("Saddle");
                    if (!saddle) {
                        return null;
                    }
                    MapType saddleItem = data.getTypeUtil().createEmptyMap();
                    data.setMap("saddle", saddleItem);
                    saddleItem.setString("id", "minecraft:saddle");
                    saddleItem.setInt("count", 1);
                    1.setGuaranteedSaddleDropChance(data);
                    return null;
                }
                return null;
            }
        });
        MCTypeRegistry.ENTITY.addWalker(4300, "minecraft:llama", new DataWalkerItemLists("Items"));
        MCTypeRegistry.ENTITY.addWalker(4300, "minecraft:trader_llama", new DataWalkerItemLists("Items"));
        MCTypeRegistry.ENTITY.addWalker(4300, "minecraft:donkey", new DataWalkerItemLists("Items"));
        MCTypeRegistry.ENTITY.addWalker(4300, "minecraft:mule", new DataWalkerItemLists("Items"));
        MCTypeRegistry.ENTITY.addWalker(4300, "minecraft:horse", DataWalker.noOp());
        MCTypeRegistry.ENTITY.addWalker(4300, "minecraft:skeleton_horse", DataWalker.noOp());
        MCTypeRegistry.ENTITY.addWalker(4300, "minecraft:zombie_horse", DataWalker.noOp());
    }

    private V4300() {
    }
}

