/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V4651 {
    public static final int VERSION = 4651;

    public static void register() {
        MCTypeRegistry.OPTIONS.addStructureConverter(new DataConverter<MapType, MapType>(4651){

            private static void convertTo(String graphicsMode, MapType dst, String dstPath, String fast, String fancy, String fabulous) {
                String toSet;
                if (graphicsMode == null) {
                    toSet = fancy;
                } else {
                    switch (graphicsMode) {
                        case "0": {
                            toSet = fast;
                            break;
                        }
                        default: {
                            toSet = fancy;
                            break;
                        }
                        case "2": {
                            toSet = fabulous;
                        }
                    }
                }
                dst.setString(dstPath, toSet);
            }

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                String graphicsMode = data.getString("graphicsMode");
                1.convertTo(graphicsMode, data, "cutoutLeaves", "false", "true", "true");
                1.convertTo(graphicsMode, data, "weatherRadius", "5", "10", "10");
                1.convertTo(graphicsMode, data, "vignette", "false", "true", "true");
                1.convertTo(graphicsMode, data, "improvedTransparency", "false", "false", "true");
                return null;
            }
        });
        MCTypeRegistry.OPTIONS.addStructureConverter(new DataConverter<MapType, MapType>(4651){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                data.setString("graphicsPreset", "custom");
                return null;
            }
        });
    }

    private V4651() {
    }
}

