/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.types.nbt;

import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import ca.spottedleaf.dataconverter.types.Types;
import ca.spottedleaf.dataconverter.types.nbt.NBTListType;
import java.util.Set;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public final class NBTMapType
implements MapType {
    final CompoundTag map;

    public NBTMapType() {
        this.map = new CompoundTag();
    }

    public NBTMapType(CompoundTag tag) {
        this.map = tag;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != NBTMapType.class) {
            return false;
        }
        return this.map.equals(((NBTMapType)obj).map);
    }

    public TypeUtil<Tag> getTypeUtil() {
        return Types.NBT;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return "NBTMapType{map=" + String.valueOf(this.map) + "}";
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.keySet().clear();
    }

    @Override
    public Set<String> keys() {
        return this.map.keySet();
    }

    public CompoundTag getTag() {
        return this.map;
    }

    @Override
    public MapType copy() {
        return new NBTMapType(this.map.copy());
    }

    @Override
    public boolean hasKey(String key) {
        return this.map.get(key) != null;
    }

    @Override
    public boolean hasKey(String key, ObjectType type) {
        Tag tag = this.map.get(key);
        if (tag == null) {
            return false;
        }
        ObjectType valueType = NBTListType.getType(tag.getId());
        return valueType == type || type == ObjectType.NUMBER && valueType.isNumber();
    }

    @Override
    public void remove(String key) {
        this.map.remove(key);
    }

    @Override
    public Object getGeneric(String key) {
        Tag tag = this.map.get(key);
        if (tag == null) {
            return null;
        }
        switch (NBTListType.getType(tag.getId())) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return ((NumericTag)tag).box();
            }
            case MAP: {
                return new NBTMapType((CompoundTag)tag);
            }
            case LIST: {
                return new NBTListType((ListTag)tag);
            }
            case STRING: {
                return ((StringTag)tag).value();
            }
            case BYTE_ARRAY: {
                return ((ByteArrayTag)tag).getAsByteArray();
            }
            case INT_ARRAY: {
                return ((IntArrayTag)tag).getAsIntArray();
            }
            case LONG_ARRAY: {
                return ((LongArrayTag)tag).getAsLongArray();
            }
        }
        throw new IllegalStateException("Unrecognized type " + String.valueOf(tag));
    }

    @Override
    public Number getNumber(String key) {
        return this.getNumber(key, null);
    }

    @Override
    public Number getNumber(String key, Number dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numTag = (NumericTag)tag;
            return numTag.box();
        }
        return dfl;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getByte(key) != 0;
    }

    @Override
    public boolean getBoolean(String key, boolean dfl) {
        return this.getByte(key, dfl ? (byte)1 : 0) != 0;
    }

    @Override
    public void setBoolean(String key, boolean val) {
        this.setByte(key, val ? (byte)1 : 0);
    }

    @Override
    public byte getByte(String key) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            return numericTag.byteValue();
        }
        return 0;
    }

    @Override
    public byte getByte(String key, byte dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            return numericTag.byteValue();
        }
        return dfl;
    }

    @Override
    public void setByte(String key, byte val) {
        this.map.putByte(key, val);
    }

    @Override
    public short getShort(String key) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            return numericTag.shortValue();
        }
        return 0;
    }

    @Override
    public short getShort(String key, short dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            return numericTag.shortValue();
        }
        return dfl;
    }

    @Override
    public void setShort(String key, short val) {
        this.map.putShort(key, val);
    }

    @Override
    public int getInt(String key) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            return numericTag.intValue();
        }
        return 0;
    }

    @Override
    public int getInt(String key, int dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            return numericTag.intValue();
        }
        return dfl;
    }

    @Override
    public void setInt(String key, int val) {
        this.map.putInt(key, val);
    }

    @Override
    public long getLong(String key) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            return numericTag.longValue();
        }
        return 0L;
    }

    @Override
    public long getLong(String key, long dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            return numericTag.longValue();
        }
        return dfl;
    }

    @Override
    public void setLong(String key, long val) {
        this.map.putLong(key, val);
    }

    @Override
    public float getFloat(String key) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            return numericTag.floatValue();
        }
        return 0.0f;
    }

    @Override
    public float getFloat(String key, float dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            return numericTag.floatValue();
        }
        return dfl;
    }

    @Override
    public void setFloat(String key, float val) {
        this.map.putFloat(key, val);
    }

    @Override
    public double getDouble(String key) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            return numericTag.doubleValue();
        }
        return 0.0;
    }

    @Override
    public double getDouble(String key, double dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            return numericTag.doubleValue();
        }
        return dfl;
    }

    @Override
    public void setDouble(String key, double val) {
        this.map.putDouble(key, val);
    }

    @Override
    public byte[] getBytes(String key) {
        return this.getBytes(key, null);
    }

    @Override
    public byte[] getBytes(String key, byte[] dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag byteArrayTag = (ByteArrayTag)tag;
            return byteArrayTag.getAsByteArray();
        }
        return dfl;
    }

    @Override
    public void setBytes(String key, byte[] val) {
        this.map.putByteArray(key, val);
    }

    @Override
    public short[] getShorts(String key) {
        return this.getShorts(key, null);
    }

    @Override
    public short[] getShorts(String key, short[] dfl) {
        return dfl;
    }

    @Override
    public void setShorts(String key, short[] val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getInts(String key) {
        return this.getInts(key, null);
    }

    @Override
    public int[] getInts(String key, int[] dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof IntArrayTag) {
            IntArrayTag intArrayTag = (IntArrayTag)tag;
            return intArrayTag.getAsIntArray();
        }
        return dfl;
    }

    @Override
    public void setInts(String key, int[] val) {
        this.map.putIntArray(key, val);
    }

    @Override
    public long[] getLongs(String key) {
        return this.getLongs(key, null);
    }

    @Override
    public long[] getLongs(String key, long[] dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof LongArrayTag) {
            LongArrayTag longArrayTag = (LongArrayTag)tag;
            return longArrayTag.getAsLongArray();
        }
        return dfl;
    }

    @Override
    public void setLongs(String key, long[] val) {
        this.map.putLongArray(key, val);
    }

    @Override
    public ListType getListUnchecked(String key) {
        return this.getListUnchecked(key, null);
    }

    @Override
    public ListType getListUnchecked(String key, ListType dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            return new NBTListType(listTag);
        }
        return dfl;
    }

    @Override
    public void setList(String key, ListType val) {
        this.map.put(key, ((NBTListType)val).getTag());
    }

    @Override
    public MapType getMap(String key) {
        return this.getMap(key, null);
    }

    @Override
    public MapType getMap(String key, MapType dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return new NBTMapType(compoundTag);
        }
        return dfl;
    }

    @Override
    public void setMap(String key, MapType val) {
        this.map.put(key, ((NBTMapType)val).getTag());
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key, String dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof StringTag) {
            StringTag strTag = (StringTag)tag;
            return strTag.value();
        }
        return dfl;
    }

    @Override
    public void setString(String key, String val) {
        this.map.putString(key, val);
    }
}

