/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.util;

import ca.spottedleaf.concurrentutil.util.IntegerUtil;
import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.util.ZeroCollidingReferenceStateTable;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReference2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;

public final class ZeroCollidingReferenceStateTable<O, S> {
    private final Int2ObjectOpenHashMap<Indexer> propertyToIndexer;
    private S[] lookup;
    private final Collection<Property<?>> properties;

    public ZeroCollidingReferenceStateTable(Collection<Property<?>> properties) {
        this.propertyToIndexer = new Int2ObjectOpenHashMap(properties.size());
        this.properties = new ReferenceArrayList(properties);
        ArrayList sortedProperties = new ArrayList(properties);
        sortedProperties.sort((p1, p2) -> Integer.compare(p1.moonrise$getId(), p2.moonrise$getId()));
        int currentMultiple = 1;
        for (Property property : sortedProperties) {
            int totalValues = property.getPossibleValues().size();
            this.propertyToIndexer.put(property.moonrise$getId(), (Object)new Indexer(totalValues, currentMultiple, IntegerUtil.getUnsignedDivisorMagic((long)currentMultiple, (int)32), IntegerUtil.getUnsignedDivisorMagic((long)totalValues, (int)32)));
            currentMultiple *= totalValues;
        }
    }

    public <T extends Comparable<T>> boolean hasProperty(Property<T> property) {
        return this.propertyToIndexer.containsKey(property.moonrise$getId());
    }

    public long getIndex(StateHolder<O, S> stateHolder) {
        long ret = 0L;
        for (Map.Entry<Property<?>, Comparable<?>> entry : stateHolder.getValues().entrySet()) {
            Property<?> property = entry.getKey();
            Comparable<?> value = entry.getValue();
            Indexer indexer = (Indexer)this.propertyToIndexer.get(property.moonrise$getId());
            ret += (long)(property.moonrise$getIdFor(value) * indexer.multiple);
        }
        return ret;
    }

    public boolean isLoaded() {
        return this.lookup != null;
    }

    public void loadInTable(Map<Map<Property<?>, Comparable<?>>, S> universe) {
        if (this.lookup != null) {
            throw new IllegalStateException();
        }
        this.lookup = new StateHolder[universe.size()];
        for (Map.Entry<Map<Property<?>, Comparable<?>>, S> entry : universe.entrySet()) {
            S value = entry.getValue();
            if (value == null) continue;
            this.lookup[(int)((StateHolder)value).moonrise$getTableIndex()] = value;
        }
        for (S value : this.lookup) {
            if (value != null) continue;
            throw new IllegalStateException();
        }
    }

    public <T extends Comparable<T>> T get(long index, Property<T> property) {
        Indexer indexer = (Indexer)this.propertyToIndexer.get(property.moonrise$getId());
        if (indexer == null) {
            return null;
        }
        long divided = index * indexer.multipleDivMagic >>> 32;
        long modded = (divided * indexer.modMagic & 0xFFFFFFFFL) * (long)indexer.totalValues >>> 32;
        return (T)((Comparable)property.moonrise$getById((int)modded));
    }

    public <T extends Comparable<T>> S set(long index, Property<T> property, T with) {
        int newValueId = property.moonrise$getIdFor(with);
        if (newValueId < 0) {
            return null;
        }
        Indexer indexer = (Indexer)this.propertyToIndexer.get(property.moonrise$getId());
        if (indexer == null) {
            return null;
        }
        long divided = index * indexer.multipleDivMagic >>> 32;
        long modded = (divided * indexer.modMagic & 0xFFFFFFFFL) * (long)indexer.totalValues >>> 32;
        long newIndex = ((long)newValueId - modded) * (long)indexer.multiple + index;
        return this.lookup[(int)newIndex];
    }

    public <T extends Comparable<T>> S trySet(long index, Property<T> property, T with, S dfl) {
        Indexer indexer = (Indexer)this.propertyToIndexer.get(property.moonrise$getId());
        if (indexer == null) {
            return dfl;
        }
        int newValueId = property.moonrise$getIdFor(with);
        if (newValueId < 0) {
            return null;
        }
        long divided = index * indexer.multipleDivMagic >>> 32;
        long modded = (divided * indexer.modMagic & 0xFFFFFFFFL) * (long)indexer.totalValues >>> 32;
        long newIndex = ((long)newValueId - modded) * (long)indexer.multiple + index;
        return this.lookup[(int)newIndex];
    }

    public Collection<Property<?>> getProperties() {
        return Collections.unmodifiableCollection(this.properties);
    }

    public Map<Property<?>, Comparable<?>> getMapView(long stateIndex) {
        return new MapView(stateIndex);
    }

    private record Indexer(int totalValues, int multiple, long multipleDivMagic, long modMagic) {
    }

    private class MapView
    extends AbstractReference2ObjectMap<Property<?>, Comparable<?>> {
        private final long stateIndex;
        private ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.util.ZeroCollidingReferenceStateTable$MapView.EntrySet entrySet;

        MapView(long stateIndex) {
            this.stateIndex = stateIndex;
        }

        public boolean containsKey(Object key) {
            Property prop;
            return key instanceof Property && ZeroCollidingReferenceStateTable.this.hasProperty(prop = (Property)key);
        }

        public int size() {
            return ZeroCollidingReferenceStateTable.this.properties.size();
        }

        public ObjectSet<Reference2ObjectMap.Entry<Property<?>, Comparable<?>>> reference2ObjectEntrySet() {
            if (this.entrySet == null) {
                this.entrySet = new EntrySet();
            }
            return this.entrySet;
        }

        public Comparable<?> get(Object key) {
            Comparable<?> comparable;
            if (key instanceof Property) {
                Property prop = (Property)key;
                comparable = (Comparable<?>)ZeroCollidingReferenceStateTable.this.get(this.stateIndex, prop);
            } else {
                comparable = null;
            }
            return comparable;
        }

        class EntrySet
        extends AbstractObjectSet<Reference2ObjectMap.Entry<Property<?>, Comparable<?>>> {
            EntrySet() {
            }

            public ObjectIterator<Reference2ObjectMap.Entry<Property<?>, Comparable<?>>> iterator() {
                final Iterator<Property<?>> propIterator = ZeroCollidingReferenceStateTable.this.properties.iterator();
                return new ObjectIterator<Reference2ObjectMap.Entry<Property<?>, Comparable<?>>>(){

                    public boolean hasNext() {
                        return propIterator.hasNext();
                    }

                    public Reference2ObjectMap.Entry<Property<?>, Comparable<?>> next() {
                        Property prop = (Property)propIterator.next();
                        return new AbstractReference2ObjectMap.BasicEntry((Object)prop, ZeroCollidingReferenceStateTable.this.get(MapView.this.stateIndex, prop));
                    }
                };
            }

            public int size() {
                return ZeroCollidingReferenceStateTable.this.properties.size();
            }
        }
    }
}

