/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.level.entity;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.EntityList;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public final class ChunkEntitySlices {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final int minSection;
    public final int maxSection;
    public final int chunkX;
    public final int chunkZ;
    public final Level world;
    private final EntityCollectionBySection allEntities;
    private final EntityCollectionBySection hardCollidingEntities;
    private final Reference2ObjectOpenHashMap<Class<? extends Entity>, EntityCollectionBySection> entitiesByClass;
    private final Reference2ObjectOpenHashMap<EntityType<?>, EntityCollectionBySection> entitiesByType;
    private final EntityList entities = new EntityList();
    public FullChunkStatus status;
    public final ChunkData chunkData;
    private boolean isTransient;
    private boolean preventStatusUpdates;

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean value) {
        this.isTransient = value;
    }

    public ChunkEntitySlices(Level world, int chunkX, int chunkZ, FullChunkStatus status, ChunkData chunkData, int minSection, int maxSection) {
        this.minSection = minSection;
        this.maxSection = maxSection;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.world = world;
        this.allEntities = new EntityCollectionBySection(this);
        this.hardCollidingEntities = new EntityCollectionBySection(this);
        this.entitiesByClass = new Reference2ObjectOpenHashMap();
        this.entitiesByType = new Reference2ObjectOpenHashMap();
        this.status = status;
        this.chunkData = chunkData;
    }

    public static List<Entity> readEntities(ServerLevel world, ChunkPos pos, CompoundTag compoundTag) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(ChunkAccess.problemPath(pos), LOGGER);){
            ValueInput valueinput = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)world.registryAccess(), compoundTag);
            List list = (List)EntityType.loadEntitiesRecursive(valueinput.childrenListOrEmpty("Entities"), world, EntitySpawnReason.LOAD).collect(ImmutableList.toImmutableList());
            return list;
        }
    }

    public static void copyEntities(CompoundTag from, CompoundTag into) {
        if (from == null) {
            return;
        }
        ListTag entitiesFrom = from.getListOrEmpty("Entities");
        if (entitiesFrom == null || entitiesFrom.isEmpty()) {
            return;
        }
        ListTag entitiesInto = into.getListOrEmpty("Entities");
        into.put("Entities", entitiesInto);
        entitiesInto.addAll(0, entitiesFrom);
    }

    public static CompoundTag saveEntityChunk(List<Entity> entities, ChunkPos chunkPos, ServerLevel world) {
        return ChunkEntitySlices.saveEntityChunk0(entities, chunkPos, world, false);
    }

    public static CompoundTag saveEntityChunk0(List<Entity> entities, ChunkPos chunkPos, ServerLevel world, boolean force) {
        if (!force && entities.isEmpty()) {
            return null;
        }
        ListTag entitiesTag = new ListTag();
        HashMap savedEntityCounts = new HashMap();
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(ChunkAccess.problemPath(chunkPos), LOGGER);){
            for (Entity entity : PlatformHooks.get().modifySavedEntities(world, chunkPos.x, chunkPos.z, entities)) {
                EntityType<?> entityType = entity.getType();
                int saveLimit = world.paperConfig().chunks.entityPerChunkSaveLimit.getOrDefault(entityType, -1);
                if (saveLimit > -1) {
                    if (savedEntityCounts.getOrDefault(entityType, 0) >= saveLimit) continue;
                    savedEntityCounts.merge(entityType, 1, Integer::sum);
                }
                TagValueOutput savedEntity = TagValueOutput.createWithContext(scopedCollector.forChild(entity.problemPath()), entity.registryAccess());
                try {
                    if (!entity.save(savedEntity)) continue;
                    entitiesTag.add(savedEntity.buildResult());
                }
                catch (Exception ex) {
                    LOGGER.error("Entity type " + String.valueOf(entity.getType()) + " failed to serialize", (Throwable)ex);
                }
            }
        }
        CompoundTag ret = NbtUtils.addCurrentDataVersion(new CompoundTag());
        ret.put("Entities", entitiesTag);
        ret.store("Position", ChunkPos.CODEC, chunkPos);
        return !force && entitiesTag.isEmpty() ? null : ret;
    }

    public CompoundTag save() {
        int len = this.entities.size();
        if (len == 0) {
            return null;
        }
        Entity[] rawData = this.entities.getRawData();
        ArrayList<Entity> collectedEntities = new ArrayList<Entity>(len);
        for (int i = 0; i < len; ++i) {
            Entity entity = rawData[i];
            if (!entity.shouldBeSaved()) continue;
            collectedEntities.add(entity);
        }
        if (collectedEntities.isEmpty()) {
            return null;
        }
        return ChunkEntitySlices.saveEntityChunk(collectedEntities, new ChunkPos(this.chunkX, this.chunkZ), (ServerLevel)this.world);
    }

    public boolean unload() {
        int len = this.entities.size();
        Entity[] collectedEntities = Arrays.copyOf(this.entities.getRawData(), len);
        for (int i = 0; i < len; ++i) {
            Entity entity = collectedEntities[i];
            if (entity.isRemoved() || !entity.shouldBeSaved()) continue;
            PlatformHooks.get().unloadEntity(entity);
            if (!entity.isVehicle()) continue;
            for (Entity passenger : entity.getIndirectPassengers()) {
                PlatformHooks.get().unloadEntity(passenger);
            }
        }
        return this.entities.size() != 0;
    }

    public List<Entity> getAllEntities() {
        int len = this.entities.size();
        if (len == 0) {
            return new ArrayList<Entity>();
        }
        Entity[] rawData = this.entities.getRawData();
        ArrayList<Entity> collectedEntities = new ArrayList<Entity>(len);
        for (int i = 0; i < len; ++i) {
            collectedEntities.add(rawData[i]);
        }
        return collectedEntities;
    }

    public boolean isEmpty() {
        return this.entities.size() == 0;
    }

    public void mergeInto(ChunkEntitySlices slices) {
        Entity[] entities = this.entities.getRawData();
        int size = Math.min(entities.length, this.entities.size());
        for (int i = 0; i < size; ++i) {
            Entity entity = entities[i];
            slices.addEntity(entity, entity.moonrise$getSectionY());
        }
    }

    public boolean startPreventingStatusUpdates() {
        boolean ret = this.preventStatusUpdates;
        this.preventStatusUpdates = true;
        return ret;
    }

    public boolean isPreventingStatusUpdates() {
        return this.preventStatusUpdates;
    }

    public void stopPreventingStatusUpdates(boolean prev) {
        this.preventStatusUpdates = prev;
    }

    public void updateStatus(FullChunkStatus status, EntityLookup lookup) {
        this.status = status;
        Entity[] entities = this.entities.getRawData();
        int size = this.entities.size();
        for (int i = 0; i < size; ++i) {
            Entity entity = entities[i];
            Visibility oldVisibility = EntityLookup.getEntityStatus(entity);
            entity.moonrise$setChunkStatus(status);
            Visibility newVisibility = EntityLookup.getEntityStatus(entity);
            lookup.entityStatusChange(entity, this, oldVisibility, newVisibility, false, false, false);
        }
    }

    public boolean addEntity(Entity entity, int chunkSection) {
        if (!this.entities.add(entity)) {
            return false;
        }
        entity.moonrise$setChunkStatus(this.status);
        entity.moonrise$setChunkData(this.chunkData);
        int sectionIndex = chunkSection - this.minSection;
        this.allEntities.addEntity(entity, sectionIndex);
        if (entity.moonrise$isHardColliding()) {
            this.hardCollidingEntities.addEntity(entity, sectionIndex);
        }
        ObjectIterator iterator = this.entitiesByClass.reference2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)iterator.next();
            if (!((Class)entry.getKey()).isInstance(entity)) continue;
            ((EntityCollectionBySection)entry.getValue()).addEntity(entity, sectionIndex);
        }
        EntityCollectionBySection byType = (EntityCollectionBySection)this.entitiesByType.get(entity.getType());
        if (byType != null) {
            byType.addEntity(entity, sectionIndex);
        } else {
            byType = new EntityCollectionBySection(this);
            this.entitiesByType.put(entity.getType(), (Object)byType);
            byType.addEntity(entity, sectionIndex);
        }
        return true;
    }

    public boolean removeEntity(Entity entity, int chunkSection) {
        if (!this.entities.remove(entity)) {
            return false;
        }
        entity.moonrise$setChunkStatus(null);
        entity.moonrise$setChunkData(null);
        int sectionIndex = chunkSection - this.minSection;
        this.allEntities.removeEntity(entity, sectionIndex);
        if (entity.moonrise$isHardColliding()) {
            this.hardCollidingEntities.removeEntity(entity, sectionIndex);
        }
        ObjectIterator iterator = this.entitiesByClass.reference2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)iterator.next();
            if (!((Class)entry.getKey()).isInstance(entity)) continue;
            ((EntityCollectionBySection)entry.getValue()).removeEntity(entity, sectionIndex);
        }
        EntityCollectionBySection byType = (EntityCollectionBySection)this.entitiesByType.get(entity.getType());
        byType.removeEntity(entity, sectionIndex);
        return true;
    }

    public void getHardCollidingEntities(Entity except, AABB box, List<Entity> into, Predicate<? super Entity> predicate) {
        this.hardCollidingEntities.getEntities(except, box, into, predicate);
    }

    public void getEntities(Entity except, AABB box, List<Entity> into, Predicate<? super Entity> predicate) {
        this.allEntities.getEntities(except, box, into, predicate);
    }

    public boolean getEntities(Entity except, AABB box, List<Entity> into, Predicate<? super Entity> predicate, int maxCount) {
        return this.allEntities.getEntitiesLimited(except, box, into, predicate, maxCount);
    }

    public <T extends Entity> void getEntities(EntityType<?> type, AABB box, List<? super T> into, Predicate<? super T> predicate) {
        EntityCollectionBySection byType = (EntityCollectionBySection)this.entitiesByType.get(type);
        if (byType != null) {
            byType.getEntities(null, box, into, predicate);
        }
    }

    public <T extends Entity> boolean getEntities(EntityType<?> type, AABB box, List<? super T> into, Predicate<? super T> predicate, int maxCount) {
        EntityCollectionBySection byType = (EntityCollectionBySection)this.entitiesByType.get(type);
        if (byType != null) {
            return byType.getEntitiesLimited(null, box, into, predicate, maxCount);
        }
        return false;
    }

    protected EntityCollectionBySection initClass(Class<? extends Entity> clazz) {
        EntityCollectionBySection ret = new EntityCollectionBySection(this);
        for (int sectionIndex = 0; sectionIndex < this.allEntities.entitiesBySection.length; ++sectionIndex) {
            BasicEntityList<Entity> sectionEntities = this.allEntities.entitiesBySection[sectionIndex];
            if (sectionEntities == null) continue;
            E[] storage = sectionEntities.storage;
            int len = Math.min(storage.length, sectionEntities.size());
            for (int i = 0; i < len; ++i) {
                Object entity = storage[i];
                if (!clazz.isInstance(entity)) continue;
                ret.addEntity((Entity)entity, sectionIndex);
            }
        }
        return ret;
    }

    public <T extends Entity> void getEntities(Class<? extends T> clazz, Entity except, AABB box, List<? super T> into, Predicate<? super T> predicate) {
        EntityCollectionBySection collection = (EntityCollectionBySection)this.entitiesByClass.get(clazz);
        if (collection != null) {
            collection.getEntities(except, box, into, predicate);
        } else {
            collection = this.initClass(clazz);
            this.entitiesByClass.put(clazz, (Object)collection);
            collection.getEntities(except, box, into, predicate);
        }
    }

    public <T extends Entity> boolean getEntities(Class<? extends T> clazz, Entity except, AABB box, List<? super T> into, Predicate<? super T> predicate, int maxCount) {
        EntityCollectionBySection collection = (EntityCollectionBySection)this.entitiesByClass.get(clazz);
        if (collection != null) {
            return collection.getEntitiesLimited(except, box, into, predicate, maxCount);
        }
        collection = this.initClass(clazz);
        this.entitiesByClass.put(clazz, (Object)collection);
        return collection.getEntitiesLimited(except, box, into, predicate, maxCount);
    }

    private static final class EntityCollectionBySection {
        private final ChunkEntitySlices slices;
        private final BasicEntityList<Entity>[] entitiesBySection;
        private int count;

        public EntityCollectionBySection(ChunkEntitySlices slices) {
            this.slices = slices;
            int sectionCount = slices.maxSection - slices.minSection + 1;
            this.entitiesBySection = new BasicEntityList[sectionCount];
        }

        public void addEntity(Entity entity, int sectionIndex) {
            BasicEntityList<Entity> list = this.entitiesBySection[sectionIndex];
            if (list != null && list.has(entity)) {
                return;
            }
            if (list == null) {
                this.entitiesBySection[sectionIndex] = list = new BasicEntityList();
            }
            list.add(entity);
            ++this.count;
        }

        public void removeEntity(Entity entity, int sectionIndex) {
            BasicEntityList<Entity> list = this.entitiesBySection[sectionIndex];
            if (list == null || !list.remove(entity)) {
                return;
            }
            --this.count;
            if (list.isEmpty()) {
                this.entitiesBySection[sectionIndex] = null;
            }
        }

        public void getEntities(Entity except, AABB box, List<Entity> into, Predicate<? super Entity> predicate) {
            if (this.count == 0) {
                return;
            }
            int minSection = this.slices.minSection;
            int maxSection = this.slices.maxSection;
            int min = Mth.clamp(Mth.floor(box.minY - 2.0) >> 4, minSection, maxSection);
            int max = Mth.clamp(Mth.floor(box.maxY + 2.0) >> 4, minSection, maxSection);
            BasicEntityList<Entity>[] entitiesBySection = this.entitiesBySection;
            for (int section = min; section <= max; ++section) {
                BasicEntityList<Entity> list = entitiesBySection[section - minSection];
                if (list == null) continue;
                E[] storage = list.storage;
                int len = Math.min(storage.length, list.size());
                for (int i = 0; i < len; ++i) {
                    Object entity = storage[i];
                    if (entity == null || entity == except || !((Entity)entity).getBoundingBox().intersects(box) || predicate != null && !predicate.test((Entity)entity)) continue;
                    into.add((Entity)entity);
                }
            }
        }

        public boolean getEntitiesLimited(Entity except, AABB box, List<Entity> into, Predicate<? super Entity> predicate, int maxCount) {
            if (this.count == 0) {
                return false;
            }
            int minSection = this.slices.minSection;
            int maxSection = this.slices.maxSection;
            int min = Mth.clamp(Mth.floor(box.minY - 2.0) >> 4, minSection, maxSection);
            int max = Mth.clamp(Mth.floor(box.maxY + 2.0) >> 4, minSection, maxSection);
            BasicEntityList<Entity>[] entitiesBySection = this.entitiesBySection;
            for (int section = min; section <= max; ++section) {
                BasicEntityList<Entity> list = entitiesBySection[section - minSection];
                if (list == null) continue;
                E[] storage = list.storage;
                int len = Math.min(storage.length, list.size());
                for (int i = 0; i < len; ++i) {
                    Object entity = storage[i];
                    if (entity == null || entity == except || !((Entity)entity).getBoundingBox().intersects(box) || predicate != null && !predicate.test((Entity)entity)) continue;
                    into.add((Entity)entity);
                    if (into.size() < maxCount) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class BasicEntityList<E extends Entity> {
        private static final Entity[] EMPTY = new Entity[0];
        private static final int DEFAULT_CAPACITY = 4;
        private E[] storage;
        private int size;

        public BasicEntityList() {
            this(0);
        }

        public BasicEntityList(int cap) {
            this.storage = cap <= 0 ? EMPTY : new Entity[cap];
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public int size() {
            return this.size;
        }

        private void resize() {
            this.storage = this.storage == EMPTY ? new Entity[4] : (Entity[])Arrays.copyOf(this.storage, this.storage.length * 2);
        }

        public void add(E entity) {
            int idx;
            if ((idx = this.size++) >= this.storage.length) {
                this.resize();
                this.storage[idx] = entity;
            } else {
                this.storage[idx] = entity;
            }
        }

        public int indexOf(E entity) {
            E[] storage = this.storage;
            int len = Math.min(this.storage.length, this.size);
            for (int i = 0; i < len; ++i) {
                if (storage[i] != entity) continue;
                return i;
            }
            return -1;
        }

        public boolean remove(E entity) {
            int idx = this.indexOf(entity);
            if (idx == -1) {
                return false;
            }
            int size = --this.size;
            E[] storage = this.storage;
            if (idx != size) {
                System.arraycopy(storage, idx + 1, storage, idx, size - idx);
            }
            storage[size] = null;
            return true;
        }

        public boolean has(E entity) {
            return this.indexOf(entity) != -1;
        }
    }
}

