/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.profile;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.destroystokyo.paper.profile.SharedPlayerProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.profile.MutablePropertyMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.StringUtil;
import net.minecraft.util.Util;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.component.ResolvableProfile;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.configuration.ConfigSerializationUtil;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.profile.CraftPlayerTextures;
import org.bukkit.craftbukkit.profile.CraftProfileProperty;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;

@SerializableAs(value="PlayerProfile")
public class CraftPlayerProfile
implements PlayerProfile,
SharedPlayerProfile {
    private boolean emptyName;
    private boolean emptyUUID;
    private GameProfile profile;
    private final PropertySet properties = new PropertySet();

    public CraftPlayerProfile(CraftPlayer player) {
        this(player.getHandle().getGameProfile());
    }

    public CraftPlayerProfile(UUID id, String name) {
        this.profile = CraftPlayerProfile.createAuthLibProfile(id, name);
        this.emptyName = name == null;
        this.emptyUUID = id == null;
    }

    public CraftPlayerProfile(NameAndId nameAndId) {
        this(nameAndId.id(), nameAndId.name());
    }

    public CraftPlayerProfile(GameProfile profile) {
        Preconditions.checkArgument((profile != null ? 1 : 0) != 0, (Object)"GameProfile cannot be null!");
        this.profile = new GameProfile(profile.id(), profile.name(), (PropertyMap)new MutablePropertyMap((Multimap<String, Property>)profile.properties()));
    }

    public CraftPlayerProfile(ResolvableProfile resolvableProfile) {
        this(resolvableProfile.unpack().map(GameProfile::id, p -> p.id().orElse(null)), resolvableProfile.unpack().map(GameProfile::name, p -> p.name().orElse(null)));
        CraftPlayerProfile.copyProfileProperties(resolvableProfile.partialProfile(), this.profile);
    }

    public boolean hasProperty(String property) {
        return this.profile.properties().containsKey((Object)property);
    }

    public void setProperty(ProfileProperty property) {
        String name = property.getName();
        PropertyMap properties = this.profile.properties();
        properties.removeAll((Object)name);
        Preconditions.checkArgument((properties.size() < 16 ? 1 : 0) != 0, (Object)"Cannot add more than 16 properties to a profile");
        properties.put((Object)name, (Object)new Property(name, property.getValue(), property.getSignature()));
    }

    public CraftPlayerTextures getTextures() {
        return new CraftPlayerTextures(this);
    }

    public void setTextures(@Nullable PlayerTextures textures) {
        if (textures == null) {
            this.removeProperty("textures");
        } else {
            CraftPlayerTextures craftPlayerTextures = new CraftPlayerTextures(this);
            craftPlayerTextures.copyFrom(textures);
            craftPlayerTextures.rebuildPropertyIfDirty();
        }
    }

    public GameProfile getGameProfile() {
        return this.buildGameProfile();
    }

    public GameProfile getGameProfileUnsafe() {
        return this.profile;
    }

    @Nullable
    public UUID getId() {
        return this.emptyUUID ? null : this.profile.id();
    }

    @Deprecated(forRemoval=true)
    public UUID setId(@Nullable UUID uuid) {
        GameProfile previousProfile = this.profile;
        UUID previousId = this.getId();
        this.profile = CraftPlayerProfile.createAuthLibProfile(uuid, previousProfile.name());
        CraftPlayerProfile.copyProfileProperties(previousProfile, this.profile);
        this.emptyUUID = uuid == null;
        return previousId;
    }

    @Override
    public UUID getUniqueId() {
        return this.getId();
    }

    @Override
    @Nullable
    public String getName() {
        return this.emptyName ? null : this.profile.name();
    }

    @Deprecated(forRemoval=true)
    public String setName(@Nullable String name) {
        GameProfile prev = this.profile;
        this.profile = CraftPlayerProfile.createAuthLibProfile(prev.id(), name);
        CraftPlayerProfile.copyProfileProperties(prev, this.profile);
        this.emptyName = name == null;
        return prev.name();
    }

    @Nonnull
    public Set<ProfileProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<ProfileProperty> properties) {
        properties.forEach(this::setProperty);
    }

    public void clearProperties() {
        this.profile.properties().clear();
    }

    @Override
    public boolean removeProperty(String property) {
        return !this.profile.properties().removeAll((Object)property).isEmpty();
    }

    @Override
    @Nullable
    public Property getProperty(String property) {
        return (Property)Iterables.getFirst((Iterable)this.profile.properties().get((Object)property), null);
    }

    @Override
    @Nullable
    public void setProperty(@NotNull String propertyName, @Nullable Property property) {
        if (property != null) {
            this.setProperty(new ProfileProperty(propertyName, property.value(), property.signature()));
        } else {
            this.profile.properties().removeAll((Object)propertyName);
        }
    }

    @Override
    @NotNull
    public GameProfile buildGameProfile() {
        return new GameProfile(this.profile.id(), this.profile.name(), new PropertyMap((Multimap)this.profile.properties()));
    }

    @Override
    @NotNull
    public ResolvableProfile buildResolvableProfile() {
        if (this.emptyName != this.emptyUUID && this.properties.isEmpty()) {
            return new ResolvableProfile.Dynamic(this.emptyName ? Either.right(this.profile.id()) : Either.left(this.profile.name()), PlayerSkin.Patch.EMPTY);
        }
        return ResolvableProfile.createResolved(this.buildGameProfile());
    }

    public CraftPlayerProfile clone() {
        CraftPlayerProfile clone = new CraftPlayerProfile(this.getId(), this.getName());
        clone.setProperties(this.getProperties());
        return clone;
    }

    public boolean isComplete() {
        return this.getId() != null && StringUtils.isNotBlank((CharSequence)this.getName());
    }

    @NotNull
    public CompletableFuture<PlayerProfile> update() {
        return CompletableFuture.supplyAsync(() -> {
            CraftPlayerProfile clone = this.clone();
            clone.complete(true);
            return clone;
        }, Util.nonCriticalIoPool());
    }

    public boolean completeFromCache() {
        return this.completeFromCache(false, GlobalConfiguration.get().proxies.isProxyOnlineMode());
    }

    public boolean completeFromCache(boolean onlineMode) {
        return this.completeFromCache(false, onlineMode);
    }

    public boolean completeFromCache(boolean lookupUUID, boolean onlineMode) {
        GameProfile copy;
        Object nameAndId;
        GameProfile profile;
        MinecraftServer server = MinecraftServer.getServer();
        String name = this.profile.name();
        if (this.getId() == null) {
            if (onlineMode) {
                profile = server.services().paper().filledProfileCache().getIfCached(name);
                if (profile == null && lookupUUID && (nameAndId = (NameAndId)server.services().nameToIdCache().get(name).orElse(null)) != null) {
                    profile = ((NameAndId)nameAndId).toUncompletedGameProfile();
                }
            } else {
                profile = UUIDUtil.createOfflineProfile(name);
            }
            if (profile != null) {
                copy = new GameProfile(profile.id(), profile.name(), (PropertyMap)new MutablePropertyMap());
                copy.properties().putAll((Multimap)profile.properties());
                CraftPlayerProfile.copyProfileProperties(this.profile, copy);
                this.profile = copy;
                this.emptyUUID = false;
            }
        }
        if ((this.profile.name().isEmpty() || !this.hasTextures()) && this.getId() != null) {
            profile = server.services().paper().filledProfileCache().getIfCached(this.profile.id());
            if (profile == null && ((Optional)(nameAndId = server.services().nameToIdCache().get(this.profile.id()))).isPresent()) {
                profile = ((NameAndId)((Optional)nameAndId).get()).toUncompletedGameProfile();
            }
            if (profile != null) {
                if (this.profile.name().isEmpty()) {
                    copy = new GameProfile(profile.id(), profile.name(), (PropertyMap)new MutablePropertyMap());
                    copy.properties().putAll((Multimap)profile.properties());
                    CraftPlayerProfile.copyProfileProperties(this.profile, copy);
                    this.profile = copy;
                    this.emptyName = false;
                } else if (profile != this.profile) {
                    CraftPlayerProfile.copyProfileProperties(profile, this.profile);
                }
            }
        }
        return this.isComplete();
    }

    public boolean complete(boolean textures) {
        return this.complete(textures, GlobalConfiguration.get().proxies.isProxyOnlineMode());
    }

    public boolean complete(boolean textures, boolean onlineMode) {
        if (this.isComplete() && (!textures || this.hasTextures())) {
            return true;
        }
        MinecraftServer server = MinecraftServer.getServer();
        boolean isCompleteFromCache = this.completeFromCache(true, onlineMode);
        if (onlineMode && (!isCompleteFromCache || textures && !this.hasTextures())) {
            ProfileResult result = server.services().sessionService().fetchProfile(this.profile.id(), true);
            if (result != null && result.profile() != null) {
                CraftPlayerProfile.copyProfileProperties(result.profile(), this.profile, true);
            }
            if (this.isComplete()) {
                GameProfile copy = new GameProfile(this.profile.id(), this.profile.name(), new PropertyMap((Multimap)this.profile.properties()));
                server.services().paper().filledProfileCache().add(copy);
            }
        }
        return this.isComplete() && (!onlineMode || !textures || this.hasTextures());
    }

    private static void copyProfileProperties(GameProfile source, GameProfile target) {
        CraftPlayerProfile.copyProfileProperties(source, target, false);
    }

    private static void copyProfileProperties(GameProfile source, GameProfile target, boolean clearTarget) {
        if (source == target) {
            throw new IllegalArgumentException("Source and target profiles are the same (" + String.valueOf(source) + ")");
        }
        PropertyMap sourceProperties = source.properties();
        PropertyMap targetProperties = target.properties();
        if (clearTarget) {
            targetProperties.clear();
        }
        if (sourceProperties.isEmpty()) {
            return;
        }
        for (Property property : sourceProperties.values()) {
            targetProperties.removeAll((Object)property.name());
            targetProperties.put((Object)property.name(), (Object)property);
        }
    }

    private static GameProfile createAuthLibProfile(UUID uniqueId, String name) {
        Preconditions.checkArgument((name == null || name.length() <= 16 ? 1 : 0) != 0, (Object)"Name cannot be longer than 16 characters");
        Preconditions.checkArgument((name == null || StringUtil.isValidPlayerName(name) ? 1 : 0) != 0, (String)"The name of the profile contains invalid characters: %s", (Object)name);
        return new GameProfile(uniqueId != null ? uniqueId : Util.NIL_UUID, name != null ? name : "", (PropertyMap)new MutablePropertyMap());
    }

    private static ProfileProperty toBukkit(Property property) {
        return new ProfileProperty(property.name(), property.value(), property.signature());
    }

    public static PlayerProfile asBukkitCopy(GameProfile gameProfile) {
        return new CraftPlayerProfile(gameProfile);
    }

    public static Property asAuthlib(ProfileProperty property) {
        return new Property(property.getName(), property.getValue(), property.getSignature());
    }

    public static GameProfile asAuthlibCopy(PlayerProfile profile) {
        CraftPlayerProfile craft = (CraftPlayerProfile)profile;
        return craft.getGameProfile();
    }

    public static ResolvableProfile asResolvableProfileCopy(PlayerProfile profile) {
        return ((SharedPlayerProfile)profile).buildResolvableProfile();
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (!this.emptyUUID) {
            map.put("uniqueId", this.getId().toString());
        }
        if (!this.emptyName) {
            map.put("name", this.getName());
        }
        if (!this.properties.isEmpty()) {
            ArrayList<Map<String, Object>> propertiesData = new ArrayList<Map<String, Object>>();
            for (ProfileProperty property : this.properties) {
                propertiesData.add(CraftProfileProperty.serialize(new Property(property.getName(), property.getValue(), property.getSignature())));
            }
            map.put("properties", propertiesData);
        }
        return map;
    }

    public static CraftPlayerProfile deserialize(Map<String, Object> map) {
        UUID uniqueId = ConfigSerializationUtil.getUuid(map, "uniqueId", true);
        String name = ConfigSerializationUtil.getString(map, "name", true);
        CraftPlayerProfile profile = new CraftPlayerProfile(uniqueId, name);
        if (map.containsKey("properties")) {
            for (Object propertyData : (List)map.get("properties")) {
                if (!(propertyData instanceof Map)) {
                    throw new IllegalArgumentException("Property data (" + String.valueOf(propertyData) + ") is not a valid Map");
                }
                Property property = CraftProfileProperty.deserialize((Map)propertyData);
                profile.profile.properties().put((Object)property.name(), (Object)property);
            }
        }
        return profile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraftPlayerProfile that = (CraftPlayerProfile)o;
        return this.emptyName == that.emptyName && this.emptyUUID == that.emptyUUID && Objects.equals(this.profile, that.profile);
    }

    public int hashCode() {
        return Objects.hash(this.emptyName, this.emptyUUID, this.profile);
    }

    public String toString() {
        return "CraftPlayerProfile [uniqueId=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", properties=" + org.bukkit.craftbukkit.profile.CraftPlayerProfile.toString(this.profile.properties()) + "]";
    }

    private class PropertySet
    extends AbstractSet<ProfileProperty> {
        private PropertySet() {
        }

        @Override
        @Nonnull
        public Iterator<ProfileProperty> iterator() {
            return new ProfilePropertyIterator(this, CraftPlayerProfile.this.profile.properties().values().iterator());
        }

        @Override
        public int size() {
            return CraftPlayerProfile.this.profile.properties().size();
        }

        @Override
        public boolean add(ProfileProperty property) {
            CraftPlayerProfile.this.setProperty(property);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends ProfileProperty> c) {
            CraftPlayerProfile.this.setProperties(c);
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof ProfileProperty && CraftPlayerProfile.this.profile.properties().containsKey((Object)((ProfileProperty)o).getName());
        }

        private class ProfilePropertyIterator
        implements Iterator<ProfileProperty> {
            private final Iterator<Property> iterator;

            ProfilePropertyIterator(PropertySet propertySet, Iterator<Property> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ProfileProperty next() {
                return CraftPlayerProfile.toBukkit(this.iterator.next());
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        }
    }
}

