/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.PaperDialogCodecs;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.NBTComponentBuilder;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.ShadowColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleGetter;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.object.ObjectContents;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import net.kyori.adventure.text.object.SpriteObjectContents;
import net.kyori.adventure.util.Index;
import net.minecraft.commands.arguments.selector.SelectorPattern;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class AdventureCodecs {
    public static final Codec<BinaryTagHolder> BINARY_TAG_HOLDER_CODEC = ExtraCodecs.NBT.flatComapMap(tag -> BinaryTagHolder.encode((Object)tag, PaperAdventure.NBT_CODEC), api -> {
        try {
            Tag tag = (Tag)api.get(PaperAdventure.NBT_CODEC);
            return DataResult.success((Object)tag);
        }
        catch (CommandSyntaxException e) {
            return DataResult.error(e::getMessage);
        }
    });
    public static final Codec<Component> COMPONENT_CODEC = Codec.recursive((String)"adventure Component", AdventureCodecs::createCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, Component> STREAM_COMPONENT_CODEC = ByteBufCodecs.fromCodecWithRegistriesTrusted(COMPONENT_CODEC);
    static final Codec<ShadowColor> SHADOW_COLOR_CODEC = ExtraCodecs.ARGB_COLOR_CODEC.xmap(ShadowColor::shadowColor, ShadowColor::value);
    static final Codec<TextColor> TEXT_COLOR_CODEC = Codec.STRING.comapFlatMap(s -> {
        if (s.startsWith("#")) {
            @Nullable TextColor value = TextColor.fromHexString((String)s);
            return value != null ? DataResult.success((Object)value) : DataResult.error(() -> "Cannot convert " + s + " to adventure TextColor");
        }
        @Nullable NamedTextColor value = (NamedTextColor)NamedTextColor.NAMES.value(s);
        return value != null ? DataResult.success((Object)value) : DataResult.error(() -> "Cannot convert " + s + " to adventure NamedTextColor");
    }, textColor -> {
        if (textColor instanceof NamedTextColor) {
            NamedTextColor named = (NamedTextColor)textColor;
            return (String)NamedTextColor.NAMES.keyOrThrow((Object)named);
        }
        return textColor.asHexString();
    });
    public static final Codec<Key> KEY_CODEC = Codec.STRING.comapFlatMap(s -> Key.parseable((String)s) ? DataResult.success((Object)Key.key((String)s)) : DataResult.error(() -> "Cannot convert " + s + " to adventure Key"), Key::asString);
    static final Function<ClickEvent, String> TEXT_PAYLOAD_EXTRACTOR = a -> ((ClickEvent.Payload.Text)a.payload()).value();
    static final MapCodec<ClickEvent> OPEN_URL_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.UNTRUSTED_URI.fieldOf("url").forGetter(a -> {
        String url = ((ClickEvent.Payload.Text)a.payload()).value();
        return URI.create((String)(!url.contains("://") ? "https://" + url : url));
    })).apply((Applicative)instance, url -> ClickEvent.openUrl((String)url.toString())));
    static final MapCodec<ClickEvent> OPEN_FILE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("path").forGetter(TEXT_PAYLOAD_EXTRACTOR)).apply((Applicative)instance, ClickEvent::openFile));
    static final MapCodec<ClickEvent> RUN_COMMAND_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.CHAT_STRING.fieldOf("command").forGetter(TEXT_PAYLOAD_EXTRACTOR)).apply((Applicative)instance, ClickEvent::runCommand));
    static final MapCodec<ClickEvent> SUGGEST_COMMAND_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.CHAT_STRING.fieldOf("command").forGetter(TEXT_PAYLOAD_EXTRACTOR)).apply((Applicative)instance, ClickEvent::suggestCommand));
    static final MapCodec<ClickEvent> CHANGE_PAGE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("page").forGetter(a -> ((ClickEvent.Payload.Int)a.payload()).integer())).apply((Applicative)instance, ClickEvent::changePage));
    static final MapCodec<ClickEvent> COPY_TO_CLIPBOARD_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("value").forGetter(TEXT_PAYLOAD_EXTRACTOR)).apply((Applicative)instance, ClickEvent::copyToClipboard));
    static final MapCodec<ClickEvent> SHOW_DIALOG_CODEC = MapCodec.recursive((String)"show_dialog", ignored -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)PaperDialogCodecs.DIALOG_CODEC.fieldOf("dialog").forGetter(a -> (Dialog)((ClickEvent.Payload.Dialog)a.payload()).dialog())).apply((Applicative)instance, ClickEvent::showDialog)));
    static final MapCodec<ClickEvent> CUSTOM_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)KEY_CODEC.fieldOf("id").forGetter(a -> ((ClickEvent.Payload.Custom)a.payload()).key()), (App)BINARY_TAG_HOLDER_CODEC.fieldOf("payload").forGetter(a -> ((ClickEvent.Payload.Custom)a.payload()).nbt())).apply((Applicative)instance, ClickEvent::custom));
    static final ClickEventType OPEN_URL_CLICK_EVENT_TYPE = new ClickEventType(OPEN_URL_CODEC, "open_url");
    static final ClickEventType OPEN_FILE_CLICK_EVENT_TYPE = new ClickEventType(OPEN_FILE_CODEC, "open_file");
    static final ClickEventType RUN_COMMAND_CLICK_EVENT_TYPE = new ClickEventType(RUN_COMMAND_CODEC, "run_command");
    static final ClickEventType SUGGEST_COMMAND_CLICK_EVENT_TYPE = new ClickEventType(SUGGEST_COMMAND_CODEC, "suggest_command");
    static final ClickEventType CHANGE_PAGE_CLICK_EVENT_TYPE = new ClickEventType(CHANGE_PAGE_CODEC, "change_page");
    static final ClickEventType COPY_TO_CLIPBOARD_CLICK_EVENT_TYPE = new ClickEventType(COPY_TO_CLIPBOARD_CODEC, "copy_to_clipboard");
    static final ClickEventType SHOW_DIALOG_CLICK_EVENT_TYPE = new ClickEventType(SHOW_DIALOG_CODEC, "show_dialog");
    static final ClickEventType CUSTOM_CLICK_EVENT_TYPE = new ClickEventType(CUSTOM_CODEC, "custom");
    public static final Supplier<ClickEventType[]> CLICK_EVENT_TYPES = () -> new ClickEventType[]{OPEN_URL_CLICK_EVENT_TYPE, OPEN_FILE_CLICK_EVENT_TYPE, RUN_COMMAND_CLICK_EVENT_TYPE, SUGGEST_COMMAND_CLICK_EVENT_TYPE, CHANGE_PAGE_CLICK_EVENT_TYPE, COPY_TO_CLIPBOARD_CLICK_EVENT_TYPE, SHOW_DIALOG_CLICK_EVENT_TYPE, CUSTOM_CLICK_EVENT_TYPE};
    static final Codec<ClickEventType> CLICK_EVENT_TYPE_CODEC = StringRepresentable.fromValues(CLICK_EVENT_TYPES);
    public static final Function<ClickEvent, ClickEventType> GET_CLICK_EVENT_TYPE = he -> switch (he.action()) {
        default -> throw new MatchException(null, null);
        case ClickEvent.Action.OPEN_URL -> OPEN_URL_CLICK_EVENT_TYPE;
        case ClickEvent.Action.OPEN_FILE -> OPEN_FILE_CLICK_EVENT_TYPE;
        case ClickEvent.Action.RUN_COMMAND -> RUN_COMMAND_CLICK_EVENT_TYPE;
        case ClickEvent.Action.SUGGEST_COMMAND -> SUGGEST_COMMAND_CLICK_EVENT_TYPE;
        case ClickEvent.Action.CHANGE_PAGE -> CHANGE_PAGE_CLICK_EVENT_TYPE;
        case ClickEvent.Action.COPY_TO_CLIPBOARD -> COPY_TO_CLIPBOARD_CLICK_EVENT_TYPE;
        case ClickEvent.Action.SHOW_DIALOG -> SHOW_DIALOG_CLICK_EVENT_TYPE;
        case ClickEvent.Action.CUSTOM -> CUSTOM_CLICK_EVENT_TYPE;
    };
    static final Codec<ClickEvent> CLICK_EVENT_CODEC = CLICK_EVENT_TYPE_CODEC.dispatch("action", GET_CLICK_EVENT_TYPE, ClickEventType::codec);
    static final MapCodec<HoverEvent<Component>> SHOW_TEXT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)COMPONENT_CODEC.fieldOf("value").forGetter(HoverEvent::value)).apply((Applicative)instance, HoverEvent::showText));
    static final MapCodec<HoverEvent<HoverEvent.ShowEntity>> SHOW_ENTITY_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)KEY_CODEC.fieldOf("id").forGetter(a -> ((HoverEvent.ShowEntity)a.value()).type()), (App)UUIDUtil.LENIENT_CODEC.fieldOf("uuid").forGetter(a -> ((HoverEvent.ShowEntity)a.value()).id()), (App)COMPONENT_CODEC.lenientOptionalFieldOf("name").forGetter(a -> Optional.ofNullable(((HoverEvent.ShowEntity)a.value()).name()))).apply((Applicative)instance, (key, uuid, component) -> HoverEvent.showEntity((Key)key, (UUID)uuid, (Component)component.orElse(null))));
    static final MapCodec<HoverEvent<HoverEvent.ShowItem>> SHOW_ITEM_CODEC = HoverEvent.ShowItem.CODEC.xmap(internal -> {
        String typeKey = internal.item().getItemHolder().unwrapKey().orElseThrow().identifier().toString();
        return HoverEvent.showItem((Keyed)Key.key((String)typeKey), (int)internal.item().getCount(), PaperAdventure.asAdventure(internal.item().getComponentsPatch()));
    }, adventure -> {
        Item itemType = BuiltInRegistries.ITEM.getValue(PaperAdventure.asVanilla(((HoverEvent.ShowItem)adventure.value()).item()));
        Map dataComponentsMap = ((HoverEvent.ShowItem)adventure.value()).dataComponents();
        ItemStack stack = new ItemStack(BuiltInRegistries.ITEM.wrapAsHolder(itemType), ((HoverEvent.ShowItem)adventure.value()).count(), PaperAdventure.asVanilla(dataComponentsMap));
        return new HoverEvent.ShowItem(stack);
    });
    static final HoverEventType<HoverEvent.ShowEntity> SHOW_ENTITY_HOVER_EVENT_TYPE = new HoverEventType<HoverEvent.ShowEntity>(SHOW_ENTITY_CODEC, "show_entity");
    static final HoverEventType<HoverEvent.ShowItem> SHOW_ITEM_HOVER_EVENT_TYPE = new HoverEventType<HoverEvent.ShowItem>(SHOW_ITEM_CODEC, "show_item");
    static final HoverEventType<Component> SHOW_TEXT_HOVER_EVENT_TYPE = new HoverEventType<Component>(SHOW_TEXT_CODEC, "show_text");
    static final Codec<HoverEventType<?>> HOVER_EVENT_TYPE_CODEC = StringRepresentable.fromValues(() -> new HoverEventType[]{SHOW_ENTITY_HOVER_EVENT_TYPE, SHOW_ITEM_HOVER_EVENT_TYPE, SHOW_TEXT_HOVER_EVENT_TYPE});
    private static final Function<HoverEvent<?>, HoverEventType<?>> GET_HOVER_EVENT_TYPE = he -> {
        if (he.action() == HoverEvent.Action.SHOW_ENTITY) {
            return SHOW_ENTITY_HOVER_EVENT_TYPE;
        }
        if (he.action() == HoverEvent.Action.SHOW_ITEM) {
            return SHOW_ITEM_HOVER_EVENT_TYPE;
        }
        if (he.action() == HoverEvent.Action.SHOW_TEXT) {
            return SHOW_TEXT_HOVER_EVENT_TYPE;
        }
        throw new IllegalStateException();
    };
    static final Codec<HoverEvent<?>> HOVER_EVENT_CODEC = HOVER_EVENT_TYPE_CODEC.dispatch("action", GET_HOVER_EVENT_TYPE, HoverEventType::codec);
    public static final MapCodec<Style> STYLE_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TEXT_COLOR_CODEC.optionalFieldOf("color").forGetter(AdventureCodecs.nullableGetter(Style::color)), (App)SHADOW_COLOR_CODEC.optionalFieldOf("shadow_color").forGetter(AdventureCodecs.nullableGetter(StyleGetter::shadowColor)), (App)Codec.BOOL.optionalFieldOf("bold").forGetter(AdventureCodecs.decorationGetter(TextDecoration.BOLD)), (App)Codec.BOOL.optionalFieldOf("italic").forGetter(AdventureCodecs.decorationGetter(TextDecoration.ITALIC)), (App)Codec.BOOL.optionalFieldOf("underlined").forGetter(AdventureCodecs.decorationGetter(TextDecoration.UNDERLINED)), (App)Codec.BOOL.optionalFieldOf("strikethrough").forGetter(AdventureCodecs.decorationGetter(TextDecoration.STRIKETHROUGH)), (App)Codec.BOOL.optionalFieldOf("obfuscated").forGetter(AdventureCodecs.decorationGetter(TextDecoration.OBFUSCATED)), (App)CLICK_EVENT_CODEC.optionalFieldOf("click_event").forGetter(AdventureCodecs.nullableGetter(Style::clickEvent)), (App)HOVER_EVENT_CODEC.optionalFieldOf("hover_event").forGetter(AdventureCodecs.nullableGetter(Style::hoverEvent)), (App)Codec.STRING.optionalFieldOf("insertion").forGetter(AdventureCodecs.nullableGetter(Style::insertion)), (App)KEY_CODEC.optionalFieldOf("font").forGetter(AdventureCodecs.nullableGetter(Style::font))).apply((Applicative)instance, (textColor, shadowColor, bold, italic, underlined, strikethrough, obfuscated, clickEvent, hoverEvent, insertion, font) -> Style.style(builder -> {
        textColor.ifPresent(arg_0 -> ((Style.Builder)builder).color(arg_0));
        shadowColor.ifPresent(arg_0 -> ((Style.Builder)builder).shadowColor(arg_0));
        bold.ifPresent(AdventureCodecs.styleBooleanConsumer(builder, TextDecoration.BOLD));
        italic.ifPresent(AdventureCodecs.styleBooleanConsumer(builder, TextDecoration.ITALIC));
        underlined.ifPresent(AdventureCodecs.styleBooleanConsumer(builder, TextDecoration.UNDERLINED));
        strikethrough.ifPresent(AdventureCodecs.styleBooleanConsumer(builder, TextDecoration.STRIKETHROUGH));
        obfuscated.ifPresent(AdventureCodecs.styleBooleanConsumer(builder, TextDecoration.OBFUSCATED));
        clickEvent.ifPresent(arg_0 -> ((Style.Builder)builder).clickEvent(arg_0));
        hoverEvent.ifPresent(arg_0 -> ((Style.Builder)builder).hoverEvent(arg_0));
        insertion.ifPresent(arg_0 -> ((Style.Builder)builder).insertion(arg_0));
        font.ifPresent(arg_0 -> ((Style.Builder)builder).font(arg_0));
    })));
    static final MapCodec<TextComponent> TEXT_COMPONENT_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("text").forGetter(TextComponent::content)).apply((Applicative)instance, Component::text));
    static final Codec<Object> PRIMITIVE_ARG_CODEC = ExtraCodecs.JAVA.validate(TranslatableContents::filterAllowedArguments);
    static final Codec<TranslationArgument> ARG_CODEC = Codec.either(PRIMITIVE_ARG_CODEC, COMPONENT_CODEC).flatXmap(primitiveOrComponent -> primitiveOrComponent.map(o -> {
        TranslationArgument arg;
        if (o instanceof String) {
            String s = (String)o;
            arg = TranslationArgument.component((ComponentLike)Component.text((String)s));
        } else if (o instanceof Boolean) {
            Boolean bool = (Boolean)o;
            arg = TranslationArgument.bool((boolean)bool);
        } else if (o instanceof Number) {
            Number num = (Number)o;
            arg = TranslationArgument.numeric((Number)num);
        } else {
            return DataResult.error(() -> String.valueOf(o) + " is not a valid translation argument primitive");
        }
        return DataResult.success((Object)arg);
    }, component -> DataResult.success((Object)TranslationArgument.component((ComponentLike)component))), translationArgument -> {
        if (translationArgument.value() instanceof Number || translationArgument.value() instanceof Boolean) {
            return DataResult.success(Either.left(translationArgument.value()));
        }
        Component component = translationArgument.asComponent();
        String collapsed = AdventureCodecs.tryCollapseToString(component);
        if (collapsed != null) {
            return DataResult.success(Either.left(collapsed));
        }
        return DataResult.success(Either.right(component));
    });
    static final MapCodec<TranslatableComponent> TRANSLATABLE_COMPONENT_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("translate").forGetter(TranslatableComponent::key), (App)Codec.STRING.lenientOptionalFieldOf("fallback").forGetter(AdventureCodecs.nullableGetter(TranslatableComponent::fallback)), (App)ARG_CODEC.listOf().optionalFieldOf("with").forGetter(c -> c.arguments().isEmpty() ? Optional.empty() : Optional.of(c.arguments()))).apply((Applicative)instance, (key, fallback, components) -> Component.translatable((String)key, components.orElse(Collections.emptyList())).fallback((String)fallback.orElse(null))));
    static final MapCodec<KeybindComponent> KEYBIND_COMPONENT_MAP_CODEC = KeybindContents.MAP_CODEC.xmap(k -> Component.keybind((String)k.getName()), k -> new KeybindContents(k.keybind()));
    static final ExtraCodecs.LateBoundIdMapper<String, MapCodec<? extends ObjectComponent>> OBJECT_CONTENTS_MAPPER = new ExtraCodecs.LateBoundIdMapper();
    static final MapCodec<ObjectComponent> SPRITE_OBJECT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)KEY_CODEC.optionalFieldOf("atlas", (Object)SpriteObjectContents.DEFAULT_ATLAS).forGetter(obj -> ((SpriteObjectContents)obj.contents()).atlas()), (App)KEY_CODEC.fieldOf("sprite").forGetter(obj -> ((SpriteObjectContents)obj.contents()).sprite())).apply((Applicative)instance, (atlas, sprite) -> Component.object((ObjectContents)ObjectContents.sprite((Key)atlas, (Key)sprite))));
    static final Codec<ObjectComponent> PLAYER_OBJECT_PLAYER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapEither(ExtraCodecs.STORED_GAME_PROFILE, ResolvableProfile.Partial.MAP_CODEC).xmap(either -> either.map(gameProfile -> Component.object((ObjectContents)ObjectContents.playerHead().name(gameProfile.name()).id(gameProfile.id()).profileProperties(gameProfile.properties().entries().stream().map(entry -> PlayerHeadObjectContents.property((String)((Property)entry.getValue()).name(), (String)((Property)entry.getValue()).value(), (String)((Property)entry.getValue()).signature())).toList()).build()), partial -> Component.object((ObjectContents)ObjectContents.playerHead().name((String)partial.name().orElse(null)).id((UUID)partial.id().orElse(null)).profileProperties(partial.properties().entries().stream().map(entry -> PlayerHeadObjectContents.property((String)((Property)entry.getValue()).name(), (String)((Property)entry.getValue()).value(), (String)((Property)entry.getValue()).signature())).toList()).build())), objectComponent -> {
        PlayerHeadObjectContents contents = (PlayerHeadObjectContents)objectComponent.contents();
        return Either.right(new ResolvableProfile.Partial(Optional.ofNullable(contents.name()), Optional.ofNullable(contents.id()), new PropertyMap((Multimap)contents.profileProperties().stream().map(prop -> new Property(prop.name(), prop.value(), prop.signature())).collect(ImmutableListMultimap.toImmutableListMultimap(Property::name, Function.identity())))));
    }).forGetter(obj -> obj), (App)KEY_CODEC.optionalFieldOf("texture").forGetter(obj -> Optional.ofNullable(((PlayerHeadObjectContents)obj.contents()).texture()))).apply((Applicative)instance, (player, texture) -> player.contents((ObjectContents)((PlayerHeadObjectContents)player.contents()).toBuilder().texture((Key)texture.orElse(null)).build())));
    static final MapCodec<ObjectComponent> PLAYER_OBJECT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PLAYER_OBJECT_PLAYER_CODEC.fieldOf("player").forGetter(obj -> obj), (App)Codec.BOOL.optionalFieldOf("hat", (Object)true).forGetter(obj -> ((PlayerHeadObjectContents)obj.contents()).hat())).apply((Applicative)instance, (player, hat) -> player.contents((ObjectContents)((PlayerHeadObjectContents)player.contents()).toBuilder().hat(hat.booleanValue()).build())));
    static final MapCodec<ObjectComponent> OBJECT_COMPONENT_MAP_CODEC;
    static final MapCodec<ScoreComponent> SCORE_COMPONENT_INNER_MAP_CODEC;
    static final MapCodec<ScoreComponent> SCORE_COMPONENT_MAP_CODEC;
    static final MapCodec<SelectorComponent> SELECTOR_COMPONENT_MAP_CODEC;
    static final DataSourceType<StorageDataSource> STORAGE_DATA_SOURCE_TYPE;
    static final DataSourceType<BlockDataSource> BLOCK_DATA_SOURCE_TYPE;
    static final DataSourceType<EntityDataSource> ENTITY_DATA_SOURCE_TYPE;
    private static final ExtraCodecs.LateBoundIdMapper<String, MapCodec<? extends NbtComponentDataSource>> NBT_COMPONENT_DATA_SOURCE_MAPPER;
    static final MapCodec<NbtComponentDataSource> NBT_COMPONENT_DATA_SOURCE_CODEC;
    static final MapCodec<NBTComponent<?, ?>> NBT_COMPONENT_MAP_CODEC;
    static final ComponentType<TextComponent> PLAIN;
    static final ComponentType<TranslatableComponent> TRANSLATABLE;
    static final ComponentType<KeybindComponent> KEYBIND;
    static final ComponentType<ObjectComponent> OBJECT;
    static final ComponentType<ScoreComponent> SCORE;
    static final ComponentType<SelectorComponent> SELECTOR;
    static final ComponentType<NBTComponent<?, ?>> NBT;
    public static final Codec<BinaryTagHolder> BINARY_TAG_HOLDER_COMPOUND_CODEC;

    static Consumer<Boolean> styleBooleanConsumer(Style.Builder builder, TextDecoration decoration) {
        return b -> builder.decoration(decoration, b.booleanValue());
    }

    static Function<Style, Optional<Boolean>> decorationGetter(TextDecoration decoration) {
        return style -> Optional.ofNullable(style.decoration(decoration) == TextDecoration.State.NOT_SET ? null : Boolean.valueOf(style.decoration(decoration) == TextDecoration.State.TRUE));
    }

    static <R, T> Function<R, Optional<T>> nullableGetter(Function<R, @Nullable T> getter) {
        return style -> Optional.ofNullable(getter.apply(style));
    }

    static Codec<Component> createCodec(Codec<Component> selfCodec) {
        ComponentType[] types;
        ExtraCodecs.LateBoundIdMapper lateBoundIdMapper = new ExtraCodecs.LateBoundIdMapper();
        for (ComponentType type : types = new ComponentType[]{PLAIN, TRANSLATABLE, KEYBIND, OBJECT, SCORE, SELECTOR, NBT}) {
            lateBoundIdMapper.put(type.id(), type.codec());
        }
        MapCodec<Component> legacyCodec = ComponentSerialization.createLegacyComponentMatcher(lateBoundIdMapper, component -> {
            for (ComponentType type : types) {
                if (!type.test().test((Component)component)) continue;
                return type.codec();
            }
            throw new IllegalStateException("Unexpected component type " + String.valueOf(component));
        }, "type");
        Codec directCodec = RecordCodecBuilder.create(instance -> instance.group((App)legacyCodec.forGetter(Function.identity()), (App)ExtraCodecs.nonEmptyList(selfCodec.listOf()).optionalFieldOf("extra", List.of()).forGetter(Component::children), (App)STYLE_MAP_CODEC.forGetter(Component::style)).apply((Applicative)instance, (component, children, style) -> component.style(style).children(children)));
        return Codec.either((Codec)Codec.either((Codec)Codec.STRING, ExtraCodecs.nonEmptyList(selfCodec.listOf())), (Codec)directCodec).xmap(stringOrListOrComponent -> stringOrListOrComponent.map(stringOrList -> stringOrList.map(Component::text, AdventureCodecs::createFromList), Function.identity()), text -> {
            @Nullable String string = AdventureCodecs.tryCollapseToString(text);
            return string != null ? Either.left(Either.left(string)) : Either.right(text);
        });
    }

    public static @Nullable String tryCollapseToString(Component component) {
        if (component instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)component;
            if (component.children().isEmpty() && component.style().isEmpty()) {
                return textComponent.content();
            }
        }
        return null;
    }

    static Component createFromList(List<? extends Component> components) {
        Component component = components.get(0);
        for (int i = 1; i < components.size(); ++i) {
            component = component.append(components.get(i));
        }
        return component;
    }

    public static <T> Codec<T> indexCodec(Index<String, T> index) {
        return Codec.of((Encoder)Codec.STRING.comap(arg_0 -> index.keyOrThrow(arg_0)), (Decoder)Codec.STRING.map(arg_0 -> index.valueOrThrow(arg_0)));
    }

    private AdventureCodecs() {
    }

    static {
        OBJECT_CONTENTS_MAPPER.put("atlas", SPRITE_OBJECT_CODEC);
        OBJECT_CONTENTS_MAPPER.put("player", PLAYER_OBJECT_CODEC);
        OBJECT_COMPONENT_MAP_CODEC = ComponentSerialization.createLegacyComponentMatcher(OBJECT_CONTENTS_MAPPER, objectComponent -> {
            if (objectComponent.contents() instanceof SpriteObjectContents) {
                return SPRITE_OBJECT_CODEC;
            }
            if (objectComponent.contents() instanceof PlayerHeadObjectContents) {
                return PLAYER_OBJECT_CODEC;
            }
            throw new IllegalArgumentException("Unknown ObjectContents type " + String.valueOf(objectComponent.contents().getClass()));
        }, "object");
        SCORE_COMPONENT_INNER_MAP_CODEC = ScoreContents.INNER_CODEC.xmap(s -> Component.score((String)s.name().map(SelectorPattern::pattern, Function.identity()), (String)s.objective()), s -> new ScoreContents(SelectorPattern.parse(s.name()).map(Either::left).result().orElse(Either.right(s.name())), s.objective()));
        SCORE_COMPONENT_MAP_CODEC = SCORE_COMPONENT_INNER_MAP_CODEC.fieldOf("score");
        SELECTOR_COMPONENT_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("selector").forGetter(SelectorComponent::pattern), (App)COMPONENT_CODEC.optionalFieldOf("separator").forGetter(AdventureCodecs.nullableGetter(SelectorComponent::separator))).apply((Applicative)instance, (selector, component) -> Component.selector((String)selector, (ComponentLike)component.orElse(null))));
        STORAGE_DATA_SOURCE_TYPE = new DataSourceType(RecordCodecBuilder.mapCodec(instance -> instance.group((App)KEY_CODEC.fieldOf("storage").forGetter(StorageDataSource::storage)).apply((Applicative)instance, StorageDataSource::new)), "storage");
        BLOCK_DATA_SOURCE_TYPE = new DataSourceType(RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("block").forGetter(BlockDataSource::posPattern)).apply((Applicative)instance, BlockDataSource::new)), "block");
        ENTITY_DATA_SOURCE_TYPE = new DataSourceType(RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("entity").forGetter(EntityDataSource::selectorPattern)).apply((Applicative)instance, EntityDataSource::new)), "entity");
        NBT_COMPONENT_DATA_SOURCE_MAPPER = new ExtraCodecs.LateBoundIdMapper();
        for (DataSourceType<StorageDataSource> type : List.of(ENTITY_DATA_SOURCE_TYPE, BLOCK_DATA_SOURCE_TYPE, STORAGE_DATA_SOURCE_TYPE)) {
            NBT_COMPONENT_DATA_SOURCE_MAPPER.put(type.id(), type.codec());
        }
        NBT_COMPONENT_DATA_SOURCE_CODEC = ComponentSerialization.createLegacyComponentMatcher(NBT_COMPONENT_DATA_SOURCE_MAPPER, source -> source.type().codec(), "source");
        NBT_COMPONENT_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("nbt").forGetter(NBTComponent::nbtPath), (App)Codec.BOOL.lenientOptionalFieldOf("interpret", (Object)false).forGetter(NBTComponent::interpret), (App)COMPONENT_CODEC.lenientOptionalFieldOf("separator").forGetter(AdventureCodecs.nullableGetter(NBTComponent::separator)), (App)NBT_COMPONENT_DATA_SOURCE_CODEC.forGetter(nbtComponent -> {
            if (nbtComponent instanceof EntityNBTComponent) {
                EntityNBTComponent entityNBTComponent = (EntityNBTComponent)nbtComponent;
                return new EntityDataSource(entityNBTComponent.selector());
            }
            if (nbtComponent instanceof BlockNBTComponent) {
                BlockNBTComponent blockNBTComponent = (BlockNBTComponent)nbtComponent;
                return new BlockDataSource(blockNBTComponent.pos().asString());
            }
            if (nbtComponent instanceof StorageNBTComponent) {
                StorageNBTComponent storageNBTComponent = (StorageNBTComponent)nbtComponent;
                return new StorageDataSource(storageNBTComponent.storage());
            }
            throw new IllegalArgumentException(String.valueOf(nbtComponent) + " isn't a valid nbt component");
        })).apply((Applicative)instance, (nbtPath, interpret, separator, dataSource) -> (NBTComponent)dataSource.builder().nbtPath(nbtPath).interpret(interpret.booleanValue()).separator((ComponentLike)separator.orElse(null)).build()));
        PLAIN = new ComponentType<TextComponent>(TEXT_COMPONENT_MAP_CODEC, TextComponent.class::isInstance, "text");
        TRANSLATABLE = new ComponentType<TranslatableComponent>(TRANSLATABLE_COMPONENT_MAP_CODEC, TranslatableComponent.class::isInstance, "translatable");
        KEYBIND = new ComponentType<KeybindComponent>(KEYBIND_COMPONENT_MAP_CODEC, KeybindComponent.class::isInstance, "keybind");
        OBJECT = new ComponentType<ObjectComponent>(OBJECT_COMPONENT_MAP_CODEC, ObjectComponent.class::isInstance, "object");
        SCORE = new ComponentType<ScoreComponent>(SCORE_COMPONENT_MAP_CODEC, ScoreComponent.class::isInstance, "score");
        SELECTOR = new ComponentType<SelectorComponent>(SELECTOR_COMPONENT_MAP_CODEC, SelectorComponent.class::isInstance, "selector");
        NBT = new ComponentType(NBT_COMPONENT_MAP_CODEC, NBTComponent.class::isInstance, "nbt");
        BINARY_TAG_HOLDER_COMPOUND_CODEC = CompoundTag.CODEC.flatComapMap(PaperAdventure::asBinaryTagHolder, api -> {
            try {
                Tag tag = (Tag)api.get(PaperAdventure.NBT_CODEC);
                if (!(tag instanceof CompoundTag)) {
                    return DataResult.error(() -> "Expected a CompoundTag, but got " + tag.getClass().getSimpleName());
                }
                CompoundTag compoundTag = (CompoundTag)tag;
                return DataResult.success((Object)compoundTag);
            }
            catch (CommandSyntaxException e) {
                return DataResult.error(e::getMessage);
            }
        });
    }

    record ComponentType<C extends Component>(MapCodec<C> codec, Predicate<Component> test, String id) implements StringRepresentable
    {
        @Override
        public String getSerializedName() {
            return this.id;
        }
    }

    static interface NbtComponentDataSource {
        public NBTComponentBuilder<?, ?> builder();

        public DataSourceType<?> type();
    }

    record EntityDataSource(String selectorPattern) implements NbtComponentDataSource
    {
        @Override
        public NBTComponentBuilder<?, ?> builder() {
            return Component.entityNBT().selector(this.selectorPattern());
        }

        @Override
        public DataSourceType<?> type() {
            return ENTITY_DATA_SOURCE_TYPE;
        }
    }

    record BlockDataSource(String posPattern) implements NbtComponentDataSource
    {
        @Override
        public NBTComponentBuilder<?, ?> builder() {
            return Component.blockNBT().pos(BlockNBTComponent.Pos.fromString((String)this.posPattern));
        }

        @Override
        public DataSourceType<?> type() {
            return BLOCK_DATA_SOURCE_TYPE;
        }
    }

    record StorageDataSource(Key storage) implements NbtComponentDataSource
    {
        @Override
        public NBTComponentBuilder<?, ?> builder() {
            return Component.storageNBT().storage(this.storage());
        }

        @Override
        public DataSourceType<?> type() {
            return STORAGE_DATA_SOURCE_TYPE;
        }
    }

    record DataSourceType<D extends NbtComponentDataSource>(MapCodec<D> codec, String id) implements StringRepresentable
    {
        @Override
        public String getSerializedName() {
            return this.id();
        }
    }

    record HoverEventType<V>(MapCodec<HoverEvent<V>> codec, String id) implements StringRepresentable
    {
        @Override
        public String getSerializedName() {
            return this.id;
        }
    }

    public record ClickEventType(MapCodec<ClickEvent> codec, String id) implements StringRepresentable
    {
        @Override
        public String getSerializedName() {
            return this.id;
        }
    }
}

