/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.brigadier;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.APICommandMeta;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.PaperCommands;
import io.papermc.paper.command.brigadier.PluginVanillaCommandWrapper;
import io.papermc.paper.command.brigadier.bukkit.BukkitCommandNode;
import java.util.Map;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.command.Command;
import org.bukkit.craftbukkit.command.VanillaCommandWrapper;

public final class PaperBrigadier {
    static final net.minecraft.commands.CommandSourceStack DUMMY = new net.minecraft.commands.CommandSourceStack(CommandSource.NULL, Vec3.ZERO, Vec2.ZERO, null, LevelBasedPermissionSet.OWNER, "", CommonComponents.EMPTY, null, null);

    public static Command wrapNode(CommandNode node) {
        Map<CommandNode<CommandSourceStack>, String> map;
        String usage;
        if (!(node instanceof LiteralCommandNode)) {
            throw new IllegalArgumentException("Unsure how to wrap a " + String.valueOf(node));
        }
        APICommandMeta meta = node.apiCommandMeta;
        if (meta == null) {
            return new VanillaCommandWrapper(node);
        }
        CommandNode<net.minecraft.commands.CommandSourceStack> argumentCommandNode = node;
        if (argumentCommandNode.getRedirect() != null) {
            argumentCommandNode = argumentCommandNode.getRedirect();
        }
        String string = usage = (map = PaperCommands.INSTANCE.getDispatcherInternal().getSmartUsage(argumentCommandNode, DUMMY)).isEmpty() ? node.getUsageText() : node.getUsageText() + " " + String.join((CharSequence)("\n" + node.getUsageText() + " "), map.values());
        if (meta.pluginMeta() == null) {
            return new VanillaCommandWrapper(node.getName(), meta.description(), usage, meta.aliases(), node, meta.helpCommandNamespace());
        }
        return new PluginVanillaCommandWrapper(node.getName(), meta.description(), usage, meta.aliases(), node, meta.plugin());
    }

    public static void moveBukkitCommands(Commands before, Commands after) {
        CommandDispatcher<net.minecraft.commands.CommandSourceStack> erasedDispatcher = before.getDispatcher();
        for (Object node : erasedDispatcher.getRoot().getChildren()) {
            CommandNode commandNode;
            if (!(node instanceof CommandNode) || !((commandNode = (CommandNode)node).getCommand() instanceof BukkitCommandNode.BukkitBrigCommand)) continue;
            after.getDispatcher().getRoot().removeCommand(((CommandNode)node).getName());
            after.getDispatcher().getRoot().addChild((CommandNode)node);
        }
    }

    public static <S> LiteralCommandNode<S> copyLiteral(String newLiteral, LiteralCommandNode<S> source) {
        LiteralArgumentBuilder copyBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)newLiteral).requires(source.getRequirement())).forward(source.getRedirect(), source.getRedirectModifier(), source.isFork());
        if (source.getCommand() != null) {
            copyBuilder.executes(source.getCommand());
        }
        for (CommandNode child : source.getChildren()) {
            copyBuilder.then(child);
        }
        return copyBuilder.build();
    }
}

