/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.serializer;

import com.destroystokyo.paper.util.SneakyThrow;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.arguments.NbtPathArgument;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

public class NbtPathSerializer
extends ScalarSerializer.Annotated<NbtPathArgument.NbtPath> {
    public static final NbtPathSerializer SERIALIZER = new NbtPathSerializer();
    private static final NbtPathArgument DUMMY_ARGUMENT = new NbtPathArgument();

    private NbtPathSerializer() {
        super(NbtPathArgument.NbtPath.class);
    }

    public static List<NbtPathArgument.NbtPath> fromString(List<String> tags) {
        ArrayList<NbtPathArgument.NbtPath> paths = new ArrayList<NbtPathArgument.NbtPath>();
        try {
            for (String tag : tags) {
                paths.add(NbtPathSerializer.fromString(tag));
            }
        }
        catch (SerializationException ex) {
            SneakyThrow.sneaky((Throwable)ex);
        }
        return List.copyOf(paths);
    }

    private static NbtPathArgument.NbtPath fromString(String tag) throws SerializationException {
        try {
            return DUMMY_ARGUMENT.parse(new StringReader(tag));
        }
        catch (CommandSyntaxException e) {
            throw new SerializationException(NbtPathArgument.NbtPath.class, (Throwable)e);
        }
    }

    public NbtPathArgument.NbtPath deserialize(AnnotatedType type, Object obj) throws SerializationException {
        return NbtPathSerializer.fromString(obj.toString());
    }

    protected Object serialize(AnnotatedType type, NbtPathArgument.NbtPath item, Predicate<Class<?>> typeSupported) {
        return item.toString();
    }
}

