/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.type;

import io.papermc.paper.configuration.type.number.IntOr;
import java.lang.reflect.Type;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public final class DespawnRange {
    public static final TypeSerializer<DespawnRange> SERIALIZER = new Serializer();
    private final IntOr.Default horizontalLimit;
    private final IntOr.Default verticalLimit;
    private final boolean wasDefinedViaLongSyntax;
    private double preComputedHorizontalLimitSquared;
    private double preComputedHorizontalLimitSquaredOverVerticalLimitSquared;
    private int preComputedVanillaDefaultLimit;

    public DespawnRange(IntOr.Default generalLimit) {
        this(generalLimit, generalLimit, false);
    }

    public DespawnRange(IntOr.Default horizontalLimit, IntOr.Default verticalLimit, boolean wasDefinedViaLongSyntax) {
        this.horizontalLimit = horizontalLimit;
        this.verticalLimit = verticalLimit;
        this.wasDefinedViaLongSyntax = wasDefinedViaLongSyntax;
    }

    public void preComputed(int defaultDistanceLimit, String identifier) throws SerializationException {
        if (this.verticalLimit.or(defaultDistanceLimit) <= 0) {
            throw new SerializationException("Vertical limit must be greater than 0 for " + identifier);
        }
        if (this.horizontalLimit.or(defaultDistanceLimit) <= 0) {
            throw new SerializationException("Horizontal limit must be greater than 0 for " + identifier);
        }
        this.preComputedVanillaDefaultLimit = defaultDistanceLimit;
        this.preComputedHorizontalLimitSquared = Math.pow(this.horizontalLimit.or(defaultDistanceLimit), 2.0);
        this.preComputedHorizontalLimitSquaredOverVerticalLimitSquared = !this.horizontalLimit.isDefined() && !this.verticalLimit.isDefined() ? 1.0 : this.preComputedHorizontalLimitSquared / Math.pow(this.verticalLimit.or(defaultDistanceLimit), 2.0);
    }

    public boolean shouldDespawn(Shape shape, double dxSqr, double dySqr, double dzSqr, double dy) {
        if (shape == Shape.ELLIPSOID) {
            return dxSqr + dzSqr + dySqr * this.preComputedHorizontalLimitSquaredOverVerticalLimitSquared > this.preComputedHorizontalLimitSquared;
        }
        return dxSqr + dzSqr > this.preComputedHorizontalLimitSquared || dy > (double)this.verticalLimit.or(this.preComputedVanillaDefaultLimit);
    }

    public boolean wasDefinedViaLongSyntax() {
        return this.wasDefinedViaLongSyntax;
    }

    public static enum Shape {
        CYLINDER,
        ELLIPSOID;

    }

    static final class Serializer
    implements TypeSerializer<DespawnRange> {
        public static final String HORIZONTAL = "horizontal";
        public static final String VERTICAL = "vertical";

        Serializer() {
        }

        public DespawnRange deserialize(Type type, ConfigurationNode node) throws SerializationException {
            if (node.hasChild(new Object[]{HORIZONTAL}) && node.hasChild(new Object[]{VERTICAL})) {
                return new DespawnRange((IntOr.Default)node.node(new Object[]{HORIZONTAL}).require(IntOr.Default.class), (IntOr.Default)node.node(new Object[]{VERTICAL}).require(IntOr.Default.class), true);
            }
            if (node.hasChild(new Object[]{HORIZONTAL}) || node.hasChild(new Object[]{VERTICAL})) {
                throw new SerializationException(node, DespawnRange.class, "Expected both horizontal and vertical despawn ranges to be defined");
            }
            return new DespawnRange((IntOr.Default)node.require(IntOr.Default.class));
        }

        public void serialize(Type type, @Nullable DespawnRange despawnRange, ConfigurationNode node) throws SerializationException {
            if (despawnRange == null) {
                node.raw(null);
                return;
            }
            if (despawnRange.wasDefinedViaLongSyntax()) {
                node.node(new Object[]{HORIZONTAL}).set((Object)despawnRange.horizontalLimit);
                node.node(new Object[]{VERTICAL}).set((Object)despawnRange.verticalLimit);
            } else {
                node.set((Object)despawnRange.verticalLimit);
            }
        }
    }
}

