/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.connection;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.connection.PaperCommonConnection;
import io.papermc.paper.connection.PlayerConfigurationConnection;
import io.papermc.paper.connection.PluginMessageBridgeImpl;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.dialog.PaperDialog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.util.MonkeyBars;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.ClientboundClearDialogPacket;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPopPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import net.minecraft.network.protocol.common.ClientboundShowDialogPacket;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.configuration.ClientboundResetChatPacket;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.jspecify.annotations.Nullable;

public class PaperPlayerConfigurationConnection
extends PaperCommonConnection<ServerConfigurationPacketListenerImpl>
implements PlayerConfigurationConnection,
Audience,
PluginMessageBridgeImpl {
    private @Nullable Pointers adventurePointers;

    public PaperPlayerConfigurationConnection(ServerConfigurationPacketListenerImpl packetListener) {
        super(packetListener);
    }

    @Override
    public ClientInformation getClientInformation() {
        return ((ServerConfigurationPacketListenerImpl)this.handle).clientInformation;
    }

    public void sendResourcePacks(ResourcePackRequest request) {
        ArrayList<ClientboundResourcePackPushPacket> packs = new ArrayList<ClientboundResourcePackPushPacket>(request.packs().size());
        if (request.replace()) {
            this.clearResourcePacks();
        }
        Component prompt = PaperAdventure.asVanilla(request.prompt());
        Iterator iter = request.packs().iterator();
        while (iter.hasNext()) {
            ResourcePackInfo pack = (ResourcePackInfo)iter.next();
            packs.add(new ClientboundResourcePackPushPacket(pack.id(), pack.uri().toASCIIString(), pack.hash(), request.required(), iter.hasNext() ? Optional.empty() : Optional.ofNullable(prompt)));
            if (request.callback() == ResourcePackCallback.noOp()) continue;
            ((ServerConfigurationPacketListenerImpl)this.handle).packCallbacks.put(pack.id(), request.callback());
        }
        packs.forEach(((ServerConfigurationPacketListenerImpl)this.handle)::send);
    }

    public void removeResourcePacks(UUID id, UUID ... others) {
        MonkeyBars.nonEmptyArrayToList(pack -> new ClientboundResourcePackPopPacket(Optional.of(pack)), (Object)id, (Object[])others).forEach(((ServerConfigurationPacketListenerImpl)this.handle)::send);
    }

    public void clearResourcePacks() {
        ((ServerConfigurationPacketListenerImpl)this.handle).send(new ClientboundResourcePackPopPacket(Optional.empty()));
    }

    public void showDialog(DialogLike dialog) {
        ((ServerConfigurationPacketListenerImpl)this.handle).send(new ClientboundShowDialogPacket(PaperDialog.bukkitToMinecraftHolder((Dialog)dialog)));
    }

    public void closeDialog() {
        ((ServerConfigurationPacketListenerImpl)this.handle).send(ClientboundClearDialogPacket.INSTANCE);
    }

    public Pointers pointers() {
        if (this.adventurePointers == null) {
            this.adventurePointers = (Pointers)Pointers.builder().withDynamic(Identity.NAME, () -> ((ServerConfigurationPacketListenerImpl)this.handle).getOwner().name()).withDynamic(Identity.UUID, () -> ((ServerConfigurationPacketListenerImpl)this.handle).getOwner().id()).build();
        }
        return this.adventurePointers;
    }

    public Audience getAudience() {
        return this;
    }

    public PlayerProfile getProfile() {
        return CraftPlayerProfile.asBukkitCopy(((ServerConfigurationPacketListenerImpl)this.handle).getOwner());
    }

    public void clearChat() {
        ((ServerConfigurationPacketListenerImpl)this.handle).send(ClientboundResetChatPacket.INSTANCE);
    }

    public void completeReconfiguration() {
        ConfigurationTask task = ((ServerConfigurationPacketListenerImpl)this.handle).currentTask;
        if (task != null) {
            return;
        }
        ((ServerConfigurationPacketListenerImpl)this.handle).returnToWorld();
    }

    @Override
    public Set<String> channels() {
        return ((ServerConfigurationPacketListenerImpl)this.handle).pluginMessagerChannels;
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)((ServerConfigurationPacketListenerImpl)this.handle).cserver.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        if (this.channels().contains(channel)) {
            Identifier id = Identifier.parse(StandardMessenger.validateAndCorrectChannel((String)channel));
            ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(new DiscardedPayload(id, message));
            ((ServerConfigurationPacketListenerImpl)this.handle).send(packet);
        }
    }

    public Set<String> getListeningPluginChannels() {
        return Set.copyOf(this.channels());
    }

    public boolean isConnected() {
        return ((ServerConfigurationPacketListenerImpl)this.handle).connection.isConnected();
    }
}

