/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.connection;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.connection.PlayerLoginConnection;
import io.papermc.paper.connection.ReadablePlayerCookieConnectionImpl;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.kyori.adventure.text.Component;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperPlayerLoginConnection
extends ReadablePlayerCookieConnectionImpl
implements PlayerLoginConnection {
    private final ServerLoginPacketListenerImpl packetListener;

    public PaperPlayerLoginConnection(ServerLoginPacketListenerImpl packetListener) {
        super(packetListener.connection);
        this.packetListener = packetListener;
    }

    public @Nullable PlayerProfile getAuthenticatedProfile() {
        return this.packetListener.authenticatedProfile == null ? null : CraftPlayerProfile.asBukkitCopy(this.packetListener.authenticatedProfile);
    }

    public @Nullable PlayerProfile getUnsafeProfile() {
        return new CraftPlayerProfile(this.packetListener.requestedUuid, this.packetListener.requestedUsername);
    }

    public SocketAddress getAddress() {
        return this.packetListener.connection.channel.remoteAddress();
    }

    public InetSocketAddress getClientAddress() {
        return (InetSocketAddress)this.packetListener.connection.getRemoteAddress();
    }

    public @Nullable InetSocketAddress getVirtualHost() {
        return this.packetListener.connection.virtualHost;
    }

    public @Nullable InetSocketAddress getHAProxyAddress() {
        InetSocketAddress inetSocketAddress;
        SocketAddress socketAddress = this.packetListener.connection.haProxyAddress;
        return socketAddress instanceof InetSocketAddress ? (inetSocketAddress = (InetSocketAddress)socketAddress) : null;
    }

    public boolean isTransferred() {
        return this.packetListener.transferred;
    }

    public void disconnect(Component component) {
        this.packetListener.disconnect(PaperAdventure.asVanilla(component));
    }

    public boolean isConnected() {
        return this.packetListener.connection.isConnected();
    }
}

