/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datapack;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datapack.Datapack;
import io.papermc.paper.datapack.PaperDiscoveredDatapack;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.Pack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PaperDatapack
extends PaperDiscoveredDatapack
implements Datapack {
    private final Pack pack;
    private final boolean enabled;

    PaperDatapack(Pack pack, boolean enabled) {
        super(pack);
        this.pack = pack;
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        MinecraftServer server = MinecraftServer.getServer();
        ArrayList<Pack> enabledPacks = new ArrayList<Pack>(server.getPackRepository().getSelectedPacks());
        Pack packToChange = server.getPackRepository().getPack(this.getName());
        if (packToChange == null) {
            throw new IllegalStateException("Cannot toggle state of pack that doesn't exist: " + this.getName());
        }
        if (enabled == enabledPacks.contains(packToChange)) {
            return;
        }
        if (enabled) {
            packToChange.getDefaultPosition().insert(enabledPacks, packToChange, Pack::selectionConfig, false);
        } else {
            enabledPacks.remove(packToChange);
        }
        server.reloadResources(enabledPacks.stream().map(Pack::getId).toList(), ServerResourcesReloadedEvent.Cause.PLUGIN);
    }

    public Component computeDisplayName() {
        return PaperAdventure.asAdventure(this.pack.getChatLink(this.enabled));
    }
}

