/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datapack;

import com.google.common.collect.ImmutableMap;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datapack.Datapack;
import io.papermc.paper.datapack.DatapackSource;
import io.papermc.paper.datapack.DiscoveredDatapack;
import io.papermc.paper.datapack.PluginPackSource;
import io.papermc.paper.world.flag.PaperFeatureFlagProviderImpl;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import org.bukkit.FeatureFlag;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PaperDiscoveredDatapack
implements DiscoveredDatapack {
    private static final Map<PackSource, DatapackSource> PACK_SOURCES = ImmutableMap.builder().put((Object)PackSource.DEFAULT, (Object)DatapackSource.DEFAULT).put((Object)PackSource.BUILT_IN, (Object)DatapackSource.BUILT_IN).put((Object)PackSource.FEATURE, (Object)DatapackSource.FEATURE).put((Object)PackSource.WORLD, (Object)DatapackSource.WORLD).put((Object)PackSource.SERVER, (Object)DatapackSource.SERVER).put((Object)PluginPackSource.INSTANCE, (Object)DatapackSource.PLUGIN).buildOrThrow();
    private final Pack pack;

    PaperDiscoveredDatapack(Pack pack) {
        this.pack = pack;
    }

    public String getName() {
        return this.pack.getId();
    }

    public Component getTitle() {
        return PaperAdventure.asAdventure(this.pack.getTitle());
    }

    public Component getDescription() {
        return PaperAdventure.asAdventure(this.pack.getDescription());
    }

    public boolean isRequired() {
        return this.pack.isRequired();
    }

    public Datapack.Compatibility getCompatibility() {
        return Datapack.Compatibility.valueOf((String)this.pack.getCompatibility().name());
    }

    public Set<FeatureFlag> getRequiredFeatures() {
        return PaperFeatureFlagProviderImpl.fromNms(this.pack.getRequestedFeatures());
    }

    public DatapackSource getSource() {
        return PACK_SOURCES.get(this.pack.location().source());
    }
}

