/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog.type;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.type.MultiActionType;
import java.util.List;
import org.jspecify.annotations.Nullable;

public record MultiActionTypeImpl(List<ActionButton> actions, @Nullable ActionButton exitAction, int columns) implements MultiActionType
{
    public MultiActionTypeImpl(List<ActionButton> actions, @Nullable ActionButton exitAction, int columns) {
        actions = List.copyOf(actions);
    }

    public static final class BuilderImpl
    implements MultiActionType.Builder {
        private final List<ActionButton> actions;
        private @Nullable ActionButton exitAction = null;
        private int columns = 2;

        public BuilderImpl(List<ActionButton> actions) {
            Preconditions.checkArgument((!actions.isEmpty() ? 1 : 0) != 0, (Object)"actions cannot be empty");
            this.actions = actions;
        }

        public MultiActionType.Builder exitAction(@Nullable ActionButton exitAction) {
            this.exitAction = exitAction;
            return this;
        }

        public MultiActionType.Builder columns(int columns) {
            Preconditions.checkArgument((columns > 0 ? 1 : 0) != 0, (Object)"columns must be greater than 0");
            this.columns = columns;
            return this;
        }

        public MultiActionType build() {
            return new MultiActionTypeImpl(this.actions, this.exitAction, this.columns);
        }
    }
}

