/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.holder;

import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.holder.InlinedRegistryHolderImpl;
import io.papermc.paper.registry.holder.ReferenceRegistryHolderImpl;
import io.papermc.paper.registry.holder.RegistryHolder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.Holder;

public final class PaperRegistryHolders {
    public static <API, ENTRY, M> RegistryHolder<API, ENTRY> create(Holder<M> holder, Function<M, ENTRY> entryCreator) {
        Holder<M> holder2 = holder;
        Objects.requireNonNull(holder2);
        Holder<M> holder3 = holder2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Holder.Direct.class, Holder.Reference.class}, holder3, n)) {
            case 0 -> {
                Holder.Direct direct = (Holder.Direct)holder3;
                yield new InlinedRegistryHolderImpl(entryCreator.apply(direct.value()), direct);
            }
            case 1 -> {
                Holder.Reference reference = (Holder.Reference)holder3;
                yield new ReferenceRegistryHolderImpl(PaperRegistries.fromNms(reference.key()));
            }
            default -> throw new IllegalArgumentException("Unsupported holder type: " + holder.getClass().getName());
        };
    }

    public static <API, ENTRY, M> Holder<M> convert(RegistryHolder<API, ENTRY> holder, Conversions conversions) {
        RegistryHolder<API, ENTRY> registryHolder = holder;
        Objects.requireNonNull(registryHolder);
        RegistryHolder<API, ENTRY> registryHolder2 = registryHolder;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RegistryHolder.Reference.class, RegistryHolder.Inlined.class}, registryHolder2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                RegistryHolder.Reference ref = (RegistryHolder.Reference)registryHolder2;
                yield conversions.getReferenceHolder(PaperRegistries.toNms(ref.key()));
            }
            case 1 -> {
                RegistryHolder.Inlined inlined = (RegistryHolder.Inlined)registryHolder2;
                yield ((InlinedRegistryHolderImpl)inlined).holder();
            }
        };
    }

    private PaperRegistryHolders() {
    }
}

