/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.OptionalFieldCodec;
import io.papermc.paper.adventure.AdventureCodecs;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import java.util.Optional;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryOps;
import org.bukkit.Keyed;
import org.bukkit.Registry;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PaperCodecs {
    public static final Codec<TriState> TRI_STATE_CODEC = Codec.STRING.comapFlatMap(name -> {
        try {
            return DataResult.success((Object)TriState.valueOf((String)name));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error(() -> "Unknown TriState value: " + name);
        }
    }, Enum::name);

    public static <M> MapCodec<Optional<M>> lenientCodec(final String name, final Codec<M> codec) {
        return new OptionalFieldCodec<M>(name, codec, true){

            public <T> RecordBuilder<T> encode(Optional<M> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                DataResult result;
                if (input.isPresent() && !(result = codec.encodeStart(ops, input.get())).isError()) {
                    return prefix.add(name, result);
                }
                return prefix;
            }
        };
    }

    public static <A extends Keyed, M> Decoder<A> registryFileDecoderFor(Decoder<? extends M> directNmsDecoder, Function<? super Holder<M>, A> directHolderConverter, final RegistryKey<A> registryKey, final boolean allowInline) {
        final Decoder.Terminal terminalDecoder = directNmsDecoder.map(nms -> (Keyed)directHolderConverter.apply(Holder.direct(nms))).terminal();
        return Decoder.ofTerminal((Decoder.Terminal)new Decoder.Terminal<A>(){

            public <T> DataResult<A> decode(DynamicOps<T> ops, T input) {
                if (ops instanceof RegistryOps) {
                    Registry registry = RegistryAccess.registryAccess().getRegistry(registryKey);
                    DataResult keyDataResult = AdventureCodecs.KEY_CODEC.decode(ops, input);
                    if (keyDataResult.result().isEmpty()) {
                        return !allowInline ? DataResult.error(() -> "Inline definitions not allowed here") : terminalDecoder.decode(ops, input);
                    }
                    Pair pair = (Pair)keyDataResult.result().get();
                    TypedKey elementKey = TypedKey.create((RegistryKey)registryKey, (Key)((Key)pair.getFirst()));
                    Keyed value = registry.get(elementKey);
                    if (value == null) {
                        return DataResult.error(() -> "Failed to get element " + String.valueOf(elementKey));
                    }
                    return DataResult.success((Object)value);
                }
                return terminalDecoder.decode(ops, input);
            }
        });
    }

    private PaperCodecs() {
    }
}

