/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public record StatePropertiesPredicate(List<PropertyMatcher> properties) {
    private static final Codec<List<PropertyMatcher>> PROPERTIES_CODEC = Codec.unboundedMap((Codec)Codec.STRING, ValueMatcher.CODEC).xmap(stateProperties -> stateProperties.entrySet().stream().map(propertyName -> new PropertyMatcher((String)propertyName.getKey(), (ValueMatcher)propertyName.getValue())).toList(), properties -> properties.stream().collect(Collectors.toMap(PropertyMatcher::name, PropertyMatcher::valueMatcher)));
    public static final Codec<StatePropertiesPredicate> CODEC = PROPERTIES_CODEC.xmap(StatePropertiesPredicate::new, StatePropertiesPredicate::properties);
    public static final StreamCodec<ByteBuf, StatePropertiesPredicate> STREAM_CODEC = PropertyMatcher.STREAM_CODEC.apply(ByteBufCodecs.list()).map(StatePropertiesPredicate::new, StatePropertiesPredicate::properties);

    public <S extends StateHolder<?, S>> boolean matches(StateDefinition<?, S> properties, S targetProperty) {
        for (PropertyMatcher propertyMatcher : this.properties) {
            if (propertyMatcher.match(properties, targetProperty)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(BlockState state) {
        return this.matches(state.getBlock().getStateDefinition(), state);
    }

    public boolean matches(FluidState state) {
        return this.matches(state.getType().getStateDefinition(), state);
    }

    public Optional<String> checkState(StateDefinition<?, ?> state) {
        for (PropertyMatcher propertyMatcher : this.properties) {
            Optional<String> optional = propertyMatcher.checkState(state);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    record PropertyMatcher(String name, ValueMatcher valueMatcher) {
        public static final StreamCodec<ByteBuf, PropertyMatcher> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.STRING_UTF8, PropertyMatcher::name, ValueMatcher.STREAM_CODEC, PropertyMatcher::valueMatcher, PropertyMatcher::new);

        public <S extends StateHolder<?, S>> boolean match(StateDefinition<?, S> properties, S propertyToMatch) {
            Property<?> property = properties.getProperty(this.name);
            return property != null && this.valueMatcher.match(propertyToMatch, property);
        }

        public Optional<String> checkState(StateDefinition<?, ?> state) {
            Property<?> property = state.getProperty(this.name);
            return property != null ? Optional.empty() : Optional.of(this.name);
        }
    }

    static interface ValueMatcher {
        public static final Codec<ValueMatcher> CODEC = Codec.either(ExactMatcher.CODEC, RangedMatcher.CODEC).xmap(Either::unwrap, valueMatcher -> {
            if (valueMatcher instanceof ExactMatcher) {
                ExactMatcher exactMatcher = (ExactMatcher)valueMatcher;
                return Either.left(exactMatcher);
            }
            if (valueMatcher instanceof RangedMatcher) {
                RangedMatcher rangedMatcher = (RangedMatcher)valueMatcher;
                return Either.right(rangedMatcher);
            }
            throw new UnsupportedOperationException();
        });
        public static final StreamCodec<ByteBuf, ValueMatcher> STREAM_CODEC = ByteBufCodecs.either(ExactMatcher.STREAM_CODEC, RangedMatcher.STREAM_CODEC).map(Either::unwrap, valueMatcher -> {
            if (valueMatcher instanceof ExactMatcher) {
                ExactMatcher exactMatcher = (ExactMatcher)valueMatcher;
                return Either.left(exactMatcher);
            }
            if (valueMatcher instanceof RangedMatcher) {
                RangedMatcher rangedMatcher = (RangedMatcher)valueMatcher;
                return Either.right(rangedMatcher);
            }
            throw new UnsupportedOperationException();
        });

        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> var1, Property<T> var2);
    }

    record RangedMatcher(Optional<String> minValue, Optional<String> maxValue) implements ValueMatcher
    {
        public static final Codec<RangedMatcher> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("min").forGetter(RangedMatcher::minValue), (App)Codec.STRING.optionalFieldOf("max").forGetter(RangedMatcher::maxValue)).apply((Applicative)instance, RangedMatcher::new));
        public static final StreamCodec<ByteBuf, RangedMatcher> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.optional(ByteBufCodecs.STRING_UTF8), RangedMatcher::minValue, ByteBufCodecs.optional(ByteBufCodecs.STRING_UTF8), RangedMatcher::maxValue, RangedMatcher::new);

        @Override
        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> stateHolder, Property<T> property) {
            Optional<T> value1;
            Comparable value = stateHolder.getValue(property);
            if (this.minValue.isPresent() && ((value1 = property.getValue(this.minValue.get())).isEmpty() || value.compareTo((Comparable)((Comparable)value1.get())) < 0)) {
                return false;
            }
            return !this.maxValue.isPresent() || !(value1 = property.getValue(this.maxValue.get())).isEmpty() && value.compareTo((Comparable)((Comparable)value1.get())) <= 0;
        }
    }

    record ExactMatcher(String value) implements ValueMatcher
    {
        public static final Codec<ExactMatcher> CODEC = Codec.STRING.xmap(ExactMatcher::new, ExactMatcher::value);
        public static final StreamCodec<ByteBuf, ExactMatcher> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(ExactMatcher::new, ExactMatcher::value);

        @Override
        public <T extends Comparable<T>> boolean match(StateHolder<?, ?> stateHolder, Property<T> property) {
            Comparable value = stateHolder.getValue(property);
            Optional<T> value1 = property.getValue(this.value);
            return value1.isPresent() && value.compareTo((Comparable)((Comparable)value1.get())) == 0;
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<PropertyMatcher> matchers = ImmutableList.builder();

        private Builder() {
        }

        public static Builder properties() {
            return new Builder();
        }

        public Builder hasProperty(Property<?> property, String value) {
            this.matchers.add((Object)new PropertyMatcher(property.getName(), new ExactMatcher(value)));
            return this;
        }

        public Builder hasProperty(Property<Integer> property, int value) {
            return this.hasProperty((Property)property, (Comparable<T> & StringRepresentable)Integer.toString(value));
        }

        public Builder hasProperty(Property<Boolean> property, boolean value) {
            return this.hasProperty((Property)property, (Comparable<T> & StringRepresentable)Boolean.toString(value));
        }

        public <T extends Comparable<T> & StringRepresentable> Builder hasProperty(Property<T> property, T value) {
            return this.hasProperty(property, (T)((StringRepresentable)value).getSerializedName());
        }

        public Optional<StatePropertiesPredicate> build() {
            return Optional.of(new StatePropertiesPredicate((List<PropertyMatcher>)this.matchers.build()));
        }
    }
}

