/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendCommandsEvent;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.brigadier.AmbiguityConsumer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.PaperBrigadier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandlerWithName;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.gametest.framework.TestCommand;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundCommandsPacket;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.AdvancementCommands;
import net.minecraft.server.commands.AttributeCommand;
import net.minecraft.server.commands.BanIpCommands;
import net.minecraft.server.commands.BanListCommands;
import net.minecraft.server.commands.BanPlayerCommands;
import net.minecraft.server.commands.BossBarCommands;
import net.minecraft.server.commands.ChaseCommand;
import net.minecraft.server.commands.ClearInventoryCommands;
import net.minecraft.server.commands.CloneCommands;
import net.minecraft.server.commands.DamageCommand;
import net.minecraft.server.commands.DataPackCommand;
import net.minecraft.server.commands.DeOpCommands;
import net.minecraft.server.commands.DebugCommand;
import net.minecraft.server.commands.DebugConfigCommand;
import net.minecraft.server.commands.DebugMobSpawningCommand;
import net.minecraft.server.commands.DebugPathCommand;
import net.minecraft.server.commands.DefaultGameModeCommands;
import net.minecraft.server.commands.DialogCommand;
import net.minecraft.server.commands.DifficultyCommand;
import net.minecraft.server.commands.EffectCommands;
import net.minecraft.server.commands.EmoteCommands;
import net.minecraft.server.commands.EnchantCommand;
import net.minecraft.server.commands.ExecuteCommand;
import net.minecraft.server.commands.ExperienceCommand;
import net.minecraft.server.commands.FetchProfileCommand;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.commands.FillCommand;
import net.minecraft.server.commands.ForceLoadCommand;
import net.minecraft.server.commands.FunctionCommand;
import net.minecraft.server.commands.GameModeCommand;
import net.minecraft.server.commands.GameRuleCommand;
import net.minecraft.server.commands.GiveCommand;
import net.minecraft.server.commands.HelpCommand;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.JfrCommand;
import net.minecraft.server.commands.KickCommand;
import net.minecraft.server.commands.KillCommand;
import net.minecraft.server.commands.ListPlayersCommand;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.commands.LootCommand;
import net.minecraft.server.commands.MsgCommand;
import net.minecraft.server.commands.OpCommand;
import net.minecraft.server.commands.PardonCommand;
import net.minecraft.server.commands.PardonIpCommand;
import net.minecraft.server.commands.ParticleCommand;
import net.minecraft.server.commands.PerfCommand;
import net.minecraft.server.commands.PlaceCommand;
import net.minecraft.server.commands.PlaySoundCommand;
import net.minecraft.server.commands.PublishCommand;
import net.minecraft.server.commands.RaidCommand;
import net.minecraft.server.commands.RandomCommand;
import net.minecraft.server.commands.RecipeCommand;
import net.minecraft.server.commands.ReloadCommand;
import net.minecraft.server.commands.ReturnCommand;
import net.minecraft.server.commands.RideCommand;
import net.minecraft.server.commands.RotateCommand;
import net.minecraft.server.commands.SaveAllCommand;
import net.minecraft.server.commands.SaveOffCommand;
import net.minecraft.server.commands.SaveOnCommand;
import net.minecraft.server.commands.SayCommand;
import net.minecraft.server.commands.ScheduleCommand;
import net.minecraft.server.commands.ScoreboardCommand;
import net.minecraft.server.commands.SeedCommand;
import net.minecraft.server.commands.ServerPackCommand;
import net.minecraft.server.commands.SetBlockCommand;
import net.minecraft.server.commands.SetPlayerIdleTimeoutCommand;
import net.minecraft.server.commands.SetSpawnCommand;
import net.minecraft.server.commands.SetWorldSpawnCommand;
import net.minecraft.server.commands.SpawnArmorTrimsCommand;
import net.minecraft.server.commands.SpectateCommand;
import net.minecraft.server.commands.SpreadPlayersCommand;
import net.minecraft.server.commands.StopCommand;
import net.minecraft.server.commands.StopSoundCommand;
import net.minecraft.server.commands.StopwatchCommand;
import net.minecraft.server.commands.SummonCommand;
import net.minecraft.server.commands.TagCommand;
import net.minecraft.server.commands.TeamCommand;
import net.minecraft.server.commands.TeamMsgCommand;
import net.minecraft.server.commands.TeleportCommand;
import net.minecraft.server.commands.TellRawCommand;
import net.minecraft.server.commands.TickCommand;
import net.minecraft.server.commands.TimeCommand;
import net.minecraft.server.commands.TitleCommand;
import net.minecraft.server.commands.TransferCommand;
import net.minecraft.server.commands.TriggerCommand;
import net.minecraft.server.commands.VersionCommand;
import net.minecraft.server.commands.WardenSpawnTrackerCommand;
import net.minecraft.server.commands.WaypointCommand;
import net.minecraft.server.commands.WeatherCommand;
import net.minecraft.server.commands.WhitelistCommand;
import net.minecraft.server.commands.WorldBorderCommand;
import net.minecraft.server.commands.data.DataCommands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.PermissionCheck;
import net.minecraft.server.permissions.PermissionProviderCheck;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.permissions.PermissionSetSupplier;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Util;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.command.VanillaCommandWrapper;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.command.UnknownCommandEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public class Commands {
    public static final String COMMAND_PREFIX = "/";
    private static final ThreadLocal<@Nullable ExecutionContext<CommandSourceStack>> CURRENT_EXECUTION_CONTEXT = new ThreadLocal();
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final PermissionCheck LEVEL_ALL = PermissionCheck.AlwaysPass.INSTANCE;
    public static final PermissionCheck LEVEL_MODERATORS = new PermissionCheck.Require(Permissions.COMMANDS_MODERATOR);
    public static final PermissionCheck LEVEL_GAMEMASTERS = new PermissionCheck.Require(Permissions.COMMANDS_GAMEMASTER);
    public static final PermissionCheck LEVEL_ADMINS = new PermissionCheck.Require(Permissions.COMMANDS_ADMIN);
    public static final PermissionCheck LEVEL_OWNERS = new PermissionCheck.Require(Permissions.COMMANDS_OWNER);
    private static final ClientboundCommandsPacket.NodeInspector<CommandSourceStack> COMMAND_NODE_INSPECTOR = new ClientboundCommandsPacket.NodeInspector<CommandSourceStack>(){
        private final CommandSourceStack noPermissionSource = Commands.createCompilationContext(PermissionSet.NO_PERMISSIONS);

        @Override
        public @Nullable Identifier suggestionId(ArgumentCommandNode<CommandSourceStack, ?> node) {
            SuggestionProvider customSuggestions = node.getCustomSuggestions();
            return customSuggestions != null ? SuggestionProviders.getName(customSuggestions) : null;
        }

        @Override
        public boolean isExecutable(CommandNode<CommandSourceStack> node) {
            return node.getCommand() != null;
        }

        @Override
        public boolean isRestricted(CommandNode<CommandSourceStack> node) {
            if (node.getRequirement() instanceof RestrictedMarker) {
                return true;
            }
            Predicate<CommandSourceStack> requirement = node.getRequirement();
            return !requirement.test(this.noPermissionSource);
        }
    };
    private final CommandDispatcher<CommandSourceStack> dispatcher = new CommandDispatcher();
    public static final ExecutorService COMMAND_SENDING_POOL = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Paper Async Command Builder Thread Pool - %1$d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandlerWithName(MinecraftServer.LOGGER)).build(), new ThreadPoolExecutor.DiscardPolicy());

    public Commands(CommandSelection selection, CommandBuildContext context) {
        this(selection, context, false);
    }

    public Commands(CommandSelection selection, CommandBuildContext context, boolean modern) {
        AdvancementCommands.register(this.dispatcher);
        AttributeCommand.register(this.dispatcher, context);
        ExecuteCommand.register(this.dispatcher, context);
        BossBarCommands.register(this.dispatcher, context);
        ClearInventoryCommands.register(this.dispatcher, context);
        CloneCommands.register(this.dispatcher, context);
        DamageCommand.register(this.dispatcher, context);
        DataCommands.register(this.dispatcher);
        DataPackCommand.register(this.dispatcher, context);
        DebugCommand.register(this.dispatcher);
        DefaultGameModeCommands.register(this.dispatcher);
        DialogCommand.register(this.dispatcher, context);
        DifficultyCommand.register(this.dispatcher);
        EffectCommands.register(this.dispatcher, context);
        EmoteCommands.register(this.dispatcher);
        EnchantCommand.register(this.dispatcher, context);
        ExperienceCommand.register(this.dispatcher);
        FillCommand.register(this.dispatcher, context);
        FillBiomeCommand.register(this.dispatcher, context);
        ForceLoadCommand.register(this.dispatcher);
        FunctionCommand.register(this.dispatcher);
        GameModeCommand.register(this.dispatcher);
        GameRuleCommand.register(this.dispatcher, context);
        GiveCommand.register(this.dispatcher, context);
        HelpCommand.register(this.dispatcher);
        ItemCommands.register(this.dispatcher, context);
        KickCommand.register(this.dispatcher);
        KillCommand.register(this.dispatcher);
        ListPlayersCommand.register(this.dispatcher);
        LocateCommand.register(this.dispatcher, context);
        LootCommand.register(this.dispatcher, context);
        MsgCommand.register(this.dispatcher);
        ParticleCommand.register(this.dispatcher, context);
        PlaceCommand.register(this.dispatcher);
        PlaySoundCommand.register(this.dispatcher);
        RandomCommand.register(this.dispatcher);
        ReloadCommand.register(this.dispatcher);
        RecipeCommand.register(this.dispatcher);
        FetchProfileCommand.register(this.dispatcher);
        ReturnCommand.register(this.dispatcher);
        RideCommand.register(this.dispatcher);
        RotateCommand.register(this.dispatcher);
        SayCommand.register(this.dispatcher);
        ScheduleCommand.register(this.dispatcher);
        ScoreboardCommand.register(this.dispatcher, context);
        SeedCommand.register(this.dispatcher, selection != CommandSelection.INTEGRATED);
        VersionCommand.register(this.dispatcher, selection != CommandSelection.INTEGRATED);
        SetBlockCommand.register(this.dispatcher, context);
        SetSpawnCommand.register(this.dispatcher);
        SetWorldSpawnCommand.register(this.dispatcher);
        SpectateCommand.register(this.dispatcher);
        SpreadPlayersCommand.register(this.dispatcher);
        StopSoundCommand.register(this.dispatcher);
        StopwatchCommand.register(this.dispatcher);
        SummonCommand.register(this.dispatcher, context);
        TagCommand.register(this.dispatcher);
        TeamCommand.register(this.dispatcher, context);
        TeamMsgCommand.register(this.dispatcher);
        TeleportCommand.register(this.dispatcher);
        TellRawCommand.register(this.dispatcher, context);
        TestCommand.register(this.dispatcher, context);
        TickCommand.register(this.dispatcher);
        TimeCommand.register(this.dispatcher);
        TitleCommand.register(this.dispatcher, context);
        TriggerCommand.register(this.dispatcher);
        WaypointCommand.register(this.dispatcher, context);
        WeatherCommand.register(this.dispatcher);
        WorldBorderCommand.register(this.dispatcher);
        if (JvmProfiler.INSTANCE.isAvailable()) {
            JfrCommand.register(this.dispatcher);
        }
        if (SharedConstants.DEBUG_CHASE_COMMAND) {
            ChaseCommand.register(this.dispatcher);
        }
        if (SharedConstants.DEBUG_DEV_COMMANDS || SharedConstants.IS_RUNNING_IN_IDE) {
            RaidCommand.register(this.dispatcher, context);
            DebugPathCommand.register(this.dispatcher);
            DebugMobSpawningCommand.register(this.dispatcher);
            WardenSpawnTrackerCommand.register(this.dispatcher);
            SpawnArmorTrimsCommand.register(this.dispatcher);
            ServerPackCommand.register(this.dispatcher);
            if (selection.includeDedicated) {
                DebugConfigCommand.register(this.dispatcher, context);
            }
        }
        if (selection.includeDedicated) {
            BanIpCommands.register(this.dispatcher);
            BanListCommands.register(this.dispatcher);
            BanPlayerCommands.register(this.dispatcher);
            DeOpCommands.register(this.dispatcher);
            OpCommand.register(this.dispatcher);
            PardonCommand.register(this.dispatcher);
            PardonIpCommand.register(this.dispatcher);
            PerfCommand.register(this.dispatcher);
            SaveAllCommand.register(this.dispatcher);
            SaveOffCommand.register(this.dispatcher);
            SaveOnCommand.register(this.dispatcher);
            SetPlayerIdleTimeoutCommand.register(this.dispatcher);
            StopCommand.register(this.dispatcher);
            TransferCommand.register(this.dispatcher);
            WhitelistCommand.register(this.dispatcher);
        }
        if (selection.includeIntegrated) {
            PublishCommand.register(this.dispatcher);
        }
        for (CommandNode node : this.dispatcher.getRoot().getChildren()) {
            if (node.getRequirement() == ArgumentBuilder.defaultRequirement()) {
                node.requirement = stack -> stack.source == CommandSource.NULL || stack.getBukkitSender().hasPermission(VanillaCommandWrapper.getPermission(node));
                continue;
            }
            Predicate predicate = node.getRequirement();
            if (!(predicate instanceof PermissionProviderCheck)) continue;
            PermissionProviderCheck check = (PermissionProviderCheck)predicate;
            check.vanillaNode().set(node);
        }
        for (CommandNode node : new ArrayList(this.dispatcher.getRoot().getChildren())) {
            if (modern) {
                this.dispatcher.getRoot().addChild(PaperBrigadier.copyLiteral("minecraft:" + node.getName(), (LiteralCommandNode)node));
                continue;
            }
            CommandNode flattenedAliasTarget = node;
            while (flattenedAliasTarget.getRedirect() != null) {
                flattenedAliasTarget = flattenedAliasTarget.getRedirect();
            }
            this.dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)("minecraft:" + node.getName())).executes(flattenedAliasTarget.getCommand())).requires(flattenedAliasTarget.getRequirement())).redirect(flattenedAliasTarget)));
        }
        this.dispatcher.setConsumer(ExecutionCommandSource.resultConsumer());
    }

    public static <S> ParseResults<S> mapSource(ParseResults<S> parseResults, UnaryOperator<S> mapper) {
        CommandContextBuilder context = parseResults.getContext();
        CommandContextBuilder commandContextBuilder = context.withSource(mapper.apply(context.getSource()));
        return new ParseResults(commandContextBuilder, parseResults.getReader(), parseResults.getExceptions());
    }

    public void performPrefixedCommand(CommandSourceStack source, String command) {
        command = Commands.trimOptionalPrefix(command);
        this.performCommand(this.dispatcher.parse(command, source), command);
    }

    public static String trimOptionalPrefix(String command) {
        return command.startsWith(COMMAND_PREFIX) ? command.substring(1) : command;
    }

    public void performCommand(ParseResults<CommandSourceStack> parseResults, String command) {
        this.performCommand(parseResults, command, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCommand(ParseResults<CommandSourceStack> parseResults, String command, boolean throwCommandError) {
        AsyncCatcher.catchOp("Cannot perform command async");
        CommandSourceStack commandSourceStack = (CommandSourceStack)parseResults.getContext().getSource();
        Profiler.get().push(() -> COMMAND_PREFIX + command);
        ContextChain<CommandSourceStack> contextChain = Commands.finishParsing(parseResults, command, commandSourceStack);
        try {
            if (contextChain != null) {
                Commands.executeCommandInContext(commandSourceStack, executionContext -> ExecutionContext.queueInitialCommandExecution(executionContext, command, contextChain, commandSourceStack, CommandResultCallback.EMPTY));
            }
        }
        catch (Throwable var12) {
            if (throwCommandError) {
                throw var12;
            }
            MutableComponent mutableComponent = net.minecraft.network.chat.Component.literal(var12.getMessage() == null ? var12.getClass().getName() : var12.getMessage());
            LOGGER.error("Command exception: /{}", (Object)command, (Object)var12);
            if (commandSourceStack.getServer().isDebugging() || LOGGER.isDebugEnabled()) {
                StackTraceElement[] stackTrace = var12.getStackTrace();
                for (int i = 0; i < Math.min(stackTrace.length, 3); ++i) {
                    mutableComponent.append("\n\n").append(stackTrace[i].getMethodName()).append("\n ").append(stackTrace[i].getFileName()).append(":").append(String.valueOf(stackTrace[i].getLineNumber()));
                }
            }
            commandSourceStack.sendFailure(net.minecraft.network.chat.Component.translatable("command.failed").withStyle(style -> style.withHoverEvent(new HoverEvent.ShowText(mutableComponent))));
            if (SharedConstants.DEBUG_VERBOSE_COMMAND_ERRORS || SharedConstants.IS_RUNNING_IN_IDE) {
                commandSourceStack.sendFailure(net.minecraft.network.chat.Component.literal(Util.describeError(var12)));
                LOGGER.error("'/{}' threw an exception", (Object)command, (Object)var12);
            }
        }
        finally {
            Profiler.get().pop();
        }
    }

    private static @Nullable ContextChain<CommandSourceStack> finishParsing(ParseResults<CommandSourceStack> parseResults, String command, CommandSourceStack source) {
        try {
            Commands.validateParseResults(parseResults);
            return (ContextChain)ContextChain.tryFlatten((CommandContext)parseResults.getContext().build(command)).orElseThrow(() -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parseResults.getReader()));
        }
        catch (CommandSyntaxException var7) {
            TextComponent.Builder builder = Component.text();
            ((TextComponent.Builder)builder.color((TextColor)NamedTextColor.RED)).append(MessageComponentSerializer.message().deserialize((Object)var7.getRawMessage()));
            if (var7.getInput() != null && var7.getCursor() >= 0) {
                int min = Math.min(var7.getInput().length(), var7.getCursor());
                MutableComponent mutableComponent = net.minecraft.network.chat.Component.empty().withStyle(ChatFormatting.GRAY).withStyle(style -> style.withClickEvent(new ClickEvent.SuggestCommand(COMMAND_PREFIX + command)));
                if (min > 10) {
                    mutableComponent.append(CommonComponents.ELLIPSIS);
                }
                mutableComponent.append(var7.getInput().substring(Math.max(0, min - 10), min));
                if (min < var7.getInput().length()) {
                    MutableComponent component = net.minecraft.network.chat.Component.literal(var7.getInput().substring(min)).withStyle(ChatFormatting.RED, ChatFormatting.UNDERLINE);
                    mutableComponent.append(component);
                }
                mutableComponent.append(net.minecraft.network.chat.Component.translatable("command.context.here").withStyle(ChatFormatting.RED, ChatFormatting.ITALIC));
                ((TextComponent.Builder)builder.append((Component)Component.newline())).append(PaperAdventure.asAdventure(mutableComponent));
            }
            UnknownCommandEvent event = new UnknownCommandEvent((io.papermc.paper.command.brigadier.CommandSourceStack)source, command, (Component)(SpigotConfig.unknownCommandMessage.isEmpty() ? null : builder.build()));
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.message() != null) {
                source.sendFailure(PaperAdventure.asVanilla(event.message()), false);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCommandInContext(CommandSourceStack source, Consumer<ExecutionContext<CommandSourceStack>> contextConsumer) {
        block9: {
            boolean flag;
            ExecutionContext<CommandSourceStack> executionContext = CURRENT_EXECUTION_CONTEXT.get();
            boolean bl = flag = executionContext == null;
            if (flag) {
                GameRules gameRules = source.getLevel().getGameRules();
                int max = Math.max(1, gameRules.get(GameRules.MAX_COMMAND_SEQUENCE_LENGTH));
                int i = gameRules.get(GameRules.MAX_COMMAND_FORKS);
                try (ExecutionContext executionContext1 = new ExecutionContext(max, i, Profiler.get());){
                    CURRENT_EXECUTION_CONTEXT.set(executionContext1);
                    contextConsumer.accept(executionContext1);
                    executionContext1.runCommandQueue();
                    break block9;
                }
                finally {
                    CURRENT_EXECUTION_CONTEXT.set(null);
                }
            }
            contextConsumer.accept(executionContext);
        }
    }

    public void sendCommands(ServerPlayer player) {
        if (SpigotConfig.tabComplete < 0) {
            player.connection.send(new ClientboundCommandsPacket(new RootCommandNode(), COMMAND_NODE_INSPECTOR));
            return;
        }
        ArrayList commandNodes = new ArrayList(this.dispatcher.getRoot().getChildren());
        COMMAND_SENDING_POOL.execute(() -> this.sendAsync(player, commandNodes));
    }

    private void sendAsync(ServerPlayer player, Collection<CommandNode<CommandSourceStack>> dispatcherRootChildren) {
        HashMap map = new HashMap();
        RootCommandNode rootCommandNode = new RootCommandNode();
        map.put((CommandNode)this.dispatcher.getRoot(), (CommandNode)rootCommandNode);
        Commands.fillUsableCommands(dispatcherRootChildren, rootCommandNode, player.createCommandSourceStack(), map);
        LinkedHashSet<String> bukkit = new LinkedHashSet<String>();
        for (CommandNode node : rootCommandNode.getChildren()) {
            bukkit.add(node.getName());
        }
        new AsyncPlayerSendCommandsEvent((Player)player.getBukkitEntity(), rootCommandNode, false).callEvent();
        MinecraftServer.getServer().execute(() -> this.runSync(player, bukkit, (RootCommandNode<CommandSourceStack>)rootCommandNode));
    }

    private void runSync(ServerPlayer player, Collection<String> bukkit, RootCommandNode<CommandSourceStack> rootCommandNode) {
        new AsyncPlayerSendCommandsEvent((Player)player.getBukkitEntity(), rootCommandNode, true).callEvent();
        PlayerCommandSendEvent event = new PlayerCommandSendEvent((Player)player.getBukkitEntity(), new LinkedHashSet<String>(bukkit));
        event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
        for (String orig : bukkit) {
            if (event.getCommands().contains(orig)) continue;
            rootCommandNode.removeCommand(orig);
        }
        player.connection.send(new ClientboundCommandsPacket(rootCommandNode, COMMAND_NODE_INSPECTOR));
    }

    private static <S> void fillUsableCommands(Collection<CommandNode<S>> children, CommandNode<S> current, S source, Map<CommandNode<S>, CommandNode<S>> output) {
        for (CommandNode<S> commandNode : children) {
            if (commandNode.clientNode != null) {
                commandNode = commandNode.clientNode;
            }
            if (!SpigotConfig.sendNamespaced && commandNode.getName().contains(":") || !commandNode.canUse(source)) continue;
            LiteralArgumentBuilder argumentBuilder = commandNode.createBuilder();
            if (argumentBuilder.getRedirect() != null && output.get(argumentBuilder.getRedirect()) == null) {
                CommandNode<S> redirect = argumentBuilder.getRedirect();
                LiteralArgumentBuilder builder = LiteralArgumentBuilder.literal((String)commandNode.getName());
                builder.requires(redirect.getRequirement());
                if (redirect.getCommand() != null) {
                    builder.executes(redirect.getCommand());
                }
                for (CommandNode<S> child : redirect.getChildren()) {
                    builder.then(child);
                }
                argumentBuilder = builder;
            }
            if (argumentBuilder.getRedirect() != null) {
                argumentBuilder.redirect(output.get(argumentBuilder.getRedirect()));
            }
            CommandNode<S> commandNode1 = argumentBuilder.build();
            output.put(commandNode, commandNode1);
            current.addChild(commandNode1);
            if (commandNode.getChildren().isEmpty()) continue;
            Commands.fillUsableCommands(commandNode.getChildren(), commandNode1, source, output);
        }
    }

    public static LiteralArgumentBuilder<CommandSourceStack> literal(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    public static <T> RequiredArgumentBuilder<CommandSourceStack, T> argument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    public static Predicate<String> createValidator(ParseFunction parser) {
        return string -> {
            try {
                parser.parse(new StringReader(string));
                return true;
            }
            catch (CommandSyntaxException var3) {
                return false;
            }
        };
    }

    public CommandDispatcher<CommandSourceStack> getDispatcher() {
        return this.dispatcher;
    }

    public static <S> void validateParseResults(ParseResults<S> parseResults) throws CommandSyntaxException {
        CommandSyntaxException parseException = Commands.getParseException(parseResults);
        if (parseException != null) {
            throw parseException;
        }
    }

    public static <S> @Nullable CommandSyntaxException getParseException(ParseResults<S> result) {
        if (!result.getReader().canRead()) {
            return null;
        }
        if (result.getExceptions().size() == 1) {
            return (CommandSyntaxException)result.getExceptions().values().iterator().next();
        }
        return result.getContext().getRange().isEmpty() ? CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(result.getReader()) : CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(result.getReader());
    }

    public static CommandBuildContext createValidationContext(final HolderLookup.Provider provider) {
        return new CommandBuildContext(){

            @Override
            public FeatureFlagSet enabledFeatures() {
                return FeatureFlags.REGISTRY.allFlags();
            }

            @Override
            public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
                return provider.listRegistryKeys();
            }

            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryKey) {
                return provider.lookup(registryKey).map(this::createLookup);
            }

            private <T> HolderLookup.RegistryLookup.Delegate<T> createLookup(final HolderLookup.RegistryLookup<T> registryLookup) {
                return new HolderLookup.RegistryLookup.Delegate<T>(){

                    @Override
                    public HolderLookup.RegistryLookup<T> parent() {
                        return registryLookup;
                    }

                    @Override
                    public Optional<HolderSet.Named<T>> get(TagKey<T> tagKey) {
                        return Optional.of(this.getOrThrow(tagKey));
                    }

                    @Override
                    public HolderSet.Named<T> getOrThrow(TagKey<T> tagKey) {
                        Optional<HolderSet.Named<HolderSet.Named>> optional = this.parent().get(tagKey);
                        return optional.orElseGet(() -> HolderSet.emptyNamed(this.parent(), tagKey));
                    }
                };
            }
        };
    }

    public static void validate() {
        CommandBuildContext commandBuildContext = Commands.createValidationContext(VanillaRegistries.createLookup());
        CommandDispatcher<CommandSourceStack> dispatcher = new Commands(CommandSelection.ALL, commandBuildContext).getDispatcher();
        RootCommandNode<CommandSourceStack> root = dispatcher.getRoot();
        dispatcher.findAmbiguities((AmbiguityConsumer<CommandSourceStack>)((AmbiguityConsumer)(commandNode, commandNode1, commandNode2, collection) -> LOGGER.warn("Ambiguity between arguments {} and {} with inputs: {}", new Object[]{dispatcher.getPath(commandNode1), dispatcher.getPath(commandNode2), collection})));
        Set<ArgumentType<?>> set = ArgumentUtils.findUsedArgumentTypes(root);
        Set set1 = set.stream().filter(argumentType -> !ArgumentTypeInfos.isClassRecognized(argumentType.getClass())).collect(Collectors.toSet());
        if (!set1.isEmpty()) {
            LOGGER.warn("Missing type registration for following arguments:\n {}", (Object)set1.stream().map(argumentType -> "\t" + String.valueOf(argumentType)).collect(Collectors.joining(",\n")));
            throw new IllegalStateException("Unregistered argument types");
        }
    }

    public static <T extends PermissionSetSupplier> PermissionProviderCheck<T> hasPermission(PermissionCheck check) {
        return new PermissionProviderCheck(check);
    }

    public static CommandSourceStack createCompilationContext(PermissionSet permissions) {
        return new CommandSourceStack(CommandSource.NULL, Vec3.ZERO, Vec2.ZERO, null, permissions, "", CommonComponents.EMPTY, null, null);
    }

    public static enum CommandSelection {
        ALL(true, true),
        DEDICATED(false, true),
        INTEGRATED(true, false);

        final boolean includeIntegrated;
        final boolean includeDedicated;

        private CommandSelection(boolean includeIntegrated, boolean includeDedicated) {
            this.includeIntegrated = includeIntegrated;
            this.includeDedicated = includeDedicated;
        }
    }

    @FunctionalInterface
    public static interface ParseFunction {
        public void parse(StringReader var1) throws CommandSyntaxException;
    }

    public static interface RestrictedMarker {
    }
}

