/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.scores.ScoreAccess;

public class OperationArgument
implements ArgumentType<Operation> {
    private static final Collection<String> EXAMPLES = Arrays.asList("=", ">", "<");
    private static final SimpleCommandExceptionType ERROR_INVALID_OPERATION = new SimpleCommandExceptionType((Message)Component.translatable("arguments.operation.invalid"));
    private static final SimpleCommandExceptionType ERROR_DIVIDE_BY_ZERO = new SimpleCommandExceptionType((Message)Component.translatable("arguments.operation.div0"));

    public static OperationArgument operation() {
        return new OperationArgument();
    }

    public static Operation getOperation(CommandContext<CommandSourceStack> context, String name) {
        return (Operation)context.getArgument(name, Operation.class);
    }

    public Operation parse(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            throw ERROR_INVALID_OPERATION.createWithContext((ImmutableStringReader)reader);
        }
        int cursor = reader.getCursor();
        while (reader.canRead() && reader.peek() != ' ') {
            reader.skip();
        }
        return OperationArgument.getOperation(reader.getString().substring(cursor, reader.getCursor()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(new String[]{"=", "+=", "-=", "*=", "/=", "%=", "<", ">", "><"}, builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static Operation getOperation(String name) throws CommandSyntaxException {
        return name.equals("><") ? (targetScore, sourceScore) -> {
            int i = targetScore.get();
            targetScore.set(sourceScore.get());
            sourceScore.set(i);
        } : OperationArgument.getSimpleOperation(name);
    }

    private static SimpleOperation getSimpleOperation(String name) throws CommandSyntaxException {
        return switch (name) {
            case "=" -> (targetScore, sourceScore) -> sourceScore;
            case "+=" -> Integer::sum;
            case "-=" -> (targetScore, sourceScore) -> targetScore - sourceScore;
            case "*=" -> (targetScore, sourceScore) -> targetScore * sourceScore;
            case "/=" -> (targetScore, sourceScore) -> {
                if (sourceScore == 0) {
                    throw ERROR_DIVIDE_BY_ZERO.create();
                }
                return Mth.floorDiv(targetScore, sourceScore);
            };
            case "%=" -> (targetScore, sourceScore) -> {
                if (sourceScore == 0) {
                    throw ERROR_DIVIDE_BY_ZERO.create();
                }
                return Mth.positiveModulo(targetScore, sourceScore);
            };
            case "<" -> Math::min;
            case ">" -> Math::max;
            default -> throw ERROR_INVALID_OPERATION.create();
        };
    }

    @FunctionalInterface
    public static interface Operation {
        public void apply(ScoreAccess var1, ScoreAccess var2) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface SimpleOperation
    extends Operation {
        public int apply(int var1, int var2) throws CommandSyntaxException;

        @Override
        default public void apply(ScoreAccess targetScore, ScoreAccess sourceScore) throws CommandSyntaxException {
            targetScore.set(this.apply(targetScore.get(), sourceScore.get()));
        }
    }
}

