/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.FloatArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.network.FriendlyByteBuf;

public class FloatArgumentInfo
implements ArgumentTypeInfo<FloatArgumentType, Template> {
    @Override
    public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
        boolean flag = template.min != -3.4028235E38f;
        boolean flag1 = template.max != Float.MAX_VALUE;
        buffer.writeByte(ArgumentUtils.createNumberFlags(flag, flag1));
        if (flag) {
            buffer.writeFloat(template.min);
        }
        if (flag1) {
            buffer.writeFloat(template.max);
        }
    }

    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
        byte _byte = buffer.readByte();
        float f = ArgumentUtils.numberHasMin(_byte) ? buffer.readFloat() : -3.4028235E38f;
        float f1 = ArgumentUtils.numberHasMax(_byte) ? buffer.readFloat() : Float.MAX_VALUE;
        return new Template(f, f1);
    }

    @Override
    public void serializeToJson(Template template, JsonObject json) {
        if (template.min != -3.4028235E38f) {
            json.addProperty("min", (Number)Float.valueOf(template.min));
        }
        if (template.max != Float.MAX_VALUE) {
            json.addProperty("max", (Number)Float.valueOf(template.max));
        }
    }

    @Override
    public Template unpack(FloatArgumentType argument) {
        return new Template(argument.getMinimum(), argument.getMaximum());
    }

    public final class Template
    implements ArgumentTypeInfo.Template<FloatArgumentType> {
        final float min;
        final float max;

        Template(float min, float max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public FloatArgumentType instantiate(CommandBuildContext context) {
            return FloatArgumentType.floatArg((float)this.min, (float)this.max);
        }

        @Override
        public ArgumentTypeInfo<FloatArgumentType, ?> type() {
            return FloatArgumentInfo.this;
        }
    }
}

