/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.LongArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.network.FriendlyByteBuf;

public class LongArgumentInfo
implements ArgumentTypeInfo<LongArgumentType, Template> {
    @Override
    public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
        boolean flag = template.min != Long.MIN_VALUE;
        boolean flag1 = template.max != Long.MAX_VALUE;
        buffer.writeByte(ArgumentUtils.createNumberFlags(flag, flag1));
        if (flag) {
            buffer.writeLong(template.min);
        }
        if (flag1) {
            buffer.writeLong(template.max);
        }
    }

    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
        byte _byte = buffer.readByte();
        long l = ArgumentUtils.numberHasMin(_byte) ? buffer.readLong() : Long.MIN_VALUE;
        long l1 = ArgumentUtils.numberHasMax(_byte) ? buffer.readLong() : Long.MAX_VALUE;
        return new Template(l, l1);
    }

    @Override
    public void serializeToJson(Template template, JsonObject json) {
        if (template.min != Long.MIN_VALUE) {
            json.addProperty("min", (Number)template.min);
        }
        if (template.max != Long.MAX_VALUE) {
            json.addProperty("max", (Number)template.max);
        }
    }

    @Override
    public Template unpack(LongArgumentType argument) {
        return new Template(argument.getMinimum(), argument.getMaximum());
    }

    public final class Template
    implements ArgumentTypeInfo.Template<LongArgumentType> {
        final long min;
        final long max;

        Template(long min, long max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public LongArgumentType instantiate(CommandBuildContext context) {
            return LongArgumentType.longArg((long)this.min, (long)this.max);
        }

        @Override
        public ArgumentTypeInfo<LongArgumentType, ?> type() {
            return LongArgumentInfo.this;
        }
    }
}

