/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.predicates.DataComponentPredicate;

public record DamagePredicate(MinMaxBounds.Ints durability, MinMaxBounds.Ints damage) implements DataComponentPredicate
{
    public static final Codec<DamagePredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MinMaxBounds.Ints.CODEC.optionalFieldOf("durability", (Object)MinMaxBounds.Ints.ANY).forGetter(DamagePredicate::durability), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("damage", (Object)MinMaxBounds.Ints.ANY).forGetter(DamagePredicate::damage)).apply((Applicative)instance, DamagePredicate::new));

    @Override
    public boolean matches(DataComponentGetter componentGetter) {
        Integer integer = componentGetter.get(DataComponents.DAMAGE);
        if (integer == null) {
            return false;
        }
        int orDefault = componentGetter.getOrDefault(DataComponents.MAX_DAMAGE, 0);
        return this.durability.matches(orDefault - integer) && this.damage.matches(integer);
    }

    public static DamagePredicate durability(MinMaxBounds.Ints durability) {
        return new DamagePredicate(durability, MinMaxBounds.Ints.ANY);
    }
}

