/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes.packs;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.data.recipes.TransmuteRecipeBuilder;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.ArmorDyeRecipe;
import net.minecraft.world.item.crafting.BannerDuplicateRecipe;
import net.minecraft.world.item.crafting.BookCloningRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.DecoratedPotRecipe;
import net.minecraft.world.item.crafting.FireworkRocketRecipe;
import net.minecraft.world.item.crafting.FireworkStarFadeRecipe;
import net.minecraft.world.item.crafting.FireworkStarRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.MapCloningRecipe;
import net.minecraft.world.item.crafting.MapExtendingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RepairItemRecipe;
import net.minecraft.world.item.crafting.ShieldDecorationRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.TippedArrowRecipe;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SuspiciousEffectHolder;

public class VanillaRecipeProvider
extends RecipeProvider {
    private static final ImmutableList<ItemLike> COAL_SMELTABLES = ImmutableList.of((Object)Items.COAL_ORE, (Object)Items.DEEPSLATE_COAL_ORE);
    private static final ImmutableList<ItemLike> IRON_SMELTABLES = ImmutableList.of((Object)Items.IRON_ORE, (Object)Items.DEEPSLATE_IRON_ORE, (Object)Items.RAW_IRON);
    private static final ImmutableList<ItemLike> COPPER_SMELTABLES = ImmutableList.of((Object)Items.COPPER_ORE, (Object)Items.DEEPSLATE_COPPER_ORE, (Object)Items.RAW_COPPER);
    private static final ImmutableList<ItemLike> GOLD_SMELTABLES = ImmutableList.of((Object)Items.GOLD_ORE, (Object)Items.DEEPSLATE_GOLD_ORE, (Object)Items.NETHER_GOLD_ORE, (Object)Items.RAW_GOLD);
    private static final ImmutableList<ItemLike> DIAMOND_SMELTABLES = ImmutableList.of((Object)Items.DIAMOND_ORE, (Object)Items.DEEPSLATE_DIAMOND_ORE);
    private static final ImmutableList<ItemLike> LAPIS_SMELTABLES = ImmutableList.of((Object)Items.LAPIS_ORE, (Object)Items.DEEPSLATE_LAPIS_ORE);
    private static final ImmutableList<ItemLike> REDSTONE_SMELTABLES = ImmutableList.of((Object)Items.REDSTONE_ORE, (Object)Items.DEEPSLATE_REDSTONE_ORE);
    private static final ImmutableList<ItemLike> EMERALD_SMELTABLES = ImmutableList.of((Object)Items.EMERALD_ORE, (Object)Items.DEEPSLATE_EMERALD_ORE);

    VanillaRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
        super(registries, output);
    }

    @Override
    protected void buildRecipes() {
        this.output.includeRootAdvancement();
        this.generateForEnabledBlockFamilies(FeatureFlagSet.of(FeatureFlags.VANILLA));
        this.planksFromLog(Blocks.ACACIA_PLANKS, ItemTags.ACACIA_LOGS, 4);
        this.planksFromLogs(Blocks.BIRCH_PLANKS, ItemTags.BIRCH_LOGS, 4);
        this.planksFromLogs(Blocks.CRIMSON_PLANKS, ItemTags.CRIMSON_STEMS, 4);
        this.planksFromLog(Blocks.DARK_OAK_PLANKS, ItemTags.DARK_OAK_LOGS, 4);
        this.planksFromLog(Blocks.PALE_OAK_PLANKS, ItemTags.PALE_OAK_LOGS, 4);
        this.planksFromLogs(Blocks.JUNGLE_PLANKS, ItemTags.JUNGLE_LOGS, 4);
        this.planksFromLogs(Blocks.OAK_PLANKS, ItemTags.OAK_LOGS, 4);
        this.planksFromLogs(Blocks.SPRUCE_PLANKS, ItemTags.SPRUCE_LOGS, 4);
        this.planksFromLogs(Blocks.WARPED_PLANKS, ItemTags.WARPED_STEMS, 4);
        this.planksFromLogs(Blocks.MANGROVE_PLANKS, ItemTags.MANGROVE_LOGS, 4);
        this.woodFromLogs(Blocks.ACACIA_WOOD, Blocks.ACACIA_LOG);
        this.woodFromLogs(Blocks.BIRCH_WOOD, Blocks.BIRCH_LOG);
        this.woodFromLogs(Blocks.DARK_OAK_WOOD, Blocks.DARK_OAK_LOG);
        this.woodFromLogs(Blocks.PALE_OAK_WOOD, Blocks.PALE_OAK_LOG);
        this.woodFromLogs(Blocks.JUNGLE_WOOD, Blocks.JUNGLE_LOG);
        this.woodFromLogs(Blocks.OAK_WOOD, Blocks.OAK_LOG);
        this.woodFromLogs(Blocks.SPRUCE_WOOD, Blocks.SPRUCE_LOG);
        this.woodFromLogs(Blocks.CRIMSON_HYPHAE, Blocks.CRIMSON_STEM);
        this.woodFromLogs(Blocks.WARPED_HYPHAE, Blocks.WARPED_STEM);
        this.woodFromLogs(Blocks.MANGROVE_WOOD, Blocks.MANGROVE_LOG);
        this.woodFromLogs(Blocks.STRIPPED_ACACIA_WOOD, Blocks.STRIPPED_ACACIA_LOG);
        this.woodFromLogs(Blocks.STRIPPED_BIRCH_WOOD, Blocks.STRIPPED_BIRCH_LOG);
        this.woodFromLogs(Blocks.STRIPPED_DARK_OAK_WOOD, Blocks.STRIPPED_DARK_OAK_LOG);
        this.woodFromLogs(Blocks.STRIPPED_PALE_OAK_WOOD, Blocks.STRIPPED_PALE_OAK_LOG);
        this.woodFromLogs(Blocks.STRIPPED_JUNGLE_WOOD, Blocks.STRIPPED_JUNGLE_LOG);
        this.woodFromLogs(Blocks.STRIPPED_OAK_WOOD, Blocks.STRIPPED_OAK_LOG);
        this.woodFromLogs(Blocks.STRIPPED_SPRUCE_WOOD, Blocks.STRIPPED_SPRUCE_LOG);
        this.woodFromLogs(Blocks.STRIPPED_CRIMSON_HYPHAE, Blocks.STRIPPED_CRIMSON_STEM);
        this.woodFromLogs(Blocks.STRIPPED_WARPED_HYPHAE, Blocks.STRIPPED_WARPED_STEM);
        this.woodFromLogs(Blocks.STRIPPED_MANGROVE_WOOD, Blocks.STRIPPED_MANGROVE_LOG);
        this.woodenBoat(Items.ACACIA_BOAT, Blocks.ACACIA_PLANKS);
        this.woodenBoat(Items.BIRCH_BOAT, Blocks.BIRCH_PLANKS);
        this.woodenBoat(Items.DARK_OAK_BOAT, Blocks.DARK_OAK_PLANKS);
        this.woodenBoat(Items.PALE_OAK_BOAT, Blocks.PALE_OAK_PLANKS);
        this.woodenBoat(Items.JUNGLE_BOAT, Blocks.JUNGLE_PLANKS);
        this.woodenBoat(Items.OAK_BOAT, Blocks.OAK_PLANKS);
        this.woodenBoat(Items.SPRUCE_BOAT, Blocks.SPRUCE_PLANKS);
        this.woodenBoat(Items.MANGROVE_BOAT, Blocks.MANGROVE_PLANKS);
        this.shelf(Blocks.ACACIA_SHELF, Items.STRIPPED_ACACIA_LOG);
        this.shelf(Blocks.BAMBOO_SHELF, Items.STRIPPED_BAMBOO_BLOCK);
        this.shelf(Blocks.BIRCH_SHELF, Items.STRIPPED_BIRCH_LOG);
        this.shelf(Blocks.CHERRY_SHELF, Items.STRIPPED_CHERRY_LOG);
        this.shelf(Blocks.CRIMSON_SHELF, Items.STRIPPED_CRIMSON_STEM);
        this.shelf(Blocks.DARK_OAK_SHELF, Items.STRIPPED_DARK_OAK_LOG);
        this.shelf(Blocks.JUNGLE_SHELF, Items.STRIPPED_JUNGLE_LOG);
        this.shelf(Blocks.MANGROVE_SHELF, Items.STRIPPED_MANGROVE_LOG);
        this.shelf(Blocks.OAK_SHELF, Items.STRIPPED_OAK_LOG);
        this.shelf(Blocks.PALE_OAK_SHELF, Items.STRIPPED_PALE_OAK_LOG);
        this.shelf(Blocks.SPRUCE_SHELF, Items.STRIPPED_SPRUCE_LOG);
        this.shelf(Blocks.WARPED_SHELF, Items.STRIPPED_WARPED_STEM);
        List<Item> list = List.of(Items.BLACK_DYE, Items.BLUE_DYE, Items.BROWN_DYE, Items.CYAN_DYE, Items.GRAY_DYE, Items.GREEN_DYE, Items.LIGHT_BLUE_DYE, Items.LIGHT_GRAY_DYE, Items.LIME_DYE, Items.MAGENTA_DYE, Items.ORANGE_DYE, Items.PINK_DYE, Items.PURPLE_DYE, Items.RED_DYE, Items.YELLOW_DYE, Items.WHITE_DYE);
        List<Item> list1 = List.of(Items.BLACK_WOOL, Items.BLUE_WOOL, Items.BROWN_WOOL, Items.CYAN_WOOL, Items.GRAY_WOOL, Items.GREEN_WOOL, Items.LIGHT_BLUE_WOOL, Items.LIGHT_GRAY_WOOL, Items.LIME_WOOL, Items.MAGENTA_WOOL, Items.ORANGE_WOOL, Items.PINK_WOOL, Items.PURPLE_WOOL, Items.RED_WOOL, Items.YELLOW_WOOL, Items.WHITE_WOOL);
        List<Item> list2 = List.of(Items.BLACK_BED, Items.BLUE_BED, Items.BROWN_BED, Items.CYAN_BED, Items.GRAY_BED, Items.GREEN_BED, Items.LIGHT_BLUE_BED, Items.LIGHT_GRAY_BED, Items.LIME_BED, Items.MAGENTA_BED, Items.ORANGE_BED, Items.PINK_BED, Items.PURPLE_BED, Items.RED_BED, Items.YELLOW_BED, Items.WHITE_BED);
        List<Item> list3 = List.of(Items.BLACK_CARPET, Items.BLUE_CARPET, Items.BROWN_CARPET, Items.CYAN_CARPET, Items.GRAY_CARPET, Items.GREEN_CARPET, Items.LIGHT_BLUE_CARPET, Items.LIGHT_GRAY_CARPET, Items.LIME_CARPET, Items.MAGENTA_CARPET, Items.ORANGE_CARPET, Items.PINK_CARPET, Items.PURPLE_CARPET, Items.RED_CARPET, Items.YELLOW_CARPET, Items.WHITE_CARPET);
        List<Item> list4 = List.of(Items.BLACK_HARNESS, Items.BLUE_HARNESS, Items.BROWN_HARNESS, Items.CYAN_HARNESS, Items.GRAY_HARNESS, Items.GREEN_HARNESS, Items.LIGHT_BLUE_HARNESS, Items.LIGHT_GRAY_HARNESS, Items.LIME_HARNESS, Items.MAGENTA_HARNESS, Items.ORANGE_HARNESS, Items.PINK_HARNESS, Items.PURPLE_HARNESS, Items.RED_HARNESS, Items.YELLOW_HARNESS, Items.WHITE_HARNESS);
        this.colorItemWithDye(list, list1, "wool", RecipeCategory.BUILDING_BLOCKS);
        this.colorItemWithDye(list, list2, "bed_dye", RecipeCategory.DECORATIONS);
        this.colorItemWithDye(list, list3, "carpet_dye", RecipeCategory.DECORATIONS);
        this.colorItemWithDye(list, list4, "harness_dye", RecipeCategory.COMBAT);
        this.carpet(Blocks.BLACK_CARPET, Blocks.BLACK_WOOL);
        this.bedFromPlanksAndWool(Items.BLACK_BED, Blocks.BLACK_WOOL);
        this.banner(Items.BLACK_BANNER, Blocks.BLACK_WOOL);
        this.carpet(Blocks.BLUE_CARPET, Blocks.BLUE_WOOL);
        this.bedFromPlanksAndWool(Items.BLUE_BED, Blocks.BLUE_WOOL);
        this.banner(Items.BLUE_BANNER, Blocks.BLUE_WOOL);
        this.carpet(Blocks.BROWN_CARPET, Blocks.BROWN_WOOL);
        this.bedFromPlanksAndWool(Items.BROWN_BED, Blocks.BROWN_WOOL);
        this.banner(Items.BROWN_BANNER, Blocks.BROWN_WOOL);
        this.carpet(Blocks.CYAN_CARPET, Blocks.CYAN_WOOL);
        this.bedFromPlanksAndWool(Items.CYAN_BED, Blocks.CYAN_WOOL);
        this.banner(Items.CYAN_BANNER, Blocks.CYAN_WOOL);
        this.carpet(Blocks.GRAY_CARPET, Blocks.GRAY_WOOL);
        this.bedFromPlanksAndWool(Items.GRAY_BED, Blocks.GRAY_WOOL);
        this.banner(Items.GRAY_BANNER, Blocks.GRAY_WOOL);
        this.carpet(Blocks.GREEN_CARPET, Blocks.GREEN_WOOL);
        this.bedFromPlanksAndWool(Items.GREEN_BED, Blocks.GREEN_WOOL);
        this.banner(Items.GREEN_BANNER, Blocks.GREEN_WOOL);
        this.carpet(Blocks.LIGHT_BLUE_CARPET, Blocks.LIGHT_BLUE_WOOL);
        this.bedFromPlanksAndWool(Items.LIGHT_BLUE_BED, Blocks.LIGHT_BLUE_WOOL);
        this.banner(Items.LIGHT_BLUE_BANNER, Blocks.LIGHT_BLUE_WOOL);
        this.carpet(Blocks.LIGHT_GRAY_CARPET, Blocks.LIGHT_GRAY_WOOL);
        this.bedFromPlanksAndWool(Items.LIGHT_GRAY_BED, Blocks.LIGHT_GRAY_WOOL);
        this.banner(Items.LIGHT_GRAY_BANNER, Blocks.LIGHT_GRAY_WOOL);
        this.carpet(Blocks.LIME_CARPET, Blocks.LIME_WOOL);
        this.bedFromPlanksAndWool(Items.LIME_BED, Blocks.LIME_WOOL);
        this.banner(Items.LIME_BANNER, Blocks.LIME_WOOL);
        this.carpet(Blocks.MAGENTA_CARPET, Blocks.MAGENTA_WOOL);
        this.bedFromPlanksAndWool(Items.MAGENTA_BED, Blocks.MAGENTA_WOOL);
        this.banner(Items.MAGENTA_BANNER, Blocks.MAGENTA_WOOL);
        this.carpet(Blocks.ORANGE_CARPET, Blocks.ORANGE_WOOL);
        this.bedFromPlanksAndWool(Items.ORANGE_BED, Blocks.ORANGE_WOOL);
        this.banner(Items.ORANGE_BANNER, Blocks.ORANGE_WOOL);
        this.carpet(Blocks.PINK_CARPET, Blocks.PINK_WOOL);
        this.bedFromPlanksAndWool(Items.PINK_BED, Blocks.PINK_WOOL);
        this.banner(Items.PINK_BANNER, Blocks.PINK_WOOL);
        this.carpet(Blocks.PURPLE_CARPET, Blocks.PURPLE_WOOL);
        this.bedFromPlanksAndWool(Items.PURPLE_BED, Blocks.PURPLE_WOOL);
        this.banner(Items.PURPLE_BANNER, Blocks.PURPLE_WOOL);
        this.carpet(Blocks.RED_CARPET, Blocks.RED_WOOL);
        this.bedFromPlanksAndWool(Items.RED_BED, Blocks.RED_WOOL);
        this.banner(Items.RED_BANNER, Blocks.RED_WOOL);
        this.carpet(Blocks.WHITE_CARPET, Blocks.WHITE_WOOL);
        this.bedFromPlanksAndWool(Items.WHITE_BED, Blocks.WHITE_WOOL);
        this.banner(Items.WHITE_BANNER, Blocks.WHITE_WOOL);
        this.carpet(Blocks.YELLOW_CARPET, Blocks.YELLOW_WOOL);
        this.bedFromPlanksAndWool(Items.YELLOW_BED, Blocks.YELLOW_WOOL);
        this.banner(Items.YELLOW_BANNER, Blocks.YELLOW_WOOL);
        this.carpet(Blocks.MOSS_CARPET, Blocks.MOSS_BLOCK);
        this.carpet(Blocks.PALE_MOSS_CARPET, Blocks.PALE_MOSS_BLOCK);
        this.harness(Items.WHITE_HARNESS, Blocks.WHITE_WOOL);
        this.harness(Items.ORANGE_HARNESS, Blocks.ORANGE_WOOL);
        this.harness(Items.MAGENTA_HARNESS, Blocks.MAGENTA_WOOL);
        this.harness(Items.LIGHT_BLUE_HARNESS, Blocks.LIGHT_BLUE_WOOL);
        this.harness(Items.YELLOW_HARNESS, Blocks.YELLOW_WOOL);
        this.harness(Items.LIME_HARNESS, Blocks.LIME_WOOL);
        this.harness(Items.PINK_HARNESS, Blocks.PINK_WOOL);
        this.harness(Items.GRAY_HARNESS, Blocks.GRAY_WOOL);
        this.harness(Items.LIGHT_GRAY_HARNESS, Blocks.LIGHT_GRAY_WOOL);
        this.harness(Items.CYAN_HARNESS, Blocks.CYAN_WOOL);
        this.harness(Items.PURPLE_HARNESS, Blocks.PURPLE_WOOL);
        this.harness(Items.BLUE_HARNESS, Blocks.BLUE_WOOL);
        this.harness(Items.BROWN_HARNESS, Blocks.BROWN_WOOL);
        this.harness(Items.GREEN_HARNESS, Blocks.GREEN_WOOL);
        this.harness(Items.RED_HARNESS, Blocks.RED_WOOL);
        this.harness(Items.BLACK_HARNESS, Blocks.BLACK_WOOL);
        this.stainedGlassFromGlassAndDye(Blocks.BLACK_STAINED_GLASS, Items.BLACK_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.BLACK_STAINED_GLASS_PANE, Blocks.BLACK_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.BLACK_STAINED_GLASS_PANE, Items.BLACK_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.BLUE_STAINED_GLASS, Items.BLUE_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.BLUE_STAINED_GLASS_PANE, Blocks.BLUE_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.BLUE_STAINED_GLASS_PANE, Items.BLUE_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.BROWN_STAINED_GLASS, Items.BROWN_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.BROWN_STAINED_GLASS_PANE, Blocks.BROWN_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.BROWN_STAINED_GLASS_PANE, Items.BROWN_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.CYAN_STAINED_GLASS, Items.CYAN_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.CYAN_STAINED_GLASS_PANE, Blocks.CYAN_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.CYAN_STAINED_GLASS_PANE, Items.CYAN_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.GRAY_STAINED_GLASS, Items.GRAY_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.GRAY_STAINED_GLASS_PANE, Blocks.GRAY_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.GRAY_STAINED_GLASS_PANE, Items.GRAY_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.GREEN_STAINED_GLASS, Items.GREEN_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.GREEN_STAINED_GLASS_PANE, Blocks.GREEN_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.GREEN_STAINED_GLASS_PANE, Items.GREEN_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.LIGHT_BLUE_STAINED_GLASS, Items.LIGHT_BLUE_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.LIGHT_BLUE_STAINED_GLASS_PANE, Blocks.LIGHT_BLUE_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.LIGHT_BLUE_STAINED_GLASS_PANE, Items.LIGHT_BLUE_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.LIGHT_GRAY_STAINED_GLASS, Items.LIGHT_GRAY_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.LIGHT_GRAY_STAINED_GLASS_PANE, Blocks.LIGHT_GRAY_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.LIGHT_GRAY_STAINED_GLASS_PANE, Items.LIGHT_GRAY_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.LIME_STAINED_GLASS, Items.LIME_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.LIME_STAINED_GLASS_PANE, Blocks.LIME_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.LIME_STAINED_GLASS_PANE, Items.LIME_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.MAGENTA_STAINED_GLASS, Items.MAGENTA_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.MAGENTA_STAINED_GLASS_PANE, Blocks.MAGENTA_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.MAGENTA_STAINED_GLASS_PANE, Items.MAGENTA_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.ORANGE_STAINED_GLASS, Items.ORANGE_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.ORANGE_STAINED_GLASS_PANE, Blocks.ORANGE_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.ORANGE_STAINED_GLASS_PANE, Items.ORANGE_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.PINK_STAINED_GLASS, Items.PINK_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.PINK_STAINED_GLASS_PANE, Blocks.PINK_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.PINK_STAINED_GLASS_PANE, Items.PINK_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.PURPLE_STAINED_GLASS, Items.PURPLE_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.PURPLE_STAINED_GLASS_PANE, Blocks.PURPLE_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.PURPLE_STAINED_GLASS_PANE, Items.PURPLE_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.RED_STAINED_GLASS, Items.RED_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.RED_STAINED_GLASS_PANE, Blocks.RED_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.RED_STAINED_GLASS_PANE, Items.RED_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.WHITE_STAINED_GLASS, Items.WHITE_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.WHITE_STAINED_GLASS_PANE, Blocks.WHITE_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.WHITE_STAINED_GLASS_PANE, Items.WHITE_DYE);
        this.stainedGlassFromGlassAndDye(Blocks.YELLOW_STAINED_GLASS, Items.YELLOW_DYE);
        this.stainedGlassPaneFromStainedGlass(Blocks.YELLOW_STAINED_GLASS_PANE, Blocks.YELLOW_STAINED_GLASS);
        this.stainedGlassPaneFromGlassPaneAndDye(Blocks.YELLOW_STAINED_GLASS_PANE, Items.YELLOW_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.BLACK_TERRACOTTA, Items.BLACK_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.BLUE_TERRACOTTA, Items.BLUE_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.BROWN_TERRACOTTA, Items.BROWN_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.CYAN_TERRACOTTA, Items.CYAN_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.GRAY_TERRACOTTA, Items.GRAY_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.GREEN_TERRACOTTA, Items.GREEN_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.LIGHT_BLUE_TERRACOTTA, Items.LIGHT_BLUE_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.LIGHT_GRAY_TERRACOTTA, Items.LIGHT_GRAY_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.LIME_TERRACOTTA, Items.LIME_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.MAGENTA_TERRACOTTA, Items.MAGENTA_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.ORANGE_TERRACOTTA, Items.ORANGE_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.PINK_TERRACOTTA, Items.PINK_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.PURPLE_TERRACOTTA, Items.PURPLE_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.RED_TERRACOTTA, Items.RED_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.WHITE_TERRACOTTA, Items.WHITE_DYE);
        this.coloredTerracottaFromTerracottaAndDye(Blocks.YELLOW_TERRACOTTA, Items.YELLOW_DYE);
        this.concretePowder(Blocks.BLACK_CONCRETE_POWDER, Items.BLACK_DYE);
        this.concretePowder(Blocks.BLUE_CONCRETE_POWDER, Items.BLUE_DYE);
        this.concretePowder(Blocks.BROWN_CONCRETE_POWDER, Items.BROWN_DYE);
        this.concretePowder(Blocks.CYAN_CONCRETE_POWDER, Items.CYAN_DYE);
        this.concretePowder(Blocks.GRAY_CONCRETE_POWDER, Items.GRAY_DYE);
        this.concretePowder(Blocks.GREEN_CONCRETE_POWDER, Items.GREEN_DYE);
        this.concretePowder(Blocks.LIGHT_BLUE_CONCRETE_POWDER, Items.LIGHT_BLUE_DYE);
        this.concretePowder(Blocks.LIGHT_GRAY_CONCRETE_POWDER, Items.LIGHT_GRAY_DYE);
        this.concretePowder(Blocks.LIME_CONCRETE_POWDER, Items.LIME_DYE);
        this.concretePowder(Blocks.MAGENTA_CONCRETE_POWDER, Items.MAGENTA_DYE);
        this.concretePowder(Blocks.ORANGE_CONCRETE_POWDER, Items.ORANGE_DYE);
        this.concretePowder(Blocks.PINK_CONCRETE_POWDER, Items.PINK_DYE);
        this.concretePowder(Blocks.PURPLE_CONCRETE_POWDER, Items.PURPLE_DYE);
        this.concretePowder(Blocks.RED_CONCRETE_POWDER, Items.RED_DYE);
        this.concretePowder(Blocks.WHITE_CONCRETE_POWDER, Items.WHITE_DYE);
        this.concretePowder(Blocks.YELLOW_CONCRETE_POWDER, Items.YELLOW_DYE);
        this.dryGhast(Blocks.DRIED_GHAST);
        ((ShapedRecipeBuilder)this.shaped(RecipeCategory.DECORATIONS, Items.CANDLE).define(Character.valueOf('S'), Items.STRING).define(Character.valueOf('H'), Items.HONEYCOMB).pattern("S").pattern("H").unlockedBy("has_string", (Criterion)this.has(Items.STRING))).unlockedBy("has_honeycomb", (Criterion)this.has(Items.HONEYCOMB)).save(this.output);
        this.candle(Blocks.BLACK_CANDLE, Items.BLACK_DYE);
        this.candle(Blocks.BLUE_CANDLE, Items.BLUE_DYE);
        this.candle(Blocks.BROWN_CANDLE, Items.BROWN_DYE);
        this.candle(Blocks.CYAN_CANDLE, Items.CYAN_DYE);
        this.candle(Blocks.GRAY_CANDLE, Items.GRAY_DYE);
        this.candle(Blocks.GREEN_CANDLE, Items.GREEN_DYE);
        this.candle(Blocks.LIGHT_BLUE_CANDLE, Items.LIGHT_BLUE_DYE);
        this.candle(Blocks.LIGHT_GRAY_CANDLE, Items.LIGHT_GRAY_DYE);
        this.candle(Blocks.LIME_CANDLE, Items.LIME_DYE);
        this.candle(Blocks.MAGENTA_CANDLE, Items.MAGENTA_DYE);
        this.candle(Blocks.ORANGE_CANDLE, Items.ORANGE_DYE);
        this.candle(Blocks.PINK_CANDLE, Items.PINK_DYE);
        this.candle(Blocks.PURPLE_CANDLE, Items.PURPLE_DYE);
        this.candle(Blocks.RED_CANDLE, Items.RED_DYE);
        this.candle(Blocks.WHITE_CANDLE, Items.WHITE_DYE);
        this.candle(Blocks.YELLOW_CANDLE, Items.YELLOW_DYE);
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.PACKED_MUD, 1).requires(Blocks.MUD).requires(Items.WHEAT).unlockedBy("has_mud", (Criterion)this.has(Blocks.MUD)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.MUD_BRICKS, 4).define(Character.valueOf('#'), Blocks.PACKED_MUD).pattern("##").pattern("##").unlockedBy("has_packed_mud", (Criterion)this.has(Blocks.PACKED_MUD)).save(this.output);
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.MUDDY_MANGROVE_ROOTS, 1).requires(Blocks.MUD).requires(Items.MANGROVE_ROOTS).unlockedBy("has_mangrove_roots", (Criterion)this.has(Blocks.MANGROVE_ROOTS)).save(this.output);
        this.shaped(RecipeCategory.TRANSPORTATION, Blocks.ACTIVATOR_RAIL, 6).define(Character.valueOf('#'), Blocks.REDSTONE_TORCH).define(Character.valueOf('S'), Items.STICK).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("XSX").pattern("X#X").pattern("XSX").unlockedBy("has_rail", (Criterion)this.has(Blocks.RAIL)).save(this.output);
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.ANDESITE, 2).requires(Blocks.DIORITE).requires(Blocks.COBBLESTONE).unlockedBy("has_stone", (Criterion)this.has(Blocks.DIORITE)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.ANVIL).define(Character.valueOf('I'), Blocks.IRON_BLOCK).define(Character.valueOf('i'), Items.IRON_INGOT).pattern("III").pattern(" i ").pattern("iii").unlockedBy("has_iron_block", (Criterion)this.has(Blocks.IRON_BLOCK)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Items.ARMOR_STAND).define(Character.valueOf('/'), Items.STICK).define(Character.valueOf('_'), Blocks.SMOOTH_STONE_SLAB).pattern("///").pattern(" / ").pattern("/_/").unlockedBy("has_stone_slab", (Criterion)this.has(Blocks.SMOOTH_STONE_SLAB)).save(this.output);
        ((ShapedRecipeBuilder)this.shaped(RecipeCategory.COMBAT, Items.ARROW, 4).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.FLINT).define(Character.valueOf('Y'), Items.FEATHER).pattern("X").pattern("#").pattern("Y").unlockedBy("has_feather", (Criterion)this.has(Items.FEATHER))).unlockedBy("has_flint", (Criterion)this.has(Items.FLINT)).save(this.output);
        ((ShapedRecipeBuilder)this.shaped(RecipeCategory.DECORATIONS, Blocks.BARREL, 1).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).pattern("PSP").pattern("P P").pattern("PSP").unlockedBy("has_planks", (Criterion)this.has(ItemTags.PLANKS))).unlockedBy("has_wood_slab", (Criterion)this.has(ItemTags.WOODEN_SLABS)).save(this.output);
        this.shaped(RecipeCategory.MISC, Blocks.BEACON).define(Character.valueOf('S'), Items.NETHER_STAR).define(Character.valueOf('G'), Blocks.GLASS).define(Character.valueOf('O'), Blocks.OBSIDIAN).pattern("GGG").pattern("GSG").pattern("OOO").unlockedBy("has_nether_star", (Criterion)this.has(Items.NETHER_STAR)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.BEEHIVE).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('H'), Items.HONEYCOMB).pattern("PPP").pattern("HHH").pattern("PPP").unlockedBy("has_honeycomb", (Criterion)this.has(Items.HONEYCOMB)).save(this.output);
        this.shapeless(RecipeCategory.FOOD, Items.BEETROOT_SOUP).requires(Items.BOWL).requires(Items.BEETROOT, 6).unlockedBy("has_beetroot", (Criterion)this.has(Items.BEETROOT)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.BLACK_DYE).requires(Items.INK_SAC).group("black_dye").unlockedBy("has_ink_sac", (Criterion)this.has(Items.INK_SAC)).save(this.output);
        this.oneToOneConversionRecipe(Items.BLACK_DYE, Blocks.WITHER_ROSE, "black_dye");
        this.shapeless(RecipeCategory.BREWING, Items.BLAZE_POWDER, 2).requires(Items.BLAZE_ROD).unlockedBy("has_blaze_rod", (Criterion)this.has(Items.BLAZE_ROD)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.BLUE_DYE).requires(Items.LAPIS_LAZULI).group("blue_dye").unlockedBy("has_lapis_lazuli", (Criterion)this.has(Items.LAPIS_LAZULI)).save(this.output);
        this.oneToOneConversionRecipe(Items.BLUE_DYE, Blocks.CORNFLOWER, "blue_dye");
        this.threeByThreePacker(RecipeCategory.BUILDING_BLOCKS, Blocks.BLUE_ICE, Blocks.PACKED_ICE);
        this.shapeless(RecipeCategory.MISC, Items.BONE_MEAL, 3).requires(Items.BONE).group("bonemeal").unlockedBy("has_bone", (Criterion)this.has(Items.BONE)).save(this.output);
        this.nineBlockStorageRecipesRecipesWithCustomUnpacking(RecipeCategory.MISC, Items.BONE_MEAL, RecipeCategory.BUILDING_BLOCKS, Items.BONE_BLOCK, "bone_meal_from_bone_block", "bonemeal");
        this.shapeless(RecipeCategory.MISC, Items.BOOK).requires(Items.PAPER, 3).requires(Items.LEATHER).unlockedBy("has_paper", (Criterion)this.has(Items.PAPER)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.BOOKSHELF).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('X'), Items.BOOK).pattern("###").pattern("XXX").pattern("###").unlockedBy("has_book", (Criterion)this.has(Items.BOOK)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.BOW).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.STRING).pattern(" #X").pattern("# X").pattern(" #X").unlockedBy("has_string", (Criterion)this.has(Items.STRING)).save(this.output);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)this.shaped(RecipeCategory.MISC, Items.BOWL, 4).define(Character.valueOf('#'), ItemTags.PLANKS).pattern("# #").pattern(" # ").unlockedBy("has_brown_mushroom", (Criterion)this.has(Blocks.BROWN_MUSHROOM))).unlockedBy("has_red_mushroom", (Criterion)this.has(Blocks.RED_MUSHROOM))).unlockedBy("has_mushroom_stew", (Criterion)this.has(Items.MUSHROOM_STEW)).save(this.output);
        this.shaped(RecipeCategory.FOOD, Items.BREAD).define(Character.valueOf('#'), Items.WHEAT).pattern("###").unlockedBy("has_wheat", (Criterion)this.has(Items.WHEAT)).save(this.output);
        this.shaped(RecipeCategory.BREWING, Blocks.BREWING_STAND).define(Character.valueOf('B'), Items.BLAZE_ROD).define(Character.valueOf('#'), ItemTags.STONE_CRAFTING_MATERIALS).pattern(" B ").pattern("###").unlockedBy("has_blaze_rod", (Criterion)this.has(Items.BLAZE_ROD)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.BRICKS).define(Character.valueOf('#'), Items.BRICK).pattern("##").pattern("##").unlockedBy("has_brick", (Criterion)this.has(Items.BRICK)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.BROWN_DYE).requires(Items.COCOA_BEANS).group("brown_dye").unlockedBy("has_cocoa_beans", (Criterion)this.has(Items.COCOA_BEANS)).save(this.output);
        this.shaped(RecipeCategory.MISC, Items.BUCKET).define(Character.valueOf('#'), Items.IRON_INGOT).pattern("# #").pattern(" # ").unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT)).save(this.output);
        this.shaped(RecipeCategory.FOOD, Blocks.CAKE).define(Character.valueOf('A'), Items.MILK_BUCKET).define(Character.valueOf('B'), Items.SUGAR).define(Character.valueOf('C'), Items.WHEAT).define(Character.valueOf('E'), ItemTags.EGGS).pattern("AAA").pattern("BEB").pattern("CCC").unlockedBy("has_egg", (Criterion)this.has(ItemTags.EGGS)).save(this.output);
        ((ShapedRecipeBuilder)this.shaped(RecipeCategory.DECORATIONS, Blocks.CAMPFIRE).define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('S'), Items.STICK).define(Character.valueOf('C'), ItemTags.COALS).pattern(" S ").pattern("SCS").pattern("LLL").unlockedBy("has_stick", (Criterion)this.has(Items.STICK))).unlockedBy("has_coal", (Criterion)this.has(ItemTags.COALS)).save(this.output);
        this.shaped(RecipeCategory.TRANSPORTATION, Items.CARROT_ON_A_STICK).define(Character.valueOf('#'), Items.FISHING_ROD).define(Character.valueOf('X'), Items.CARROT).pattern("# ").pattern(" X").unlockedBy("has_carrot", (Criterion)this.has(Items.CARROT)).save(this.output);
        this.shaped(RecipeCategory.TRANSPORTATION, Items.WARPED_FUNGUS_ON_A_STICK).define(Character.valueOf('#'), Items.FISHING_ROD).define(Character.valueOf('X'), Items.WARPED_FUNGUS).pattern("# ").pattern(" X").unlockedBy("has_warped_fungus", (Criterion)this.has(Items.WARPED_FUNGUS)).save(this.output);
        this.shaped(RecipeCategory.BREWING, Blocks.CAULDRON).define(Character.valueOf('#'), Items.IRON_INGOT).pattern("# #").pattern("# #").pattern("###").unlockedBy("has_water_bucket", (Criterion)this.has(Items.WATER_BUCKET)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.COMPOSTER).define(Character.valueOf('#'), ItemTags.WOODEN_SLABS).pattern("# #").pattern("# #").pattern("###").unlockedBy("has_wood_slab", (Criterion)this.has(ItemTags.WOODEN_SLABS)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.CHEST).define(Character.valueOf('#'), ItemTags.PLANKS).pattern("###").pattern("# #").pattern("###").unlockedBy("has_lots_of_items", (Criterion)CriteriaTriggers.INVENTORY_CHANGED.createCriterion(new InventoryChangeTrigger.TriggerInstance(Optional.empty(), new InventoryChangeTrigger.TriggerInstance.Slots(MinMaxBounds.Ints.atLeast(10), MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY), List.of()))).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.COPPER_CHEST).define(Character.valueOf('#'), Items.COPPER_INGOT).define(Character.valueOf('X'), Items.CHEST).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_copper_chest", (Criterion)this.has(Items.COPPER_CHEST)).save(this.output);
        this.shapeless(RecipeCategory.TRANSPORTATION, Items.CHEST_MINECART).requires(Blocks.CHEST).requires(Items.MINECART).unlockedBy("has_minecart", (Criterion)this.has(Items.MINECART)).save(this.output);
        this.chestBoat(Items.ACACIA_CHEST_BOAT, Items.ACACIA_BOAT);
        this.chestBoat(Items.BIRCH_CHEST_BOAT, Items.BIRCH_BOAT);
        this.chestBoat(Items.DARK_OAK_CHEST_BOAT, Items.DARK_OAK_BOAT);
        this.chestBoat(Items.PALE_OAK_CHEST_BOAT, Items.PALE_OAK_BOAT);
        this.chestBoat(Items.JUNGLE_CHEST_BOAT, Items.JUNGLE_BOAT);
        this.chestBoat(Items.OAK_CHEST_BOAT, Items.OAK_BOAT);
        this.chestBoat(Items.SPRUCE_CHEST_BOAT, Items.SPRUCE_BOAT);
        this.chestBoat(Items.MANGROVE_CHEST_BOAT, Items.MANGROVE_BOAT);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)this.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_QUARTZ_BLOCK, Ingredient.of((ItemLike)Blocks.QUARTZ_SLAB)).unlockedBy("has_chiseled_quartz_block", (Criterion)this.has(Blocks.CHISELED_QUARTZ_BLOCK))).unlockedBy("has_quartz_block", (Criterion)this.has(Blocks.QUARTZ_BLOCK))).unlockedBy("has_quartz_pillar", (Criterion)this.has(Blocks.QUARTZ_PILLAR)).save(this.output);
        this.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_STONE_BRICKS, Ingredient.of((ItemLike)Blocks.STONE_BRICK_SLAB)).unlockedBy("has_tag", (Criterion)this.has(ItemTags.STONE_BRICKS)).save(this.output);
        this.twoByTwoPacker(RecipeCategory.BUILDING_BLOCKS, Blocks.CLAY, Items.CLAY_BALL);
        this.shaped(RecipeCategory.TOOLS, Items.CLOCK).define(Character.valueOf('#'), Items.GOLD_INGOT).define(Character.valueOf('X'), Items.REDSTONE).pattern(" # ").pattern("#X#").pattern(" # ").unlockedBy("has_redstone", (Criterion)this.has(Items.REDSTONE)).save(this.output);
        this.nineBlockStorageRecipes(RecipeCategory.MISC, Items.COAL, RecipeCategory.BUILDING_BLOCKS, Items.COAL_BLOCK);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.COARSE_DIRT, 4).define(Character.valueOf('D'), Blocks.DIRT).define(Character.valueOf('G'), Blocks.GRAVEL).pattern("DG").pattern("GD").unlockedBy("has_gravel", (Criterion)this.has(Blocks.GRAVEL)).save(this.output);
        this.shaped(RecipeCategory.REDSTONE, Blocks.COMPARATOR).define(Character.valueOf('#'), Blocks.REDSTONE_TORCH).define(Character.valueOf('X'), Items.QUARTZ).define(Character.valueOf('I'), Blocks.STONE).pattern(" # ").pattern("#X#").pattern("III").unlockedBy("has_quartz", (Criterion)this.has(Items.QUARTZ)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.COMPASS).define(Character.valueOf('#'), Items.IRON_INGOT).define(Character.valueOf('X'), Items.REDSTONE).pattern(" # ").pattern("#X#").pattern(" # ").unlockedBy("has_redstone", (Criterion)this.has(Items.REDSTONE)).save(this.output);
        this.shaped(RecipeCategory.FOOD, Items.COOKIE, 8).define(Character.valueOf('#'), Items.WHEAT).define(Character.valueOf('X'), Items.COCOA_BEANS).pattern("#X#").unlockedBy("has_cocoa", (Criterion)this.has(Items.COCOA_BEANS)).save(this.output);
        ((ShapedRecipeBuilder)this.shaped(RecipeCategory.DECORATIONS, Blocks.CRAFTING_TABLE).define(Character.valueOf('#'), ItemTags.PLANKS).pattern("##").pattern("##").unlockedBy("unlock_right_away", (Criterion)PlayerTrigger.TriggerInstance.tick())).showNotification(false).save(this.output);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)this.shaped(RecipeCategory.COMBAT, Items.CROSSBOW).define(Character.valueOf('~'), Items.STRING).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('&'), Items.IRON_INGOT).define(Character.valueOf('$'), Blocks.TRIPWIRE_HOOK).pattern("#&#").pattern("~$~").pattern(" # ").unlockedBy("has_string", (Criterion)this.has(Items.STRING))).unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT))).unlockedBy("has_tripwire_hook", (Criterion)this.has(Blocks.TRIPWIRE_HOOK)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.LOOM).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('@'), Items.STRING).pattern("@@").pattern("##").unlockedBy("has_string", (Criterion)this.has(Items.STRING)).save(this.output);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)this.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_RED_SANDSTONE, Ingredient.of((ItemLike)Blocks.RED_SANDSTONE_SLAB)).unlockedBy("has_red_sandstone", (Criterion)this.has(Blocks.RED_SANDSTONE))).unlockedBy("has_chiseled_red_sandstone", (Criterion)this.has(Blocks.CHISELED_RED_SANDSTONE))).unlockedBy("has_cut_red_sandstone", (Criterion)this.has(Blocks.CUT_RED_SANDSTONE)).save(this.output);
        this.chiseled(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_SANDSTONE, Blocks.SANDSTONE_SLAB);
        this.nineBlockStorageRecipesRecipesWithCustomUnpacking(RecipeCategory.MISC, Items.COPPER_INGOT, RecipeCategory.BUILDING_BLOCKS, Items.COPPER_BLOCK, VanillaRecipeProvider.getSimpleRecipeName(Items.COPPER_INGOT), VanillaRecipeProvider.getItemName(Items.COPPER_INGOT));
        this.shapeless(RecipeCategory.MISC, Items.COPPER_INGOT, 9).requires(Blocks.WAXED_COPPER_BLOCK).group(VanillaRecipeProvider.getItemName(Items.COPPER_INGOT)).unlockedBy(VanillaRecipeProvider.getHasName(Blocks.WAXED_COPPER_BLOCK), (Criterion)this.has(Blocks.WAXED_COPPER_BLOCK)).save(this.output, VanillaRecipeProvider.getConversionRecipeName(Items.COPPER_INGOT, Blocks.WAXED_COPPER_BLOCK));
        this.waxRecipes(FeatureFlagSet.of(FeatureFlags.VANILLA));
        ((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.MISC, Items.CYAN_DYE, 2).requires(Items.BLUE_DYE).requires(Items.GREEN_DYE).group("cyan_dye").unlockedBy("has_green_dye", (Criterion)this.has(Items.GREEN_DYE))).unlockedBy("has_blue_dye", (Criterion)this.has(Items.BLUE_DYE)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.DARK_PRISMARINE).define(Character.valueOf('S'), Items.PRISMARINE_SHARD).define(Character.valueOf('I'), Items.BLACK_DYE).pattern("SSS").pattern("SIS").pattern("SSS").unlockedBy("has_prismarine_shard", (Criterion)this.has(Items.PRISMARINE_SHARD)).save(this.output);
        this.shaped(RecipeCategory.REDSTONE, Blocks.DAYLIGHT_DETECTOR).define(Character.valueOf('Q'), Items.QUARTZ).define(Character.valueOf('G'), Blocks.GLASS).define(Character.valueOf('W'), ItemTags.WOODEN_SLABS).pattern("GGG").pattern("QQQ").pattern("WWW").unlockedBy("has_quartz", (Criterion)this.has(Items.QUARTZ)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICKS, 4).define(Character.valueOf('S'), Blocks.POLISHED_DEEPSLATE).pattern("SS").pattern("SS").unlockedBy("has_polished_deepslate", (Criterion)this.has(Blocks.POLISHED_DEEPSLATE)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILES, 4).define(Character.valueOf('S'), Blocks.DEEPSLATE_BRICKS).pattern("SS").pattern("SS").unlockedBy("has_deepslate_bricks", (Criterion)this.has(Blocks.DEEPSLATE_BRICKS)).save(this.output);
        this.shaped(RecipeCategory.TRANSPORTATION, Blocks.DETECTOR_RAIL, 6).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('#'), Blocks.STONE_PRESSURE_PLATE).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("X X").pattern("X#X").pattern("XRX").unlockedBy("has_rail", (Criterion)this.has(Blocks.RAIL)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.DIAMOND_AXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.DIAMOND_TOOL_MATERIALS).pattern("XX").pattern("X#").pattern(" #").unlockedBy("has_diamond", (Criterion)this.has(ItemTags.DIAMOND_TOOL_MATERIALS)).save(this.output);
        this.nineBlockStorageRecipes(RecipeCategory.MISC, Items.DIAMOND, RecipeCategory.BUILDING_BLOCKS, Items.DIAMOND_BLOCK);
        this.shaped(RecipeCategory.COMBAT, Items.DIAMOND_BOOTS).define(Character.valueOf('X'), Items.DIAMOND).pattern("X X").pattern("X X").unlockedBy("has_diamond", (Criterion)this.has(Items.DIAMOND)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.DIAMOND_CHESTPLATE).define(Character.valueOf('X'), Items.DIAMOND).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy("has_diamond", (Criterion)this.has(Items.DIAMOND)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.DIAMOND_HELMET).define(Character.valueOf('X'), Items.DIAMOND).pattern("XXX").pattern("X X").unlockedBy("has_diamond", (Criterion)this.has(Items.DIAMOND)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.DIAMOND_HOE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.DIAMOND_TOOL_MATERIALS).pattern("XX").pattern(" #").pattern(" #").unlockedBy("has_diamond", (Criterion)this.has(ItemTags.DIAMOND_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.DIAMOND_LEGGINGS).define(Character.valueOf('X'), Items.DIAMOND).pattern("XXX").pattern("X X").pattern("X X").unlockedBy("has_diamond", (Criterion)this.has(Items.DIAMOND)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.DIAMOND_PICKAXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.DIAMOND_TOOL_MATERIALS).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy("has_diamond", (Criterion)this.has(ItemTags.DIAMOND_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.DIAMOND_SHOVEL).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.DIAMOND_TOOL_MATERIALS).pattern("X").pattern("#").pattern("#").unlockedBy("has_diamond", (Criterion)this.has(ItemTags.DIAMOND_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.DIAMOND_SWORD).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.DIAMOND_TOOL_MATERIALS).pattern("X").pattern("X").pattern("#").unlockedBy("has_diamond", (Criterion)this.has(ItemTags.DIAMOND_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.DIAMOND_SPEAR).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.DIAMOND_TOOL_MATERIALS).pattern("  X").pattern(" # ").pattern("#  ").unlockedBy("has_diamond", (Criterion)this.has(ItemTags.DIAMOND_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.DIORITE, 2).define(Character.valueOf('Q'), Items.QUARTZ).define(Character.valueOf('C'), Blocks.COBBLESTONE).pattern("CQ").pattern("QC").unlockedBy("has_quartz", (Criterion)this.has(Items.QUARTZ)).save(this.output);
        this.shaped(RecipeCategory.REDSTONE, Blocks.DISPENSER).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('#'), Blocks.COBBLESTONE).define(Character.valueOf('X'), Items.BOW).pattern("###").pattern("#X#").pattern("#R#").unlockedBy("has_bow", (Criterion)this.has(Items.BOW)).save(this.output);
        this.twoByTwoPacker(RecipeCategory.BUILDING_BLOCKS, Blocks.DRIPSTONE_BLOCK, Items.POINTED_DRIPSTONE);
        this.shaped(RecipeCategory.REDSTONE, Blocks.DROPPER).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('#'), Blocks.COBBLESTONE).pattern("###").pattern("# #").pattern("#R#").unlockedBy("has_redstone", (Criterion)this.has(Items.REDSTONE)).save(this.output);
        this.nineBlockStorageRecipes(RecipeCategory.MISC, Items.EMERALD, RecipeCategory.BUILDING_BLOCKS, Items.EMERALD_BLOCK);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.ENCHANTING_TABLE).define(Character.valueOf('B'), Items.BOOK).define(Character.valueOf('#'), Blocks.OBSIDIAN).define(Character.valueOf('D'), Items.DIAMOND).pattern(" B ").pattern("D#D").pattern("###").unlockedBy("has_obsidian", (Criterion)this.has(Blocks.OBSIDIAN)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.ENDER_CHEST).define(Character.valueOf('#'), Blocks.OBSIDIAN).define(Character.valueOf('E'), Items.ENDER_EYE).pattern("###").pattern("#E#").pattern("###").unlockedBy("has_ender_eye", (Criterion)this.has(Items.ENDER_EYE)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.ENDER_EYE).requires(Items.ENDER_PEARL).requires(Items.BLAZE_POWDER).unlockedBy("has_blaze_powder", (Criterion)this.has(Items.BLAZE_POWDER)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.END_STONE_BRICKS, 4).define(Character.valueOf('#'), Blocks.END_STONE).pattern("##").pattern("##").unlockedBy("has_end_stone", (Criterion)this.has(Blocks.END_STONE)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Items.END_CRYSTAL).define(Character.valueOf('T'), Items.GHAST_TEAR).define(Character.valueOf('E'), Items.ENDER_EYE).define(Character.valueOf('G'), Blocks.GLASS).pattern("GGG").pattern("GEG").pattern("GTG").unlockedBy("has_ender_eye", (Criterion)this.has(Items.ENDER_EYE)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.END_ROD, 4).define(Character.valueOf('#'), Items.POPPED_CHORUS_FRUIT).define(Character.valueOf('/'), Items.BLAZE_ROD).pattern("/").pattern("#").unlockedBy("has_chorus_fruit_popped", (Criterion)this.has(Items.POPPED_CHORUS_FRUIT)).save(this.output);
        this.shapeless(RecipeCategory.BREWING, Items.FERMENTED_SPIDER_EYE).requires(Items.SPIDER_EYE).requires(Blocks.BROWN_MUSHROOM).requires(Items.SUGAR).unlockedBy("has_spider_eye", (Criterion)this.has(Items.SPIDER_EYE)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.FIRE_CHARGE, 3).requires(Items.GUNPOWDER).requires(Items.BLAZE_POWDER).requires(Ingredient.of(Items.COAL, Items.CHARCOAL)).unlockedBy("has_blaze_powder", (Criterion)this.has(Items.BLAZE_POWDER)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.FIREWORK_ROCKET, 3).requires(Items.GUNPOWDER).requires(Items.PAPER).unlockedBy("has_gunpowder", (Criterion)this.has(Items.GUNPOWDER)).save(this.output, "firework_rocket_simple");
        this.shaped(RecipeCategory.TOOLS, Items.FISHING_ROD).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.STRING).pattern("  #").pattern(" #X").pattern("# X").unlockedBy("has_string", (Criterion)this.has(Items.STRING)).save(this.output);
        ((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.TOOLS, Items.FLINT_AND_STEEL).requires(Items.IRON_INGOT).requires(Items.FLINT).unlockedBy("has_flint", (Criterion)this.has(Items.FLINT))).unlockedBy("has_obsidian", (Criterion)this.has(Blocks.OBSIDIAN)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.FLOWER_POT).define(Character.valueOf('#'), Items.BRICK).pattern("# #").pattern(" # ").unlockedBy("has_brick", (Criterion)this.has(Items.BRICK)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.FURNACE).define(Character.valueOf('#'), ItemTags.STONE_CRAFTING_MATERIALS).pattern("###").pattern("# #").pattern("###").unlockedBy("has_cobblestone", (Criterion)this.has(ItemTags.STONE_CRAFTING_MATERIALS)).save(this.output);
        this.shapeless(RecipeCategory.TRANSPORTATION, Items.FURNACE_MINECART).requires(Blocks.FURNACE).requires(Items.MINECART).unlockedBy("has_minecart", (Criterion)this.has(Items.MINECART)).save(this.output);
        this.shaped(RecipeCategory.BREWING, Items.GLASS_BOTTLE, 3).define(Character.valueOf('#'), Blocks.GLASS).pattern("# #").pattern(" # ").unlockedBy("has_glass", (Criterion)this.has(Blocks.GLASS)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.GLASS_PANE, 16).define(Character.valueOf('#'), Blocks.GLASS).pattern("###").pattern("###").unlockedBy("has_glass", (Criterion)this.has(Blocks.GLASS)).save(this.output);
        this.twoByTwoPacker(RecipeCategory.BUILDING_BLOCKS, Blocks.GLOWSTONE, Items.GLOWSTONE_DUST);
        ((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.DECORATIONS, Items.GLOW_ITEM_FRAME).requires(Items.ITEM_FRAME).requires(Items.GLOW_INK_SAC).unlockedBy("has_item_frame", (Criterion)this.has(Items.ITEM_FRAME))).unlockedBy("has_glow_ink_sac", (Criterion)this.has(Items.GLOW_INK_SAC)).save(this.output);
        this.shaped(RecipeCategory.FOOD, Items.GOLDEN_APPLE).define(Character.valueOf('#'), Items.GOLD_INGOT).define(Character.valueOf('X'), Items.APPLE).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_gold_ingot", (Criterion)this.has(Items.GOLD_INGOT)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.GOLDEN_AXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.GOLD_TOOL_MATERIALS).pattern("XX").pattern("X#").pattern(" #").unlockedBy("has_gold_ingot", (Criterion)this.has(ItemTags.GOLD_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.GOLDEN_BOOTS).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("X X").pattern("X X").unlockedBy("has_gold_ingot", (Criterion)this.has(Items.GOLD_INGOT)).save(this.output);
        this.shaped(RecipeCategory.BREWING, Items.GOLDEN_CARROT).define(Character.valueOf('#'), Items.GOLD_NUGGET).define(Character.valueOf('X'), Items.CARROT).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_gold_nugget", (Criterion)this.has(Items.GOLD_NUGGET)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.GOLDEN_CHESTPLATE).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy("has_gold_ingot", (Criterion)this.has(Items.GOLD_INGOT)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.GOLDEN_HELMET).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("XXX").pattern("X X").unlockedBy("has_gold_ingot", (Criterion)this.has(Items.GOLD_INGOT)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.GOLDEN_HOE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.GOLD_TOOL_MATERIALS).pattern("XX").pattern(" #").pattern(" #").unlockedBy("has_gold_ingot", (Criterion)this.has(ItemTags.GOLD_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.GOLDEN_LEGGINGS).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("XXX").pattern("X X").pattern("X X").unlockedBy("has_gold_ingot", (Criterion)this.has(Items.GOLD_INGOT)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.GOLDEN_PICKAXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.GOLD_TOOL_MATERIALS).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy("has_gold_ingot", (Criterion)this.has(ItemTags.GOLD_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.TRANSPORTATION, Blocks.POWERED_RAIL, 6).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("X X").pattern("X#X").pattern("XRX").unlockedBy("has_rail", (Criterion)this.has(Blocks.RAIL)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.GOLDEN_SHOVEL).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.GOLD_TOOL_MATERIALS).pattern("X").pattern("#").pattern("#").unlockedBy("has_gold_ingot", (Criterion)this.has(ItemTags.GOLD_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.GOLDEN_SWORD).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.GOLD_TOOL_MATERIALS).pattern("X").pattern("X").pattern("#").unlockedBy("has_gold_ingot", (Criterion)this.has(ItemTags.GOLD_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.GOLDEN_SPEAR).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.GOLD_TOOL_MATERIALS).pattern("  X").pattern(" # ").pattern("#  ").unlockedBy("has_gold_ingot", (Criterion)this.has(ItemTags.GOLD_TOOL_MATERIALS)).save(this.output);
        this.nineBlockStorageRecipesRecipesWithCustomUnpacking(RecipeCategory.MISC, Items.GOLD_INGOT, RecipeCategory.BUILDING_BLOCKS, Items.GOLD_BLOCK, "gold_ingot_from_gold_block", "gold_ingot");
        this.nineBlockStorageRecipesWithCustomPacking(RecipeCategory.MISC, Items.GOLD_NUGGET, RecipeCategory.MISC, Items.GOLD_INGOT, "gold_ingot_from_nuggets", "gold_ingot");
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.GRANITE).requires(Blocks.DIORITE).requires(Items.QUARTZ).unlockedBy("has_quartz", (Criterion)this.has(Items.QUARTZ)).save(this.output);
        ((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.MISC, Items.GRAY_DYE, 2).requires(Items.BLACK_DYE).requires(Items.WHITE_DYE).group("gray_dye").unlockedBy("has_white_dye", (Criterion)this.has(Items.WHITE_DYE))).unlockedBy("has_black_dye", (Criterion)this.has(Items.BLACK_DYE)).save(this.output);
        this.threeByThreePacker(RecipeCategory.BUILDING_BLOCKS, Blocks.HAY_BLOCK, Items.WHEAT);
        this.pressurePlate(Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE, Items.IRON_INGOT);
        this.shapeless(RecipeCategory.FOOD, Items.HONEY_BOTTLE, 4).requires(Items.HONEY_BLOCK).requires(Items.GLASS_BOTTLE, 4).unlockedBy("has_honey_block", (Criterion)this.has(Blocks.HONEY_BLOCK)).save(this.output);
        this.twoByTwoPacker(RecipeCategory.REDSTONE, Blocks.HONEY_BLOCK, Items.HONEY_BOTTLE);
        this.twoByTwoPacker(RecipeCategory.DECORATIONS, Blocks.HONEYCOMB_BLOCK, Items.HONEYCOMB);
        this.shaped(RecipeCategory.REDSTONE, Blocks.HOPPER).define(Character.valueOf('C'), Blocks.CHEST).define(Character.valueOf('I'), Items.IRON_INGOT).pattern("I I").pattern("ICI").pattern(" I ").unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT)).save(this.output);
        this.shapeless(RecipeCategory.TRANSPORTATION, Items.HOPPER_MINECART).requires(Blocks.HOPPER).requires(Items.MINECART).unlockedBy("has_minecart", (Criterion)this.has(Items.MINECART)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.IRON_AXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.IRON_TOOL_MATERIALS).pattern("XX").pattern("X#").pattern(" #").unlockedBy("has_iron_ingot", (Criterion)this.has(ItemTags.IRON_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.IRON_BARS, 16).define(Character.valueOf('#'), Items.IRON_INGOT).pattern("###").pattern("###").unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.COPPER_BARS.unaffected(), 16).define(Character.valueOf('#'), Items.COPPER_INGOT).pattern("###").pattern("###").unlockedBy("has_copper_ingot", (Criterion)this.has(Items.COPPER_INGOT)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.IRON_BOOTS).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("X X").pattern("X X").unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.IRON_CHESTPLATE).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT)).save(this.output);
        this.doorBuilder(Blocks.IRON_DOOR, Ingredient.of((ItemLike)Items.IRON_INGOT)).unlockedBy(VanillaRecipeProvider.getHasName(Items.IRON_INGOT), this.has(Items.IRON_INGOT)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.IRON_HELMET).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("XXX").pattern("X X").unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.IRON_HOE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.IRON_TOOL_MATERIALS).pattern("XX").pattern(" #").pattern(" #").unlockedBy("has_iron_ingot", (Criterion)this.has(ItemTags.IRON_TOOL_MATERIALS)).save(this.output);
        this.nineBlockStorageRecipesRecipesWithCustomUnpacking(RecipeCategory.MISC, Items.IRON_INGOT, RecipeCategory.BUILDING_BLOCKS, Items.IRON_BLOCK, "iron_ingot_from_iron_block", "iron_ingot");
        this.nineBlockStorageRecipesWithCustomPacking(RecipeCategory.MISC, Items.IRON_NUGGET, RecipeCategory.MISC, Items.IRON_INGOT, "iron_ingot_from_nuggets", "iron_ingot");
        this.shaped(RecipeCategory.COMBAT, Items.IRON_LEGGINGS).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("XXX").pattern("X X").pattern("X X").unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.IRON_PICKAXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.IRON_TOOL_MATERIALS).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy("has_iron_ingot", (Criterion)this.has(ItemTags.IRON_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.IRON_SHOVEL).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.IRON_TOOL_MATERIALS).pattern("X").pattern("#").pattern("#").unlockedBy("has_iron_ingot", (Criterion)this.has(ItemTags.IRON_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.IRON_SWORD).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.IRON_TOOL_MATERIALS).pattern("X").pattern("X").pattern("#").unlockedBy("has_iron_ingot", (Criterion)this.has(ItemTags.IRON_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.IRON_SPEAR).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.IRON_TOOL_MATERIALS).pattern("  X").pattern(" # ").pattern("#  ").unlockedBy("has_iron_ingot", (Criterion)this.has(ItemTags.IRON_TOOL_MATERIALS)).save(this.output);
        this.twoByTwoPacker(RecipeCategory.REDSTONE, Blocks.IRON_TRAPDOOR, Items.IRON_INGOT);
        this.shaped(RecipeCategory.DECORATIONS, Items.ITEM_FRAME).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.LEATHER).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_leather", (Criterion)this.has(Items.LEATHER)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.JUKEBOX).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('X'), Items.DIAMOND).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_diamond", (Criterion)this.has(Items.DIAMOND)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.LADDER, 3).define(Character.valueOf('#'), Items.STICK).pattern("# #").pattern("###").pattern("# #").unlockedBy("has_stick", (Criterion)this.has(Items.STICK)).save(this.output);
        this.nineBlockStorageRecipes(RecipeCategory.MISC, Items.LAPIS_LAZULI, RecipeCategory.BUILDING_BLOCKS, Items.LAPIS_BLOCK);
        this.shaped(RecipeCategory.TOOLS, Items.LEAD, 2).define(Character.valueOf('~'), Items.STRING).pattern("~~ ").pattern("~~ ").pattern("  ~").unlockedBy("has_string", (Criterion)this.has(Items.STRING)).save(this.output);
        this.twoByTwoPacker(RecipeCategory.MISC, Items.LEATHER, Items.RABBIT_HIDE);
        this.shaped(RecipeCategory.COMBAT, Items.LEATHER_BOOTS).define(Character.valueOf('X'), Items.LEATHER).pattern("X X").pattern("X X").unlockedBy("has_leather", (Criterion)this.has(Items.LEATHER)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.LEATHER_CHESTPLATE).define(Character.valueOf('X'), Items.LEATHER).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy("has_leather", (Criterion)this.has(Items.LEATHER)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.LEATHER_HELMET).define(Character.valueOf('X'), Items.LEATHER).pattern("XXX").pattern("X X").unlockedBy("has_leather", (Criterion)this.has(Items.LEATHER)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.LEATHER_LEGGINGS).define(Character.valueOf('X'), Items.LEATHER).pattern("XXX").pattern("X X").pattern("X X").unlockedBy("has_leather", (Criterion)this.has(Items.LEATHER)).save(this.output);
        this.shaped(RecipeCategory.MISC, Items.LEATHER_HORSE_ARMOR).define(Character.valueOf('X'), Items.LEATHER).pattern("X X").pattern("XXX").pattern("X X").unlockedBy("has_leather", (Criterion)this.has(Items.LEATHER)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.SADDLE).define(Character.valueOf('X'), Items.LEATHER).define(Character.valueOf('#'), Items.IRON_INGOT).pattern(" X ").pattern("X#X").unlockedBy("has_leather", (Criterion)this.has(Items.LEATHER)).save(this.output);
        this.nineBlockStorageRecipesWithCustomPacking(RecipeCategory.MISC, Items.COPPER_NUGGET, RecipeCategory.MISC, Items.COPPER_INGOT, "copper_ingot_from_nuggets", "copper_ingot");
        this.shaped(RecipeCategory.TOOLS, Items.COPPER_AXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.COPPER_TOOL_MATERIALS).pattern("XX").pattern("X#").pattern(" #").unlockedBy("has_copper_ingot", (Criterion)this.has(ItemTags.COPPER_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.COPPER_HOE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.COPPER_TOOL_MATERIALS).pattern("XX").pattern(" #").pattern(" #").unlockedBy("has_copper_ingot", (Criterion)this.has(ItemTags.COPPER_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.COPPER_PICKAXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.COPPER_TOOL_MATERIALS).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy("has_copper_ingot", (Criterion)this.has(ItemTags.COPPER_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.COPPER_SHOVEL).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.COPPER_TOOL_MATERIALS).pattern("X").pattern("#").pattern("#").unlockedBy("has_copper_ingot", (Criterion)this.has(ItemTags.COPPER_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.COPPER_SWORD).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.COPPER_TOOL_MATERIALS).pattern("X").pattern("X").pattern("#").unlockedBy("has_copper_ingot", (Criterion)this.has(ItemTags.COPPER_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.COPPER_SPEAR).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.COPPER_TOOL_MATERIALS).pattern("  X").pattern(" # ").pattern("#  ").unlockedBy("has_copper_ingot", (Criterion)this.has(ItemTags.COPPER_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.COPPER_BOOTS).define(Character.valueOf('X'), Items.COPPER_INGOT).pattern("X X").pattern("X X").unlockedBy("has_copper_ingot", (Criterion)this.has(Items.COPPER_INGOT)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.COPPER_CHESTPLATE).define(Character.valueOf('X'), Items.COPPER_INGOT).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy("has_copper_ingot", (Criterion)this.has(Items.COPPER_INGOT)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.COPPER_HELMET).define(Character.valueOf('X'), Items.COPPER_INGOT).pattern("XXX").pattern("X X").unlockedBy("has_copper_ingot", (Criterion)this.has(Items.COPPER_INGOT)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.COPPER_LEGGINGS).define(Character.valueOf('X'), Items.COPPER_INGOT).pattern("XXX").pattern("X X").pattern("X X").unlockedBy("has_copper_ingot", (Criterion)this.has(Items.COPPER_INGOT)).save(this.output);
        this.shaped(RecipeCategory.REDSTONE, Blocks.LECTERN).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).define(Character.valueOf('B'), Blocks.BOOKSHELF).pattern("SSS").pattern(" B ").pattern(" S ").unlockedBy("has_book", (Criterion)this.has(Items.BOOK)).save(this.output);
        this.shaped(RecipeCategory.REDSTONE, Blocks.LEVER).define(Character.valueOf('#'), Blocks.COBBLESTONE).define(Character.valueOf('X'), Items.STICK).pattern("X").pattern("#").unlockedBy("has_cobblestone", (Criterion)this.has(Blocks.COBBLESTONE)).save(this.output);
        this.oneToOneConversionRecipe(Items.LIGHT_BLUE_DYE, Blocks.BLUE_ORCHID, "light_blue_dye");
        ((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.MISC, Items.LIGHT_BLUE_DYE, 2).requires(Items.BLUE_DYE).requires(Items.WHITE_DYE).group("light_blue_dye").unlockedBy("has_blue_dye", (Criterion)this.has(Items.BLUE_DYE))).unlockedBy("has_white_dye", (Criterion)this.has(Items.WHITE_DYE)).save(this.output, "light_blue_dye_from_blue_white_dye");
        this.oneToOneConversionRecipe(Items.LIGHT_GRAY_DYE, Blocks.AZURE_BLUET, "light_gray_dye");
        ((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.MISC, Items.LIGHT_GRAY_DYE, 2).requires(Items.GRAY_DYE).requires(Items.WHITE_DYE).group("light_gray_dye").unlockedBy("has_gray_dye", (Criterion)this.has(Items.GRAY_DYE))).unlockedBy("has_white_dye", (Criterion)this.has(Items.WHITE_DYE)).save(this.output, "light_gray_dye_from_gray_white_dye");
        ((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.MISC, Items.LIGHT_GRAY_DYE, 3).requires(Items.BLACK_DYE).requires(Items.WHITE_DYE, 2).group("light_gray_dye").unlockedBy("has_white_dye", (Criterion)this.has(Items.WHITE_DYE))).unlockedBy("has_black_dye", (Criterion)this.has(Items.BLACK_DYE)).save(this.output, "light_gray_dye_from_black_white_dye");
        this.oneToOneConversionRecipe(Items.LIGHT_GRAY_DYE, Blocks.OXEYE_DAISY, "light_gray_dye");
        this.oneToOneConversionRecipe(Items.LIGHT_GRAY_DYE, Blocks.WHITE_TULIP, "light_gray_dye");
        this.pressurePlate(Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE, Items.GOLD_INGOT);
        this.shaped(RecipeCategory.REDSTONE, Blocks.LIGHTNING_ROD).define(Character.valueOf('#'), Items.COPPER_INGOT).pattern("#").pattern("#").pattern("#").unlockedBy("has_copper_ingot", (Criterion)this.has(Items.COPPER_INGOT)).save(this.output);
        ((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.MISC, Items.LIME_DYE, 2).requires(Items.GREEN_DYE).requires(Items.WHITE_DYE).unlockedBy("has_green_dye", (Criterion)this.has(Items.GREEN_DYE))).unlockedBy("has_white_dye", (Criterion)this.has(Items.WHITE_DYE)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.JACK_O_LANTERN).define(Character.valueOf('A'), Blocks.CARVED_PUMPKIN).define(Character.valueOf('B'), Blocks.TORCH).pattern("A").pattern("B").unlockedBy("has_carved_pumpkin", (Criterion)this.has(Blocks.CARVED_PUMPKIN)).save(this.output);
        this.oneToOneConversionRecipe(Items.MAGENTA_DYE, Blocks.ALLIUM, "magenta_dye");
        ((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.MISC, Items.MAGENTA_DYE, 4).requires(Items.BLUE_DYE).requires(Items.RED_DYE, 2).requires(Items.WHITE_DYE).group("magenta_dye").unlockedBy("has_blue_dye", (Criterion)this.has(Items.BLUE_DYE))).unlockedBy("has_rose_red", (Criterion)this.has(Items.RED_DYE))).unlockedBy("has_white_dye", (Criterion)this.has(Items.WHITE_DYE)).save(this.output, "magenta_dye_from_blue_red_white_dye");
        ((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.MISC, Items.MAGENTA_DYE, 3).requires(Items.BLUE_DYE).requires(Items.RED_DYE).requires(Items.PINK_DYE).group("magenta_dye").unlockedBy("has_pink_dye", (Criterion)this.has(Items.PINK_DYE))).unlockedBy("has_blue_dye", (Criterion)this.has(Items.BLUE_DYE))).unlockedBy("has_red_dye", (Criterion)this.has(Items.RED_DYE)).save(this.output, "magenta_dye_from_blue_red_pink");
        this.oneToOneConversionRecipe(Items.MAGENTA_DYE, Blocks.LILAC, "magenta_dye", 2);
        ((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.MISC, Items.MAGENTA_DYE, 2).requires(Items.PURPLE_DYE).requires(Items.PINK_DYE).group("magenta_dye").unlockedBy("has_pink_dye", (Criterion)this.has(Items.PINK_DYE))).unlockedBy("has_purple_dye", (Criterion)this.has(Items.PURPLE_DYE)).save(this.output, "magenta_dye_from_purple_and_pink");
        this.twoByTwoPacker(RecipeCategory.BUILDING_BLOCKS, Blocks.MAGMA_BLOCK, Items.MAGMA_CREAM);
        this.shapeless(RecipeCategory.BREWING, Items.MAGMA_CREAM).requires(Items.BLAZE_POWDER).requires(Items.SLIME_BALL).unlockedBy("has_blaze_powder", (Criterion)this.has(Items.BLAZE_POWDER)).save(this.output);
        this.shaped(RecipeCategory.MISC, Items.MAP).define(Character.valueOf('#'), Items.PAPER).define(Character.valueOf('X'), Items.COMPASS).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_compass", (Criterion)this.has(Items.COMPASS)).save(this.output);
        this.threeByThreePacker(RecipeCategory.BUILDING_BLOCKS, Blocks.MELON, Items.MELON_SLICE, "has_melon");
        this.shapeless(RecipeCategory.MISC, Items.MELON_SEEDS).requires(Items.MELON_SLICE).unlockedBy("has_melon", (Criterion)this.has(Items.MELON_SLICE)).save(this.output);
        this.shaped(RecipeCategory.TRANSPORTATION, Items.MINECART).define(Character.valueOf('#'), Items.IRON_INGOT).pattern("# #").pattern("###").unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT)).save(this.output);
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_COBBLESTONE).requires(Blocks.COBBLESTONE).requires(Blocks.VINE).group("mossy_cobblestone").unlockedBy("has_vine", (Criterion)this.has(Blocks.VINE)).save(this.output, VanillaRecipeProvider.getConversionRecipeName(Blocks.MOSSY_COBBLESTONE, Blocks.VINE));
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_STONE_BRICKS).requires(Blocks.STONE_BRICKS).requires(Blocks.VINE).group("mossy_stone_bricks").unlockedBy("has_vine", (Criterion)this.has(Blocks.VINE)).save(this.output, VanillaRecipeProvider.getConversionRecipeName(Blocks.MOSSY_STONE_BRICKS, Blocks.VINE));
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_COBBLESTONE).requires(Blocks.COBBLESTONE).requires(Blocks.MOSS_BLOCK).group("mossy_cobblestone").unlockedBy("has_moss_block", (Criterion)this.has(Blocks.MOSS_BLOCK)).save(this.output, VanillaRecipeProvider.getConversionRecipeName(Blocks.MOSSY_COBBLESTONE, Blocks.MOSS_BLOCK));
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_STONE_BRICKS).requires(Blocks.STONE_BRICKS).requires(Blocks.MOSS_BLOCK).group("mossy_stone_bricks").unlockedBy("has_moss_block", (Criterion)this.has(Blocks.MOSS_BLOCK)).save(this.output, VanillaRecipeProvider.getConversionRecipeName(Blocks.MOSSY_STONE_BRICKS, Blocks.MOSS_BLOCK));
        ((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.FOOD, Items.MUSHROOM_STEW).requires(Blocks.BROWN_MUSHROOM).requires(Blocks.RED_MUSHROOM).requires(Items.BOWL).unlockedBy("has_mushroom_stew", (Criterion)this.has(Items.MUSHROOM_STEW))).unlockedBy("has_bowl", (Criterion)this.has(Items.BOWL))).unlockedBy("has_brown_mushroom", (Criterion)this.has(Blocks.BROWN_MUSHROOM))).unlockedBy("has_red_mushroom", (Criterion)this.has(Blocks.RED_MUSHROOM)).save(this.output);
        BuiltInRegistries.ITEM.stream().forEach(item -> {
            SuspiciousEffectHolder suspiciousEffectHolder = SuspiciousEffectHolder.tryGet(item);
            if (suspiciousEffectHolder != null) {
                this.suspiciousStew((Item)item, suspiciousEffectHolder);
            }
        });
        this.twoByTwoPacker(RecipeCategory.BUILDING_BLOCKS, Blocks.NETHER_BRICKS, Items.NETHER_BRICK);
        this.twoByTwoPacker(RecipeCategory.BUILDING_BLOCKS, Blocks.RESIN_BRICKS, Items.RESIN_BRICK);
        this.nineBlockStorageRecipes(RecipeCategory.MISC, Items.RESIN_CLUMP, RecipeCategory.BUILDING_BLOCKS, Items.RESIN_BLOCK);
        this.shaped(RecipeCategory.MISC, Blocks.CREAKING_HEART).define(Character.valueOf('R'), Items.RESIN_BLOCK).define(Character.valueOf('L'), Blocks.PALE_OAK_LOG).pattern(" L ").pattern(" R ").pattern(" L ").unlockedBy("has_resin_block", (Criterion)this.has(Items.RESIN_BLOCK)).save(this.output);
        this.threeByThreePacker(RecipeCategory.BUILDING_BLOCKS, Blocks.NETHER_WART_BLOCK, Items.NETHER_WART);
        this.shaped(RecipeCategory.REDSTONE, Blocks.NOTE_BLOCK).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('X'), Items.REDSTONE).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_redstone", (Criterion)this.has(Items.REDSTONE)).save(this.output);
        this.shaped(RecipeCategory.REDSTONE, Blocks.OBSERVER).define(Character.valueOf('Q'), Items.QUARTZ).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('#'), Blocks.COBBLESTONE).pattern("###").pattern("RRQ").pattern("###").unlockedBy("has_quartz", (Criterion)this.has(Items.QUARTZ)).save(this.output);
        this.oneToOneConversionRecipe(Items.ORANGE_DYE, Blocks.ORANGE_TULIP, "orange_dye");
        ((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.MISC, Items.ORANGE_DYE, 2).requires(Items.RED_DYE).requires(Items.YELLOW_DYE).group("orange_dye").unlockedBy("has_red_dye", (Criterion)this.has(Items.RED_DYE))).unlockedBy("has_yellow_dye", (Criterion)this.has(Items.YELLOW_DYE)).save(this.output, "orange_dye_from_red_yellow");
        this.shaped(RecipeCategory.DECORATIONS, Items.PAINTING).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.WOOL).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_wool", (Criterion)this.has(ItemTags.WOOL)).save(this.output);
        this.shaped(RecipeCategory.MISC, Items.PAPER, 3).define(Character.valueOf('#'), Blocks.SUGAR_CANE).pattern("###").unlockedBy("has_reeds", (Criterion)this.has(Blocks.SUGAR_CANE)).save(this.output);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_PILLAR, 2).define(Character.valueOf('#'), Blocks.QUARTZ_BLOCK).pattern("#").pattern("#").unlockedBy("has_chiseled_quartz_block", (Criterion)this.has(Blocks.CHISELED_QUARTZ_BLOCK))).unlockedBy("has_quartz_block", (Criterion)this.has(Blocks.QUARTZ_BLOCK))).unlockedBy("has_quartz_pillar", (Criterion)this.has(Blocks.QUARTZ_PILLAR)).save(this.output);
        this.threeByThreePacker(RecipeCategory.BUILDING_BLOCKS, Blocks.PACKED_ICE, Blocks.ICE);
        this.oneToOneConversionRecipe(Items.PINK_DYE, Blocks.PEONY, "pink_dye", 2);
        this.oneToOneConversionRecipe(Items.PINK_DYE, Blocks.PINK_TULIP, "pink_dye");
        this.oneToOneConversionRecipe(Items.PINK_DYE, Blocks.CACTUS_FLOWER, "pink_dye");
        ((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.MISC, Items.PINK_DYE, 2).requires(Items.RED_DYE).requires(Items.WHITE_DYE).group("pink_dye").unlockedBy("has_white_dye", (Criterion)this.has(Items.WHITE_DYE))).unlockedBy("has_red_dye", (Criterion)this.has(Items.RED_DYE)).save(this.output, "pink_dye_from_red_white_dye");
        this.shaped(RecipeCategory.REDSTONE, Blocks.PISTON).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('#'), Blocks.COBBLESTONE).define(Character.valueOf('T'), ItemTags.PLANKS).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("TTT").pattern("#X#").pattern("#R#").unlockedBy("has_redstone", (Criterion)this.has(Items.REDSTONE)).save(this.output);
        this.polished(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BASALT, Blocks.BASALT);
        this.twoByTwoPacker(RecipeCategory.BUILDING_BLOCKS, Blocks.PRISMARINE, Items.PRISMARINE_SHARD);
        this.threeByThreePacker(RecipeCategory.BUILDING_BLOCKS, Blocks.PRISMARINE_BRICKS, Items.PRISMARINE_SHARD);
        ((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.FOOD, Items.PUMPKIN_PIE).requires(Blocks.PUMPKIN).requires(Items.SUGAR).requires(ItemTags.EGGS).unlockedBy("has_carved_pumpkin", (Criterion)this.has(Blocks.CARVED_PUMPKIN))).unlockedBy("has_pumpkin", (Criterion)this.has(Blocks.PUMPKIN)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.PUMPKIN_SEEDS, 4).requires(Blocks.PUMPKIN).unlockedBy("has_pumpkin", (Criterion)this.has(Blocks.PUMPKIN)).save(this.output);
        ((ShapelessRecipeBuilder)this.shapeless(RecipeCategory.MISC, Items.PURPLE_DYE, 2).requires(Items.BLUE_DYE).requires(Items.RED_DYE).unlockedBy("has_blue_dye", (Criterion)this.has(Items.BLUE_DYE))).unlockedBy("has_red_dye", (Criterion)this.has(Items.RED_DYE)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.SHULKER_BOX).define(Character.valueOf('#'), Blocks.CHEST).define(Character.valueOf('-'), Items.SHULKER_SHELL).pattern("-").pattern("#").pattern("-").unlockedBy("has_shulker_shell", (Criterion)this.has(Items.SHULKER_SHELL)).save(this.output);
        this.shulkerBoxRecipes();
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.PURPUR_BLOCK, 4).define(Character.valueOf('F'), Items.POPPED_CHORUS_FRUIT).pattern("FF").pattern("FF").unlockedBy("has_chorus_fruit_popped", (Criterion)this.has(Items.POPPED_CHORUS_FRUIT)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.PURPUR_PILLAR).define(Character.valueOf('#'), Blocks.PURPUR_SLAB).pattern("#").pattern("#").unlockedBy("has_purpur_block", (Criterion)this.has(Blocks.PURPUR_BLOCK)).save(this.output);
        this.slabBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.PURPUR_SLAB, Ingredient.of(Blocks.PURPUR_BLOCK, Blocks.PURPUR_PILLAR)).unlockedBy("has_purpur_block", this.has(Blocks.PURPUR_BLOCK)).save(this.output);
        this.stairBuilder(Blocks.PURPUR_STAIRS, Ingredient.of(Blocks.PURPUR_BLOCK, Blocks.PURPUR_PILLAR)).unlockedBy("has_purpur_block", this.has(Blocks.PURPUR_BLOCK)).save(this.output);
        this.twoByTwoPacker(RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_BLOCK, Items.QUARTZ);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_BRICKS, 4).define(Character.valueOf('#'), Blocks.QUARTZ_BLOCK).pattern("##").pattern("##").unlockedBy("has_quartz_block", (Criterion)this.has(Blocks.QUARTZ_BLOCK)).save(this.output);
        this.slabBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_SLAB, Ingredient.of(Blocks.CHISELED_QUARTZ_BLOCK, Blocks.QUARTZ_BLOCK, Blocks.QUARTZ_PILLAR)).unlockedBy("has_chiseled_quartz_block", this.has(Blocks.CHISELED_QUARTZ_BLOCK)).unlockedBy("has_quartz_block", this.has(Blocks.QUARTZ_BLOCK)).unlockedBy("has_quartz_pillar", this.has(Blocks.QUARTZ_PILLAR)).save(this.output);
        this.stairBuilder(Blocks.QUARTZ_STAIRS, Ingredient.of(Blocks.CHISELED_QUARTZ_BLOCK, Blocks.QUARTZ_BLOCK, Blocks.QUARTZ_PILLAR)).unlockedBy("has_chiseled_quartz_block", this.has(Blocks.CHISELED_QUARTZ_BLOCK)).unlockedBy("has_quartz_block", this.has(Blocks.QUARTZ_BLOCK)).unlockedBy("has_quartz_pillar", this.has(Blocks.QUARTZ_PILLAR)).save(this.output);
        this.shapeless(RecipeCategory.FOOD, Items.RABBIT_STEW).requires(Items.BAKED_POTATO).requires(Items.COOKED_RABBIT).requires(Items.BOWL).requires(Items.CARROT).requires(Blocks.BROWN_MUSHROOM).group("rabbit_stew").unlockedBy("has_cooked_rabbit", (Criterion)this.has(Items.COOKED_RABBIT)).save(this.output, VanillaRecipeProvider.getConversionRecipeName(Items.RABBIT_STEW, Items.BROWN_MUSHROOM));
        this.shapeless(RecipeCategory.FOOD, Items.RABBIT_STEW).requires(Items.BAKED_POTATO).requires(Items.COOKED_RABBIT).requires(Items.BOWL).requires(Items.CARROT).requires(Blocks.RED_MUSHROOM).group("rabbit_stew").unlockedBy("has_cooked_rabbit", (Criterion)this.has(Items.COOKED_RABBIT)).save(this.output, VanillaRecipeProvider.getConversionRecipeName(Items.RABBIT_STEW, Items.RED_MUSHROOM));
        this.shaped(RecipeCategory.TRANSPORTATION, Blocks.RAIL, 16).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("X X").pattern("X#X").pattern("X X").unlockedBy("has_minecart", (Criterion)this.has(Items.MINECART)).save(this.output);
        this.nineBlockStorageRecipes(RecipeCategory.REDSTONE, Items.REDSTONE, RecipeCategory.REDSTONE, Items.REDSTONE_BLOCK);
        this.shaped(RecipeCategory.REDSTONE, Blocks.REDSTONE_LAMP).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('G'), Blocks.GLOWSTONE).pattern(" R ").pattern("RGR").pattern(" R ").unlockedBy("has_glowstone", (Criterion)this.has(Blocks.GLOWSTONE)).save(this.output);
        this.shaped(RecipeCategory.REDSTONE, Blocks.REDSTONE_TORCH).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.REDSTONE).pattern("X").pattern("#").unlockedBy("has_redstone", (Criterion)this.has(Items.REDSTONE)).save(this.output);
        this.oneToOneConversionRecipe(Items.RED_DYE, Items.BEETROOT, "red_dye");
        this.oneToOneConversionRecipe(Items.RED_DYE, Blocks.POPPY, "red_dye");
        this.oneToOneConversionRecipe(Items.RED_DYE, Blocks.ROSE_BUSH, "red_dye", 2);
        this.oneToOneConversionRecipe(Items.ORANGE_DYE, Blocks.OPEN_EYEBLOSSOM, "orange_dye");
        this.oneToOneConversionRecipe(Items.GRAY_DYE, Blocks.CLOSED_EYEBLOSSOM, "gray_dye");
        this.shapeless(RecipeCategory.MISC, Items.RED_DYE).requires(Blocks.RED_TULIP).group("red_dye").unlockedBy("has_red_flower", (Criterion)this.has(Blocks.RED_TULIP)).save(this.output, "red_dye_from_tulip");
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.RED_NETHER_BRICKS).define(Character.valueOf('W'), Items.NETHER_WART).define(Character.valueOf('N'), Items.NETHER_BRICK).pattern("NW").pattern("WN").unlockedBy("has_nether_wart", (Criterion)this.has(Items.NETHER_WART)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.RED_SANDSTONE).define(Character.valueOf('#'), Blocks.RED_SAND).pattern("##").pattern("##").unlockedBy("has_sand", (Criterion)this.has(Blocks.RED_SAND)).save(this.output);
        this.slabBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.RED_SANDSTONE_SLAB, Ingredient.of(Blocks.RED_SANDSTONE, Blocks.CHISELED_RED_SANDSTONE)).unlockedBy("has_red_sandstone", this.has(Blocks.RED_SANDSTONE)).unlockedBy("has_chiseled_red_sandstone", this.has(Blocks.CHISELED_RED_SANDSTONE)).save(this.output);
        this.stairBuilder(Blocks.RED_SANDSTONE_STAIRS, Ingredient.of(Blocks.RED_SANDSTONE, Blocks.CHISELED_RED_SANDSTONE, Blocks.CUT_RED_SANDSTONE)).unlockedBy("has_red_sandstone", this.has(Blocks.RED_SANDSTONE)).unlockedBy("has_chiseled_red_sandstone", this.has(Blocks.CHISELED_RED_SANDSTONE)).unlockedBy("has_cut_red_sandstone", this.has(Blocks.CUT_RED_SANDSTONE)).save(this.output);
        this.shaped(RecipeCategory.REDSTONE, Blocks.REPEATER).define(Character.valueOf('#'), Blocks.REDSTONE_TORCH).define(Character.valueOf('X'), Items.REDSTONE).define(Character.valueOf('I'), Blocks.STONE).pattern("#X#").pattern("III").unlockedBy("has_redstone_torch", (Criterion)this.has(Blocks.REDSTONE_TORCH)).save(this.output);
        this.twoByTwoPacker(RecipeCategory.BUILDING_BLOCKS, Blocks.SANDSTONE, Blocks.SAND);
        this.slabBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.SANDSTONE_SLAB, Ingredient.of(Blocks.SANDSTONE, Blocks.CHISELED_SANDSTONE)).unlockedBy("has_sandstone", this.has(Blocks.SANDSTONE)).unlockedBy("has_chiseled_sandstone", this.has(Blocks.CHISELED_SANDSTONE)).save(this.output);
        this.stairBuilder(Blocks.SANDSTONE_STAIRS, Ingredient.of(Blocks.SANDSTONE, Blocks.CHISELED_SANDSTONE, Blocks.CUT_SANDSTONE)).unlockedBy("has_sandstone", this.has(Blocks.SANDSTONE)).unlockedBy("has_chiseled_sandstone", this.has(Blocks.CHISELED_SANDSTONE)).unlockedBy("has_cut_sandstone", this.has(Blocks.CUT_SANDSTONE)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.SEA_LANTERN).define(Character.valueOf('S'), Items.PRISMARINE_SHARD).define(Character.valueOf('C'), Items.PRISMARINE_CRYSTALS).pattern("SCS").pattern("CCC").pattern("SCS").unlockedBy("has_prismarine_crystals", (Criterion)this.has(Items.PRISMARINE_CRYSTALS)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.SHEARS).define(Character.valueOf('#'), Items.IRON_INGOT).pattern(" #").pattern("# ").unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.SHIELD).define(Character.valueOf('W'), ItemTags.WOODEN_TOOL_MATERIALS).define(Character.valueOf('o'), Items.IRON_INGOT).pattern("WoW").pattern("WWW").pattern(" W ").unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT)).save(this.output);
        this.nineBlockStorageRecipes(RecipeCategory.MISC, Items.SLIME_BALL, RecipeCategory.REDSTONE, Items.SLIME_BLOCK);
        this.cut(RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_RED_SANDSTONE, Blocks.RED_SANDSTONE);
        this.cut(RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_SANDSTONE, Blocks.SANDSTONE);
        this.twoByTwoPacker(RecipeCategory.BUILDING_BLOCKS, Blocks.SNOW_BLOCK, Items.SNOWBALL);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.SNOW, 6).define(Character.valueOf('#'), Blocks.SNOW_BLOCK).pattern("###").unlockedBy("has_snowball", (Criterion)this.has(Items.SNOWBALL)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.SOUL_CAMPFIRE).define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('S'), Items.STICK).define(Character.valueOf('#'), ItemTags.SOUL_FIRE_BASE_BLOCKS).pattern(" S ").pattern("S#S").pattern("LLL").unlockedBy("has_soul_sand", (Criterion)this.has(ItemTags.SOUL_FIRE_BASE_BLOCKS)).save(this.output);
        this.shaped(RecipeCategory.BREWING, Items.GLISTERING_MELON_SLICE).define(Character.valueOf('#'), Items.GOLD_NUGGET).define(Character.valueOf('X'), Items.MELON_SLICE).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_melon", (Criterion)this.has(Items.MELON_SLICE)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.SPECTRAL_ARROW, 2).define(Character.valueOf('#'), Items.GLOWSTONE_DUST).define(Character.valueOf('X'), Items.ARROW).pattern(" # ").pattern("#X#").pattern(" # ").unlockedBy("has_glowstone_dust", (Criterion)this.has(Items.GLOWSTONE_DUST)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.SPYGLASS).define(Character.valueOf('#'), Items.AMETHYST_SHARD).define(Character.valueOf('X'), Items.COPPER_INGOT).pattern(" # ").pattern(" X ").pattern(" X ").unlockedBy("has_amethyst_shard", (Criterion)this.has(Items.AMETHYST_SHARD)).save(this.output);
        this.shaped(RecipeCategory.MISC, Items.STICK, 4).define(Character.valueOf('#'), ItemTags.PLANKS).pattern("#").pattern("#").group("sticks").unlockedBy("has_planks", (Criterion)this.has(ItemTags.PLANKS)).save(this.output);
        this.shaped(RecipeCategory.MISC, Items.STICK, 1).define(Character.valueOf('#'), Blocks.BAMBOO).pattern("#").pattern("#").group("sticks").unlockedBy("has_bamboo", (Criterion)this.has(Blocks.BAMBOO)).save(this.output, "stick_from_bamboo_item");
        this.shaped(RecipeCategory.REDSTONE, Blocks.STICKY_PISTON).define(Character.valueOf('P'), Blocks.PISTON).define(Character.valueOf('S'), Items.SLIME_BALL).pattern("S").pattern("P").unlockedBy("has_slime_ball", (Criterion)this.has(Items.SLIME_BALL)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_BRICKS, 4).define(Character.valueOf('#'), Blocks.STONE).pattern("##").pattern("##").unlockedBy("has_stone", (Criterion)this.has(Blocks.STONE)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.STONE_AXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).pattern("XX").pattern("X#").pattern(" #").unlockedBy("has_cobblestone", (Criterion)this.has(ItemTags.STONE_TOOL_MATERIALS)).save(this.output);
        this.slabBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_BRICK_SLAB, Ingredient.of((ItemLike)Blocks.STONE_BRICKS)).unlockedBy("has_stone_bricks", this.has(ItemTags.STONE_BRICKS)).save(this.output);
        this.stairBuilder(Blocks.STONE_BRICK_STAIRS, Ingredient.of((ItemLike)Blocks.STONE_BRICKS)).unlockedBy("has_stone_bricks", this.has(ItemTags.STONE_BRICKS)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.STONE_HOE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).pattern("XX").pattern(" #").pattern(" #").unlockedBy("has_cobblestone", (Criterion)this.has(ItemTags.STONE_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.STONE_PICKAXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy("has_cobblestone", (Criterion)this.has(ItemTags.STONE_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.STONE_SHOVEL).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).pattern("X").pattern("#").pattern("#").unlockedBy("has_cobblestone", (Criterion)this.has(ItemTags.STONE_TOOL_MATERIALS)).save(this.output);
        this.slab(RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_STONE_SLAB, Blocks.SMOOTH_STONE);
        this.shaped(RecipeCategory.COMBAT, Items.STONE_SWORD).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).pattern("X").pattern("X").pattern("#").unlockedBy("has_cobblestone", (Criterion)this.has(ItemTags.STONE_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.STONE_SPEAR).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).pattern("  X").pattern(" # ").pattern("#  ").unlockedBy("has_cobblestone", (Criterion)this.has(ItemTags.STONE_TOOL_MATERIALS)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.WHITE_WOOL).define(Character.valueOf('#'), Items.STRING).pattern("##").pattern("##").unlockedBy("has_string", (Criterion)this.has(Items.STRING)).save(this.output, VanillaRecipeProvider.getConversionRecipeName(Blocks.WHITE_WOOL, Items.STRING));
        this.oneToOneConversionRecipe(Items.SUGAR, Blocks.SUGAR_CANE, "sugar");
        this.shapeless(RecipeCategory.MISC, Items.SUGAR, 3).requires(Items.HONEY_BOTTLE).group("sugar").unlockedBy("has_honey_bottle", (Criterion)this.has(Items.HONEY_BOTTLE)).save(this.output, VanillaRecipeProvider.getConversionRecipeName(Items.SUGAR, Items.HONEY_BOTTLE));
        ((ShapedRecipeBuilder)this.shaped(RecipeCategory.REDSTONE, Blocks.TARGET).define(Character.valueOf('H'), Items.HAY_BLOCK).define(Character.valueOf('R'), Items.REDSTONE).pattern(" R ").pattern("RHR").pattern(" R ").unlockedBy("has_redstone", (Criterion)this.has(Items.REDSTONE))).unlockedBy("has_hay_block", (Criterion)this.has(Blocks.HAY_BLOCK)).save(this.output);
        this.shaped(RecipeCategory.REDSTONE, Blocks.TNT).define(Character.valueOf('#'), Ingredient.of(Blocks.SAND, Blocks.RED_SAND)).define(Character.valueOf('X'), Items.GUNPOWDER).pattern("X#X").pattern("#X#").pattern("X#X").unlockedBy("has_gunpowder", (Criterion)this.has(Items.GUNPOWDER)).save(this.output);
        this.shapeless(RecipeCategory.TRANSPORTATION, Items.TNT_MINECART).requires(Blocks.TNT).requires(Items.MINECART).unlockedBy("has_minecart", (Criterion)this.has(Items.MINECART)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.TORCH, 4).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Ingredient.of(Items.COAL, Items.CHARCOAL)).pattern("X").pattern("#").unlockedBy("has_stone_pickaxe", (Criterion)this.has(Items.STONE_PICKAXE)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.SOUL_TORCH, 4).define(Character.valueOf('X'), Ingredient.of(Items.COAL, Items.CHARCOAL)).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('S'), ItemTags.SOUL_FIRE_BASE_BLOCKS).pattern("X").pattern("#").pattern("S").unlockedBy("has_soul_sand", (Criterion)this.has(ItemTags.SOUL_FIRE_BASE_BLOCKS)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.COPPER_TORCH, 4).define(Character.valueOf('X'), Ingredient.of(Items.COAL, Items.CHARCOAL)).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('C'), Items.COPPER_NUGGET).pattern("C").pattern("X").pattern("#").unlockedBy("has_copper_nugget", (Criterion)this.has(Items.COPPER_NUGGET)).save(this.output);
        ((ShapedRecipeBuilder)this.shaped(RecipeCategory.DECORATIONS, Blocks.LANTERN).define(Character.valueOf('#'), Items.TORCH).define(Character.valueOf('X'), Items.IRON_NUGGET).pattern("XXX").pattern("X#X").pattern("XXX").unlockedBy("has_iron_nugget", (Criterion)this.has(Items.IRON_NUGGET))).unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.SOUL_LANTERN).define(Character.valueOf('#'), Items.SOUL_TORCH).define(Character.valueOf('X'), Items.IRON_NUGGET).pattern("XXX").pattern("X#X").pattern("XXX").unlockedBy("has_soul_torch", (Criterion)this.has(Items.SOUL_TORCH)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.COPPER_LANTERN.unaffected()).define(Character.valueOf('#'), Items.COPPER_TORCH).define(Character.valueOf('X'), Items.COPPER_NUGGET).pattern("XXX").pattern("X#X").pattern("XXX").unlockedBy("has_copper_torch", (Criterion)this.has(Items.COPPER_TORCH)).save(this.output);
        this.shapeless(RecipeCategory.REDSTONE, Blocks.TRAPPED_CHEST).requires(Blocks.CHEST).requires(Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", (Criterion)this.has(Blocks.TRIPWIRE_HOOK)).save(this.output);
        this.shaped(RecipeCategory.REDSTONE, Blocks.TRIPWIRE_HOOK, 2).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('S'), Items.STICK).define(Character.valueOf('I'), Items.IRON_INGOT).pattern("I").pattern("S").pattern("#").unlockedBy("has_string", (Criterion)this.has(Items.STRING)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.TURTLE_HELMET).define(Character.valueOf('X'), Items.TURTLE_SCUTE).pattern("XXX").pattern("X X").unlockedBy("has_turtle_scute", (Criterion)this.has(Items.TURTLE_SCUTE)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.WOLF_ARMOR).define(Character.valueOf('X'), Items.ARMADILLO_SCUTE).pattern("X  ").pattern("XXX").pattern("X X").unlockedBy("has_armadillo_scute", (Criterion)this.has(Items.ARMADILLO_SCUTE)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.WHEAT, 9).requires(Blocks.HAY_BLOCK).unlockedBy("has_hay_block", (Criterion)this.has(Blocks.HAY_BLOCK)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.WHITE_DYE).requires(Items.BONE_MEAL).group("white_dye").unlockedBy("has_bone_meal", (Criterion)this.has(Items.BONE_MEAL)).save(this.output);
        this.oneToOneConversionRecipe(Items.WHITE_DYE, Blocks.LILY_OF_THE_VALLEY, "white_dye");
        this.shaped(RecipeCategory.TOOLS, Items.WOODEN_AXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.WOODEN_TOOL_MATERIALS).pattern("XX").pattern("X#").pattern(" #").unlockedBy("has_stick", (Criterion)this.has(Items.STICK)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.WOODEN_HOE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.WOODEN_TOOL_MATERIALS).pattern("XX").pattern(" #").pattern(" #").unlockedBy("has_stick", (Criterion)this.has(Items.STICK)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.WOODEN_PICKAXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.WOODEN_TOOL_MATERIALS).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy("has_stick", (Criterion)this.has(Items.STICK)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, Items.WOODEN_SHOVEL).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.WOODEN_TOOL_MATERIALS).pattern("X").pattern("#").pattern("#").unlockedBy("has_stick", (Criterion)this.has(Items.STICK)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.WOODEN_SWORD).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.WOODEN_TOOL_MATERIALS).pattern("X").pattern("X").pattern("#").unlockedBy("has_stick", (Criterion)this.has(Items.STICK)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, Items.WOODEN_SPEAR).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.WOODEN_TOOL_MATERIALS).pattern("  X").pattern(" # ").pattern("#  ").unlockedBy("has_stick", (Criterion)this.has(Items.STICK)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.WRITABLE_BOOK).requires(Items.BOOK).requires(Items.INK_SAC).requires(Items.FEATHER).unlockedBy("has_book", (Criterion)this.has(Items.BOOK)).save(this.output);
        this.oneToOneConversionRecipe(Items.YELLOW_DYE, Blocks.DANDELION, "yellow_dye");
        this.oneToOneConversionRecipe(Items.YELLOW_DYE, Blocks.SUNFLOWER, "yellow_dye", 2);
        this.oneToOneConversionRecipe(Items.YELLOW_DYE, Blocks.WILDFLOWERS, "yellow_dye");
        this.nineBlockStorageRecipes(RecipeCategory.FOOD, Items.DRIED_KELP, RecipeCategory.BUILDING_BLOCKS, Items.DRIED_KELP_BLOCK);
        ((ShapedRecipeBuilder)this.shaped(RecipeCategory.MISC, Blocks.CONDUIT).define(Character.valueOf('#'), Items.NAUTILUS_SHELL).define(Character.valueOf('X'), Items.HEART_OF_THE_SEA).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_nautilus_core", (Criterion)this.has(Items.HEART_OF_THE_SEA))).unlockedBy("has_nautilus_shell", (Criterion)this.has(Items.NAUTILUS_SHELL)).save(this.output);
        this.wall(RecipeCategory.DECORATIONS, Blocks.RED_SANDSTONE_WALL, Blocks.RED_SANDSTONE);
        this.wall(RecipeCategory.DECORATIONS, Blocks.STONE_BRICK_WALL, Blocks.STONE_BRICKS);
        this.wall(RecipeCategory.DECORATIONS, Blocks.SANDSTONE_WALL, Blocks.SANDSTONE);
        this.shapeless(RecipeCategory.MISC, Items.FIELD_MASONED_BANNER_PATTERN).requires(Items.PAPER).requires(Blocks.BRICKS).unlockedBy("has_bricks", (Criterion)this.has(Blocks.BRICKS)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.BORDURE_INDENTED_BANNER_PATTERN).requires(Items.PAPER).requires(Blocks.VINE).unlockedBy("has_vines", (Criterion)this.has(Blocks.VINE)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.CREEPER_BANNER_PATTERN).requires(Items.PAPER).requires(Items.CREEPER_HEAD).unlockedBy("has_creeper_head", (Criterion)this.has(Items.CREEPER_HEAD)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.SKULL_BANNER_PATTERN).requires(Items.PAPER).requires(Items.WITHER_SKELETON_SKULL).unlockedBy("has_wither_skeleton_skull", (Criterion)this.has(Items.WITHER_SKELETON_SKULL)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.FLOWER_BANNER_PATTERN).requires(Items.PAPER).requires(Blocks.OXEYE_DAISY).unlockedBy("has_oxeye_daisy", (Criterion)this.has(Blocks.OXEYE_DAISY)).save(this.output);
        this.shapeless(RecipeCategory.MISC, Items.MOJANG_BANNER_PATTERN).requires(Items.PAPER).requires(Items.ENCHANTED_GOLDEN_APPLE).unlockedBy("has_enchanted_golden_apple", (Criterion)this.has(Items.ENCHANTED_GOLDEN_APPLE)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.SCAFFOLDING, 6).define(Character.valueOf('~'), Items.STRING).define(Character.valueOf('I'), Blocks.BAMBOO).pattern("I~I").pattern("I I").pattern("I I").unlockedBy("has_bamboo", (Criterion)this.has(Blocks.BAMBOO)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.GRINDSTONE).define(Character.valueOf('I'), Items.STICK).define(Character.valueOf('-'), Blocks.STONE_SLAB).define(Character.valueOf('#'), ItemTags.PLANKS).pattern("I-I").pattern("# #").unlockedBy("has_stone_slab", (Criterion)this.has(Blocks.STONE_SLAB)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.BLAST_FURNACE).define(Character.valueOf('#'), Blocks.SMOOTH_STONE).define(Character.valueOf('X'), Blocks.FURNACE).define(Character.valueOf('I'), Items.IRON_INGOT).pattern("III").pattern("IXI").pattern("###").unlockedBy("has_smooth_stone", (Criterion)this.has(Blocks.SMOOTH_STONE)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.SMOKER).define(Character.valueOf('#'), ItemTags.LOGS).define(Character.valueOf('X'), Blocks.FURNACE).pattern(" # ").pattern("#X#").pattern(" # ").unlockedBy("has_furnace", (Criterion)this.has(Blocks.FURNACE)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.CARTOGRAPHY_TABLE).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('@'), Items.PAPER).pattern("@@").pattern("##").pattern("##").unlockedBy("has_paper", (Criterion)this.has(Items.PAPER)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.SMITHING_TABLE).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('@'), Items.IRON_INGOT).pattern("@@").pattern("##").pattern("##").unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.FLETCHING_TABLE).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('@'), Items.FLINT).pattern("@@").pattern("##").pattern("##").unlockedBy("has_flint", (Criterion)this.has(Items.FLINT)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.STONECUTTER).define(Character.valueOf('I'), Items.IRON_INGOT).define(Character.valueOf('#'), Blocks.STONE).pattern(" I ").pattern("###").unlockedBy("has_stone", (Criterion)this.has(Blocks.STONE)).save(this.output);
        ((ShapedRecipeBuilder)this.shaped(RecipeCategory.DECORATIONS, Blocks.LODESTONE).define(Character.valueOf('S'), Items.CHISELED_STONE_BRICKS).define(Character.valueOf('#'), Items.IRON_INGOT).pattern("SSS").pattern("S#S").pattern("SSS").unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT))).unlockedBy("has_lodestone", (Criterion)this.has(Items.LODESTONE)).save(this.output);
        this.nineBlockStorageRecipesRecipesWithCustomUnpacking(RecipeCategory.MISC, Items.NETHERITE_INGOT, RecipeCategory.BUILDING_BLOCKS, Items.NETHERITE_BLOCK, "netherite_ingot_from_netherite_block", "netherite_ingot");
        this.shapeless(RecipeCategory.MISC, Items.NETHERITE_INGOT).requires(Items.NETHERITE_SCRAP, 4).requires(Items.GOLD_INGOT, 4).group("netherite_ingot").unlockedBy("has_netherite_scrap", (Criterion)this.has(Items.NETHERITE_SCRAP)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Blocks.RESPAWN_ANCHOR).define(Character.valueOf('O'), Blocks.CRYING_OBSIDIAN).define(Character.valueOf('G'), Blocks.GLOWSTONE).pattern("OOO").pattern("GGG").pattern("OOO").unlockedBy("has_obsidian", (Criterion)this.has(Blocks.CRYING_OBSIDIAN)).save(this.output);
        ((ShapedRecipeBuilder)this.shaped(RecipeCategory.DECORATIONS, Blocks.IRON_CHAIN).define(Character.valueOf('I'), Items.IRON_INGOT).define(Character.valueOf('N'), Items.IRON_NUGGET).pattern("N").pattern("I").pattern("N").unlockedBy("has_iron_nugget", (Criterion)this.has(Items.IRON_NUGGET))).unlockedBy("has_iron_ingot", (Criterion)this.has(Items.IRON_INGOT)).save(this.output);
        ((ShapedRecipeBuilder)this.shaped(RecipeCategory.DECORATIONS, Blocks.COPPER_CHAIN.unaffected()).define(Character.valueOf('I'), Items.COPPER_INGOT).define(Character.valueOf('N'), Items.COPPER_NUGGET).pattern("N").pattern("I").pattern("N").unlockedBy("has_copper_nugget", (Criterion)this.has(Items.COPPER_NUGGET))).unlockedBy("has_copper_ingot", (Criterion)this.has(Items.COPPER_INGOT)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.TINTED_GLASS, 2).define(Character.valueOf('G'), Blocks.GLASS).define(Character.valueOf('S'), Items.AMETHYST_SHARD).pattern(" S ").pattern("SGS").pattern(" S ").unlockedBy("has_amethyst_shard", (Criterion)this.has(Items.AMETHYST_SHARD)).save(this.output);
        this.twoByTwoPacker(RecipeCategory.BUILDING_BLOCKS, Blocks.AMETHYST_BLOCK, Items.AMETHYST_SHARD);
        this.shaped(RecipeCategory.TOOLS, Items.RECOVERY_COMPASS).define(Character.valueOf('C'), Items.COMPASS).define(Character.valueOf('S'), Items.ECHO_SHARD).pattern("SSS").pattern("SCS").pattern("SSS").unlockedBy("has_echo_shard", (Criterion)this.has(Items.ECHO_SHARD)).save(this.output);
        this.shaped(RecipeCategory.REDSTONE, Items.CALIBRATED_SCULK_SENSOR).define(Character.valueOf('#'), Items.AMETHYST_SHARD).define(Character.valueOf('X'), Items.SCULK_SENSOR).pattern(" # ").pattern("#X#").unlockedBy("has_amethyst_shard", (Criterion)this.has(Items.AMETHYST_SHARD)).save(this.output);
        this.threeByThreePacker(RecipeCategory.MISC, Items.MUSIC_DISC_5, Items.DISC_FRAGMENT_5);
        SpecialRecipeBuilder.special(ArmorDyeRecipe::new).save(this.output, "armor_dye");
        SpecialRecipeBuilder.special(BannerDuplicateRecipe::new).save(this.output, "banner_duplicate");
        SpecialRecipeBuilder.special(BookCloningRecipe::new).save(this.output, "book_cloning");
        SpecialRecipeBuilder.special(FireworkRocketRecipe::new).save(this.output, "firework_rocket");
        SpecialRecipeBuilder.special(FireworkStarRecipe::new).save(this.output, "firework_star");
        SpecialRecipeBuilder.special(FireworkStarFadeRecipe::new).save(this.output, "firework_star_fade");
        SpecialRecipeBuilder.special(MapCloningRecipe::new).save(this.output, "map_cloning");
        SpecialRecipeBuilder.special(MapExtendingRecipe::new).save(this.output, "map_extending");
        SpecialRecipeBuilder.special(RepairItemRecipe::new).save(this.output, "repair_item");
        SpecialRecipeBuilder.special(ShieldDecorationRecipe::new).save(this.output, "shield_decoration");
        SpecialRecipeBuilder.special(TippedArrowRecipe::new).save(this.output, "tipped_arrow");
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Items.POTATO), RecipeCategory.FOOD, Items.BAKED_POTATO, 0.35f, 200).unlockedBy("has_potato", (Criterion)this.has(Items.POTATO)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Items.CLAY_BALL), RecipeCategory.MISC, Items.BRICK, 0.3f, 200).unlockedBy("has_clay_ball", (Criterion)this.has(Items.CLAY_BALL)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(this.tag(ItemTags.LOGS_THAT_BURN), RecipeCategory.MISC, Items.CHARCOAL, 0.15f, 200).unlockedBy("has_log", (Criterion)this.has(ItemTags.LOGS_THAT_BURN)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Items.CHORUS_FRUIT), RecipeCategory.MISC, Items.POPPED_CHORUS_FRUIT, 0.1f, 200).unlockedBy("has_chorus_fruit", (Criterion)this.has(Items.CHORUS_FRUIT)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Items.BEEF), RecipeCategory.FOOD, Items.COOKED_BEEF, 0.35f, 200).unlockedBy("has_beef", (Criterion)this.has(Items.BEEF)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Items.CHICKEN), RecipeCategory.FOOD, Items.COOKED_CHICKEN, 0.35f, 200).unlockedBy("has_chicken", (Criterion)this.has(Items.CHICKEN)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Items.COD), RecipeCategory.FOOD, Items.COOKED_COD, 0.35f, 200).unlockedBy("has_cod", (Criterion)this.has(Items.COD)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.KELP), RecipeCategory.FOOD, Items.DRIED_KELP, 0.1f, 200).unlockedBy("has_kelp", (Criterion)this.has(Blocks.KELP)).save(this.output, VanillaRecipeProvider.getSmeltingRecipeName(Items.DRIED_KELP));
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Items.SALMON), RecipeCategory.FOOD, Items.COOKED_SALMON, 0.35f, 200).unlockedBy("has_salmon", (Criterion)this.has(Items.SALMON)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Items.MUTTON), RecipeCategory.FOOD, Items.COOKED_MUTTON, 0.35f, 200).unlockedBy("has_mutton", (Criterion)this.has(Items.MUTTON)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Items.PORKCHOP), RecipeCategory.FOOD, Items.COOKED_PORKCHOP, 0.35f, 200).unlockedBy("has_porkchop", (Criterion)this.has(Items.PORKCHOP)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Items.RABBIT), RecipeCategory.FOOD, Items.COOKED_RABBIT, 0.35f, 200).unlockedBy("has_rabbit", (Criterion)this.has(Items.RABBIT)).save(this.output);
        this.oreSmelting((List<ItemLike>)COAL_SMELTABLES, RecipeCategory.MISC, Items.COAL, 0.1f, 200, "coal");
        this.oreSmelting((List<ItemLike>)IRON_SMELTABLES, RecipeCategory.MISC, Items.IRON_INGOT, 0.7f, 200, "iron_ingot");
        this.oreSmelting((List<ItemLike>)COPPER_SMELTABLES, RecipeCategory.MISC, Items.COPPER_INGOT, 0.7f, 200, "copper_ingot");
        this.oreSmelting((List<ItemLike>)GOLD_SMELTABLES, RecipeCategory.MISC, Items.GOLD_INGOT, 1.0f, 200, "gold_ingot");
        this.oreSmelting((List<ItemLike>)DIAMOND_SMELTABLES, RecipeCategory.MISC, Items.DIAMOND, 1.0f, 200, "diamond");
        this.oreSmelting((List<ItemLike>)LAPIS_SMELTABLES, RecipeCategory.MISC, Items.LAPIS_LAZULI, 0.2f, 200, "lapis_lazuli");
        this.oreSmelting((List<ItemLike>)REDSTONE_SMELTABLES, RecipeCategory.REDSTONE, Items.REDSTONE, 0.7f, 200, "redstone");
        this.oreSmelting((List<ItemLike>)EMERALD_SMELTABLES, RecipeCategory.MISC, Items.EMERALD, 1.0f, 200, "emerald");
        this.nineBlockStorageRecipes(RecipeCategory.MISC, Items.RAW_IRON, RecipeCategory.BUILDING_BLOCKS, Items.RAW_IRON_BLOCK);
        this.nineBlockStorageRecipes(RecipeCategory.MISC, Items.RAW_COPPER, RecipeCategory.BUILDING_BLOCKS, Items.RAW_COPPER_BLOCK);
        this.nineBlockStorageRecipes(RecipeCategory.MISC, Items.RAW_GOLD, RecipeCategory.BUILDING_BLOCKS, Items.RAW_GOLD_BLOCK);
        SimpleCookingRecipeBuilder.smelting(this.tag(ItemTags.SMELTS_TO_GLASS), RecipeCategory.BUILDING_BLOCKS, Blocks.GLASS.asItem(), 0.1f, 200).unlockedBy("has_smelts_to_glass", (Criterion)this.has(ItemTags.SMELTS_TO_GLASS)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.SEA_PICKLE), RecipeCategory.MISC, Items.LIME_DYE, 0.1f, 200).unlockedBy("has_sea_pickle", (Criterion)this.has(Blocks.SEA_PICKLE)).save(this.output, VanillaRecipeProvider.getSmeltingRecipeName(Items.LIME_DYE));
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.CACTUS.asItem()), RecipeCategory.MISC, Items.GREEN_DYE, 1.0f, 200).unlockedBy("has_cactus", (Criterion)this.has(Blocks.CACTUS)).save(this.output);
        ((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.GOLDEN_PICKAXE, Items.GOLDEN_SHOVEL, Items.GOLDEN_AXE, Items.GOLDEN_HOE, Items.GOLDEN_SWORD, Items.GOLDEN_SPEAR, Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS, Items.GOLDEN_HORSE_ARMOR, Items.GOLDEN_NAUTILUS_ARMOR), RecipeCategory.MISC, Items.GOLD_NUGGET, 0.1f, 200).unlockedBy("has_golden_pickaxe", (Criterion)this.has(Items.GOLDEN_PICKAXE))).unlockedBy("has_golden_shovel", (Criterion)this.has(Items.GOLDEN_SHOVEL))).unlockedBy("has_golden_axe", (Criterion)this.has(Items.GOLDEN_AXE))).unlockedBy("has_golden_hoe", (Criterion)this.has(Items.GOLDEN_HOE))).unlockedBy("has_golden_sword", (Criterion)this.has(Items.GOLDEN_SWORD))).unlockedBy("has_golden_spear", (Criterion)this.has(Items.GOLDEN_SPEAR))).unlockedBy("has_golden_helmet", (Criterion)this.has(Items.GOLDEN_HELMET))).unlockedBy("has_golden_chestplate", (Criterion)this.has(Items.GOLDEN_CHESTPLATE))).unlockedBy("has_golden_leggings", (Criterion)this.has(Items.GOLDEN_LEGGINGS))).unlockedBy("has_golden_boots", (Criterion)this.has(Items.GOLDEN_BOOTS))).unlockedBy("has_golden_horse_armor", (Criterion)this.has(Items.GOLDEN_HORSE_ARMOR))).unlockedBy("has_golden_nautilus_armor", (Criterion)this.has(Items.GOLDEN_NAUTILUS_ARMOR)).save(this.output, VanillaRecipeProvider.getSmeltingRecipeName(Items.GOLD_NUGGET));
        ((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.COPPER_PICKAXE, Items.COPPER_SHOVEL, Items.COPPER_AXE, Items.COPPER_HOE, Items.COPPER_SWORD, Items.COPPER_SPEAR, Items.COPPER_HELMET, Items.COPPER_CHESTPLATE, Items.COPPER_LEGGINGS, Items.COPPER_BOOTS, Items.COPPER_HORSE_ARMOR, Items.COPPER_NAUTILUS_ARMOR), RecipeCategory.MISC, Items.COPPER_NUGGET, 0.1f, 200).unlockedBy("has_copper_pickaxe", (Criterion)this.has(Items.COPPER_PICKAXE))).unlockedBy("has_copper_shovel", (Criterion)this.has(Items.COPPER_SHOVEL))).unlockedBy("has_copper_axe", (Criterion)this.has(Items.COPPER_AXE))).unlockedBy("has_copper_hoe", (Criterion)this.has(Items.COPPER_HOE))).unlockedBy("has_copper_sword", (Criterion)this.has(Items.COPPER_SWORD))).unlockedBy("has_copper_spear", (Criterion)this.has(Items.COPPER_SPEAR))).unlockedBy("has_copper_helmet", (Criterion)this.has(Items.COPPER_HELMET))).unlockedBy("has_copper_chestplate", (Criterion)this.has(Items.COPPER_CHESTPLATE))).unlockedBy("has_copper_leggings", (Criterion)this.has(Items.COPPER_LEGGINGS))).unlockedBy("has_copper_boots", (Criterion)this.has(Items.COPPER_BOOTS))).unlockedBy("has_copper_horse_armor", (Criterion)this.has(Items.COPPER_HORSE_ARMOR))).unlockedBy("has_copper_nautilus_armor", (Criterion)this.has(Items.COPPER_NAUTILUS_ARMOR)).save(this.output, VanillaRecipeProvider.getSmeltingRecipeName(Items.COPPER_NUGGET));
        ((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.IRON_PICKAXE, Items.IRON_SHOVEL, Items.IRON_AXE, Items.IRON_HOE, Items.IRON_SWORD, Items.IRON_SPEAR, Items.IRON_HELMET, Items.IRON_CHESTPLATE, Items.IRON_LEGGINGS, Items.IRON_BOOTS, Items.IRON_HORSE_ARMOR, Items.CHAINMAIL_HELMET, Items.CHAINMAIL_CHESTPLATE, Items.CHAINMAIL_LEGGINGS, Items.CHAINMAIL_BOOTS, Items.IRON_NAUTILUS_ARMOR), RecipeCategory.MISC, Items.IRON_NUGGET, 0.1f, 200).unlockedBy("has_iron_pickaxe", (Criterion)this.has(Items.IRON_PICKAXE))).unlockedBy("has_iron_shovel", (Criterion)this.has(Items.IRON_SHOVEL))).unlockedBy("has_iron_axe", (Criterion)this.has(Items.IRON_AXE))).unlockedBy("has_iron_hoe", (Criterion)this.has(Items.IRON_HOE))).unlockedBy("has_iron_sword", (Criterion)this.has(Items.IRON_SWORD))).unlockedBy("has_iron_spear", (Criterion)this.has(Items.IRON_SPEAR))).unlockedBy("has_iron_helmet", (Criterion)this.has(Items.IRON_HELMET))).unlockedBy("has_iron_chestplate", (Criterion)this.has(Items.IRON_CHESTPLATE))).unlockedBy("has_iron_leggings", (Criterion)this.has(Items.IRON_LEGGINGS))).unlockedBy("has_iron_boots", (Criterion)this.has(Items.IRON_BOOTS))).unlockedBy("has_iron_horse_armor", (Criterion)this.has(Items.IRON_HORSE_ARMOR))).unlockedBy("has_chainmail_helmet", (Criterion)this.has(Items.CHAINMAIL_HELMET))).unlockedBy("has_chainmail_chestplate", (Criterion)this.has(Items.CHAINMAIL_CHESTPLATE))).unlockedBy("has_chainmail_leggings", (Criterion)this.has(Items.CHAINMAIL_LEGGINGS))).unlockedBy("has_chainmail_boots", (Criterion)this.has(Items.CHAINMAIL_BOOTS))).unlockedBy("has_iron_nautilus_armor", (Criterion)this.has(Items.IRON_NAUTILUS_ARMOR)).save(this.output, VanillaRecipeProvider.getSmeltingRecipeName(Items.IRON_NUGGET));
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.CLAY), RecipeCategory.BUILDING_BLOCKS, Blocks.TERRACOTTA.asItem(), 0.35f, 200).unlockedBy("has_clay_block", (Criterion)this.has(Blocks.CLAY)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.NETHERRACK), RecipeCategory.MISC, Items.NETHER_BRICK, 0.1f, 200).unlockedBy("has_netherrack", (Criterion)this.has(Blocks.NETHERRACK)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Items.RESIN_CLUMP), RecipeCategory.MISC, Items.RESIN_BRICK, 0.1f, 200).unlockedBy("has_resin_clump", (Criterion)this.has(Blocks.RESIN_CLUMP)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.NETHER_QUARTZ_ORE), RecipeCategory.MISC, Items.QUARTZ, 0.2f, 200).unlockedBy("has_nether_quartz_ore", (Criterion)this.has(Blocks.NETHER_QUARTZ_ORE)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.WET_SPONGE), RecipeCategory.BUILDING_BLOCKS, Blocks.SPONGE.asItem(), 0.15f, 200).unlockedBy("has_wet_sponge", (Criterion)this.has(Blocks.WET_SPONGE)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.COBBLESTONE), RecipeCategory.BUILDING_BLOCKS, Blocks.STONE.asItem(), 0.1f, 200).unlockedBy("has_cobblestone", (Criterion)this.has(Blocks.COBBLESTONE)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.STONE), RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_STONE.asItem(), 0.1f, 200).unlockedBy("has_stone", (Criterion)this.has(Blocks.STONE)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.SANDSTONE), RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_SANDSTONE.asItem(), 0.1f, 200).unlockedBy("has_sandstone", (Criterion)this.has(Blocks.SANDSTONE)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.RED_SANDSTONE), RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_RED_SANDSTONE.asItem(), 0.1f, 200).unlockedBy("has_red_sandstone", (Criterion)this.has(Blocks.RED_SANDSTONE)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.QUARTZ_BLOCK), RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_QUARTZ.asItem(), 0.1f, 200).unlockedBy("has_quartz_block", (Criterion)this.has(Blocks.QUARTZ_BLOCK)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.STONE_BRICKS), RecipeCategory.BUILDING_BLOCKS, Blocks.CRACKED_STONE_BRICKS.asItem(), 0.1f, 200).unlockedBy("has_stone_bricks", (Criterion)this.has(Blocks.STONE_BRICKS)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.BLACK_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.BLACK_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_black_terracotta", (Criterion)this.has(Blocks.BLACK_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.BLUE_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.BLUE_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_blue_terracotta", (Criterion)this.has(Blocks.BLUE_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.BROWN_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.BROWN_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_brown_terracotta", (Criterion)this.has(Blocks.BROWN_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.CYAN_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.CYAN_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_cyan_terracotta", (Criterion)this.has(Blocks.CYAN_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.GRAY_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.GRAY_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_gray_terracotta", (Criterion)this.has(Blocks.GRAY_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.GREEN_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.GREEN_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_green_terracotta", (Criterion)this.has(Blocks.GREEN_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.LIGHT_BLUE_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_light_blue_terracotta", (Criterion)this.has(Blocks.LIGHT_BLUE_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.LIGHT_GRAY_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_light_gray_terracotta", (Criterion)this.has(Blocks.LIGHT_GRAY_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.LIME_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.LIME_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_lime_terracotta", (Criterion)this.has(Blocks.LIME_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.MAGENTA_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.MAGENTA_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_magenta_terracotta", (Criterion)this.has(Blocks.MAGENTA_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.ORANGE_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.ORANGE_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_orange_terracotta", (Criterion)this.has(Blocks.ORANGE_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.PINK_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.PINK_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_pink_terracotta", (Criterion)this.has(Blocks.PINK_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.PURPLE_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.PURPLE_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_purple_terracotta", (Criterion)this.has(Blocks.PURPLE_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.RED_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.RED_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_red_terracotta", (Criterion)this.has(Blocks.RED_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.WHITE_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.WHITE_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_white_terracotta", (Criterion)this.has(Blocks.WHITE_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.YELLOW_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.YELLOW_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_yellow_terracotta", (Criterion)this.has(Blocks.YELLOW_TERRACOTTA)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.ANCIENT_DEBRIS), RecipeCategory.MISC, Items.NETHERITE_SCRAP, 2.0f, 200).unlockedBy("has_ancient_debris", (Criterion)this.has(Blocks.ANCIENT_DEBRIS)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.BASALT), RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_BASALT, 0.1f, 200).unlockedBy("has_basalt", (Criterion)this.has(Blocks.BASALT)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of((ItemLike)Blocks.COBBLED_DEEPSLATE), RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE, 0.1f, 200).unlockedBy("has_cobbled_deepslate", (Criterion)this.has(Blocks.COBBLED_DEEPSLATE)).save(this.output);
        SimpleCookingRecipeBuilder.smelting(this.tag(ItemTags.LEAVES), RecipeCategory.MISC, Blocks.LEAF_LITTER, 0.1f, 200).unlockedBy("has_leaves", (Criterion)this.has(ItemTags.LEAVES)).save(this.output);
        this.oreBlasting((List<ItemLike>)COAL_SMELTABLES, RecipeCategory.MISC, Items.COAL, 0.1f, 100, "coal");
        this.oreBlasting((List<ItemLike>)IRON_SMELTABLES, RecipeCategory.MISC, Items.IRON_INGOT, 0.7f, 100, "iron_ingot");
        this.oreBlasting((List<ItemLike>)COPPER_SMELTABLES, RecipeCategory.MISC, Items.COPPER_INGOT, 0.7f, 100, "copper_ingot");
        this.oreBlasting((List<ItemLike>)GOLD_SMELTABLES, RecipeCategory.MISC, Items.GOLD_INGOT, 1.0f, 100, "gold_ingot");
        this.oreBlasting((List<ItemLike>)DIAMOND_SMELTABLES, RecipeCategory.MISC, Items.DIAMOND, 1.0f, 100, "diamond");
        this.oreBlasting((List<ItemLike>)LAPIS_SMELTABLES, RecipeCategory.MISC, Items.LAPIS_LAZULI, 0.2f, 100, "lapis_lazuli");
        this.oreBlasting((List<ItemLike>)REDSTONE_SMELTABLES, RecipeCategory.REDSTONE, Items.REDSTONE, 0.7f, 100, "redstone");
        this.oreBlasting((List<ItemLike>)EMERALD_SMELTABLES, RecipeCategory.MISC, Items.EMERALD, 1.0f, 100, "emerald");
        SimpleCookingRecipeBuilder.blasting(Ingredient.of((ItemLike)Blocks.NETHER_QUARTZ_ORE), RecipeCategory.MISC, Items.QUARTZ, 0.2f, 100).unlockedBy("has_nether_quartz_ore", (Criterion)this.has(Blocks.NETHER_QUARTZ_ORE)).save(this.output, VanillaRecipeProvider.getBlastingRecipeName(Items.QUARTZ));
        ((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.blasting(Ingredient.of(Items.GOLDEN_PICKAXE, Items.GOLDEN_SHOVEL, Items.GOLDEN_AXE, Items.GOLDEN_HOE, Items.GOLDEN_SWORD, Items.GOLDEN_SPEAR, Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS, Items.GOLDEN_HORSE_ARMOR, Items.GOLDEN_NAUTILUS_ARMOR), RecipeCategory.MISC, Items.GOLD_NUGGET, 0.1f, 100).unlockedBy("has_golden_pickaxe", (Criterion)this.has(Items.GOLDEN_PICKAXE))).unlockedBy("has_golden_shovel", (Criterion)this.has(Items.GOLDEN_SHOVEL))).unlockedBy("has_golden_axe", (Criterion)this.has(Items.GOLDEN_AXE))).unlockedBy("has_golden_hoe", (Criterion)this.has(Items.GOLDEN_HOE))).unlockedBy("has_golden_sword", (Criterion)this.has(Items.GOLDEN_SWORD))).unlockedBy("has_golden_spear", (Criterion)this.has(Items.GOLDEN_SPEAR))).unlockedBy("has_golden_helmet", (Criterion)this.has(Items.GOLDEN_HELMET))).unlockedBy("has_golden_chestplate", (Criterion)this.has(Items.GOLDEN_CHESTPLATE))).unlockedBy("has_golden_leggings", (Criterion)this.has(Items.GOLDEN_LEGGINGS))).unlockedBy("has_golden_boots", (Criterion)this.has(Items.GOLDEN_BOOTS))).unlockedBy("has_golden_horse_armor", (Criterion)this.has(Items.GOLDEN_HORSE_ARMOR))).unlockedBy("has_golden_nautilus_armor", (Criterion)this.has(Items.GOLDEN_NAUTILUS_ARMOR)).save(this.output, VanillaRecipeProvider.getBlastingRecipeName(Items.GOLD_NUGGET));
        ((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.blasting(Ingredient.of(Items.COPPER_PICKAXE, Items.COPPER_SHOVEL, Items.COPPER_AXE, Items.COPPER_HOE, Items.COPPER_SWORD, Items.COPPER_SPEAR, Items.COPPER_HELMET, Items.COPPER_CHESTPLATE, Items.COPPER_LEGGINGS, Items.COPPER_BOOTS, Items.COPPER_HORSE_ARMOR, Items.COPPER_NAUTILUS_ARMOR), RecipeCategory.MISC, Items.COPPER_NUGGET, 0.1f, 100).unlockedBy("has_copper_pickaxe", (Criterion)this.has(Items.COPPER_PICKAXE))).unlockedBy("has_copper_shovel", (Criterion)this.has(Items.COPPER_SHOVEL))).unlockedBy("has_copper_axe", (Criterion)this.has(Items.COPPER_AXE))).unlockedBy("has_copper_hoe", (Criterion)this.has(Items.COPPER_HOE))).unlockedBy("has_copper_sword", (Criterion)this.has(Items.COPPER_SWORD))).unlockedBy("has_copper_spear", (Criterion)this.has(Items.COPPER_SPEAR))).unlockedBy("has_copper_helmet", (Criterion)this.has(Items.COPPER_HELMET))).unlockedBy("has_copper_chestplate", (Criterion)this.has(Items.COPPER_CHESTPLATE))).unlockedBy("has_copper_leggings", (Criterion)this.has(Items.COPPER_LEGGINGS))).unlockedBy("has_copper_boots", (Criterion)this.has(Items.COPPER_BOOTS))).unlockedBy("has_copper_horse_armor", (Criterion)this.has(Items.COPPER_HORSE_ARMOR))).unlockedBy("has_copper_nautilus_armor", (Criterion)this.has(Items.COPPER_NAUTILUS_ARMOR)).save(this.output, VanillaRecipeProvider.getBlastingRecipeName(Items.COPPER_NUGGET));
        ((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.blasting(Ingredient.of(Items.IRON_PICKAXE, Items.IRON_SHOVEL, Items.IRON_AXE, Items.IRON_HOE, Items.IRON_SWORD, Items.IRON_SPEAR, Items.IRON_HELMET, Items.IRON_CHESTPLATE, Items.IRON_LEGGINGS, Items.IRON_BOOTS, Items.IRON_HORSE_ARMOR, Items.IRON_NAUTILUS_ARMOR, Items.CHAINMAIL_HELMET, Items.CHAINMAIL_CHESTPLATE, Items.CHAINMAIL_LEGGINGS, Items.CHAINMAIL_BOOTS), RecipeCategory.MISC, Items.IRON_NUGGET, 0.1f, 100).unlockedBy("has_iron_pickaxe", (Criterion)this.has(Items.IRON_PICKAXE))).unlockedBy("has_iron_shovel", (Criterion)this.has(Items.IRON_SHOVEL))).unlockedBy("has_iron_axe", (Criterion)this.has(Items.IRON_AXE))).unlockedBy("has_iron_hoe", (Criterion)this.has(Items.IRON_HOE))).unlockedBy("has_iron_sword", (Criterion)this.has(Items.IRON_SWORD))).unlockedBy("has_iron_spear", (Criterion)this.has(Items.IRON_SPEAR))).unlockedBy("has_iron_helmet", (Criterion)this.has(Items.IRON_HELMET))).unlockedBy("has_iron_chestplate", (Criterion)this.has(Items.IRON_CHESTPLATE))).unlockedBy("has_iron_leggings", (Criterion)this.has(Items.IRON_LEGGINGS))).unlockedBy("has_iron_boots", (Criterion)this.has(Items.IRON_BOOTS))).unlockedBy("has_iron_horse_armor", (Criterion)this.has(Items.IRON_HORSE_ARMOR))).unlockedBy("has_chainmail_helmet", (Criterion)this.has(Items.CHAINMAIL_HELMET))).unlockedBy("has_chainmail_chestplate", (Criterion)this.has(Items.CHAINMAIL_CHESTPLATE))).unlockedBy("has_chainmail_leggings", (Criterion)this.has(Items.CHAINMAIL_LEGGINGS))).unlockedBy("has_chainmail_boots", (Criterion)this.has(Items.CHAINMAIL_BOOTS))).unlockedBy("has_iron_nautilus_armor", (Criterion)this.has(Items.IRON_NAUTILUS_ARMOR)).save(this.output, VanillaRecipeProvider.getBlastingRecipeName(Items.IRON_NUGGET));
        SimpleCookingRecipeBuilder.blasting(Ingredient.of((ItemLike)Blocks.ANCIENT_DEBRIS), RecipeCategory.MISC, Items.NETHERITE_SCRAP, 2.0f, 100).unlockedBy("has_ancient_debris", (Criterion)this.has(Blocks.ANCIENT_DEBRIS)).save(this.output, VanillaRecipeProvider.getBlastingRecipeName(Items.NETHERITE_SCRAP));
        this.cookRecipes("smoking", RecipeSerializer.SMOKING_RECIPE, SmokingRecipe::new, 100);
        this.cookRecipes("campfire_cooking", RecipeSerializer.CAMPFIRE_COOKING_RECIPE, CampfireCookingRecipe::new, 600);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_SLAB, Blocks.STONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_STAIRS, Blocks.STONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_BRICKS, Blocks.STONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_BRICK_SLAB, Blocks.STONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_BRICK_STAIRS, Blocks.STONE);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of((ItemLike)Blocks.STONE), RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_STONE_BRICKS).unlockedBy("has_stone", (Criterion)this.has(Blocks.STONE)).save(this.output, "chiseled_stone_bricks_stone_from_stonecutting");
        SingleItemRecipeBuilder.stonecutting(Ingredient.of((ItemLike)Blocks.STONE), RecipeCategory.DECORATIONS, Blocks.STONE_BRICK_WALL).unlockedBy("has_stone", (Criterion)this.has(Blocks.STONE)).save(this.output, "stone_brick_walls_from_stone_stonecutting");
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_SANDSTONE, Blocks.SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.SANDSTONE_SLAB, Blocks.SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_SANDSTONE_SLAB, Blocks.SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_SANDSTONE_SLAB, Blocks.CUT_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.SANDSTONE_STAIRS, Blocks.SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.SANDSTONE_WALL, Blocks.SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_SANDSTONE, Blocks.SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_RED_SANDSTONE, Blocks.RED_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.RED_SANDSTONE_SLAB, Blocks.RED_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_RED_SANDSTONE_SLAB, Blocks.RED_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_RED_SANDSTONE_SLAB, Blocks.CUT_RED_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.RED_SANDSTONE_STAIRS, Blocks.RED_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.RED_SANDSTONE_WALL, Blocks.RED_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_RED_SANDSTONE, Blocks.RED_SANDSTONE);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of((ItemLike)Blocks.QUARTZ_BLOCK), RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_SLAB, 2).unlockedBy("has_quartz_block", (Criterion)this.has(Blocks.QUARTZ_BLOCK)).save(this.output, "quartz_slab_from_stonecutting");
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_STAIRS, Blocks.QUARTZ_BLOCK);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_PILLAR, Blocks.QUARTZ_BLOCK);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_QUARTZ_BLOCK, Blocks.QUARTZ_BLOCK);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_BRICKS, Blocks.QUARTZ_BLOCK);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.COBBLESTONE_STAIRS, Blocks.COBBLESTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.COBBLESTONE_SLAB, Blocks.COBBLESTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.COBBLESTONE_WALL, Blocks.COBBLESTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_BRICK_SLAB, Blocks.STONE_BRICKS, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_BRICK_STAIRS, Blocks.STONE_BRICKS);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of((ItemLike)Blocks.STONE_BRICKS), RecipeCategory.DECORATIONS, Blocks.STONE_BRICK_WALL).unlockedBy("has_stone_bricks", (Criterion)this.has(Blocks.STONE_BRICKS)).save(this.output, "stone_brick_wall_from_stone_bricks_stonecutting");
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_STONE_BRICKS, Blocks.STONE_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.BRICK_SLAB, Blocks.BRICKS, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.BRICK_STAIRS, Blocks.BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.BRICK_WALL, Blocks.BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.MUD_BRICK_SLAB, Blocks.MUD_BRICKS, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.MUD_BRICK_STAIRS, Blocks.MUD_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.MUD_BRICK_WALL, Blocks.MUD_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.NETHER_BRICK_SLAB, Blocks.NETHER_BRICKS, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.NETHER_BRICK_STAIRS, Blocks.NETHER_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.NETHER_BRICK_WALL, Blocks.NETHER_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_NETHER_BRICKS, Blocks.NETHER_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.RESIN_BRICK_SLAB, Blocks.RESIN_BRICKS, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.RESIN_BRICK_STAIRS, Blocks.RESIN_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.RESIN_BRICK_WALL, Blocks.RESIN_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_RESIN_BRICKS, Blocks.RESIN_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.RED_NETHER_BRICK_SLAB, Blocks.RED_NETHER_BRICKS, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.RED_NETHER_BRICK_STAIRS, Blocks.RED_NETHER_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.RED_NETHER_BRICK_WALL, Blocks.RED_NETHER_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.PURPUR_SLAB, Blocks.PURPUR_BLOCK, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.PURPUR_STAIRS, Blocks.PURPUR_BLOCK);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.PURPUR_PILLAR, Blocks.PURPUR_BLOCK);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.PRISMARINE_SLAB, Blocks.PRISMARINE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.PRISMARINE_STAIRS, Blocks.PRISMARINE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.PRISMARINE_WALL, Blocks.PRISMARINE);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of((ItemLike)Blocks.PRISMARINE_BRICKS), RecipeCategory.BUILDING_BLOCKS, Blocks.PRISMARINE_BRICK_SLAB, 2).unlockedBy("has_prismarine_brick", (Criterion)this.has(Blocks.PRISMARINE_BRICKS)).save(this.output, "prismarine_brick_slab_from_prismarine_stonecutting");
        SingleItemRecipeBuilder.stonecutting(Ingredient.of((ItemLike)Blocks.PRISMARINE_BRICKS), RecipeCategory.BUILDING_BLOCKS, Blocks.PRISMARINE_BRICK_STAIRS).unlockedBy("has_prismarine_brick", (Criterion)this.has(Blocks.PRISMARINE_BRICKS)).save(this.output, "prismarine_brick_stairs_from_prismarine_stonecutting");
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DARK_PRISMARINE_SLAB, Blocks.DARK_PRISMARINE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DARK_PRISMARINE_STAIRS, Blocks.DARK_PRISMARINE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.ANDESITE_SLAB, Blocks.ANDESITE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.ANDESITE_STAIRS, Blocks.ANDESITE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.ANDESITE_WALL, Blocks.ANDESITE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_ANDESITE, Blocks.ANDESITE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_ANDESITE_SLAB, Blocks.ANDESITE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_ANDESITE_STAIRS, Blocks.ANDESITE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_ANDESITE_SLAB, Blocks.POLISHED_ANDESITE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_ANDESITE_STAIRS, Blocks.POLISHED_ANDESITE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BASALT, Blocks.BASALT);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.GRANITE_SLAB, Blocks.GRANITE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.GRANITE_STAIRS, Blocks.GRANITE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.GRANITE_WALL, Blocks.GRANITE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_GRANITE, Blocks.GRANITE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_GRANITE_SLAB, Blocks.GRANITE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_GRANITE_STAIRS, Blocks.GRANITE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_GRANITE_SLAB, Blocks.POLISHED_GRANITE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_GRANITE_STAIRS, Blocks.POLISHED_GRANITE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DIORITE_SLAB, Blocks.DIORITE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DIORITE_STAIRS, Blocks.DIORITE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.DIORITE_WALL, Blocks.DIORITE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DIORITE, Blocks.DIORITE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DIORITE_SLAB, Blocks.DIORITE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DIORITE_STAIRS, Blocks.DIORITE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DIORITE_SLAB, Blocks.POLISHED_DIORITE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DIORITE_STAIRS, Blocks.POLISHED_DIORITE);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of((ItemLike)Blocks.MOSSY_STONE_BRICKS), RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_STONE_BRICK_SLAB, 2).unlockedBy("has_mossy_stone_bricks", (Criterion)this.has(Blocks.MOSSY_STONE_BRICKS)).save(this.output, "mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting");
        SingleItemRecipeBuilder.stonecutting(Ingredient.of((ItemLike)Blocks.MOSSY_STONE_BRICKS), RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_STONE_BRICK_STAIRS).unlockedBy("has_mossy_stone_bricks", (Criterion)this.has(Blocks.MOSSY_STONE_BRICKS)).save(this.output, "mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting");
        SingleItemRecipeBuilder.stonecutting(Ingredient.of((ItemLike)Blocks.MOSSY_STONE_BRICKS), RecipeCategory.DECORATIONS, Blocks.MOSSY_STONE_BRICK_WALL).unlockedBy("has_mossy_stone_bricks", (Criterion)this.has(Blocks.MOSSY_STONE_BRICKS)).save(this.output, "mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting");
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_COBBLESTONE_SLAB, Blocks.MOSSY_COBBLESTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_COBBLESTONE_STAIRS, Blocks.MOSSY_COBBLESTONE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.MOSSY_COBBLESTONE_WALL, Blocks.MOSSY_COBBLESTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_SANDSTONE_SLAB, Blocks.SMOOTH_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_SANDSTONE_STAIRS, Blocks.SMOOTH_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_RED_SANDSTONE_SLAB, Blocks.SMOOTH_RED_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_RED_SANDSTONE_STAIRS, Blocks.SMOOTH_RED_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_QUARTZ_SLAB, Blocks.SMOOTH_QUARTZ, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_QUARTZ_STAIRS, Blocks.SMOOTH_QUARTZ);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of((ItemLike)Blocks.END_STONE_BRICKS), RecipeCategory.BUILDING_BLOCKS, Blocks.END_STONE_BRICK_SLAB, 2).unlockedBy("has_end_stone_brick", (Criterion)this.has(Blocks.END_STONE_BRICKS)).save(this.output, "end_stone_brick_slab_from_end_stone_brick_stonecutting");
        SingleItemRecipeBuilder.stonecutting(Ingredient.of((ItemLike)Blocks.END_STONE_BRICKS), RecipeCategory.BUILDING_BLOCKS, Blocks.END_STONE_BRICK_STAIRS).unlockedBy("has_end_stone_brick", (Criterion)this.has(Blocks.END_STONE_BRICKS)).save(this.output, "end_stone_brick_stairs_from_end_stone_brick_stonecutting");
        SingleItemRecipeBuilder.stonecutting(Ingredient.of((ItemLike)Blocks.END_STONE_BRICKS), RecipeCategory.DECORATIONS, Blocks.END_STONE_BRICK_WALL).unlockedBy("has_end_stone_brick", (Criterion)this.has(Blocks.END_STONE_BRICKS)).save(this.output, "end_stone_brick_wall_from_end_stone_brick_stonecutting");
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.END_STONE_BRICKS, Blocks.END_STONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.END_STONE_BRICK_SLAB, Blocks.END_STONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.END_STONE_BRICK_STAIRS, Blocks.END_STONE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.END_STONE_BRICK_WALL, Blocks.END_STONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_STONE_SLAB, Blocks.SMOOTH_STONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.BLACKSTONE_SLAB, Blocks.BLACKSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.BLACKSTONE_STAIRS, Blocks.BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.BLACKSTONE_WALL, Blocks.BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE, Blocks.BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.POLISHED_BLACKSTONE_WALL, Blocks.BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_SLAB, Blocks.BLACKSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_STAIRS, Blocks.BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_POLISHED_BLACKSTONE, Blocks.BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICKS, Blocks.BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICK_SLAB, Blocks.BLACKSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICK_STAIRS, Blocks.BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.POLISHED_BLACKSTONE_BRICK_WALL, Blocks.BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_SLAB, Blocks.POLISHED_BLACKSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_STAIRS, Blocks.POLISHED_BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICKS, Blocks.POLISHED_BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.POLISHED_BLACKSTONE_WALL, Blocks.POLISHED_BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICK_SLAB, Blocks.POLISHED_BLACKSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICK_STAIRS, Blocks.POLISHED_BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.POLISHED_BLACKSTONE_BRICK_WALL, Blocks.POLISHED_BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_POLISHED_BLACKSTONE, Blocks.POLISHED_BLACKSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICK_SLAB, Blocks.POLISHED_BLACKSTONE_BRICKS, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICK_STAIRS, Blocks.POLISHED_BLACKSTONE_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.POLISHED_BLACKSTONE_BRICK_WALL, Blocks.POLISHED_BLACKSTONE_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_COPPER_SLAB, Blocks.CUT_COPPER, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_COPPER_STAIRS, Blocks.CUT_COPPER);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.EXPOSED_CUT_COPPER_SLAB, Blocks.EXPOSED_CUT_COPPER, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.EXPOSED_CUT_COPPER_STAIRS, Blocks.EXPOSED_CUT_COPPER);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WEATHERED_CUT_COPPER_SLAB, Blocks.WEATHERED_CUT_COPPER, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WEATHERED_CUT_COPPER_STAIRS, Blocks.WEATHERED_CUT_COPPER);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.OXIDIZED_CUT_COPPER_SLAB, Blocks.OXIDIZED_CUT_COPPER, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.OXIDIZED_CUT_COPPER_STAIRS, Blocks.OXIDIZED_CUT_COPPER);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_CUT_COPPER_SLAB, Blocks.WAXED_CUT_COPPER, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_CUT_COPPER_STAIRS, Blocks.WAXED_CUT_COPPER);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_EXPOSED_CUT_COPPER_SLAB, Blocks.WAXED_EXPOSED_CUT_COPPER, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_EXPOSED_CUT_COPPER_STAIRS, Blocks.WAXED_EXPOSED_CUT_COPPER);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_WEATHERED_CUT_COPPER_SLAB, Blocks.WAXED_WEATHERED_CUT_COPPER, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_WEATHERED_CUT_COPPER_STAIRS, Blocks.WAXED_WEATHERED_CUT_COPPER);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_OXIDIZED_CUT_COPPER_SLAB, Blocks.WAXED_OXIDIZED_CUT_COPPER, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_OXIDIZED_CUT_COPPER_STAIRS, Blocks.WAXED_OXIDIZED_CUT_COPPER);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_COPPER, Blocks.COPPER_BLOCK, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_COPPER_STAIRS, Blocks.COPPER_BLOCK, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_COPPER_SLAB, Blocks.COPPER_BLOCK, 8);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.EXPOSED_CUT_COPPER, Blocks.EXPOSED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.EXPOSED_CUT_COPPER_STAIRS, Blocks.EXPOSED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.EXPOSED_CUT_COPPER_SLAB, Blocks.EXPOSED_COPPER, 8);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WEATHERED_CUT_COPPER, Blocks.WEATHERED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WEATHERED_CUT_COPPER_STAIRS, Blocks.WEATHERED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WEATHERED_CUT_COPPER_SLAB, Blocks.WEATHERED_COPPER, 8);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.OXIDIZED_CUT_COPPER, Blocks.OXIDIZED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.OXIDIZED_CUT_COPPER_STAIRS, Blocks.OXIDIZED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.OXIDIZED_CUT_COPPER_SLAB, Blocks.OXIDIZED_COPPER, 8);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_CUT_COPPER, Blocks.WAXED_COPPER_BLOCK, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_CUT_COPPER_STAIRS, Blocks.WAXED_COPPER_BLOCK, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_CUT_COPPER_SLAB, Blocks.WAXED_COPPER_BLOCK, 8);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_EXPOSED_CUT_COPPER, Blocks.WAXED_EXPOSED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_EXPOSED_CUT_COPPER_STAIRS, Blocks.WAXED_EXPOSED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_EXPOSED_CUT_COPPER_SLAB, Blocks.WAXED_EXPOSED_COPPER, 8);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_WEATHERED_CUT_COPPER, Blocks.WAXED_WEATHERED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_WEATHERED_CUT_COPPER_STAIRS, Blocks.WAXED_WEATHERED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_WEATHERED_CUT_COPPER_SLAB, Blocks.WAXED_WEATHERED_COPPER, 8);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_OXIDIZED_CUT_COPPER, Blocks.WAXED_OXIDIZED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_OXIDIZED_CUT_COPPER_STAIRS, Blocks.WAXED_OXIDIZED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_OXIDIZED_CUT_COPPER_SLAB, Blocks.WAXED_OXIDIZED_COPPER, 8);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.COBBLED_DEEPSLATE_SLAB, Blocks.COBBLED_DEEPSLATE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.COBBLED_DEEPSLATE_STAIRS, Blocks.COBBLED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.COBBLED_DEEPSLATE_WALL, Blocks.COBBLED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_DEEPSLATE, Blocks.COBBLED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DEEPSLATE, Blocks.COBBLED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DEEPSLATE_SLAB, Blocks.COBBLED_DEEPSLATE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DEEPSLATE_STAIRS, Blocks.COBBLED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.POLISHED_DEEPSLATE_WALL, Blocks.COBBLED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICKS, Blocks.COBBLED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICK_SLAB, Blocks.COBBLED_DEEPSLATE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICK_STAIRS, Blocks.COBBLED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.DEEPSLATE_BRICK_WALL, Blocks.COBBLED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILES, Blocks.COBBLED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_SLAB, Blocks.COBBLED_DEEPSLATE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_STAIRS, Blocks.COBBLED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.DEEPSLATE_TILE_WALL, Blocks.COBBLED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DEEPSLATE_SLAB, Blocks.POLISHED_DEEPSLATE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DEEPSLATE_STAIRS, Blocks.POLISHED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.POLISHED_DEEPSLATE_WALL, Blocks.POLISHED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICKS, Blocks.POLISHED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICK_SLAB, Blocks.POLISHED_DEEPSLATE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICK_STAIRS, Blocks.POLISHED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.DEEPSLATE_BRICK_WALL, Blocks.POLISHED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILES, Blocks.POLISHED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_SLAB, Blocks.POLISHED_DEEPSLATE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_STAIRS, Blocks.POLISHED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.DEEPSLATE_TILE_WALL, Blocks.POLISHED_DEEPSLATE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICK_SLAB, Blocks.DEEPSLATE_BRICKS, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICK_STAIRS, Blocks.DEEPSLATE_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.DEEPSLATE_BRICK_WALL, Blocks.DEEPSLATE_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILES, Blocks.DEEPSLATE_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_SLAB, Blocks.DEEPSLATE_BRICKS, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_STAIRS, Blocks.DEEPSLATE_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.DEEPSLATE_TILE_WALL, Blocks.DEEPSLATE_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_SLAB, Blocks.DEEPSLATE_TILES, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_STAIRS, Blocks.DEEPSLATE_TILES);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.DEEPSLATE_TILE_WALL, Blocks.DEEPSLATE_TILES);
        VanillaRecipeProvider.smithingTrims().forEach(trimTemplate -> this.trimSmithing(trimTemplate.template(), trimTemplate.patternId(), trimTemplate.recipeId()));
        this.netheriteSmithing(Items.DIAMOND_CHESTPLATE, RecipeCategory.COMBAT, Items.NETHERITE_CHESTPLATE);
        this.netheriteSmithing(Items.DIAMOND_LEGGINGS, RecipeCategory.COMBAT, Items.NETHERITE_LEGGINGS);
        this.netheriteSmithing(Items.DIAMOND_HELMET, RecipeCategory.COMBAT, Items.NETHERITE_HELMET);
        this.netheriteSmithing(Items.DIAMOND_BOOTS, RecipeCategory.COMBAT, Items.NETHERITE_BOOTS);
        this.netheriteSmithing(Items.DIAMOND_NAUTILUS_ARMOR, RecipeCategory.COMBAT, Items.NETHERITE_NAUTILUS_ARMOR);
        this.netheriteSmithing(Items.DIAMOND_HORSE_ARMOR, RecipeCategory.COMBAT, Items.NETHERITE_HORSE_ARMOR);
        this.netheriteSmithing(Items.DIAMOND_SWORD, RecipeCategory.COMBAT, Items.NETHERITE_SWORD);
        this.netheriteSmithing(Items.DIAMOND_SPEAR, RecipeCategory.COMBAT, Items.NETHERITE_SPEAR);
        this.netheriteSmithing(Items.DIAMOND_AXE, RecipeCategory.TOOLS, Items.NETHERITE_AXE);
        this.netheriteSmithing(Items.DIAMOND_PICKAXE, RecipeCategory.TOOLS, Items.NETHERITE_PICKAXE);
        this.netheriteSmithing(Items.DIAMOND_HOE, RecipeCategory.TOOLS, Items.NETHERITE_HOE);
        this.netheriteSmithing(Items.DIAMOND_SHOVEL, RecipeCategory.TOOLS, Items.NETHERITE_SHOVEL);
        this.copySmithingTemplate((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE, Items.NETHERRACK);
        this.copySmithingTemplate((ItemLike)Items.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE, Items.COBBLESTONE);
        this.copySmithingTemplate((ItemLike)Items.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.SANDSTONE);
        this.copySmithingTemplate((ItemLike)Items.COAST_ARMOR_TRIM_SMITHING_TEMPLATE, Items.COBBLESTONE);
        this.copySmithingTemplate((ItemLike)Items.WILD_ARMOR_TRIM_SMITHING_TEMPLATE, Items.MOSSY_COBBLESTONE);
        this.copySmithingTemplate((ItemLike)Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE, Items.COBBLED_DEEPSLATE);
        this.copySmithingTemplate((ItemLike)Items.EYE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.END_STONE);
        this.copySmithingTemplate((ItemLike)Items.VEX_ARMOR_TRIM_SMITHING_TEMPLATE, Items.COBBLESTONE);
        this.copySmithingTemplate((ItemLike)Items.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.PRISMARINE);
        this.copySmithingTemplate((ItemLike)Items.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE, Items.BLACKSTONE);
        this.copySmithingTemplate((ItemLike)Items.RIB_ARMOR_TRIM_SMITHING_TEMPLATE, Items.NETHERRACK);
        this.copySmithingTemplate((ItemLike)Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.PURPUR_BLOCK);
        this.copySmithingTemplate((ItemLike)Items.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.COBBLED_DEEPSLATE);
        this.copySmithingTemplate((ItemLike)Items.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE, Items.TERRACOTTA);
        this.copySmithingTemplate((ItemLike)Items.SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE, Items.TERRACOTTA);
        this.copySmithingTemplate((ItemLike)Items.RAISER_ARMOR_TRIM_SMITHING_TEMPLATE, Items.TERRACOTTA);
        this.copySmithingTemplate((ItemLike)Items.HOST_ARMOR_TRIM_SMITHING_TEMPLATE, Items.TERRACOTTA);
        this.copySmithingTemplate((ItemLike)Items.FLOW_ARMOR_TRIM_SMITHING_TEMPLATE, Items.BREEZE_ROD);
        this.copySmithingTemplate((ItemLike)Items.BOLT_ARMOR_TRIM_SMITHING_TEMPLATE, Ingredient.of(Items.COPPER_BLOCK, Items.WAXED_COPPER_BLOCK));
        this.threeByThreePacker(RecipeCategory.BUILDING_BLOCKS, Blocks.BAMBOO_BLOCK, Items.BAMBOO);
        this.planksFromLogs(Blocks.BAMBOO_PLANKS, ItemTags.BAMBOO_BLOCKS, 2);
        this.mosaicBuilder(RecipeCategory.DECORATIONS, Blocks.BAMBOO_MOSAIC, Blocks.BAMBOO_SLAB);
        this.woodenBoat(Items.BAMBOO_RAFT, Blocks.BAMBOO_PLANKS);
        this.chestBoat(Items.BAMBOO_CHEST_RAFT, Items.BAMBOO_RAFT);
        this.hangingSign(Items.OAK_HANGING_SIGN, Blocks.STRIPPED_OAK_LOG);
        this.hangingSign(Items.SPRUCE_HANGING_SIGN, Blocks.STRIPPED_SPRUCE_LOG);
        this.hangingSign(Items.BIRCH_HANGING_SIGN, Blocks.STRIPPED_BIRCH_LOG);
        this.hangingSign(Items.JUNGLE_HANGING_SIGN, Blocks.STRIPPED_JUNGLE_LOG);
        this.hangingSign(Items.ACACIA_HANGING_SIGN, Blocks.STRIPPED_ACACIA_LOG);
        this.hangingSign(Items.CHERRY_HANGING_SIGN, Blocks.STRIPPED_CHERRY_LOG);
        this.hangingSign(Items.DARK_OAK_HANGING_SIGN, Blocks.STRIPPED_DARK_OAK_LOG);
        this.hangingSign(Items.PALE_OAK_HANGING_SIGN, Blocks.STRIPPED_PALE_OAK_LOG);
        this.hangingSign(Items.MANGROVE_HANGING_SIGN, Blocks.STRIPPED_MANGROVE_LOG);
        this.hangingSign(Items.BAMBOO_HANGING_SIGN, Items.STRIPPED_BAMBOO_BLOCK);
        this.hangingSign(Items.CRIMSON_HANGING_SIGN, Blocks.STRIPPED_CRIMSON_STEM);
        this.hangingSign(Items.WARPED_HANGING_SIGN, Blocks.STRIPPED_WARPED_STEM);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_BOOKSHELF).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('X'), ItemTags.WOODEN_SLABS).pattern("###").pattern("XXX").pattern("###").unlockedBy("has_book", (Criterion)this.has(Items.BOOK)).save(this.output);
        this.oneToOneConversionRecipe(Items.ORANGE_DYE, Blocks.TORCHFLOWER, "orange_dye");
        this.oneToOneConversionRecipe(Items.CYAN_DYE, Blocks.PITCHER_PLANT, "cyan_dye", 2);
        this.planksFromLog(Blocks.CHERRY_PLANKS, ItemTags.CHERRY_LOGS, 4);
        this.woodFromLogs(Blocks.CHERRY_WOOD, Blocks.CHERRY_LOG);
        this.woodFromLogs(Blocks.STRIPPED_CHERRY_WOOD, Blocks.STRIPPED_CHERRY_LOG);
        this.woodenBoat(Items.CHERRY_BOAT, Blocks.CHERRY_PLANKS);
        this.chestBoat(Items.CHERRY_CHEST_BOAT, Items.CHERRY_BOAT);
        this.oneToOneConversionRecipe(Items.PINK_DYE, Items.PINK_PETALS, "pink_dye", 1);
        this.shaped(RecipeCategory.TOOLS, Items.BRUSH).define(Character.valueOf('X'), Items.FEATHER).define(Character.valueOf('#'), Items.COPPER_INGOT).define(Character.valueOf('I'), Items.STICK).pattern("X").pattern("#").pattern("I").unlockedBy("has_copper_ingot", (Criterion)this.has(Items.COPPER_INGOT)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, Items.DECORATED_POT).define(Character.valueOf('#'), Items.BRICK).pattern(" # ").pattern("# #").pattern(" # ").unlockedBy("has_brick", (Criterion)this.has(ItemTags.DECORATED_POT_INGREDIENTS)).save(this.output, "decorated_pot_simple");
        SpecialRecipeBuilder.special(DecoratedPotRecipe::new).save(this.output, "decorated_pot");
        this.shaped(RecipeCategory.REDSTONE, Blocks.CRAFTER).define(Character.valueOf('#'), Items.IRON_INGOT).define(Character.valueOf('C'), Items.CRAFTING_TABLE).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('D'), Items.DROPPER).pattern("###").pattern("#C#").pattern("RDR").unlockedBy("has_dropper", (Criterion)this.has(Items.DROPPER)).save(this.output);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.TUFF_SLAB, Blocks.TUFF, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.TUFF_STAIRS, Blocks.TUFF);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.TUFF_WALL, Blocks.TUFF);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_TUFF, Blocks.TUFF);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_TUFF, Blocks.TUFF);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_TUFF_SLAB, Blocks.TUFF, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_TUFF_STAIRS, Blocks.TUFF);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.POLISHED_TUFF_WALL, Blocks.TUFF);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.TUFF_BRICKS, Blocks.TUFF);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.TUFF_BRICK_SLAB, Blocks.TUFF, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.TUFF_BRICK_STAIRS, Blocks.TUFF);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.TUFF_BRICK_WALL, Blocks.TUFF);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_TUFF_BRICKS, Blocks.TUFF);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_TUFF_SLAB, Blocks.POLISHED_TUFF, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_TUFF_STAIRS, Blocks.POLISHED_TUFF);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.POLISHED_TUFF_WALL, Blocks.POLISHED_TUFF);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.TUFF_BRICKS, Blocks.POLISHED_TUFF);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.TUFF_BRICK_SLAB, Blocks.POLISHED_TUFF, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.TUFF_BRICK_STAIRS, Blocks.POLISHED_TUFF);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.TUFF_BRICK_WALL, Blocks.POLISHED_TUFF);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_TUFF_BRICKS, Blocks.POLISHED_TUFF);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.TUFF_BRICK_SLAB, Blocks.TUFF_BRICKS, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.TUFF_BRICK_STAIRS, Blocks.TUFF_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, Blocks.TUFF_BRICK_WALL, Blocks.TUFF_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_TUFF_BRICKS, Blocks.TUFF_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_COPPER, Blocks.COPPER_BLOCK, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.EXPOSED_CHISELED_COPPER, Blocks.EXPOSED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WEATHERED_CHISELED_COPPER, Blocks.WEATHERED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.OXIDIZED_CHISELED_COPPER, Blocks.OXIDIZED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_CHISELED_COPPER, Blocks.WAXED_COPPER_BLOCK, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_EXPOSED_CHISELED_COPPER, Blocks.WAXED_EXPOSED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_WEATHERED_CHISELED_COPPER, Blocks.WAXED_WEATHERED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_OXIDIZED_CHISELED_COPPER, Blocks.WAXED_OXIDIZED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_COPPER, Blocks.CUT_COPPER, 1);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.EXPOSED_CHISELED_COPPER, Blocks.EXPOSED_CUT_COPPER, 1);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WEATHERED_CHISELED_COPPER, Blocks.WEATHERED_CUT_COPPER, 1);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.OXIDIZED_CHISELED_COPPER, Blocks.OXIDIZED_CUT_COPPER, 1);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_CHISELED_COPPER, Blocks.WAXED_CUT_COPPER, 1);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_EXPOSED_CHISELED_COPPER, Blocks.WAXED_EXPOSED_CUT_COPPER, 1);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_WEATHERED_CHISELED_COPPER, Blocks.WAXED_WEATHERED_CUT_COPPER, 1);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_OXIDIZED_CHISELED_COPPER, Blocks.WAXED_OXIDIZED_CUT_COPPER, 1);
        this.grate(Blocks.COPPER_GRATE, Blocks.COPPER_BLOCK);
        this.grate(Blocks.EXPOSED_COPPER_GRATE, Blocks.EXPOSED_COPPER);
        this.grate(Blocks.WEATHERED_COPPER_GRATE, Blocks.WEATHERED_COPPER);
        this.grate(Blocks.OXIDIZED_COPPER_GRATE, Blocks.OXIDIZED_COPPER);
        this.grate(Blocks.WAXED_COPPER_GRATE, Blocks.WAXED_COPPER_BLOCK);
        this.grate(Blocks.WAXED_EXPOSED_COPPER_GRATE, Blocks.WAXED_EXPOSED_COPPER);
        this.grate(Blocks.WAXED_WEATHERED_COPPER_GRATE, Blocks.WAXED_WEATHERED_COPPER);
        this.grate(Blocks.WAXED_OXIDIZED_COPPER_GRATE, Blocks.WAXED_OXIDIZED_COPPER);
        this.copperBulb(Blocks.COPPER_BULB, Blocks.COPPER_BLOCK);
        this.copperBulb(Blocks.EXPOSED_COPPER_BULB, Blocks.EXPOSED_COPPER);
        this.copperBulb(Blocks.WEATHERED_COPPER_BULB, Blocks.WEATHERED_COPPER);
        this.copperBulb(Blocks.OXIDIZED_COPPER_BULB, Blocks.OXIDIZED_COPPER);
        this.copperBulb(Blocks.WAXED_COPPER_BULB, Blocks.WAXED_COPPER_BLOCK);
        this.copperBulb(Blocks.WAXED_EXPOSED_COPPER_BULB, Blocks.WAXED_EXPOSED_COPPER);
        this.copperBulb(Blocks.WAXED_WEATHERED_COPPER_BULB, Blocks.WAXED_WEATHERED_COPPER);
        this.copperBulb(Blocks.WAXED_OXIDIZED_COPPER_BULB, Blocks.WAXED_OXIDIZED_COPPER);
        this.waxedChiseled(Blocks.WAXED_CHISELED_COPPER, Blocks.WAXED_CUT_COPPER_SLAB);
        this.waxedChiseled(Blocks.WAXED_EXPOSED_CHISELED_COPPER, Blocks.WAXED_EXPOSED_CUT_COPPER_SLAB);
        this.waxedChiseled(Blocks.WAXED_WEATHERED_CHISELED_COPPER, Blocks.WAXED_WEATHERED_CUT_COPPER_SLAB);
        this.waxedChiseled(Blocks.WAXED_OXIDIZED_CHISELED_COPPER, Blocks.WAXED_OXIDIZED_CUT_COPPER_SLAB);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.COPPER_GRATE, Blocks.COPPER_BLOCK, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.EXPOSED_COPPER_GRATE, Blocks.EXPOSED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WEATHERED_COPPER_GRATE, Blocks.WEATHERED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.OXIDIZED_COPPER_GRATE, Blocks.OXIDIZED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_COPPER_GRATE, Blocks.WAXED_COPPER_BLOCK, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_EXPOSED_COPPER_GRATE, Blocks.WAXED_EXPOSED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_WEATHERED_COPPER_GRATE, Blocks.WAXED_WEATHERED_COPPER, 4);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_OXIDIZED_COPPER_GRATE, Blocks.WAXED_OXIDIZED_COPPER, 4);
        this.shapeless(RecipeCategory.MISC, Items.WIND_CHARGE, 4).requires(Items.BREEZE_ROD).unlockedBy("has_breeze_rod", (Criterion)this.has(Items.BREEZE_ROD)).save(this.output);
        ((ShapedRecipeBuilder)this.shaped(RecipeCategory.COMBAT, Items.MACE, 1).define(Character.valueOf('I'), Items.BREEZE_ROD).define(Character.valueOf('#'), Blocks.HEAVY_CORE).pattern(" # ").pattern(" I ").unlockedBy("has_breeze_rod", (Criterion)this.has(Items.BREEZE_ROD))).unlockedBy("has_heavy_core", (Criterion)this.has(Blocks.HEAVY_CORE)).save(this.output);
        this.doorBuilder(Blocks.COPPER_DOOR, Ingredient.of((ItemLike)Items.COPPER_INGOT)).unlockedBy(VanillaRecipeProvider.getHasName(Items.COPPER_INGOT), this.has(Items.COPPER_INGOT)).save(this.output);
        this.twoByTwoPacker(RecipeCategory.REDSTONE, Blocks.COPPER_TRAPDOOR, Items.COPPER_INGOT);
        this.shaped(RecipeCategory.TOOLS, Items.BUNDLE).define(Character.valueOf('-'), Items.STRING).define(Character.valueOf('#'), Items.LEATHER).pattern("-").pattern("#").unlockedBy("has_string", (Criterion)this.has(Items.STRING)).save(this.output);
        this.bundleRecipes();
    }

    public static Stream<TrimTemplate> smithingTrims() {
        return Stream.of(Pair.of((Object)Items.BOLT_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.BOLT), Pair.of((Object)Items.COAST_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.COAST), Pair.of((Object)Items.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.DUNE), Pair.of((Object)Items.EYE_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.EYE), Pair.of((Object)Items.FLOW_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.FLOW), Pair.of((Object)Items.HOST_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.HOST), Pair.of((Object)Items.RAISER_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.RAISER), Pair.of((Object)Items.RIB_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.RIB), Pair.of((Object)Items.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.SENTRY), Pair.of((Object)Items.SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.SHAPER), Pair.of((Object)Items.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.SILENCE), Pair.of((Object)Items.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.SNOUT), Pair.of((Object)Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.SPIRE), Pair.of((Object)Items.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.TIDE), Pair.of((Object)Items.VEX_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.VEX), Pair.of((Object)Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.WARD), Pair.of((Object)Items.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.WAYFINDER), Pair.of((Object)Items.WILD_ARMOR_TRIM_SMITHING_TEMPLATE, TrimPatterns.WILD)).map(pair -> {
            Item item = (Item)pair.getFirst();
            ResourceKey resourceKey = (ResourceKey)pair.getSecond();
            ResourceKey<Recipe<?>> resourceKey1 = ResourceKey.create(Registries.RECIPE, Identifier.withDefaultNamespace(VanillaRecipeProvider.getItemName(item) + "_smithing_trim"));
            return new TrimTemplate(item, resourceKey, resourceKey1);
        });
    }

    private void shulkerBoxRecipes() {
        Ingredient ingredient = this.tag(ItemTags.SHULKER_BOXES);
        for (DyeColor dyeColor : DyeColor.values()) {
            TransmuteRecipeBuilder.transmute(RecipeCategory.DECORATIONS, ingredient, Ingredient.of((ItemLike)DyeItem.byColor(dyeColor)), ShulkerBoxBlock.getBlockByColor(dyeColor).asItem()).group("shulker_box_dye").unlockedBy("has_shulker_box", (Criterion)this.has(ItemTags.SHULKER_BOXES)).save(this.output);
        }
    }

    private void bundleRecipes() {
        Ingredient ingredient = this.tag(ItemTags.BUNDLES);
        for (DyeColor dyeColor : DyeColor.values()) {
            DyeItem dyeItem = DyeItem.byColor(dyeColor);
            TransmuteRecipeBuilder.transmute(RecipeCategory.TOOLS, ingredient, Ingredient.of((ItemLike)dyeItem), BundleItem.getByColor(dyeColor)).group("bundle_dye").unlockedBy(VanillaRecipeProvider.getHasName(dyeItem), (Criterion)this.has(dyeItem)).save(this.output);
        }
    }

    public record TrimTemplate(Item template, ResourceKey<TrimPattern> patternId, ResourceKey<Recipe<?>> recipeId) {
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
            super(packOutput, registries);
        }

        @Override
        protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            return new VanillaRecipeProvider(registries, output);
        }

        @Override
        public String getName() {
            return "Vanilla Recipes";
        }
    }
}

