/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.Util;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class SnbtToNbt
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput output;
    private final Iterable<Path> inputFolders;
    private final List<Filter> filters = Lists.newArrayList();

    public SnbtToNbt(PackOutput output, Iterable<Path> inputFolders) {
        this.output = output;
        this.inputFolders = inputFolders;
    }

    public SnbtToNbt addFilter(Filter filter) {
        this.filters.add(filter);
        return this;
    }

    private CompoundTag applyFilters(String fileName, CompoundTag tag) {
        CompoundTag compoundTag = tag;
        for (Filter filter : this.filters) {
            compoundTag = filter.apply(fileName, compoundTag);
        }
        return compoundTag;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput output) {
        Path outputFolder = this.output.getOutputFolder();
        ArrayList list = Lists.newArrayList();
        for (Path path : this.inputFolders) {
            list.add(CompletableFuture.supplyAsync(() -> {
                try {
                    CompletableFuture<Void> var5x;
                    try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                        var5x = CompletableFuture.allOf((CompletableFuture[])stream.filter(path1 -> path1.toString().endsWith(".snbt")).map(path1 -> CompletableFuture.runAsync(() -> {
                            TaskResult structure = this.readStructure((Path)path1, this.getName(path, (Path)path1));
                            this.storeStructureIfChanged(output, structure, outputFolder);
                        }, Util.backgroundExecutor().forName("SnbtToNbt"))).toArray(CompletableFuture[]::new));
                    }
                    return var5x;
                }
                catch (Exception var9) {
                    throw new RuntimeException("Failed to read structure input directory, aborting", var9);
                }
            }, Util.backgroundExecutor().forName("SnbtToNbt")).thenCompose(completableFuture -> completableFuture));
        }
        return Util.sequenceFailFast(list);
    }

    @Override
    public final String getName() {
        return "SNBT -> NBT";
    }

    private String getName(Path inputFolder, Path filePath) {
        String string = inputFolder.relativize(filePath).toString().replaceAll("\\\\", "/");
        return string.substring(0, string.length() - ".snbt".length());
    }

    private TaskResult readStructure(Path filePath, String fileName) {
        try {
            TaskResult var10;
            try (BufferedReader bufferedReader = Files.newBufferedReader(filePath);){
                String string = IOUtils.toString((Reader)bufferedReader);
                CompoundTag compoundTag = this.applyFilters(fileName, NbtUtils.snbtToStructure(string));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
                NbtIo.writeCompressed(compoundTag, (OutputStream)hashingOutputStream);
                byte[] bytes = byteArrayOutputStream.toByteArray();
                HashCode hashCode = hashingOutputStream.hash();
                var10 = new TaskResult(fileName, bytes, hashCode);
            }
            return var10;
        }
        catch (Throwable var13) {
            throw new StructureConversionException(filePath, var13);
        }
    }

    private void storeStructureIfChanged(CachedOutput output, TaskResult taskResult, Path directoryPath) {
        Path path = directoryPath.resolve(taskResult.name + ".nbt");
        try {
            output.writeIfNeeded(path, taskResult.payload, taskResult.hash);
        }
        catch (IOException var6) {
            LOGGER.error("Couldn't write structure {} at {}", new Object[]{taskResult.name, path, var6});
        }
    }

    @FunctionalInterface
    public static interface Filter {
        public CompoundTag apply(String var1, CompoundTag var2);
    }

    record TaskResult(String name, byte[] payload, HashCode hash) {
    }

    static class StructureConversionException
    extends RuntimeException {
        public StructureConversionException(Path path, Throwable cause) {
            super(path.toAbsolutePath().toString(), cause);
        }
    }
}

