/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Rotation;

public class GameTestBatchFactory {
    private static final int MAX_TESTS_PER_BATCH = 50;
    public static final TestDecorator DIRECT = (instance, level) -> Stream.of(new GameTestInfo(instance, Rotation.NONE, level, RetryOptions.noRetries()));

    public static List<GameTestBatch> divideIntoBatches(Collection<Holder.Reference<GameTestInstance>> instances, TestDecorator decorator, ServerLevel level) {
        Map<Holder, List<GameTestInfo>> map = instances.stream().flatMap(instance -> decorator.decorate((Holder.Reference<GameTestInstance>)instance, level)).collect(Collectors.groupingBy(testInfo -> testInfo.getTest().batch()));
        return map.entrySet().stream().flatMap(entry -> {
            Holder holder = (Holder)entry.getKey();
            List list = (List)entry.getValue();
            return Streams.mapWithIndex(Lists.partition((List)list, (int)50).stream(), (gameTestInfos, index) -> GameTestBatchFactory.toGameTestBatch(gameTestInfos, holder, (int)index));
        }).toList();
    }

    public static GameTestRunner.GameTestBatcher fromGameTestInfo() {
        return GameTestBatchFactory.fromGameTestInfo(50);
    }

    public static GameTestRunner.GameTestBatcher fromGameTestInfo(int maxTests) {
        return infos -> {
            Map<Holder, List<GameTestInfo>> map = infos.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(gameTestInfo -> gameTestInfo.getTest().batch()));
            return map.entrySet().stream().flatMap(entry -> {
                Holder holder = (Holder)entry.getKey();
                List list = (List)entry.getValue();
                return Streams.mapWithIndex(Lists.partition((List)list, (int)maxTests).stream(), (list1, l) -> GameTestBatchFactory.toGameTestBatch(List.copyOf(list1), holder, (int)l));
            }).toList();
        };
    }

    public static GameTestBatch toGameTestBatch(Collection<GameTestInfo> gameTestInfos, Holder<TestEnvironmentDefinition> environment, int index) {
        return new GameTestBatch(index, gameTestInfos, environment);
    }

    @FunctionalInterface
    public static interface TestDecorator {
        public Stream<GameTestInfo> decorate(Holder.Reference<GameTestInstance> var1, ServerLevel var2);
    }
}

