/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gizmos;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gizmos.ArrowGizmo;
import net.minecraft.gizmos.CircleGizmo;
import net.minecraft.gizmos.CuboidGizmo;
import net.minecraft.gizmos.Gizmo;
import net.minecraft.gizmos.GizmoCollector;
import net.minecraft.gizmos.GizmoProperties;
import net.minecraft.gizmos.GizmoStyle;
import net.minecraft.gizmos.LineGizmo;
import net.minecraft.gizmos.PointGizmo;
import net.minecraft.gizmos.RectGizmo;
import net.minecraft.gizmos.TextGizmo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class Gizmos {
    static final ThreadLocal<@Nullable GizmoCollector> collector = new ThreadLocal();

    private Gizmos() {
    }

    public static TemporaryCollection withCollector(GizmoCollector collector) {
        TemporaryCollection temporaryCollection = new TemporaryCollection();
        Gizmos.collector.set(collector);
        return temporaryCollection;
    }

    public static GizmoProperties addGizmo(Gizmo gizmo) {
        GizmoCollector gizmoCollector = collector.get();
        if (gizmoCollector == null) {
            throw new IllegalStateException("Gizmos cannot be created here! No GizmoCollector has been registered.");
        }
        return gizmoCollector.add(gizmo);
    }

    public static GizmoProperties cuboid(AABB aabb, GizmoStyle style) {
        return Gizmos.cuboid(aabb, style, false);
    }

    public static GizmoProperties cuboid(AABB aabb, GizmoStyle style, boolean coloredCornerStroke) {
        return Gizmos.addGizmo(new CuboidGizmo(aabb, style, coloredCornerStroke));
    }

    public static GizmoProperties cuboid(BlockPos pos, GizmoStyle style) {
        return Gizmos.cuboid(new AABB(pos), style);
    }

    public static GizmoProperties cuboid(BlockPos pos, float margin, GizmoStyle style) {
        return Gizmos.cuboid(new AABB(pos).inflate(margin), style);
    }

    public static GizmoProperties circle(Vec3 pos, float radius, GizmoStyle style) {
        return Gizmos.addGizmo(new CircleGizmo(pos, radius, style));
    }

    public static GizmoProperties line(Vec3 start, Vec3 end, int color) {
        return Gizmos.addGizmo(new LineGizmo(start, end, color, 3.0f));
    }

    public static GizmoProperties line(Vec3 start, Vec3 end, int color, float width) {
        return Gizmos.addGizmo(new LineGizmo(start, end, color, width));
    }

    public static GizmoProperties arrow(Vec3 start, Vec3 end, int color) {
        return Gizmos.addGizmo(new ArrowGizmo(start, end, color, 2.5f));
    }

    public static GizmoProperties arrow(Vec3 start, Vec3 end, int color, float width) {
        return Gizmos.addGizmo(new ArrowGizmo(start, end, color, width));
    }

    public static GizmoProperties rect(Vec3 pos1, Vec3 pos2, Direction face, GizmoStyle style) {
        return Gizmos.addGizmo(RectGizmo.fromCuboidFace(pos1, pos2, face, style));
    }

    public static GizmoProperties rect(Vec3 a, Vec3 b, Vec3 c, Vec3 d, GizmoStyle style) {
        return Gizmos.addGizmo(new RectGizmo(a, b, c, d, style));
    }

    public static GizmoProperties point(Vec3 pos, int color, float size) {
        return Gizmos.addGizmo(new PointGizmo(pos, color, size));
    }

    public static GizmoProperties billboardTextOverBlock(String text, BlockPos pos, int line, int color, float scale) {
        double d = 1.3;
        double d1 = 0.2;
        GizmoProperties gizmoProperties = Gizmos.billboardText(text, Vec3.atLowerCornerWithOffset(pos, 0.5, 1.3 + (double)line * 0.2, 0.5), TextGizmo.Style.forColorAndCentered(color).withScale(scale));
        gizmoProperties.setAlwaysOnTop();
        return gizmoProperties;
    }

    public static GizmoProperties billboardTextOverMob(Entity entity, int line, String text, int color, float scale) {
        double d = 2.4;
        double d1 = 0.25;
        double d2 = (double)entity.getBlockX() + 0.5;
        double d3 = entity.getY() + 2.4 + (double)line * 0.25;
        double d4 = (double)entity.getBlockZ() + 0.5;
        float f = 0.5f;
        GizmoProperties gizmoProperties = Gizmos.billboardText(text, new Vec3(d2, d3, d4), TextGizmo.Style.forColor(color).withScale(scale).withLeftAlignment(0.5f));
        gizmoProperties.setAlwaysOnTop();
        return gizmoProperties;
    }

    public static GizmoProperties billboardText(String text, Vec3 pos, TextGizmo.Style style) {
        return Gizmos.addGizmo(new TextGizmo(pos, text, style));
    }

    public static class TemporaryCollection
    implements AutoCloseable {
        private final @Nullable GizmoCollector old = collector.get();
        private boolean closed;

        TemporaryCollection() {
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                collector.set(this.old);
            }
        }
    }
}

