/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.locale;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.minecraft.locale.Language;
import net.minecraft.util.StrictJsonParser;
import org.slf4j.Logger;

public record DeprecatedTranslationsInfo(List<String> removed, Map<String, String> renamed) {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeprecatedTranslationsInfo EMPTY = new DeprecatedTranslationsInfo(List.of(), Map.of());
    public static final Codec<DeprecatedTranslationsInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("removed").forGetter(DeprecatedTranslationsInfo::removed), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("renamed").forGetter(DeprecatedTranslationsInfo::renamed)).apply((Applicative)instance, DeprecatedTranslationsInfo::new));

    public static DeprecatedTranslationsInfo loadFromJson(InputStream inputStream) {
        JsonElement jsonElement = StrictJsonParser.parse(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        return (DeprecatedTranslationsInfo)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(string -> new IllegalStateException("Failed to parse deprecated language data: " + string));
    }

    public static DeprecatedTranslationsInfo loadFromResource(String name) {
        DeprecatedTranslationsInfo deprecatedTranslationsInfo;
        block8: {
            InputStream resourceAsStream = Language.class.getResourceAsStream(name);
            try {
                DeprecatedTranslationsInfo deprecatedTranslationsInfo2 = deprecatedTranslationsInfo = resourceAsStream != null ? DeprecatedTranslationsInfo.loadFromJson(resourceAsStream) : EMPTY;
                if (resourceAsStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception var6) {
                    LOGGER.error("Failed to read {}", (Object)name, (Object)var6);
                    return EMPTY;
                }
            }
            resourceAsStream.close();
        }
        return deprecatedTranslationsInfo;
    }

    public static DeprecatedTranslationsInfo loadFromDefaultResource() {
        return DeprecatedTranslationsInfo.loadFromResource("/assets/minecraft/lang/deprecated.json");
    }

    public void applyToMap(Map<String, String> translations) {
        for (String string : this.removed) {
            translations.remove(string);
        }
        this.renamed.forEach((string1, string2) -> {
            String string3 = (String)translations.remove(string1);
            if (string3 == null) {
                LOGGER.warn("Missing translation key for rename: {}", string1);
                translations.remove(string2);
            } else {
                translations.put((String)string2, string3);
            }
        });
    }
}

