/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TagVisitor;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public final class CompoundTag
implements Tag {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<CompoundTag> CODEC = Codec.PASSTHROUGH.comapFlatMap(tag -> {
        CompoundTag compoundTag;
        Tag tag1 = tag.convert(NbtOps.INSTANCE).getValue();
        return tag1 instanceof CompoundTag ? DataResult.success((Object)((compoundTag = (CompoundTag)tag1) == tag.getValue() ? compoundTag.copy() : compoundTag)) : DataResult.error(() -> "Not a compound tag: " + String.valueOf(tag1));
    }, tag -> new Dynamic<CompoundTag>(NbtOps.INSTANCE, tag.copy()));
    private static final int SELF_SIZE_IN_BYTES = 48;
    private static final int MAP_ENTRY_SIZE_IN_BYTES = 32;
    public static final TagType<CompoundTag> TYPE = new TagType.VariableSize<CompoundTag>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompoundTag load(DataInput input, NbtAccounter accounter) throws IOException {
            CompoundTag var3;
            accounter.pushDepth();
            try {
                var3 = 1.loadCompound(input, accounter);
            }
            finally {
                accounter.popDepth();
            }
            return var3;
        }

        private static CompoundTag loadCompound(DataInput input, NbtAccounter nbtAccounter) throws IOException {
            byte b;
            nbtAccounter.accountBytes(48L);
            Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(8, 0.8f);
            while ((b = input.readByte()) != 0) {
                Tag namedTagData;
                String string = 1.readString(input, nbtAccounter);
                if (map.put((Object)string, (Object)(namedTagData = CompoundTag.readNamedTagData(TagTypes.getType(b), string, input, nbtAccounter))) != null) continue;
                nbtAccounter.accountBytes(36L);
            }
            return new CompoundTag((Map<String, Tag>)map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput input, StreamTagVisitor visitor, NbtAccounter accounter) throws IOException {
            StreamTagVisitor.ValueResult var4;
            accounter.pushDepth();
            try {
                var4 = 1.parseCompound(input, visitor, accounter);
            }
            finally {
                accounter.popDepth();
            }
            return var4;
        }

        private static StreamTagVisitor.ValueResult parseCompound(DataInput input, StreamTagVisitor visitor, NbtAccounter nbtAccounter) throws IOException {
            byte b;
            nbtAccounter.accountBytes(48L);
            block13: while ((b = input.readByte()) != 0) {
                TagType<?> type = TagTypes.getType(b);
                switch (visitor.visitEntry(type)) {
                    case HALT: {
                        return StreamTagVisitor.ValueResult.HALT;
                    }
                    case BREAK: {
                        StringTag.skipString(input);
                        type.skip(input, nbtAccounter);
                        break block13;
                    }
                    case SKIP: {
                        StringTag.skipString(input);
                        type.skip(input, nbtAccounter);
                        continue block13;
                    }
                    default: {
                        String string = 1.readString(input, nbtAccounter);
                        switch (visitor.visitEntry(type, string)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                            case BREAK: {
                                type.skip(input, nbtAccounter);
                                break block13;
                            }
                            case SKIP: {
                                type.skip(input, nbtAccounter);
                                continue block13;
                            }
                        }
                        nbtAccounter.accountBytes(36L);
                        switch (type.parse(input, visitor, nbtAccounter)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                        }
                        continue block13;
                    }
                }
            }
            if (b != 0) {
                while ((b = input.readByte()) != 0) {
                    StringTag.skipString(input);
                    TagTypes.getType(b).skip(input, nbtAccounter);
                }
            }
            return visitor.visitContainerEnd();
        }

        private static String readString(DataInput input, NbtAccounter accounter) throws IOException {
            String utf = input.readUTF();
            accounter.accountBytes(28L);
            accounter.accountBytes(2L, utf.length());
            return utf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skip(DataInput input, NbtAccounter accounter) throws IOException {
            accounter.pushDepth();
            try {
                byte b;
                while ((b = input.readByte()) != 0) {
                    StringTag.skipString(input);
                    TagTypes.getType(b).skip(input, accounter);
                }
            }
            finally {
                accounter.popDepth();
            }
        }

        @Override
        public String getName() {
            return "COMPOUND";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Compound";
        }
    };
    private final Map<String, Tag> tags;

    CompoundTag(Map<String, Tag> tags) {
        this.tags = tags;
    }

    public CompoundTag() {
        this((Map<String, Tag>)new Object2ObjectOpenHashMap(8, 0.8f));
    }

    @Override
    public void write(DataOutput output) throws IOException {
        for (String string : this.tags.keySet()) {
            Tag tag = this.tags.get(string);
            CompoundTag.writeNamedTag(string, tag, output);
        }
        output.writeByte(0);
    }

    @Override
    public int sizeInBytes() {
        int i = 48;
        for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
            i += 28 + 2 * entry.getKey().length();
            i += 36;
            i += entry.getValue().sizeInBytes();
        }
        return i;
    }

    public Set<String> keySet() {
        return this.tags.keySet();
    }

    public Set<Map.Entry<String, Tag>> entrySet() {
        return this.tags.entrySet();
    }

    public Collection<Tag> values() {
        return this.tags.values();
    }

    public void forEach(BiConsumer<String, Tag> action) {
        this.tags.forEach(action);
    }

    @Override
    public byte getId() {
        return 10;
    }

    public TagType<CompoundTag> getType() {
        return TYPE;
    }

    public int size() {
        return this.tags.size();
    }

    public @Nullable Tag put(String key, Tag value) {
        return this.tags.put(key, value);
    }

    public void putByte(String key, byte value) {
        this.tags.put(key, ByteTag.valueOf(value));
    }

    public void putShort(String key, short value) {
        this.tags.put(key, ShortTag.valueOf(value));
    }

    public void putInt(String key, int value) {
        this.tags.put(key, IntTag.valueOf(value));
    }

    public void putLong(String key, long value) {
        this.tags.put(key, LongTag.valueOf(value));
    }

    public void putFloat(String key, float value) {
        this.tags.put(key, FloatTag.valueOf(value));
    }

    public void putDouble(String key, double value) {
        this.tags.put(key, DoubleTag.valueOf(value));
    }

    public void putString(String key, String value) {
        this.tags.put(key, StringTag.valueOf(value));
    }

    public void putByteArray(String key, byte[] value) {
        this.tags.put(key, new ByteArrayTag(value));
    }

    public void putIntArray(String key, int[] value) {
        this.tags.put(key, new IntArrayTag(value));
    }

    public void putLongArray(String key, long[] value) {
        this.tags.put(key, new LongArrayTag(value));
    }

    public void putBoolean(String key, boolean value) {
        this.tags.put(key, ByteTag.valueOf(value));
    }

    public @Nullable Tag get(String key) {
        return this.tags.get(key);
    }

    public boolean contains(String key) {
        return this.tags.containsKey(key);
    }

    private Optional<Tag> getOptional(String key) {
        return Optional.ofNullable(this.tags.get(key));
    }

    public Optional<Byte> getByte(String key) {
        return this.getOptional(key).flatMap(Tag::asByte);
    }

    public byte getByteOr(String key, byte defaultValue) {
        byte by;
        Tag tag = this.tags.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            by = numericTag.byteValue();
        } else {
            by = defaultValue;
        }
        return by;
    }

    public Optional<Short> getShort(String key) {
        return this.getOptional(key).flatMap(Tag::asShort);
    }

    public short getShortOr(String key, short defaultValue) {
        short s;
        Tag tag = this.tags.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            s = numericTag.shortValue();
        } else {
            s = defaultValue;
        }
        return s;
    }

    public Optional<Integer> getInt(String key) {
        return this.getOptional(key).flatMap(Tag::asInt);
    }

    public int getIntOr(String key, int defaultValue) {
        int n;
        Tag tag = this.tags.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            n = numericTag.intValue();
        } else {
            n = defaultValue;
        }
        return n;
    }

    public Optional<Long> getLong(String key) {
        return this.getOptional(key).flatMap(Tag::asLong);
    }

    public long getLongOr(String key, long defaultValue) {
        long l;
        Tag tag = this.tags.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            l = numericTag.longValue();
        } else {
            l = defaultValue;
        }
        return l;
    }

    public Optional<Float> getFloat(String key) {
        return this.getOptional(key).flatMap(Tag::asFloat);
    }

    public float getFloatOr(String key, float defaultValue) {
        float f;
        Tag tag = this.tags.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            f = numericTag.floatValue();
        } else {
            f = defaultValue;
        }
        return f;
    }

    public Optional<Double> getDouble(String key) {
        return this.getOptional(key).flatMap(Tag::asDouble);
    }

    public double getDoubleOr(String key, double defaultValue) {
        double d;
        Tag tag = this.tags.get(key);
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            d = numericTag.doubleValue();
        } else {
            d = defaultValue;
        }
        return d;
    }

    public Optional<String> getString(String key) {
        return this.getOptional(key).flatMap(Tag::asString);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getStringOr(String key, String defaultValue) {
        String string;
        Tag tag = this.tags.get(key);
        if (!(tag instanceof StringTag)) {
            string = defaultValue;
            return string;
        }
        StringTag stringTag = (StringTag)tag;
        try {
            String string2;
            String var8;
            string = var8 = (string2 = stringTag.value());
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public Optional<byte[]> getByteArray(String key) {
        Optional<byte[]> optional;
        Tag tag = this.tags.get(key);
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag byteArrayTag = (ByteArrayTag)tag;
            optional = Optional.of(byteArrayTag.getAsByteArray());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Optional<int[]> getIntArray(String key) {
        Optional<int[]> optional;
        Tag tag = this.tags.get(key);
        if (tag instanceof IntArrayTag) {
            IntArrayTag intArrayTag = (IntArrayTag)tag;
            optional = Optional.of(intArrayTag.getAsIntArray());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Optional<long[]> getLongArray(String key) {
        Optional<long[]> optional;
        Tag tag = this.tags.get(key);
        if (tag instanceof LongArrayTag) {
            LongArrayTag longArrayTag = (LongArrayTag)tag;
            optional = Optional.of(longArrayTag.getAsLongArray());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Optional<CompoundTag> getCompound(String key) {
        Optional<CompoundTag> optional;
        Tag tag = this.tags.get(key);
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            optional = Optional.of(compoundTag);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public CompoundTag getCompoundOrEmpty(String key) {
        return this.getCompound(key).orElseGet(CompoundTag::new);
    }

    public Optional<ListTag> getList(String key) {
        Optional<ListTag> optional;
        Tag tag = this.tags.get(key);
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            optional = Optional.of(listTag);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public ListTag getListOrEmpty(String key) {
        return this.getList(key).orElseGet(ListTag::new);
    }

    public Optional<Boolean> getBoolean(String key) {
        return this.getOptional(key).flatMap(Tag::asBoolean);
    }

    public boolean getBooleanOr(String key, boolean defaultValue) {
        return this.getByteOr(key, (byte)(defaultValue ? 1 : 0)) != 0;
    }

    public @Nullable Tag remove(String key) {
        return this.tags.remove(key);
    }

    @Override
    public String toString() {
        StringTagVisitor stringTagVisitor = new StringTagVisitor();
        stringTagVisitor.visitCompound(this);
        return stringTagVisitor.build();
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    protected CompoundTag shallowCopy() {
        return new CompoundTag(new HashMap<String, Tag>(this.tags));
    }

    @Override
    public CompoundTag copy() {
        ObjectIterator iterator;
        Object2ObjectOpenHashMap ret = new Object2ObjectOpenHashMap(this.tags.size(), 0.8f);
        ObjectIterator objectIterator = iterator = this.tags instanceof Object2ObjectOpenHashMap ? ((Object2ObjectOpenHashMap)this.tags).object2ObjectEntrySet().fastIterator() : this.tags.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ret.put((Object)((String)entry.getKey()), (Object)((Tag)entry.getValue()).copy());
        }
        return new CompoundTag((Map<String, Tag>)ret);
    }

    @Override
    public Optional<CompoundTag> asCompound() {
        return Optional.of(this);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CompoundTag && Objects.equals(this.tags, ((CompoundTag)other).tags);
    }

    public int hashCode() {
        return this.tags.hashCode();
    }

    private static void writeNamedTag(String name, Tag tag, DataOutput output) throws IOException {
        output.writeByte(tag.getId());
        if (tag.getId() != 0) {
            output.writeUTF(name);
            tag.write(output);
        }
    }

    static Tag readNamedTagData(TagType<?> type, String name, DataInput input, NbtAccounter accounter) {
        try {
            return type.load(input, accounter);
        }
        catch (IOException var7) {
            CrashReport crashReport = CrashReport.forThrowable(var7, "Loading NBT data");
            CrashReportCategory crashReportCategory = crashReport.addCategory("NBT Tag");
            crashReportCategory.setDetail("Tag name", name);
            crashReportCategory.setDetail("Tag type", type.getName());
            throw new ReportedNbtException(crashReport);
        }
    }

    public CompoundTag merge(CompoundTag other) {
        for (String string : other.tags.keySet()) {
            Tag tag = other.tags.get(string);
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                Tag tag2 = this.tags.get(string);
                if (tag2 instanceof CompoundTag) {
                    CompoundTag compoundTag1 = (CompoundTag)tag2;
                    compoundTag1.merge(compoundTag);
                    continue;
                }
            }
            this.put(string, tag.copy());
        }
        return this;
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitCompound(this);
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor visitor) {
        block14: for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
            Tag tag = entry.getValue();
            TagType<?> type = tag.getType();
            StreamTagVisitor.EntryResult entryResult = visitor.visitEntry(type);
            switch (entryResult) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return visitor.visitContainerEnd();
                }
                case SKIP: {
                    continue block14;
                }
            }
            entryResult = visitor.visitEntry(type, entry.getKey());
            switch (entryResult) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return visitor.visitContainerEnd();
                }
                case SKIP: {
                    continue block14;
                }
            }
            StreamTagVisitor.ValueResult valueResult = tag.accept(visitor);
            switch (valueResult) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return visitor.visitContainerEnd();
                }
            }
        }
        return visitor.visitContainerEnd();
    }

    public <T> void store(String key, Codec<T> codec, T data) {
        this.store(key, codec, NbtOps.INSTANCE, data);
    }

    public <T> void storeNullable(String key, Codec<T> codec, @Nullable T data) {
        if (data != null) {
            this.store(key, codec, data);
        }
    }

    public <T> void store(String key, Codec<T> codec, DynamicOps<Tag> ops, T data) {
        this.put(key, (Tag)codec.encodeStart(ops, data).getOrThrow());
    }

    public <T> void storeNullable(String key, Codec<T> codec, DynamicOps<Tag> ops, @Nullable T data) {
        if (data != null) {
            this.store(key, codec, ops, data);
        }
    }

    public <T> void store(MapCodec<T> mapCodec, T data) {
        this.store(mapCodec, NbtOps.INSTANCE, data);
    }

    public <T> void store(MapCodec<T> mapCodec, DynamicOps<Tag> ops, T data) {
        this.merge((CompoundTag)mapCodec.encoder().encodeStart(ops, data).getOrThrow());
    }

    public <T> Optional<T> read(String key, Codec<T> codec) {
        return this.read(key, codec, NbtOps.INSTANCE);
    }

    public <T> Optional<T> read(String key, Codec<T> codec, DynamicOps<Tag> ops) {
        Tag tag = this.get(key);
        return tag == null ? Optional.empty() : codec.parse(ops, (Object)tag).resultOrPartial(string -> LOGGER.error("Failed to read field ({}={}): {}", new Object[]{key, tag, string}));
    }

    public <T> Optional<T> read(MapCodec<T> mapCodec) {
        return this.read(mapCodec, NbtOps.INSTANCE);
    }

    public <T> Optional<T> read(MapCodec<T> mapCodec, DynamicOps<Tag> ops) {
        return mapCodec.decode(ops, (MapLike)ops.getMap((Object)this).getOrThrow()).resultOrPartial(string -> LOGGER.error("Failed to read value ({}): {}", (Object)this, string));
    }

    public <T> Optional<T> readQuiet(String key, Codec<T> codec) {
        return this.readQuiet(key, codec, NbtOps.INSTANCE);
    }

    public <T> Optional<T> readQuiet(String key, Codec<T> codec, DynamicOps<Tag> ops) {
        Tag tag = this.get(key);
        return tag == null ? Optional.empty() : codec.parse(ops, (Object)tag).resultOrPartial();
    }

    public <T> Optional<T> readQuiet(MapCodec<T> mapCodec) {
        return this.readQuiet(mapCodec, NbtOps.INSTANCE);
    }

    public <T> Optional<T> readQuiet(MapCodec<T> mapCodec, DynamicOps<Tag> ops) {
        return mapCodec.decode(ops, (MapLike)ops.getMap((Object)this).getOrThrow()).resultOrPartial();
    }
}

