/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.BitSet;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public class FilterMask {
    public static final Codec<FilterMask> CODEC = StringRepresentable.fromEnum(Type::values).dispatch(FilterMask::type, Type::codec);
    public static final FilterMask FULLY_FILTERED = new FilterMask(new BitSet(0), Type.FULLY_FILTERED);
    public static final FilterMask PASS_THROUGH = new FilterMask(new BitSet(0), Type.PASS_THROUGH);
    public static final Style FILTERED_STYLE = Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withHoverEvent(new HoverEvent.ShowText(Component.translatable("chat.filtered")));
    static final MapCodec<FilterMask> PASS_THROUGH_CODEC = MapCodec.unit((Object)PASS_THROUGH);
    static final MapCodec<FilterMask> FULLY_FILTERED_CODEC = MapCodec.unit((Object)FULLY_FILTERED);
    static final MapCodec<FilterMask> PARTIALLY_FILTERED_CODEC = ExtraCodecs.BIT_SET.xmap(FilterMask::new, FilterMask::mask).fieldOf("value");
    private static final char HASH = '#';
    private final BitSet mask;
    private final Type type;

    private FilterMask(BitSet mask, Type type) {
        this.mask = mask;
        this.type = type;
    }

    private FilterMask(BitSet mask) {
        this.mask = mask;
        this.type = Type.PARTIALLY_FILTERED;
    }

    public FilterMask(int size) {
        this(new BitSet(size), Type.PARTIALLY_FILTERED);
    }

    private Type type() {
        return this.type;
    }

    private BitSet mask() {
        return this.mask;
    }

    public static FilterMask read(FriendlyByteBuf buffer) {
        Type type = buffer.readEnum(Type.class);
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> PASS_THROUGH;
            case 1 -> FULLY_FILTERED;
            case 2 -> new FilterMask(buffer.readBitSet(), Type.PARTIALLY_FILTERED);
        };
    }

    public static void write(FriendlyByteBuf buffer, FilterMask mask) {
        buffer.writeEnum(mask.type);
        if (mask.type == Type.PARTIALLY_FILTERED) {
            buffer.writeBitSet(mask.mask);
        }
    }

    public void setFiltered(int bitIndex) {
        this.mask.set(bitIndex);
    }

    public @Nullable String apply(String text) {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> text;
            case 1 -> null;
            case 2 -> {
                char[] chars = text.toCharArray();
                for (int i = 0; i < chars.length && i < this.mask.length(); ++i) {
                    if (!this.mask.get(i)) continue;
                    chars[i] = 35;
                }
                yield new String(chars);
            }
        };
    }

    public @Nullable Component applyWithFormatting(String text) {
        MutableComponent mutableComponent;
        block0 : switch (this.type.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                mutableComponent = Component.literal(text);
                break;
            }
            case 1: {
                mutableComponent = null;
                break;
            }
            case 2: {
                MutableComponent mutableComponent2 = Component.empty();
                int i = 0;
                boolean flag = this.mask.get(0);
                while (true) {
                    int i1 = flag ? this.mask.nextClearBit(i) : this.mask.nextSetBit(i);
                    int n = i1 = i1 < 0 ? text.length() : i1;
                    if (i1 == i) {
                        mutableComponent = mutableComponent2;
                        break block0;
                    }
                    if (flag) {
                        mutableComponent2.append(Component.literal(StringUtils.repeat((char)'#', (int)(i1 - i))).withStyle(FILTERED_STYLE));
                    } else {
                        mutableComponent2.append(text.substring(i, i1));
                    }
                    flag = !flag;
                    i = i1;
                }
            }
        }
        return mutableComponent;
    }

    public boolean isEmpty() {
        return this.type == Type.PASS_THROUGH;
    }

    public boolean isFullyFiltered() {
        return this.type == Type.FULLY_FILTERED;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            FilterMask filterMask = (FilterMask)other;
            return this.mask.equals(filterMask.mask) && this.type == filterMask.type;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.mask.hashCode();
        return 31 * hashCode + this.type.hashCode();
    }

    static enum Type implements StringRepresentable
    {
        PASS_THROUGH("pass_through", () -> PASS_THROUGH_CODEC),
        FULLY_FILTERED("fully_filtered", () -> FULLY_FILTERED_CODEC),
        PARTIALLY_FILTERED("partially_filtered", () -> PARTIALLY_FILTERED_CODEC);

        private final String serializedName;
        private final Supplier<MapCodec<FilterMask>> codec;

        private Type(String serializedName, Supplier<MapCodec<FilterMask>> codec) {
            this.serializedName = serializedName;
            this.codec = codec;
        }

        @Override
        public String getSerializedName() {
            return this.serializedName;
        }

        private MapCodec<FilterMask> codec() {
            return this.codec.get();
        }
    }
}

