/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Unit;

public interface FormattedText {
    public static final Optional<Unit> STOP_ITERATION = Optional.of(Unit.INSTANCE);
    public static final FormattedText EMPTY = new FormattedText(){

        @Override
        public <T> Optional<T> visit(ContentConsumer<T> acceptor) {
            return Optional.empty();
        }

        @Override
        public <T> Optional<T> visit(StyledContentConsumer<T> acceptor, Style style) {
            return Optional.empty();
        }
    };

    public <T> Optional<T> visit(ContentConsumer<T> var1);

    public <T> Optional<T> visit(StyledContentConsumer<T> var1, Style var2);

    public static FormattedText of(final String text) {
        return new FormattedText(){

            @Override
            public <T> Optional<T> visit(ContentConsumer<T> acceptor) {
                return acceptor.accept(text);
            }

            @Override
            public <T> Optional<T> visit(StyledContentConsumer<T> acceptor, Style style) {
                return acceptor.accept(style, text);
            }
        };
    }

    public static FormattedText of(final String text, final Style style) {
        return new FormattedText(){

            @Override
            public <T> Optional<T> visit(ContentConsumer<T> acceptor) {
                return acceptor.accept(text);
            }

            @Override
            public <T> Optional<T> visit(StyledContentConsumer<T> acceptor, Style style1) {
                return acceptor.accept(style.applyTo(style1), text);
            }
        };
    }

    public static FormattedText composite(FormattedText ... elements) {
        return FormattedText.composite((List<? extends FormattedText>)ImmutableList.copyOf((Object[])elements));
    }

    public static FormattedText composite(final List<? extends FormattedText> elements) {
        return new FormattedText(){

            @Override
            public <T> Optional<T> visit(ContentConsumer<T> acceptor) {
                for (FormattedText formattedText : elements) {
                    Optional<T> optional = formattedText.visit(acceptor);
                    if (!optional.isPresent()) continue;
                    return optional;
                }
                return Optional.empty();
            }

            @Override
            public <T> Optional<T> visit(StyledContentConsumer<T> acceptor, Style style) {
                for (FormattedText formattedText : elements) {
                    Optional<T> optional = formattedText.visit(acceptor, style);
                    if (!optional.isPresent()) continue;
                    return optional;
                }
                return Optional.empty();
            }
        };
    }

    default public String getString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.visit(content -> {
            stringBuilder.append(content);
            return Optional.empty();
        });
        return stringBuilder.toString();
    }

    public static interface ContentConsumer<T> {
        public Optional<T> accept(String var1);
    }

    public static interface StyledContentConsumer<T> {
        public Optional<T> accept(Style var1, String var2);
    }
}

