/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.NbtPredicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.contents.data.DataSource;
import net.minecraft.world.entity.Entity;
import org.jspecify.annotations.Nullable;

public record EntityDataSource(String selectorPattern, @Nullable EntitySelector compiledSelector) implements DataSource
{
    public static final MapCodec<EntityDataSource> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("entity").forGetter(EntityDataSource::selectorPattern)).apply((Applicative)instance, EntityDataSource::new));

    public EntityDataSource(String selectorPattern) {
        this(selectorPattern, EntityDataSource.compileSelector(selectorPattern));
    }

    private static @Nullable EntitySelector compileSelector(String selectorPattern) {
        try {
            EntitySelectorParser entitySelectorParser = new EntitySelectorParser(new StringReader(selectorPattern), true);
            return entitySelectorParser.parse();
        }
        catch (CommandSyntaxException var2) {
            return null;
        }
    }

    @Override
    public Stream<CompoundTag> getData(CommandSourceStack source) throws CommandSyntaxException {
        if (this.compiledSelector != null) {
            List<? extends Entity> list = this.compiledSelector.findEntities(source);
            return list.stream().map(NbtPredicate::getEntityTagToCompare);
        }
        return Stream.empty();
    }

    public MapCodec<EntityDataSource> codec() {
        return MAP_CODEC;
    }

    @Override
    public String toString() {
        return "entity=" + this.selectorPattern;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof EntityDataSource)) return false;
        EntityDataSource entityDataSource = (EntityDataSource)other;
        if (!this.selectorPattern.equals(entityDataSource.selectorPattern)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.selectorPattern.hashCode();
    }
}

