/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.antixray.ChunkPacketInfo;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jspecify.annotations.Nullable;

public class ClientboundLevelChunkPacketData {
    private static final StreamCodec<ByteBuf, Map<Heightmap.Types, long[]>> HEIGHTMAPS_STREAM_CODEC = ByteBufCodecs.map(i -> new EnumMap(Heightmap.Types.class), Heightmap.Types.STREAM_CODEC, ByteBufCodecs.LONG_ARRAY);
    private static final int TWO_MEGABYTES = 0x200000;
    private final Map<Heightmap.Types, long[]> heightmaps;
    private final byte[] buffer;
    private final List<BlockEntityInfo> blockEntitiesData;
    private final List<Packet<?>> extraPackets = new ArrayList();
    private static final int BLOCK_ENTITY_LIMIT = Integer.getInteger("Paper.excessiveTELimit", 750);

    public List<Packet<?>> getExtraPackets() {
        return this.extraPackets;
    }

    @Deprecated
    @DoNotUse
    public ClientboundLevelChunkPacketData(LevelChunk levelChunk) {
        this(levelChunk, null);
    }

    public ClientboundLevelChunkPacketData(LevelChunk levelChunk, ChunkPacketInfo<BlockState> chunkPacketInfo) {
        this.heightmaps = levelChunk.getHeightmaps().stream().filter(entry1 -> ((Heightmap.Types)entry1.getKey()).sendToClient()).collect(Collectors.toMap(Map.Entry::getKey, entry1 -> (long[])((Heightmap)entry1.getValue()).getRawData().clone()));
        this.buffer = new byte[ClientboundLevelChunkPacketData.calculateChunkSize(levelChunk)];
        if (chunkPacketInfo != null) {
            chunkPacketInfo.setBuffer(this.buffer);
        }
        ClientboundLevelChunkPacketData.extractChunkData(new FriendlyByteBuf(this.getWriteBuffer()), levelChunk, chunkPacketInfo);
        this.blockEntitiesData = Lists.newArrayList();
        int totalTileEntities = 0;
        for (Map.Entry<BlockPos, BlockEntity> entry : levelChunk.getBlockEntities().entrySet()) {
            Packet<ClientGamePacketListener> packet;
            if (++totalTileEntities > BLOCK_ENTITY_LIMIT && (packet = entry.getValue().getUpdatePacket()) != null) {
                this.extraPackets.add(packet);
                continue;
            }
            this.blockEntitiesData.add(BlockEntityInfo.create(entry.getValue()));
        }
    }

    public ClientboundLevelChunkPacketData(RegistryFriendlyByteBuf buffer, int x, int z) {
        this.heightmaps = (Map)HEIGHTMAPS_STREAM_CODEC.decode(buffer);
        int varInt = buffer.readVarInt();
        if (varInt > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.buffer = new byte[varInt];
        buffer.readBytes(this.buffer);
        this.blockEntitiesData = (List)BlockEntityInfo.LIST_STREAM_CODEC.decode(buffer);
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        HEIGHTMAPS_STREAM_CODEC.encode(buffer, this.heightmaps);
        buffer.writeVarInt(this.buffer.length);
        buffer.writeBytes(this.buffer);
        BlockEntityInfo.LIST_STREAM_CODEC.encode(buffer, this.blockEntitiesData);
    }

    private static int calculateChunkSize(LevelChunk chunk) {
        int i = 0;
        for (LevelChunkSection levelChunkSection : chunk.getSections()) {
            i += levelChunkSection.getSerializedSize();
        }
        return i;
    }

    private ByteBuf getWriteBuffer() {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.buffer);
        byteBuf.writerIndex(0);
        return byteBuf;
    }

    @Deprecated
    @DoNotUse
    public static void extractChunkData(FriendlyByteBuf buffer, LevelChunk chunk) {
        ClientboundLevelChunkPacketData.extractChunkData(buffer, chunk, null);
    }

    public static void extractChunkData(FriendlyByteBuf buffer, LevelChunk chunk, ChunkPacketInfo<BlockState> chunkPacketInfo) {
        int chunkSectionIndex = 0;
        for (LevelChunkSection levelChunkSection : chunk.getSections()) {
            levelChunkSection.write(buffer, chunkPacketInfo, chunkSectionIndex);
            ++chunkSectionIndex;
        }
        if (buffer.writerIndex() != buffer.capacity()) {
            throw new IllegalStateException("Didn't fill chunk buffer: expected " + buffer.capacity() + " bytes, got " + buffer.writerIndex());
        }
    }

    public Consumer<BlockEntityTagOutput> getBlockEntitiesTagsConsumer(int chunkX, int chunkZ) {
        return blockEntityTagOutput -> this.getBlockEntitiesTags((BlockEntityTagOutput)blockEntityTagOutput, chunkX, chunkZ);
    }

    private void getBlockEntitiesTags(BlockEntityTagOutput output, int chunkX, int chunkZ) {
        int i = 16 * chunkX;
        int i1 = 16 * chunkZ;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (BlockEntityInfo blockEntityInfo : this.blockEntitiesData) {
            int i2 = i + SectionPos.sectionRelative(blockEntityInfo.packedXZ >> 4);
            int i3 = i1 + SectionPos.sectionRelative(blockEntityInfo.packedXZ);
            mutableBlockPos.set(i2, blockEntityInfo.y, i3);
            output.accept(mutableBlockPos, blockEntityInfo.type, blockEntityInfo.tag);
        }
    }

    public FriendlyByteBuf getReadBuffer() {
        return new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])this.buffer));
    }

    public Map<Heightmap.Types, long[]> getHeightmaps() {
        return this.heightmaps;
    }

    static class BlockEntityInfo {
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockEntityInfo> STREAM_CODEC = StreamCodec.ofMember(BlockEntityInfo::write, BlockEntityInfo::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, List<BlockEntityInfo>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());
        final int packedXZ;
        final int y;
        final BlockEntityType<?> type;
        final @Nullable CompoundTag tag;

        private BlockEntityInfo(int packedXZ, int y, BlockEntityType<?> type, @Nullable CompoundTag tag) {
            this.packedXZ = packedXZ;
            this.y = y;
            this.type = type;
            this.tag = tag;
        }

        private BlockEntityInfo(RegistryFriendlyByteBuf buffer) {
            this.packedXZ = buffer.readByte();
            this.y = buffer.readShort();
            this.type = (BlockEntityType)ByteBufCodecs.registry(Registries.BLOCK_ENTITY_TYPE).decode(buffer);
            this.tag = buffer.readNbt();
        }

        private void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeByte(this.packedXZ);
            buffer.writeShort(this.y);
            ByteBufCodecs.registry(Registries.BLOCK_ENTITY_TYPE).encode(buffer, this.type);
            buffer.writeNbt(this.tag);
        }

        static BlockEntityInfo create(BlockEntity blockEntity) {
            CompoundTag updateTag = blockEntity.getUpdateTag(blockEntity.getLevel().registryAccess());
            BlockPos blockPos = blockEntity.getBlockPos();
            int i = SectionPos.sectionRelative(blockPos.getX()) << 4 | SectionPos.sectionRelative(blockPos.getZ());
            blockEntity.sanitizeSentNbt(updateTag);
            return new BlockEntityInfo(i, blockPos.getY(), blockEntity.getType(), updateTag.isEmpty() ? null : updateTag);
        }
    }

    @FunctionalInterface
    public static interface BlockEntityTagOutput {
        public void accept(BlockPos var1, BlockEntityType<?> var2, @Nullable CompoundTag var3);
    }
}

