/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.ImmutableList;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.jspecify.annotations.Nullable;

public class ClientboundSetPlayerTeamPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundSetPlayerTeamPacket> STREAM_CODEC = Packet.codec(ClientboundSetPlayerTeamPacket::write, ClientboundSetPlayerTeamPacket::new);
    private static final int METHOD_ADD = 0;
    private static final int METHOD_REMOVE = 1;
    private static final int METHOD_CHANGE = 2;
    private static final int METHOD_JOIN = 3;
    private static final int METHOD_LEAVE = 4;
    private static final int MAX_VISIBILITY_LENGTH = 40;
    private static final int MAX_COLLISION_LENGTH = 40;
    private final int method;
    private final String name;
    private final Collection<String> players;
    private final Optional<Parameters> parameters;

    public static ClientboundSetPlayerTeamPacket createMultiplePlayerPacket(PlayerTeam team, Collection<String> players, Action operation) {
        return new ClientboundSetPlayerTeamPacket(team.getName(), operation == Action.ADD ? 3 : 4, Optional.empty(), players);
    }

    private ClientboundSetPlayerTeamPacket(String name, int method, Optional<Parameters> parameters, Collection<String> players) {
        this.name = name;
        this.method = method;
        this.parameters = parameters;
        this.players = ImmutableList.copyOf(players);
    }

    public static ClientboundSetPlayerTeamPacket createAddOrModifyPacket(PlayerTeam team, boolean useAdd) {
        return new ClientboundSetPlayerTeamPacket(team.getName(), useAdd ? 0 : 2, Optional.of(new Parameters(team)), useAdd ? team.getPlayers() : ImmutableList.of());
    }

    public static ClientboundSetPlayerTeamPacket createRemovePacket(PlayerTeam team) {
        return new ClientboundSetPlayerTeamPacket(team.getName(), 1, Optional.empty(), (Collection<String>)ImmutableList.of());
    }

    public static ClientboundSetPlayerTeamPacket createPlayerPacket(PlayerTeam team, String playerName, Action action) {
        return new ClientboundSetPlayerTeamPacket(team.getName(), action == Action.ADD ? 3 : 4, Optional.empty(), (Collection<String>)ImmutableList.of((Object)playerName));
    }

    private ClientboundSetPlayerTeamPacket(RegistryFriendlyByteBuf buffer) {
        this.name = buffer.readUtf();
        this.method = buffer.readByte();
        this.parameters = ClientboundSetPlayerTeamPacket.shouldHaveParameters(this.method) ? Optional.of(new Parameters(buffer)) : Optional.empty();
        this.players = ClientboundSetPlayerTeamPacket.shouldHavePlayerList(this.method) ? buffer.readList(FriendlyByteBuf::readUtf) : ImmutableList.of();
    }

    private void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeUtf(this.name);
        buffer.writeByte(this.method);
        if (ClientboundSetPlayerTeamPacket.shouldHaveParameters(this.method)) {
            this.parameters.orElseThrow(() -> new IllegalStateException("Parameters not present, but method is" + this.method)).write(buffer);
        }
        if (ClientboundSetPlayerTeamPacket.shouldHavePlayerList(this.method)) {
            buffer.writeCollection(this.players, FriendlyByteBuf::writeUtf);
        }
    }

    private static boolean shouldHavePlayerList(int method) {
        return method == 0 || method == 3 || method == 4;
    }

    private static boolean shouldHaveParameters(int method) {
        return method == 0 || method == 2;
    }

    public @Nullable Action getPlayerAction() {
        return switch (this.method) {
            case 0, 3 -> Action.ADD;
            default -> null;
            case 4 -> Action.REMOVE;
        };
    }

    public @Nullable Action getTeamAction() {
        return switch (this.method) {
            case 0 -> Action.ADD;
            case 1 -> Action.REMOVE;
            default -> null;
        };
    }

    @Override
    public PacketType<ClientboundSetPlayerTeamPacket> type() {
        return GamePacketTypes.CLIENTBOUND_SET_PLAYER_TEAM;
    }

    @Override
    public void handle(ClientGamePacketListener handler) {
        handler.handleSetPlayerTeamPacket(this);
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getPlayers() {
        return this.players;
    }

    public Optional<Parameters> getParameters() {
        return this.parameters;
    }

    public static enum Action {
        ADD,
        REMOVE;

    }

    public static class Parameters {
        private final Component displayName;
        private final Component playerPrefix;
        private final Component playerSuffix;
        private final Team.Visibility nametagVisibility;
        private final Team.CollisionRule collisionRule;
        private final ChatFormatting color;
        private final int options;

        public Parameters(PlayerTeam team) {
            this.displayName = team.getDisplayName();
            this.options = team.packOptions();
            this.nametagVisibility = team.getNameTagVisibility();
            this.collisionRule = team.getCollisionRule();
            this.color = team.getColor();
            this.playerPrefix = team.getPlayerPrefix();
            this.playerSuffix = team.getPlayerSuffix();
        }

        public Parameters(RegistryFriendlyByteBuf buffer) {
            this.displayName = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(buffer);
            this.options = buffer.readByte();
            this.nametagVisibility = (Team.Visibility)Team.Visibility.STREAM_CODEC.decode(buffer);
            this.collisionRule = (Team.CollisionRule)Team.CollisionRule.STREAM_CODEC.decode(buffer);
            this.color = buffer.readEnum(ChatFormatting.class);
            this.playerPrefix = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(buffer);
            this.playerSuffix = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(buffer);
        }

        public Component getDisplayName() {
            return this.displayName;
        }

        public int getOptions() {
            return this.options;
        }

        public ChatFormatting getColor() {
            return this.color;
        }

        public Team.Visibility getNametagVisibility() {
            return this.nametagVisibility;
        }

        public Team.CollisionRule getCollisionRule() {
            return this.collisionRule;
        }

        public Component getPlayerPrefix() {
            return this.playerPrefix;
        }

        public Component getPlayerSuffix() {
            return this.playerSuffix;
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(buffer, this.displayName);
            buffer.writeByte(this.options);
            Team.Visibility.STREAM_CODEC.encode(buffer, this.nametagVisibility);
            Team.CollisionRule.STREAM_CODEC.encode(buffer, !GlobalConfiguration.get().collisions.enablePlayerCollisions ? Team.CollisionRule.NEVER : this.collisionRule);
            buffer.writeEnum(this.color);
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(buffer, this.playerPrefix);
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(buffer, this.playerSuffix);
        }
    }
}

