/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import com.google.gson.JsonElement;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.login.ClientLoginPacketListener;
import net.minecraft.network.protocol.login.LoginPacketTypes;
import net.minecraft.resources.RegistryOps;

public record ClientboundLoginDisconnectPacket(Component reason) implements Packet<ClientLoginPacketListener>
{
    private static final RegistryOps<JsonElement> OPS = RegistryAccess.EMPTY.createSerializationContext(JsonOps.INSTANCE);
    public static final StreamCodec<FriendlyByteBuf, ClientboundLoginDisconnectPacket> STREAM_CODEC = StreamCodec.composite(new StreamCodec<FriendlyByteBuf, Component>(){
        private static final StreamCodec<ByteBuf, JsonElement> LENIENT_JSON = ByteBufCodecs.lenientJson(262144);

        @Override
        public Component decode(FriendlyByteBuf buffer) {
            Locale bufLocale = buffer.adventure$locale;
            return (Component)LENIENT_JSON.apply(ByteBufCodecs.fromCodec(OPS, ComponentSerialization.localizedCodec(bufLocale == null ? Locale.US : bufLocale))).decode(buffer);
        }

        @Override
        public void encode(FriendlyByteBuf buffer, Component value) {
            Locale bufLocale = buffer.adventure$locale;
            LENIENT_JSON.apply(ByteBufCodecs.fromCodec(OPS, ComponentSerialization.localizedCodec(bufLocale == null ? Locale.US : bufLocale))).encode(buffer, value);
        }
    }, ClientboundLoginDisconnectPacket::reason, ClientboundLoginDisconnectPacket::new);

    @Override
    public PacketType<ClientboundLoginDisconnectPacket> type() {
        return LoginPacketTypes.CLIENTBOUND_LOGIN_DISCONNECT;
    }

    @Override
    public void handle(ClientLoginPacketListener handler) {
        handler.handleDisconnect(this);
    }
}

