/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.login.LoginPacketTypes;
import net.minecraft.network.protocol.login.ServerLoginPacketListener;
import net.minecraft.network.protocol.login.custom.CustomQueryAnswerPayload;
import net.minecraft.network.protocol.login.custom.DiscardedQueryAnswerPayload;
import org.jspecify.annotations.Nullable;

public record ServerboundCustomQueryAnswerPacket(int transactionId, @Nullable CustomQueryAnswerPayload payload) implements Packet<ServerLoginPacketListener>
{
    public static final StreamCodec<FriendlyByteBuf, ServerboundCustomQueryAnswerPacket> STREAM_CODEC = Packet.codec(ServerboundCustomQueryAnswerPacket::write, ServerboundCustomQueryAnswerPacket::read);
    private static final int MAX_PAYLOAD_SIZE = 0x100000;

    private static ServerboundCustomQueryAnswerPacket read(FriendlyByteBuf buffer) {
        int varInt = buffer.readVarInt();
        return new ServerboundCustomQueryAnswerPacket(varInt, ServerboundCustomQueryAnswerPacket.readPayload(varInt, buffer));
    }

    private static CustomQueryAnswerPayload readPayload(int transactionId, FriendlyByteBuf buffer) {
        FriendlyByteBuf buf = buffer.readNullable(buf2 -> {
            int readableBytes = buf2.readableBytes();
            if (readableBytes >= 0 && readableBytes <= 0x100000) {
                return new FriendlyByteBuf(buf2.readBytes(readableBytes));
            }
            throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
        });
        return buf == null ? null : new QueryAnswerPayload(buf);
    }

    private static CustomQueryAnswerPayload readUnknownPayload(FriendlyByteBuf buffer) {
        int i = buffer.readableBytes();
        if (i >= 0 && i <= 0x100000) {
            buffer.skipBytes(i);
            return DiscardedQueryAnswerPayload.INSTANCE;
        }
        throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
    }

    private void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.transactionId);
        buffer.writeNullable(this.payload, (buffer1, value) -> value.write((FriendlyByteBuf)((Object)buffer1)));
    }

    @Override
    public PacketType<ServerboundCustomQueryAnswerPacket> type() {
        return LoginPacketTypes.SERVERBOUND_CUSTOM_QUERY_ANSWER;
    }

    @Override
    public void handle(ServerLoginPacketListener handler) {
        handler.handleCustomQueryPacket(this);
    }

    public static final class QueryAnswerPayload
    implements CustomQueryAnswerPayload {
        public final FriendlyByteBuf buffer;

        public QueryAnswerPayload(FriendlyByteBuf buffer) {
            this.buffer = buffer;
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.writeBytes(this.buffer.copy());
        }
    }
}

