/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.mojang.logging.LogUtils;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.util.ClassTreeIdRegistry;
import org.apache.commons.lang3.ObjectUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class SynchedEntityData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_ID_VALUE = 254;
    static final ClassTreeIdRegistry ID_REGISTRY = new ClassTreeIdRegistry();
    private final SyncedDataHolder entity;
    private final DataItem<?>[] itemsById;
    private boolean isDirty;

    SynchedEntityData(SyncedDataHolder entity, DataItem<?>[] itemsById) {
        this.entity = entity;
        this.itemsById = itemsById;
    }

    public static <T> EntityDataAccessor<T> defineId(Class<? extends SyncedDataHolder> clazz, EntityDataSerializer<T> serializer) {
        int i;
        if (LOGGER.isDebugEnabled()) {
            try {
                Class<?> clazz1 = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!clazz1.equals(clazz)) {
                    LOGGER.debug("defineId called for: {} from {}", new Object[]{clazz, clazz1, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException clazz1) {
                // empty catch block
            }
        }
        if ((i = ID_REGISTRY.define(clazz)) > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i + "! (Max is 254)");
        }
        return serializer.createAccessor(i);
    }

    public <T> DataItem<T> getItem(EntityDataAccessor<T> key) {
        return this.itemsById[key.id()];
    }

    public <T> T get(EntityDataAccessor<T> key) {
        return this.getItem(key).getValue();
    }

    public <T> void set(EntityDataAccessor<T> key, T value) {
        this.set(key, value, false);
    }

    public <T> void set(EntityDataAccessor<T> key, T value, boolean force) {
        DataItem<T> item = this.getItem(key);
        if (force || ObjectUtils.notEqual(value, item.getValue())) {
            item.setValue(value);
            this.entity.onSyncedDataUpdated(key);
            item.setDirty(true);
            this.isDirty = true;
        }
    }

    public <T> void markDirty(EntityDataAccessor<T> entityDataAccessor) {
        this.getItem(entityDataAccessor).setDirty(true);
        this.isDirty = true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public @Nullable List<DataValue<?>> packDirty() {
        if (!this.isDirty) {
            return null;
        }
        this.isDirty = false;
        ArrayList list = new ArrayList();
        for (DataItem<?> dataItem : this.itemsById) {
            if (!dataItem.isDirty()) continue;
            dataItem.setDirty(false);
            list.add(dataItem.value());
        }
        return list;
    }

    public @Nullable List<DataValue<?>> getNonDefaultValues() {
        ArrayList list = null;
        for (DataItem<?> dataItem : this.itemsById) {
            if (dataItem.isSetToDefault()) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(dataItem.value());
        }
        return list;
    }

    public void assignValues(List<DataValue<?>> entries) {
        for (DataValue<?> dataValue : entries) {
            DataItem<?> dataItem = this.itemsById[dataValue.id];
            this.assignValue(dataItem, dataValue);
            this.entity.onSyncedDataUpdated(dataItem.getAccessor());
        }
        this.entity.onSyncedDataUpdated(entries);
    }

    private <T> void assignValue(DataItem<T> target, DataValue<?> entry) {
        if (!Objects.equals(entry.serializer(), target.accessor.serializer())) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", target.accessor.id(), this.entity, target.value, target.value.getClass(), entry.value, entry.value.getClass()));
        }
        target.setValue(entry.value);
    }

    public List<DataValue<?>> packAll() {
        ArrayList list = new ArrayList(this.itemsById.length);
        for (DataItem<?> dataItem : this.itemsById) {
            list.add(dataItem.value());
        }
        return list;
    }

    public static class DataItem<T> {
        final EntityDataAccessor<T> accessor;
        T value;
        private final T initialValue;
        private boolean dirty;

        public DataItem(EntityDataAccessor<T> accessor, T value) {
            this.accessor = accessor;
            this.initialValue = value;
            this.value = value;
        }

        public EntityDataAccessor<T> getAccessor() {
            return this.accessor;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public boolean isSetToDefault() {
            return this.initialValue.equals(this.value);
        }

        public DataValue<T> value() {
            return DataValue.create(this.accessor, this.value);
        }
    }

    public record DataValue<T>(int id, EntityDataSerializer<T> serializer, T value) {
        public static <T> DataValue<T> create(EntityDataAccessor<T> dataAccessor, T value) {
            EntityDataSerializer<T> entityDataSerializer = dataAccessor.serializer();
            return new DataValue<T>(dataAccessor.id(), entityDataSerializer, entityDataSerializer.copy(value));
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            int serializedId = EntityDataSerializers.getSerializedId(this.serializer);
            if (serializedId < 0) {
                throw new EncoderException("Unknown serializer type " + String.valueOf(this.serializer));
            }
            buffer.writeByte(this.id);
            buffer.writeVarInt(serializedId);
            this.serializer.codec().encode(buffer, this.value);
        }

        public static DataValue<?> read(RegistryFriendlyByteBuf buffer, int id) {
            int varInt = buffer.readVarInt();
            EntityDataSerializer<?> serializer = EntityDataSerializers.getSerializer(varInt);
            if (serializer == null) {
                throw new DecoderException("Unknown serializer type " + varInt);
            }
            return DataValue.read(buffer, id, serializer);
        }

        private static <T> DataValue<T> read(RegistryFriendlyByteBuf buffer, int id, EntityDataSerializer<T> serializer) {
            return new DataValue<T>(id, serializer, serializer.codec().decode(buffer));
        }
    }

    public static class Builder {
        private final SyncedDataHolder entity;
        private final @Nullable DataItem<?>[] itemsById;

        public Builder(SyncedDataHolder entity) {
            this.entity = entity;
            this.itemsById = new DataItem[ID_REGISTRY.getCount(entity.getClass())];
        }

        public <T> Builder define(EntityDataAccessor<T> accessor, T value) {
            int id = accessor.id();
            if (id > this.itemsById.length) {
                throw new IllegalArgumentException("Data value id is too big with " + id + "! (Max is " + this.itemsById.length + ")");
            }
            if (this.itemsById[id] != null) {
                throw new IllegalArgumentException("Duplicate id value for " + id + "!");
            }
            if (EntityDataSerializers.getSerializedId(accessor.serializer()) < 0) {
                throw new IllegalArgumentException("Unregistered serializer " + String.valueOf(accessor.serializer()) + " for " + id + "!");
            }
            this.itemsById[accessor.id()] = new DataItem<T>(accessor, value);
            return this;
        }

        public SynchedEntityData build() {
            for (int i = 0; i < this.itemsById.length; ++i) {
                if (this.itemsById[i] != null) continue;
                throw new IllegalStateException("Entity " + String.valueOf(this.entity.getClass()) + " has not defined synched data value " + i);
            }
            return new SynchedEntityData(this.entity, this.itemsById);
        }
    }
}

