/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.function.UnaryOperator;
import net.minecraft.IdentifierException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public final class Identifier
implements Comparable<Identifier> {
    public static final Codec<Identifier> CODEC = Codec.STRING.comapFlatMap(Identifier::read, Identifier::toString).stable();
    public static final StreamCodec<ByteBuf, Identifier> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(Identifier::parse, Identifier::toString);
    public static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)Component.translatable("argument.id.invalid"));
    public static final char NAMESPACE_SEPARATOR = ':';
    public static final String DEFAULT_NAMESPACE = "minecraft";
    public static final String REALMS_NAMESPACE = "realms";
    public static final String PAPER_NAMESPACE = "paper";
    private final String namespace;
    private final String path;

    private Identifier(String namespace, String path) {
        assert (Identifier.isValidNamespace(namespace));
        assert (Identifier.isValidPath(path));
        String resourceLocation = namespace + ":" + path;
        if (resourceLocation.length() > Short.MAX_VALUE || ByteBufUtil.utf8MaxBytes((CharSequence)resourceLocation) > 65535) {
            throw new IdentifierException("Resource location too long: " + resourceLocation);
        }
        this.namespace = namespace;
        this.path = path;
    }

    private static Identifier createUntrusted(String namespace, String path) {
        return new Identifier(Identifier.assertValidNamespace(namespace, path), Identifier.assertValidPath(namespace, path));
    }

    public static Identifier fromNamespaceAndPath(String namespace, String path) {
        return Identifier.createUntrusted(namespace, path);
    }

    public static Identifier parse(String location) {
        return Identifier.bySeparator(location, ':');
    }

    public static Identifier withDefaultNamespace(String location) {
        return new Identifier(DEFAULT_NAMESPACE, Identifier.assertValidPath(DEFAULT_NAMESPACE, location));
    }

    public static @Nullable Identifier tryParse(String location) {
        return Identifier.tryBySeparator(location, ':');
    }

    public static @Nullable Identifier tryBuild(String namespace, String path) {
        return Identifier.isValidNamespace(namespace) && Identifier.isValidPath(path) ? new Identifier(namespace, path) : null;
    }

    public static Identifier bySeparator(String location, char separator) {
        int index = location.indexOf(separator);
        if (index >= 0) {
            String sub = location.substring(index + 1);
            if (index != 0) {
                String sub1 = location.substring(0, index);
                return Identifier.createUntrusted(sub1, sub);
            }
            return Identifier.withDefaultNamespace(sub);
        }
        return Identifier.withDefaultNamespace(location);
    }

    public static @Nullable Identifier tryBySeparator(String location, char separator) {
        int index = location.indexOf(separator);
        if (index >= 0) {
            String sub = location.substring(index + 1);
            if (!Identifier.isValidPath(sub)) {
                return null;
            }
            if (index != 0) {
                String sub1 = location.substring(0, index);
                return Identifier.isValidNamespace(sub1) ? new Identifier(sub1, sub) : null;
            }
            return new Identifier(DEFAULT_NAMESPACE, sub);
        }
        return Identifier.isValidPath(location) ? new Identifier(DEFAULT_NAMESPACE, location) : null;
    }

    public static DataResult<Identifier> read(String location) {
        try {
            return DataResult.success((Object)Identifier.parse(location));
        }
        catch (IdentifierException var2) {
            return DataResult.error(() -> "Not a valid resource location: " + location + " " + var2.getMessage());
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Identifier withPath(String path) {
        return new Identifier(this.namespace, Identifier.assertValidPath(this.namespace, path));
    }

    public Identifier withPath(UnaryOperator<String> pathOperator) {
        return this.withPath((String)pathOperator.apply(this.path));
    }

    public Identifier withPrefix(String pathPrefix) {
        return this.withPath(pathPrefix + this.path);
    }

    public Identifier withSuffix(String pathSuffix) {
        return this.withPath(this.path + pathSuffix);
    }

    public String toString() {
        return this.namespace + ":" + this.path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof Identifier)) return false;
        Identifier identifier = (Identifier)other;
        if (!this.namespace.equals(identifier.namespace)) return false;
        if (!this.path.equals(identifier.path)) return false;
        return true;
    }

    public int hashCode() {
        return 31 * this.namespace.hashCode() + this.path.hashCode();
    }

    @Override
    public int compareTo(Identifier other) {
        int i = this.path.compareTo(other.path);
        if (i == 0) {
            i = this.namespace.compareTo(other.namespace);
        }
        return i;
    }

    public String toDebugFileName() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public String toLanguageKey() {
        return this.namespace + "." + this.path;
    }

    public String toShortLanguageKey() {
        return this.namespace.equals(DEFAULT_NAMESPACE) ? this.path : this.toLanguageKey();
    }

    public String toShortString() {
        return this.namespace.equals(DEFAULT_NAMESPACE) ? this.path : this.toString();
    }

    public String toLanguageKey(String type) {
        return type + "." + this.toLanguageKey();
    }

    public String toLanguageKey(String type, String key) {
        return type + "." + this.toLanguageKey() + "." + key;
    }

    private static String readGreedy(StringReader reader) {
        int cursor = reader.getCursor();
        while (reader.canRead() && Identifier.isAllowedInIdentifier(reader.peek())) {
            reader.skip();
        }
        return reader.getString().substring(cursor, reader.getCursor());
    }

    public static Identifier read(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String greedy = Identifier.readGreedy(reader);
        try {
            return Identifier.parse(greedy);
        }
        catch (IdentifierException var4) {
            reader.setCursor(cursor);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static Identifier readNonEmpty(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String greedy = Identifier.readGreedy(reader);
        if (greedy.isEmpty()) {
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
        }
        try {
            return Identifier.parse(greedy);
        }
        catch (IdentifierException var4) {
            reader.setCursor(cursor);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static boolean isAllowedInIdentifier(char character) {
        return character >= '0' && character <= '9' || character >= 'a' && character <= 'z' || character == '_' || character == ':' || character == '/' || character == '.' || character == '-';
    }

    public static boolean isValidPath(String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (Identifier.validPathChar(path.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNamespace(String namespace) {
        for (int i = 0; i < namespace.length(); ++i) {
            if (Identifier.validNamespaceChar(namespace.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String assertValidNamespace(String namespace, String path) {
        if (!Identifier.isValidNamespace(namespace)) {
            throw new IdentifierException("Non [a-z0-9_.-] character in namespace of location: " + StringUtils.normalizeSpace((String)namespace) + ":" + StringUtils.normalizeSpace((String)path));
        }
        return namespace;
    }

    public static boolean validPathChar(char pathChar) {
        return pathChar == '_' || pathChar == '-' || pathChar >= 'a' && pathChar <= 'z' || pathChar >= '0' && pathChar <= '9' || pathChar == '/' || pathChar == '.';
    }

    private static boolean validNamespaceChar(char namespaceChar) {
        return namespaceChar == '_' || namespaceChar == '-' || namespaceChar >= 'a' && namespaceChar <= 'z' || namespaceChar >= '0' && namespaceChar <= '9' || namespaceChar == '.';
    }

    private static String assertValidPath(String namespace, String path) {
        if (!Identifier.isValidPath(path)) {
            throw new IdentifierException("Non [a-z0-9/._-] character in path of location: " + namespace + ":" + StringUtils.normalizeSpace((String)path));
        }
        return path;
    }
}

