/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.registry.PaperRegistryAccess;
import io.papermc.paper.registry.PaperRegistryListenerManager;
import io.papermc.paper.registry.data.util.Conversions;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.Util;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class ReloadableServerRegistries {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final RegistrationInfo DEFAULT_REGISTRATION_INFO = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());

    public static CompletableFuture<LoadResult> reload(LayeredRegistryAccess<RegistryLayer> registryAccess, List<Registry.PendingTags<?>> postponedTags, ResourceManager resourceManager, Executor backgroundExecutor) {
        List<HolderLookup.RegistryLookup<?>> list = TagLoader.buildUpdatedLookups(registryAccess.getAccessForLoading(RegistryLayer.RELOADABLE), postponedTags);
        HolderLookup.Provider provider = HolderLookup.Provider.create(list.stream());
        RegistryOps registryOps = provider.createSerializationContext(JsonOps.INSTANCE);
        Conversions conversions = new Conversions(registryOps.lookupProvider);
        List<CompletableFuture> list1 = LootDataType.values().map(lootDataType -> ReloadableServerRegistries.scheduleRegistryLoad(lootDataType, registryOps, resourceManager, backgroundExecutor, conversions)).toList();
        CompletableFuture completableFuture = Util.sequence(list1);
        return completableFuture.thenApplyAsync(list2 -> ReloadableServerRegistries.createAndValidateFullContext(registryAccess, provider, list2), backgroundExecutor);
    }

    private static <T> CompletableFuture<WritableRegistry<?>> scheduleRegistryLoad(LootDataType<T> lootDataType, RegistryOps<JsonElement> ops, ResourceManager resourceManager, Executor backgroundExecutor, Conversions conversions) {
        return CompletableFuture.supplyAsync(() -> {
            MappedRegistry writableRegistry = new MappedRegistry(lootDataType.registryKey(), Lifecycle.experimental());
            PaperRegistryAccess.instance().registerReloadableRegistry(writableRegistry);
            HashMap<Identifier, Object> map = new HashMap<Identifier, Object>();
            SimpleJsonResourceReloadListener.scanDirectory(resourceManager, lootDataType.registryKey(), (DynamicOps<JsonElement>)ops, lootDataType.codec(), map);
            map.forEach((identifier, object) -> PaperRegistryListenerManager.INSTANCE.registerWithListeners(writableRegistry, ResourceKey.create(lootDataType.registryKey(), identifier), object, DEFAULT_REGISTRATION_INFO, conversions));
            TagLoader.loadTagsForRegistry(resourceManager, writableRegistry, ReloadableRegistrarEvent.Cause.RELOAD);
            return writableRegistry;
        }, backgroundExecutor);
    }

    private static LoadResult createAndValidateFullContext(LayeredRegistryAccess<RegistryLayer> registryAccess, HolderLookup.Provider provider, List<WritableRegistry<?>> registries) {
        LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess = ReloadableServerRegistries.createUpdatedRegistries(registryAccess, registries);
        HolderLookup.Provider provider1 = ReloadableServerRegistries.concatenateLookups(provider, layeredRegistryAccess.getLayer(RegistryLayer.RELOADABLE));
        ReloadableServerRegistries.validateLootRegistries(provider1);
        return new LoadResult(layeredRegistryAccess, provider1);
    }

    private static HolderLookup.Provider concatenateLookups(HolderLookup.Provider lookup1, HolderLookup.Provider lookup2) {
        return HolderLookup.Provider.create(Stream.concat(lookup1.listRegistries(), lookup2.listRegistries()));
    }

    private static void validateLootRegistries(HolderLookup.Provider registries) {
        ProblemReporter.Collector collector = new ProblemReporter.Collector();
        ValidationContext validationContext = new ValidationContext(collector, LootContextParamSets.ALL_PARAMS, registries);
        LootDataType.values().forEach(lootDataType -> ReloadableServerRegistries.validateRegistry(validationContext, lootDataType, registries));
        collector.forEach((string, problem) -> LOGGER.warn("Found loot table element validation problem in {}: {}", string, (Object)problem.description()));
    }

    private static LayeredRegistryAccess<RegistryLayer> createUpdatedRegistries(LayeredRegistryAccess<RegistryLayer> registryAccess, List<WritableRegistry<?>> registries) {
        return registryAccess.replaceFrom(RegistryLayer.RELOADABLE, new RegistryAccess.ImmutableRegistryAccess(registries).freeze());
    }

    private static <T> void validateRegistry(ValidationContext context, LootDataType<T> lootDataType, HolderLookup.Provider registries) {
        HolderGetter holderLookup = registries.lookupOrThrow(lootDataType.registryKey());
        holderLookup.listElements().forEach(reference -> lootDataType.runValidation(context, reference.key(), reference.value()));
    }

    public record LoadResult(LayeredRegistryAccess<RegistryLayer> layers, HolderLookup.Provider lookupWithUpdatedTags) {
    }

    public static class Holder {
        private final HolderLookup.Provider registries;

        public Holder(HolderLookup.Provider registries) {
            this.registries = registries;
        }

        public HolderLookup.Provider lookup() {
            return this.registries;
        }

        public LootTable getLootTable(ResourceKey<LootTable> lootTableKey) {
            return this.registries.lookup(Registries.LOOT_TABLE).flatMap(registryLookup -> registryLookup.get(lootTableKey)).map(net.minecraft.core.Holder::value).orElse(LootTable.EMPTY);
        }
    }
}

