/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jspecify.annotations.Nullable;

public class FillCommand {
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((maxBlocks, specifiedBlocks) -> Component.translatableEscape("commands.fill.toobig", maxBlocks, specifiedBlocks));
    static final BlockInput HOLLOW_CORE = new BlockInput(Blocks.AIR.defaultBlockState(), Collections.emptySet(), null);
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.fill.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("fill").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.argument("from", BlockPosArgument.blockPos()).then(Commands.argument("to", BlockPosArgument.blockPos()).then(((ArgumentBuilder)FillCommand.wrapWithMode(buildContext, Commands.argument("block", BlockStateArgument.block(buildContext)), input -> BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)input, "from"), context -> BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "to"), input -> BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)input, "block"), context -> null).then(((LiteralArgumentBuilder)Commands.literal("replace").executes(commandContext -> FillCommand.fillBlocks((CommandSourceStack)commandContext.getSource(), BoundingBox.fromCorners(BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandContext, "from"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandContext, "to")), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)commandContext, "block"), Mode.REPLACE, null, false))).then(FillCommand.wrapWithMode(buildContext, Commands.argument("filter", BlockPredicateArgument.blockPredicate(buildContext)), input -> BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)input, "from"), context -> BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "to"), input -> BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)input, "block"), context -> BlockPredicateArgument.getBlockPredicate((CommandContext<CommandSourceStack>)context, "filter"))))).then(Commands.literal("keep").executes(commandContext -> FillCommand.fillBlocks((CommandSourceStack)commandContext.getSource(), BoundingBox.fromCorners(BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandContext, "from"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandContext, "to")), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)commandContext, "block"), Mode.REPLACE, blockInWorld -> blockInWorld.getLevel().isEmptyBlock(blockInWorld.getPos()), false))))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> wrapWithMode(CommandBuildContext buildContext, ArgumentBuilder<CommandSourceStack, ?> argumentBuilder, InCommandFunction<CommandContext<CommandSourceStack>, BlockPos> from, InCommandFunction<CommandContext<CommandSourceStack>, BlockPos> to, InCommandFunction<CommandContext<CommandSourceStack>, BlockInput> block, NullableCommandFunction<CommandContext<CommandSourceStack>, Predicate<BlockInWorld>> filter) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.executes((Command<CommandSourceStack>)((Command)commandContext -> FillCommand.fillBlocks((CommandSourceStack)commandContext.getSource(), BoundingBox.fromCorners((Vec3i)from.apply(commandContext), (Vec3i)to.apply(commandContext)), (BlockInput)block.apply(commandContext), Mode.REPLACE, (Predicate)filter.apply(commandContext), false)))).then(Commands.literal("outline").executes(context -> FillCommand.fillBlocks((CommandSourceStack)context.getSource(), BoundingBox.fromCorners((Vec3i)from.apply(context), (Vec3i)to.apply(context)), (BlockInput)block.apply(context), Mode.OUTLINE, (Predicate)filter.apply(context), false)))).then(Commands.literal("hollow").executes(context -> FillCommand.fillBlocks((CommandSourceStack)context.getSource(), BoundingBox.fromCorners((Vec3i)from.apply(context), (Vec3i)to.apply(context)), (BlockInput)block.apply(context), Mode.HOLLOW, (Predicate)filter.apply(context), false)))).then(Commands.literal("destroy").executes(context -> FillCommand.fillBlocks((CommandSourceStack)context.getSource(), BoundingBox.fromCorners((Vec3i)from.apply(context), (Vec3i)to.apply(context)), (BlockInput)block.apply(context), Mode.DESTROY, (Predicate)filter.apply(context), false)))).then(Commands.literal("strict").executes(context -> FillCommand.fillBlocks((CommandSourceStack)context.getSource(), BoundingBox.fromCorners((Vec3i)from.apply(context), (Vec3i)to.apply(context)), (BlockInput)block.apply(context), Mode.REPLACE, (Predicate)filter.apply(context), true)));
    }

    private static int fillBlocks(CommandSourceStack source, BoundingBox box, BlockInput block, Mode mode, @Nullable Predicate<BlockInWorld> filter, boolean strict) throws CommandSyntaxException {
        record UpdatedPosition(BlockPos pos, BlockState oldState) {
        }
        int i1;
        int i = box.getXSpan() * box.getYSpan() * box.getZSpan();
        if (i > (i1 = source.getLevel().getGameRules().get(GameRules.MAX_BLOCK_MODIFICATIONS).intValue())) {
            throw ERROR_AREA_TOO_LARGE.create((Object)i1, (Object)i);
        }
        ArrayList list = Lists.newArrayList();
        ServerLevel level = source.getLevel();
        if (level.isDebug()) {
            throw ERROR_FAILED.create();
        }
        int i2 = 0;
        for (BlockPos blockPos : BlockPos.betweenClosed(box.minX(), box.minY(), box.minZ(), box.maxX(), box.maxY(), box.maxZ())) {
            BlockInput blockInput;
            if (filter != null && !filter.test(new BlockInWorld(level, blockPos, true))) continue;
            BlockState blockState = level.getBlockState(blockPos);
            boolean flag = false;
            if (mode.affector.affect(level, blockPos)) {
                flag = true;
            }
            if ((blockInput = mode.filter.filter(box, blockPos, block, level)) == null) {
                if (!flag) continue;
                ++i2;
                continue;
            }
            if (!blockInput.place(level, blockPos, 2 | (strict ? 816 : 256))) {
                if (!flag) continue;
                ++i2;
                continue;
            }
            if (!strict) {
                list.add(new UpdatedPosition(blockPos.immutable(), blockState));
            }
            ++i2;
        }
        for (UpdatedPosition updatedPosition : list) {
            level.updateNeighboursOnBlockSet(updatedPosition.pos, updatedPosition.oldState);
        }
        if (i2 == 0) {
            throw ERROR_FAILED.create();
        }
        int i3 = i2;
        source.sendSuccess(() -> Component.translatable("commands.fill.success", i3), true);
        return i2;
    }

    @FunctionalInterface
    static interface NullableCommandFunction<T, R> {
        public @Nullable R apply(T var1) throws CommandSyntaxException;
    }

    static enum Mode {
        REPLACE(Affector.NOOP, Filter.NOOP),
        OUTLINE(Affector.NOOP, (area, pos, newBlock, level) -> pos.getX() != area.minX() && pos.getX() != area.maxX() && pos.getY() != area.minY() && pos.getY() != area.maxY() && pos.getZ() != area.minZ() && pos.getZ() != area.maxZ() ? null : newBlock),
        HOLLOW(Affector.NOOP, (area, pos, newBlock, level) -> pos.getX() != area.minX() && pos.getX() != area.maxX() && pos.getY() != area.minY() && pos.getY() != area.maxY() && pos.getZ() != area.minZ() && pos.getZ() != area.maxZ() ? HOLLOW_CORE : newBlock),
        DESTROY((level, pos) -> level.destroyBlock(pos, true), Filter.NOOP);

        public final Filter filter;
        public final Affector affector;

        private Mode(Affector affector, Filter filter) {
            this.affector = affector;
            this.filter = filter;
        }
    }

    @FunctionalInterface
    public static interface Affector {
        public static final Affector NOOP = (level, pos) -> false;

        public boolean affect(ServerLevel var1, BlockPos var2);
    }

    @FunctionalInterface
    public static interface Filter {
        public static final Filter NOOP = (box, pos, block, level) -> block;

        public @Nullable BlockInput filter(BoundingBox var1, BlockPos var2, BlockInput var3, ServerLevel var4);
    }
}

