/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.MacroFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.FunctionCommand;
import net.minecraft.world.level.timers.FunctionCallback;
import net.minecraft.world.level.timers.FunctionTagCallback;
import net.minecraft.world.level.timers.TimerQueue;

public class ScheduleCommand {
    private static final SimpleCommandExceptionType ERROR_SAME_TICK = new SimpleCommandExceptionType((Message)Component.translatable("commands.schedule.same_tick"));
    private static final DynamicCommandExceptionType ERROR_CANT_REMOVE = new DynamicCommandExceptionType(functionName -> Component.translatableEscape("commands.schedule.cleared.failure", functionName));
    private static final SimpleCommandExceptionType ERROR_MACRO = new SimpleCommandExceptionType((Message)Component.translatableEscape("commands.schedule.macro", new Object[0]));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SCHEDULE = (context, builder) -> SharedSuggestionProvider.suggest(((CommandSourceStack)context.getSource()).getLevel().serverLevelData.getScheduledEvents().getEventsIds(), builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("schedule").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.literal("function").then(Commands.argument("function", FunctionArgument.functions()).suggests(FunctionCommand.SUGGEST_FUNCTION).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("time", TimeArgument.time()).executes(context -> ScheduleCommand.schedule((CommandSourceStack)context.getSource(), FunctionArgument.getFunctionOrTag((CommandContext<CommandSourceStack>)context, "function"), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"), true))).then(Commands.literal("append").executes(context -> ScheduleCommand.schedule((CommandSourceStack)context.getSource(), FunctionArgument.getFunctionOrTag((CommandContext<CommandSourceStack>)context, "function"), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"), false)))).then(Commands.literal("replace").executes(context -> ScheduleCommand.schedule((CommandSourceStack)context.getSource(), FunctionArgument.getFunctionOrTag((CommandContext<CommandSourceStack>)context, "function"), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"), true))))))).then(Commands.literal("clear").then(Commands.argument("function", StringArgumentType.greedyString()).suggests(SUGGEST_SCHEDULE).executes(context -> ScheduleCommand.remove((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"function")))))));
    }

    private static int schedule(CommandSourceStack source, Pair<Identifier, Either<CommandFunction<CommandSourceStack>, Collection<CommandFunction<CommandSourceStack>>>> function, int time, boolean append) throws CommandSyntaxException {
        if (time == 0) {
            throw ERROR_SAME_TICK.create();
        }
        long l = source.getLevel().getGameTime() + (long)time;
        Identifier identifier = (Identifier)function.getFirst();
        TimerQueue<MinecraftServer> scheduledEvents = source.getLevel().serverLevelData.overworldData().getScheduledEvents();
        Optional optional = ((Either)function.getSecond()).left();
        if (optional.isPresent()) {
            if (optional.get() instanceof MacroFunction) {
                throw ERROR_MACRO.create();
            }
            String string = identifier.toString();
            if (append) {
                scheduledEvents.remove(string);
            }
            scheduledEvents.schedule(string, l, new FunctionCallback(identifier));
            source.sendSuccess(() -> Component.translatable("commands.schedule.created.function", Component.translationArg(identifier), time, l), true);
        } else {
            String string = "#" + String.valueOf(identifier);
            if (append) {
                scheduledEvents.remove(string);
            }
            scheduledEvents.schedule(string, l, new FunctionTagCallback(identifier));
            source.sendSuccess(() -> Component.translatable("commands.schedule.created.tag", Component.translationArg(identifier), time, l), true);
        }
        return Math.floorMod(l, Integer.MAX_VALUE);
    }

    private static int remove(CommandSourceStack source, String function) throws CommandSyntaxException {
        int i = source.getLevel().serverLevelData.overworldData().getScheduledEvents().remove(function);
        if (i == 0) {
            throw ERROR_CANT_REMOVE.create((Object)function);
        }
        source.sendSuccess(() -> Component.translatable("commands.schedule.cleared.success", i, function), true);
        return i;
    }
}

