/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.ObjectiveCriteriaArgument;
import net.minecraft.commands.arguments.OperationArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.ScoreboardSlotArgument;
import net.minecraft.commands.arguments.StyleArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.numbers.BlankFormat;
import net.minecraft.network.chat.numbers.FixedFormat;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.jspecify.annotations.Nullable;

public class ScoreboardCommand {
    private static final SimpleCommandExceptionType ERROR_OBJECTIVE_ALREADY_EXISTS = new SimpleCommandExceptionType((Message)Component.translatable("commands.scoreboard.objectives.add.duplicate"));
    private static final SimpleCommandExceptionType ERROR_DISPLAY_SLOT_ALREADY_EMPTY = new SimpleCommandExceptionType((Message)Component.translatable("commands.scoreboard.objectives.display.alreadyEmpty"));
    private static final SimpleCommandExceptionType ERROR_DISPLAY_SLOT_ALREADY_SET = new SimpleCommandExceptionType((Message)Component.translatable("commands.scoreboard.objectives.display.alreadySet"));
    private static final SimpleCommandExceptionType ERROR_TRIGGER_ALREADY_ENABLED = new SimpleCommandExceptionType((Message)Component.translatable("commands.scoreboard.players.enable.failed"));
    private static final SimpleCommandExceptionType ERROR_NOT_TRIGGER = new SimpleCommandExceptionType((Message)Component.translatable("commands.scoreboard.players.enable.invalid"));
    private static final Dynamic2CommandExceptionType ERROR_NO_VALUE = new Dynamic2CommandExceptionType((objective, target) -> Component.translatableEscape("commands.scoreboard.players.get.null", objective, target));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("scoreboard").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("objectives").then(Commands.literal("list").executes(commandContext -> ScoreboardCommand.listObjectives((CommandSourceStack)commandContext.getSource())))).then(Commands.literal("add").then(Commands.argument("objective", StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.argument("criteria", ObjectiveCriteriaArgument.criteria()).executes(context1 -> ScoreboardCommand.addObjective((CommandSourceStack)context1.getSource(), StringArgumentType.getString((CommandContext)context1, (String)"objective"), ObjectiveCriteriaArgument.getCriteria((CommandContext<CommandSourceStack>)context1, "criteria"), Component.literal(StringArgumentType.getString((CommandContext)context1, (String)"objective"))))).then(Commands.argument("displayName", ComponentArgument.textComponent(context)).executes(context1 -> ScoreboardCommand.addObjective((CommandSourceStack)context1.getSource(), StringArgumentType.getString((CommandContext)context1, (String)"objective"), ObjectiveCriteriaArgument.getCriteria((CommandContext<CommandSourceStack>)context1, "criteria"), ComponentArgument.getResolvedComponent((CommandContext<CommandSourceStack>)context1, "displayName")))))))).then(Commands.literal("modify").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("objective", ObjectiveArgument.objective()).then(Commands.literal("displayname").then(Commands.argument("displayName", ComponentArgument.textComponent(context)).executes(context1 -> ScoreboardCommand.setDisplayName((CommandSourceStack)context1.getSource(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context1, "objective"), ComponentArgument.getResolvedComponent((CommandContext<CommandSourceStack>)context1, "displayName")))))).then(ScoreboardCommand.createRenderTypeModify())).then(Commands.literal("displayautoupdate").then(Commands.argument("value", BoolArgumentType.bool()).executes(context1 -> ScoreboardCommand.setDisplayAutoUpdate((CommandSourceStack)context1.getSource(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context1, "objective"), BoolArgumentType.getBool((CommandContext)context1, (String)"value")))))).then(ScoreboardCommand.addNumberFormats(context, Commands.literal("numberformat"), (context1, format) -> ScoreboardCommand.setObjectiveFormat((CommandSourceStack)context1.getSource(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context1, "objective"), format)))))).then(Commands.literal("remove").then(Commands.argument("objective", ObjectiveArgument.objective()).executes(commandContext -> ScoreboardCommand.removeObjective((CommandSourceStack)commandContext.getSource(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)commandContext, "objective")))))).then(Commands.literal("setdisplay").then(((RequiredArgumentBuilder)Commands.argument("slot", ScoreboardSlotArgument.displaySlot()).executes(context1 -> ScoreboardCommand.clearDisplaySlot((CommandSourceStack)context1.getSource(), ScoreboardSlotArgument.getDisplaySlot((CommandContext<CommandSourceStack>)context1, "slot")))).then(Commands.argument("objective", ObjectiveArgument.objective()).executes(context1 -> ScoreboardCommand.setDisplaySlot((CommandSourceStack)context1.getSource(), ScoreboardSlotArgument.getDisplaySlot((CommandContext<CommandSourceStack>)context1, "slot"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context1, "objective")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("players").then(((LiteralArgumentBuilder)Commands.literal("list").executes(context1 -> ScoreboardCommand.listTrackedPlayers((CommandSourceStack)context1.getSource()))).then(Commands.argument("target", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).executes(context1 -> ScoreboardCommand.listTrackedPlayerScores((CommandSourceStack)context1.getSource(), ScoreHolderArgument.getName((CommandContext<CommandSourceStack>)context1, "target")))))).then(Commands.literal("set").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("objective", ObjectiveArgument.objective()).then(Commands.argument("score", IntegerArgumentType.integer()).executes(context1 -> ScoreboardCommand.setScore((CommandSourceStack)context1.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context1, "targets"), ObjectiveArgument.getWritableObjective((CommandContext<CommandSourceStack>)context1, "objective"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"score")))))))).then(Commands.literal("get").then(Commands.argument("target", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("objective", ObjectiveArgument.objective()).executes(context1 -> ScoreboardCommand.getScore((CommandSourceStack)context1.getSource(), ScoreHolderArgument.getName((CommandContext<CommandSourceStack>)context1, "target"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context1, "objective"))))))).then(Commands.literal("add").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("objective", ObjectiveArgument.objective()).then(Commands.argument("score", IntegerArgumentType.integer((int)0)).executes(context1 -> ScoreboardCommand.addScore((CommandSourceStack)context1.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context1, "targets"), ObjectiveArgument.getWritableObjective((CommandContext<CommandSourceStack>)context1, "objective"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"score")))))))).then(Commands.literal("remove").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("objective", ObjectiveArgument.objective()).then(Commands.argument("score", IntegerArgumentType.integer((int)0)).executes(context1 -> ScoreboardCommand.removeScore((CommandSourceStack)context1.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context1, "targets"), ObjectiveArgument.getWritableObjective((CommandContext<CommandSourceStack>)context1, "objective"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"score")))))))).then(Commands.literal("reset").then(((RequiredArgumentBuilder)Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).executes(context1 -> ScoreboardCommand.resetScores((CommandSourceStack)context1.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context1, "targets")))).then(Commands.argument("objective", ObjectiveArgument.objective()).executes(commandContext -> ScoreboardCommand.resetScore((CommandSourceStack)commandContext.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)commandContext, "targets"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)commandContext, "objective"))))))).then(Commands.literal("enable").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("objective", ObjectiveArgument.objective()).suggests((commandContext, suggestionsBuilder) -> ScoreboardCommand.suggestTriggers((CommandSourceStack)commandContext.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)commandContext, "targets"), suggestionsBuilder)).executes(commandContext -> ScoreboardCommand.enableTrigger((CommandSourceStack)commandContext.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)commandContext, "targets"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)commandContext, "objective"))))))).then(((LiteralArgumentBuilder)Commands.literal("display").then(Commands.literal("name").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(((RequiredArgumentBuilder)Commands.argument("objective", ObjectiveArgument.objective()).then(Commands.argument("name", ComponentArgument.textComponent(context)).executes(commandContext -> ScoreboardCommand.setScoreDisplay((CommandSourceStack)commandContext.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)commandContext, "targets"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)commandContext, "objective"), ComponentArgument.getResolvedComponent((CommandContext<CommandSourceStack>)commandContext, "name"))))).executes(commandContext -> ScoreboardCommand.setScoreDisplay((CommandSourceStack)commandContext.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)commandContext, "targets"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)commandContext, "objective"), null)))))).then(Commands.literal("numberformat").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ScoreboardCommand.addNumberFormats(context, Commands.argument("objective", ObjectiveArgument.objective()), (context1, format) -> ScoreboardCommand.setScoreNumberFormat((CommandSourceStack)context1.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context1, "targets"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context1, "objective"), format))))))).then(Commands.literal("operation").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("targetObjective", ObjectiveArgument.objective()).then(Commands.argument("operation", OperationArgument.operation()).then(Commands.argument("source", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("sourceObjective", ObjectiveArgument.objective()).executes(commandContext -> ScoreboardCommand.performOperation((CommandSourceStack)commandContext.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)commandContext, "targets"), ObjectiveArgument.getWritableObjective((CommandContext<CommandSourceStack>)commandContext, "targetObjective"), OperationArgument.getOperation((CommandContext<CommandSourceStack>)commandContext, "operation"), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)commandContext, "source"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)commandContext, "sourceObjective"))))))))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addNumberFormats(CommandBuildContext context, ArgumentBuilder<CommandSourceStack, ?> argumentBuilder, NumberFormatCommandExecutor executor) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.then(Commands.literal("blank").executes(commandContext -> executor.run((CommandContext<CommandSourceStack>)commandContext, BlankFormat.INSTANCE)))).then(Commands.literal("fixed").then(Commands.argument("contents", ComponentArgument.textComponent(context)).executes(commandContext -> {
            Component resolvedComponent = ComponentArgument.getResolvedComponent((CommandContext<CommandSourceStack>)commandContext, "contents");
            return executor.run((CommandContext<CommandSourceStack>)commandContext, new FixedFormat(resolvedComponent));
        })))).then(Commands.literal("styled").then(Commands.argument("style", StyleArgument.style(context)).executes(commandContext -> {
            Style style = StyleArgument.getStyle((CommandContext<CommandSourceStack>)commandContext, "style");
            return executor.run((CommandContext<CommandSourceStack>)commandContext, new StyledFormat(style));
        })))).executes(commandContext -> executor.run((CommandContext<CommandSourceStack>)commandContext, null));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createRenderTypeModify() {
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder = Commands.literal("rendertype");
        for (ObjectiveCriteria.RenderType renderType : ObjectiveCriteria.RenderType.values()) {
            literalArgumentBuilder.then(Commands.literal(renderType.getId()).executes(commandContext -> ScoreboardCommand.setRenderType((CommandSourceStack)commandContext.getSource(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)commandContext, "objective"), renderType)));
        }
        return literalArgumentBuilder;
    }

    private static CompletableFuture<Suggestions> suggestTriggers(CommandSourceStack source, Collection<ScoreHolder> targets, SuggestionsBuilder suggestions) {
        ArrayList list = Lists.newArrayList();
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        for (Objective objective : scoreboard.getObjectives()) {
            if (objective.getCriteria() != ObjectiveCriteria.TRIGGER) continue;
            boolean flag = false;
            for (ScoreHolder scoreHolder : targets) {
                ReadOnlyScoreInfo playerScoreInfo = scoreboard.getPlayerScoreInfo(scoreHolder, objective);
                if (playerScoreInfo != null && !playerScoreInfo.isLocked()) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            list.add(objective.getName());
        }
        return SharedSuggestionProvider.suggest(list, suggestions);
    }

    private static int getScore(CommandSourceStack source, ScoreHolder scoreHolder, Objective objective) throws CommandSyntaxException {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        ReadOnlyScoreInfo playerScoreInfo = scoreboard.getPlayerScoreInfo(scoreHolder, objective);
        if (playerScoreInfo == null) {
            throw ERROR_NO_VALUE.create((Object)objective.getName(), (Object)scoreHolder.getFeedbackDisplayName());
        }
        source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.get.success", scoreHolder.getFeedbackDisplayName(), playerScoreInfo.value(), objective.getFormattedDisplayName()), false);
        return playerScoreInfo.value();
    }

    private static Component getFirstTargetName(Collection<ScoreHolder> scores) {
        return scores.iterator().next().getFeedbackDisplayName();
    }

    private static int performOperation(CommandSourceStack source, Collection<ScoreHolder> targets, Objective targetObjectives, OperationArgument.Operation operation, Collection<ScoreHolder> sourceEntities, Objective sourceObjective) throws CommandSyntaxException {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        int i = 0;
        for (ScoreHolder scoreHolder : targets) {
            ScoreAccess playerScore = scoreboard.getOrCreatePlayerScore(scoreHolder, targetObjectives);
            for (ScoreHolder scoreHolder1 : sourceEntities) {
                ScoreAccess playerScore1 = scoreboard.getOrCreatePlayerScore(scoreHolder1, sourceObjective);
                operation.apply(playerScore, playerScore1);
            }
            i += playerScore.get();
        }
        if (targets.size() == 1) {
            int i1 = i;
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.operation.success.single", targetObjectives.getFormattedDisplayName(), ScoreboardCommand.getFirstTargetName(targets), i1), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.operation.success.multiple", targetObjectives.getFormattedDisplayName(), targets.size()), true);
        }
        return i;
    }

    private static int enableTrigger(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective) throws CommandSyntaxException {
        if (objective.getCriteria() != ObjectiveCriteria.TRIGGER) {
            throw ERROR_NOT_TRIGGER.create();
        }
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        int i = 0;
        for (ScoreHolder scoreHolder : targets) {
            ScoreAccess playerScore = scoreboard.getOrCreatePlayerScore(scoreHolder, objective);
            if (!playerScore.locked()) continue;
            playerScore.unlock();
            ++i;
        }
        if (i == 0) {
            throw ERROR_TRIGGER_ALREADY_ENABLED.create();
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.enable.success.single", objective.getFormattedDisplayName(), ScoreboardCommand.getFirstTargetName(targets)), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.enable.success.multiple", objective.getFormattedDisplayName(), targets.size()), true);
        }
        return i;
    }

    private static int resetScores(CommandSourceStack source, Collection<ScoreHolder> targets) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.resetAllPlayerScores(scoreHolder);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.reset.all.single", ScoreboardCommand.getFirstTargetName(targets)), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.reset.all.multiple", targets.size()), true);
        }
        return targets.size();
    }

    private static int resetScore(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.resetSinglePlayerScore(scoreHolder, objective);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.reset.specific.single", objective.getFormattedDisplayName(), ScoreboardCommand.getFirstTargetName(targets)), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.reset.specific.multiple", objective.getFormattedDisplayName(), targets.size()), true);
        }
        return targets.size();
    }

    private static int setScore(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective, int newValue) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.getOrCreatePlayerScore(scoreHolder, objective).set(newValue);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.set.success.single", objective.getFormattedDisplayName(), ScoreboardCommand.getFirstTargetName(targets), newValue), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.set.success.multiple", objective.getFormattedDisplayName(), targets.size(), newValue), true);
        }
        return newValue * targets.size();
    }

    private static int setScoreDisplay(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective, @Nullable Component displayName) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.getOrCreatePlayerScore(scoreHolder, objective).display(displayName);
        }
        if (displayName == null) {
            if (targets.size() == 1) {
                source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.name.clear.success.single", ScoreboardCommand.getFirstTargetName(targets), objective.getFormattedDisplayName()), true);
            } else {
                source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.name.clear.success.multiple", targets.size(), objective.getFormattedDisplayName()), true);
            }
        } else if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.name.set.success.single", displayName, ScoreboardCommand.getFirstTargetName(targets), objective.getFormattedDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.name.set.success.multiple", displayName, targets.size(), objective.getFormattedDisplayName()), true);
        }
        return targets.size();
    }

    private static int setScoreNumberFormat(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective, @Nullable NumberFormat numberFormat) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.getOrCreatePlayerScore(scoreHolder, objective).numberFormatOverride(numberFormat);
        }
        if (numberFormat == null) {
            if (targets.size() == 1) {
                source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.numberFormat.clear.success.single", ScoreboardCommand.getFirstTargetName(targets), objective.getFormattedDisplayName()), true);
            } else {
                source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.numberFormat.clear.success.multiple", targets.size(), objective.getFormattedDisplayName()), true);
            }
        } else if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.numberFormat.set.success.single", ScoreboardCommand.getFirstTargetName(targets), objective.getFormattedDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.numberFormat.set.success.multiple", targets.size(), objective.getFormattedDisplayName()), true);
        }
        return targets.size();
    }

    private static int addScore(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective, int amount) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        int i = 0;
        for (ScoreHolder scoreHolder : targets) {
            ScoreAccess playerScore = scoreboard.getOrCreatePlayerScore(scoreHolder, objective);
            playerScore.set(playerScore.get() + amount);
            i += playerScore.get();
        }
        if (targets.size() == 1) {
            int i1 = i;
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.add.success.single", amount, objective.getFormattedDisplayName(), ScoreboardCommand.getFirstTargetName(targets), i1), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.add.success.multiple", amount, objective.getFormattedDisplayName(), targets.size()), true);
        }
        return i;
    }

    private static int removeScore(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective, int amount) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        int i = 0;
        for (ScoreHolder scoreHolder : targets) {
            ScoreAccess playerScore = scoreboard.getOrCreatePlayerScore(scoreHolder, objective);
            playerScore.set(playerScore.get() - amount);
            i += playerScore.get();
        }
        if (targets.size() == 1) {
            int i1 = i;
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.remove.success.single", amount, objective.getFormattedDisplayName(), ScoreboardCommand.getFirstTargetName(targets), i1), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.remove.success.multiple", amount, objective.getFormattedDisplayName(), targets.size()), true);
        }
        return i;
    }

    private static int listTrackedPlayers(CommandSourceStack source) {
        Collection<ScoreHolder> trackedPlayers = source.getServer().getScoreboard().getTrackedPlayers();
        if (trackedPlayers.isEmpty()) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.list.empty"), false);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.list.success", trackedPlayers.size(), ComponentUtils.formatList(trackedPlayers, ScoreHolder::getFeedbackDisplayName)), false);
        }
        return trackedPlayers.size();
    }

    private static int listTrackedPlayerScores(CommandSourceStack source, ScoreHolder score) {
        Object2IntMap<Objective> map = source.getServer().getScoreboard().listPlayerScores(score);
        if (map.isEmpty()) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.list.entity.empty", score.getFeedbackDisplayName()), false);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.list.entity.success", score.getFeedbackDisplayName(), map.size()), false);
            Object2IntMaps.fastForEach(map, entry -> source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.list.entity.entry", ((Objective)entry.getKey()).getFormattedDisplayName(), entry.getIntValue()), false));
        }
        return map.size();
    }

    private static int clearDisplaySlot(CommandSourceStack source, DisplaySlot slot) throws CommandSyntaxException {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        if (scoreboard.getDisplayObjective(slot) == null) {
            throw ERROR_DISPLAY_SLOT_ALREADY_EMPTY.create();
        }
        ((Scoreboard)scoreboard).setDisplayObjective(slot, null);
        source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.display.cleared", slot.getSerializedName()), true);
        return 0;
    }

    private static int setDisplaySlot(CommandSourceStack source, DisplaySlot slot, Objective objective) throws CommandSyntaxException {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        if (scoreboard.getDisplayObjective(slot) == objective) {
            throw ERROR_DISPLAY_SLOT_ALREADY_SET.create();
        }
        ((Scoreboard)scoreboard).setDisplayObjective(slot, objective);
        source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.display.set", slot.getSerializedName(), objective.getDisplayName()), true);
        return 0;
    }

    private static int setDisplayName(CommandSourceStack source, Objective objective, Component displayName) {
        if (!objective.getDisplayName().equals(displayName)) {
            objective.setDisplayName(displayName);
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.modify.displayname", objective.getName(), objective.getFormattedDisplayName()), true);
        }
        return 0;
    }

    private static int setDisplayAutoUpdate(CommandSourceStack source, Objective objective, boolean displayAutoUpdate) {
        if (objective.displayAutoUpdate() != displayAutoUpdate) {
            objective.setDisplayAutoUpdate(displayAutoUpdate);
            if (displayAutoUpdate) {
                source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.modify.displayAutoUpdate.enable", objective.getName(), objective.getFormattedDisplayName()), true);
            } else {
                source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.modify.displayAutoUpdate.disable", objective.getName(), objective.getFormattedDisplayName()), true);
            }
        }
        return 0;
    }

    private static int setObjectiveFormat(CommandSourceStack source, Objective objective, @Nullable NumberFormat format) {
        objective.setNumberFormat(format);
        if (format != null) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.modify.objectiveFormat.set", objective.getName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.modify.objectiveFormat.clear", objective.getName()), true);
        }
        return 0;
    }

    private static int setRenderType(CommandSourceStack source, Objective objective, ObjectiveCriteria.RenderType renderType) {
        if (objective.getRenderType() != renderType) {
            objective.setRenderType(renderType);
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.modify.rendertype", objective.getFormattedDisplayName()), true);
        }
        return 0;
    }

    private static int removeObjective(CommandSourceStack source, Objective objective) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        scoreboard.removeObjective(objective);
        source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.remove.success", objective.getFormattedDisplayName()), true);
        return scoreboard.getObjectives().size();
    }

    private static int addObjective(CommandSourceStack source, String name, ObjectiveCriteria criteria, Component displayName) throws CommandSyntaxException {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        if (scoreboard.getObjective(name) != null) {
            throw ERROR_OBJECTIVE_ALREADY_EXISTS.create();
        }
        scoreboard.addObjective(name, criteria, displayName, criteria.getDefaultRenderType(), false, null);
        Objective objective = scoreboard.getObjective(name);
        source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.add.success", objective.getFormattedDisplayName()), true);
        return scoreboard.getObjectives().size();
    }

    private static int listObjectives(CommandSourceStack source) {
        Collection<Objective> objectives = source.getServer().getScoreboard().getObjectives();
        if (objectives.isEmpty()) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.list.empty"), false);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.list.success", objectives.size(), ComponentUtils.formatList(objectives, Objective::getFormattedDisplayName)), false);
        }
        return objectives.size();
    }

    @FunctionalInterface
    public static interface NumberFormatCommandExecutor {
        public int run(CommandContext<CommandSourceStack> var1, @Nullable NumberFormat var2) throws CommandSyntaxException;
    }
}

