/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec2;

public class SetSpawnCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("spawnpoint").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).executes(context -> SetSpawnCommand.setSpawn((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).getPlayerOrException()), BlockPos.containing(((CommandSourceStack)context.getSource()).getPosition()), WorldCoordinates.ZERO_ROTATION))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(context -> SetSpawnCommand.setSpawn((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), BlockPos.containing(((CommandSourceStack)context.getSource()).getPosition()), WorldCoordinates.ZERO_ROTATION))).then(((RequiredArgumentBuilder)Commands.argument("pos", BlockPosArgument.blockPos()).executes(context -> SetSpawnCommand.setSpawn((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)context, "pos"), WorldCoordinates.ZERO_ROTATION))).then(Commands.argument("rotation", RotationArgument.rotation()).executes(context -> SetSpawnCommand.setSpawn((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)context, "pos"), RotationArgument.getRotation((CommandContext<CommandSourceStack>)context, "rotation"))))))));
    }

    private static int setSpawn(CommandSourceStack source, Collection<ServerPlayer> targets, BlockPos pos, Coordinates rotationSupplier) {
        ResourceKey<Level> resourceKey = source.getLevel().dimension();
        Vec2 rotation = rotationSupplier.getRotation(source);
        float f = Mth.wrapDegrees(rotation.y);
        float f1 = Mth.clamp(rotation.x, -90.0f, 90.0f);
        ArrayList<ServerPlayer> actualTargets = new ArrayList<ServerPlayer>();
        for (ServerPlayer serverPlayer : targets) {
            if (!serverPlayer.setRespawnPosition(new ServerPlayer.RespawnConfig(LevelData.RespawnData.of(resourceKey, pos, f, f1), true), false, PlayerSetSpawnEvent.Cause.COMMAND)) continue;
            actualTargets.add(serverPlayer);
        }
        if (actualTargets.isEmpty()) {
            return 0;
        }
        String string = resourceKey.identifier().toString();
        if (actualTargets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.spawnpoint.success.single", pos.getX(), pos.getY(), pos.getZ(), Float.valueOf(f), Float.valueOf(f1), string, ((ServerPlayer)actualTargets.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.spawnpoint.success.multiple", pos.getX(), pos.getY(), pos.getZ(), Float.valueOf(f), Float.valueOf(f1), string, actualTargets.size()), true);
        }
        return actualTargets.size();
    }
}

