/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import joptsimple.OptionSet;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.Settings;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.server.permissions.PermissionLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class DedicatedServerProperties
extends Settings<DedicatedServerProperties> {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final Pattern SHA1 = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').trimResults();
    public final boolean debug = this.get("debug", false);
    public static final String MANAGEMENT_SERVER_TLS_ENABLED_KEY = "management-server-tls-enabled";
    public static final String MANAGEMENT_SERVER_TLS_KEYSTORE_KEY = "management-server-tls-keystore";
    public static final String MANAGEMENT_SERVER_TLS_KEYSTORE_PASSWORD_KEY = "management-server-tls-keystore-password";
    public final boolean onlineMode = this.get("online-mode", true);
    public final boolean preventProxyConnections = this.get("prevent-proxy-connections", false);
    public final String serverIp = this.get("server-ip", "");
    public final Settings.MutableValue<Boolean> allowFlight = this.getMutable("allow-flight", false);
    public final Settings.MutableValue<String> motd = this.getMutable("motd", "A Minecraft Server");
    public final boolean codeOfConduct = this.get("enable-code-of-conduct", false);
    public final String bugReportLink = this.get("bug-report-link", "");
    public final Settings.MutableValue<Boolean> forceGameMode = this.getMutable("force-gamemode", false);
    public final Settings.MutableValue<Boolean> enforceWhitelist = this.getMutable("enforce-whitelist", false);
    public final Settings.MutableValue<Difficulty> difficulty = this.getMutable("difficulty", DedicatedServerProperties.dispatchNumberOrString(Difficulty::byId, Difficulty::byName), Difficulty::getKey, Difficulty.EASY);
    public final Settings.MutableValue<GameType> gameMode = this.getMutable("gamemode", DedicatedServerProperties.dispatchNumberOrString(GameType::byId, GameType::byName), GameType::getName, GameType.SURVIVAL);
    public final String levelName = this.get("level-name", "world");
    public final int serverPort = this.get("server-port", 25565);
    public final boolean managementServerEnabled = this.get("management-server-enabled", false);
    public final String managementServerHost = this.get("management-server-host", "localhost");
    public final int managementServerPort = this.get("management-server-port", 0);
    public final String managementServerSecret = this.get("management-server-secret", SecurityConfig.generateSecretKey());
    public final boolean managementServerTlsEnabled = this.get("management-server-tls-enabled", true);
    public final String managementServerTlsKeystore = this.get("management-server-tls-keystore", "");
    public final String managementServerTlsKeystorePassword = this.get("management-server-tls-keystore-password", "");
    public final String managementServerAllowedOrigins = this.get("management-server-allowed-origins", "");
    public final @Nullable Boolean announcePlayerAchievements = this.getLegacyBoolean("announce-player-achievements");
    public final boolean enableQuery = this.get("enable-query", false);
    public final int queryPort = this.get("query.port", 25565);
    public final boolean enableRcon = this.get("enable-rcon", false);
    public final int rconPort = this.get("rcon.port", 25575);
    public final String rconPassword = this.get("rcon.password", "");
    public final boolean hardcore = this.get("hardcore", false);
    public final boolean useNativeTransport = this.get("use-native-transport", true);
    public final Settings.MutableValue<Integer> spawnProtection = this.getMutable("spawn-protection", 16);
    public final Settings.MutableValue<LevelBasedPermissionSet> opPermissions = this.getMutable("op-permission-level", DedicatedServerProperties::deserializePermission, DedicatedServerProperties::serializePermission, LevelBasedPermissionSet.OWNER);
    public final LevelBasedPermissionSet functionPermissions = this.get("function-permission-level", DedicatedServerProperties::deserializePermission, DedicatedServerProperties::serializePermission, LevelBasedPermissionSet.GAMEMASTER);
    public final long maxTickTime = this.get("max-tick-time", TimeUnit.MINUTES.toMillis(1L));
    public final int maxChainedNeighborUpdates = this.get("max-chained-neighbor-updates", 1000000);
    public final int rateLimitPacketsPerSecond = this.get("rate-limit", 0);
    public final Settings.MutableValue<Integer> viewDistance = this.getMutable("view-distance", 10);
    public final Settings.MutableValue<Integer> simulationDistance = this.getMutable("simulation-distance", 10);
    public final Settings.MutableValue<Integer> maxPlayers = this.getMutable("max-players", 20);
    public final int networkCompressionThreshold = this.get("network-compression-threshold", 256);
    public final boolean broadcastRconToOps = this.get("broadcast-rcon-to-ops", true);
    public final boolean broadcastConsoleToOps = this.get("broadcast-console-to-ops", true);
    public final int maxWorldSize = this.get("max-world-size", property -> Mth.clamp(property, 1, 29999984), 29999984);
    public final boolean syncChunkWrites = this.get("sync-chunk-writes", true) && Boolean.getBoolean("Paper.enable-sync-chunk-writes");
    public final String regionFileComression = this.get("region-file-compression", "deflate");
    public final boolean enableJmxMonitoring = this.get("enable-jmx-monitoring", false);
    public final Settings.MutableValue<Boolean> enableStatus = this.getMutable("enable-status", true);
    public final Settings.MutableValue<Boolean> hideOnlinePlayers = this.getMutable("hide-online-players", false);
    public final Settings.MutableValue<Integer> entityBroadcastRangePercentage = this.getMutable("entity-broadcast-range-percentage", string1 -> Mth.clamp(Integer.parseInt(string1), 10, 1000), 100);
    public final String textFilteringConfig = this.get("text-filtering-config", "");
    public final int textFilteringVersion = this.get("text-filtering-version", 0);
    public final Optional<MinecraftServer.ServerResourcePackInfo> serverResourcePackInfo;
    public final DataPackConfig initialDataPackConfiguration;
    public final Settings.MutableValue<Integer> playerIdleTimeout = this.getMutable("player-idle-timeout", 0);
    public final Settings.MutableValue<Integer> statusHeartbeatInterval = this.getMutable("status-heartbeat-interval", 0);
    public final Settings.MutableValue<Boolean> whiteList = this.getMutable("white-list", false);
    public final boolean enforceSecureProfile = this.get("enforce-secure-profile", true);
    public final boolean logIPs = this.get("log-ips", true);
    public Settings.MutableValue<Integer> pauseWhenEmptySeconds = this.getMutable("pause-when-empty-seconds", -1);
    private final WorldDimensionData worldDimensionData;
    public final WorldOptions worldOptions;
    public Settings.MutableValue<Boolean> acceptsTransfers = this.getMutable("accepts-transfers", false);
    public final String rconIp;

    public DedicatedServerProperties(Properties properties, OptionSet optionset) {
        super(properties, optionset);
        String string = this.get("level-seed", "");
        boolean flag = this.get("generate-structures", true);
        long l = WorldOptions.parseSeed(string).orElse(WorldOptions.randomSeed());
        this.worldOptions = new WorldOptions(l, flag, false);
        this.worldDimensionData = new WorldDimensionData(this.get("generator-settings", (String property) -> GsonHelper.parse(!property.isEmpty() ? property : "{}"), new JsonObject()), this.get("level-type", (String property) -> property.toLowerCase(Locale.ROOT), WorldPresets.NORMAL.identifier().toString()));
        this.serverResourcePackInfo = DedicatedServerProperties.getServerPackInfo(this.get("resource-pack-id", ""), this.get("resource-pack", ""), this.get("resource-pack-sha1", ""), this.getLegacyString("resource-pack-hash"), this.get("require-resource-pack", false), this.get("resource-pack-prompt", ""));
        this.initialDataPackConfiguration = DedicatedServerProperties.getDatapackConfig(this.get("initial-enabled-packs", String.join((CharSequence)",", WorldDataConfiguration.DEFAULT.dataPacks().getEnabled())), this.get("initial-disabled-packs", String.join((CharSequence)",", WorldDataConfiguration.DEFAULT.dataPacks().getDisabled())));
        String rconIp = this.getStringRaw("rcon.ip");
        this.rconIp = rconIp == null ? this.serverIp : rconIp;
    }

    public static DedicatedServerProperties fromFile(Path path, OptionSet optionset) {
        return new DedicatedServerProperties(DedicatedServerProperties.loadFromFile(path), optionset);
    }

    @Override
    public DedicatedServerProperties reload(RegistryAccess registryAccess, Properties properties, OptionSet options) {
        return new DedicatedServerProperties(properties, options);
    }

    private static @Nullable Component parseResourcePackPrompt(String json) {
        if (!Strings.isNullOrEmpty((String)json)) {
            try {
                JsonElement jsonElement = StrictJsonParser.parse(json);
                return ComponentSerialization.CODEC.parse(RegistryAccess.EMPTY.createSerializationContext(JsonOps.INSTANCE), (Object)jsonElement).resultOrPartial(string -> LOGGER.warn("Failed to parse resource pack prompt '{}': {}", (Object)json, string)).orElse(null);
            }
            catch (Exception var2) {
                LOGGER.warn("Failed to parse resource pack prompt '{}'", (Object)json, (Object)var2);
            }
        }
        return null;
    }

    private static Optional<MinecraftServer.ServerResourcePackInfo> getServerPackInfo(String id, String url, String sha1, @Nullable String hash, boolean isRequired, String promptJson) {
        UUID uuid;
        String string;
        if (url.isEmpty()) {
            return Optional.empty();
        }
        if (!sha1.isEmpty()) {
            string = sha1;
            if (!Strings.isNullOrEmpty((String)hash)) {
                LOGGER.warn("resource-pack-hash is deprecated and found along side resource-pack-sha1. resource-pack-hash will be ignored.");
            }
        } else if (!Strings.isNullOrEmpty((String)hash)) {
            LOGGER.warn("resource-pack-hash is deprecated. Please use resource-pack-sha1 instead.");
            string = hash;
        } else {
            string = "";
        }
        if (string.isEmpty()) {
            LOGGER.warn("You specified a resource pack without providing a sha1 hash. Pack will be updated on the client only if you change the name of the pack.");
        } else if (!SHA1.matcher(string).matches()) {
            LOGGER.warn("Invalid sha1 for resource-pack-sha1");
        }
        Component component = DedicatedServerProperties.parseResourcePackPrompt(promptJson);
        if (id.isEmpty()) {
            uuid = UUID.nameUUIDFromBytes(url.getBytes(StandardCharsets.UTF_8));
            LOGGER.warn("resource-pack-id missing, using default of {}", (Object)uuid);
        } else {
            try {
                uuid = UUID.fromString(id);
            }
            catch (IllegalArgumentException var10) {
                LOGGER.warn("Failed to parse '{}' into UUID", (Object)id);
                return Optional.empty();
            }
        }
        return Optional.of(new MinecraftServer.ServerResourcePackInfo(uuid, url, string, isRequired, component));
    }

    private static DataPackConfig getDatapackConfig(String initialEnabledPacks, String initialDisabledPacks) {
        List parts = COMMA_SPLITTER.splitToList((CharSequence)initialEnabledPacks);
        List parts1 = COMMA_SPLITTER.splitToList((CharSequence)initialDisabledPacks);
        return new DataPackConfig(parts, parts1);
    }

    public static @Nullable LevelBasedPermissionSet deserializePermission(String id) {
        try {
            PermissionLevel permissionLevel = PermissionLevel.byId(Integer.parseInt(id));
            return LevelBasedPermissionSet.forLevel(permissionLevel);
        }
        catch (NumberFormatException var2) {
            return null;
        }
    }

    public static String serializePermission(LevelBasedPermissionSet permissions) {
        return Integer.toString(permissions.level().id());
    }

    public WorldDimensions createDimensions(HolderLookup.Provider registries) {
        return this.worldDimensionData.create(registries);
    }

    public record WorldDimensionData(JsonObject generatorSettings, String levelType) {
        private static final Map<String, ResourceKey<WorldPreset>> LEGACY_PRESET_NAMES = Map.of("default", WorldPresets.NORMAL, "largebiomes", WorldPresets.LARGE_BIOMES);

        public WorldDimensions create(HolderLookup.Provider registries) {
            HolderGetter holderLookup = registries.lookupOrThrow(Registries.WORLD_PRESET);
            Holder.Reference<WorldPreset> reference = holderLookup.get(WorldPresets.NORMAL).or(() -> WorldDimensionData.lambda$create$0((HolderLookup)holderLookup)).orElseThrow(() -> new IllegalStateException("Invalid datapack contents: can't find default preset"));
            Holder holder = Optional.ofNullable(Identifier.tryParse(this.levelType)).map(presetPath -> ResourceKey.create(Registries.WORLD_PRESET, presetPath)).or(() -> Optional.ofNullable(LEGACY_PRESET_NAMES.get(this.levelType))).flatMap(((HolderLookup)holderLookup)::get).orElseGet(() -> {
                LOGGER.warn("Failed to parse level-type {}, defaulting to {}", (Object)this.levelType, (Object)reference.key().identifier());
                return reference;
            });
            WorldDimensions worldDimensions = ((WorldPreset)holder.value()).createWorldDimensions();
            if (holder.is(WorldPresets.FLAT)) {
                RegistryOps registryOps = registries.createSerializationContext(JsonOps.INSTANCE);
                Optional optional = FlatLevelGeneratorSettings.CODEC.parse(new Dynamic<JsonObject>(registryOps, this.generatorSettings())).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
                if (optional.isPresent()) {
                    return worldDimensions.replaceOverworldGenerator(registries, new FlatLevelSource((FlatLevelGeneratorSettings)optional.get()));
                }
            }
            return worldDimensions;
        }

        private static /* synthetic */ Optional lambda$create$0(HolderLookup holderLookup) {
            return holderLookup.listElements().findAny();
        }
    }
}

