/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dialog.action;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;

public interface Action {
    public static final Codec<Action> CODEC = BuiltInRegistries.DIALOG_ACTION_TYPE.byNameCodec().dispatch(Action::codec, mapCodec -> mapCodec);

    public MapCodec<? extends Action> codec();

    public Optional<ClickEvent> createAction(Map<String, ValueGetter> var1);

    public static interface ValueGetter {
        public String asTemplateSubstitution();

        public Tag asTag();

        public static Map<String, String> getAsTemplateSubstitutions(Map<String, ValueGetter> valueGetters) {
            return Maps.transformValues(valueGetters, ValueGetter::asTemplateSubstitution);
        }

        public static ValueGetter of(final String value) {
            return new ValueGetter(){

                @Override
                public String asTemplateSubstitution() {
                    return value;
                }

                @Override
                public Tag asTag() {
                    return StringTag.valueOf(value);
                }
            };
        }

        public static ValueGetter of(final Supplier<String> valueSupplier) {
            return new ValueGetter(){

                @Override
                public String asTemplateSubstitution() {
                    return (String)valueSupplier.get();
                }

                @Override
                public Tag asTag() {
                    return StringTag.valueOf((String)valueSupplier.get());
                }
            };
        }
    }
}

